/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.text;

import java.util.Iterator;
import java.util.List;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.text.OracleIndex;

class OracleIndexIteratorImpl<T extends OracleElementBase>
implements Iterator<OracleIndex<T>> {
    static SimpleLog ms_log = SimpleLog.getLog(OracleIndexIteratorImpl.class);
    private List<OracleIndex<T>> m_indices;
    private int index = 0;
    private boolean m_bClosed = false;

    OracleIndexIteratorImpl(List<OracleIndex<T>> indices) {
        this.m_indices = indices;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove operation not supported");
    }

    @Override
    public boolean hasNext() {
        if (this.m_bClosed) {
            ms_log.debug("hasNext: iterator already closed, return false");
            return false;
        }
        if (this.m_indices == null) {
            ms_log.debug("hasNext: index array is null, return false");
            return false;
        }
        if (this.index >= 0 && this.index < this.m_indices.size()) {
            ms_log.debug("hasNext: indices found, return true");
            return true;
        }
        ms_log.debug("hasNext: no more indices left, close and return false");
        this.close();
        return false;
    }

    private void close() {
        if (this.m_bClosed) {
            ms_log.debug("close: iterator already closed");
            return;
        }
        ms_log.debug("close: close inner document iterators");
        this.m_bClosed = true;
        this.m_indices = null;
    }

    @Override
    public OracleIndex<T> next() {
        if (this.m_bClosed) {
            ms_log.debug("next: iterator is already closed, return null");
            return null;
        }
        if (!this.hasNext()) {
            ms_log.debug("next: no more elements left, return null");
            return null;
        }
        ms_log.debug("next: return next element");
        OracleIndex<T> lastIndex = this.m_indices.get(this.index);
        ++this.index;
        return lastIndex;
    }
}

