/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.text;

import java.util.HashMap;
import java.util.Map;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.text.OracleIndexParameters;
import oracle.pg.text.Parameter;

public class IndexParametersBase {
    private static SimpleLog ms_log = SimpleLog.getLog(IndexParametersBase.class);
    private static boolean ms_bDebug = ms_log.isDebugEnabled();
    static boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    private int m_iBatchSize = -1;
    private int m_iCommitSize = -1;
    protected final Map<String, Object> m_indexParams;
    private OraclePropertyGraphBase m_opg;
    private int m_iNumConns = -1;
    private long m_iWriteTimeout = -1L;

    public IndexParametersBase(Parameter[] indexParams, OraclePropertyGraphBase opg) {
        if (indexParams == null || indexParams.length <= 0) {
            ms_log.debug("setParameters: parameters is null, use ones from opg");
            indexParams = this.m_opg.getDefaultIndexParameters().getParameters();
        }
        this.m_indexParams = this.setParameters(indexParams);
        this.m_opg = opg;
    }

    public final int getBatchSize() {
        if (this.m_iBatchSize <= 0) {
            if (this.m_indexParams.containsKey("batch-size")) {
                Integer batchSize = (Integer)this.m_indexParams.get("batch-size");
                if (batchSize != null && batchSize > 0 && batchSize < 1000000) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"getBatchSize: use batch size from index parameters ", batchSize);
                    }
                    this.m_iBatchSize = batchSize;
                    if (ms_bShowProgress) {
                        ms_log.debug("getBatchSize: initialize batch size with " + this.m_iBatchSize);
                    }
                    return this.m_iBatchSize;
                }
                if (batchSize != null && batchSize >= 1000000) {
                    this.m_iBatchSize = 1000000;
                    return this.m_iBatchSize;
                }
            }
            ms_log.debug("getBatchSize: use default batch size (10k)");
            this.m_iBatchSize = 10000;
        }
        return this.m_iBatchSize;
    }

    public final int getCommitBatchSize() {
        if (this.m_iCommitSize == -1) {
            ms_log.debug("getCommitBatchSize: initialize batch size");
            if (this.m_indexParams.containsKey("commit-batch-size")) {
                Integer batchSize = (Integer)this.m_indexParams.get("commit-batch-size");
                if (batchSize != null && batchSize > 0 && batchSize < OracleIndexParameters.MAX_COMMIT) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"getCommitBatchSize: use commit batch size from index ", "parameters ");
                    }
                    this.m_iCommitSize = batchSize;
                    if (ms_bShowProgress) {
                        ms_log.debug("getCommitBatchSize: initialize commit size with " + this.m_iCommitSize);
                    }
                    return this.m_iCommitSize;
                }
                if (batchSize != null && batchSize >= OracleIndexParameters.MAX_COMMIT) {
                    this.m_iCommitSize = OracleIndexParameters.MAX_COMMIT;
                    return this.m_iCommitSize;
                }
            }
            ms_log.debug("getCommitBatchSize: use default commit batch size (500k)");
            this.m_iCommitSize = 500000;
        }
        return this.m_iCommitSize;
    }

    public final int getNumConnections() {
        if (this.m_iNumConns <= 0) {
            ms_log.debug("getNumConnections: initialize number of connections ");
            if (this.m_indexParams.containsKey("reindex-numConns")) {
                Integer numConn = (Integer)this.m_indexParams.get("reindex-numConns");
                if (numConn != null && numConn > 0 && numConn < OracleIndexParameters.MAX_CONNS) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"getNumConnections: initialize number of connections", " with index parameters ");
                    }
                    this.m_iNumConns = numConn;
                    if (ms_bShowProgress) {
                        ms_log.debug("getNumConnections: initialize connections to " + this.m_iNumConns);
                    }
                    return this.m_iNumConns;
                }
                if (numConn != null && numConn >= OracleIndexParameters.MAX_CONNS) {
                    this.m_iNumConns = OracleIndexParameters.MAX_CONNS;
                    return this.m_iNumConns;
                }
            }
            if (ms_bDebug) {
                ms_log.debug((Object)"getNumConnections:initialize number of connections with", " default value");
            }
            this.m_iNumConns = 1;
        }
        return this.m_iNumConns;
    }

    public final long getWriteTimeout() {
        if (this.m_iWriteTimeout <= 0L) {
            ms_log.debug("getWriteTimeout:initialize write timeout");
            if (this.m_indexParams.containsKey("write-timeout")) {
                Long timeout = (Long)this.m_indexParams.get("write-timeout");
                if ((timeout = Long.valueOf(timeout * 1000L)) != null && timeout > 0L && timeout < (long)OracleIndexParameters.MAX_WAIT_TIMEOUT.intValue()) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"getWriteTimeout: use write timeout from index ", "parameters ");
                    }
                    this.m_iWriteTimeout = timeout;
                    if (ms_bShowProgress) {
                        ms_log.debug("getWriteTimeout: initialize write timeout with " + this.m_iWriteTimeout);
                    }
                    return this.m_iWriteTimeout;
                }
                if (timeout != null && timeout >= (long)OracleIndexParameters.MAX_WAIT_TIMEOUT.intValue()) {
                    this.m_iWriteTimeout = OracleIndexParameters.MAX_WAIT_TIMEOUT.intValue();
                    return this.m_iWriteTimeout;
                }
            }
            ms_log.debug("getWriteTimeout: use default write timeout (15 sec)");
            this.m_iWriteTimeout = 2000L;
        }
        return this.m_iWriteTimeout;
    }

    private final Map<String, Object> setParameters(Parameter[] indexParameters) {
        HashMap<String, Object> indexParams = new HashMap<String, Object>();
        ms_log.debug("setParameters: put parameters into hash map, for fast look up");
        for (int i = 0; i < indexParameters.length; ++i) {
            Parameter p = indexParameters[i];
            if (p == null || p.getKey() == null || p.getValue() == null) continue;
            if (ms_bDebug) {
                ms_log.debug((Object)"setParameters: add parameter ", p.toString());
            }
            indexParams.put((String)p.getKey(), p.getValue());
        }
        return indexParams;
    }

    public Map<String, Object> getParametersMap() {
        return this.m_indexParams;
    }
}

