/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class LocalizedMessage {
    private String m_errorCode;
    private Locale m_locale;
    private Object[] m_params;
    private static String CANNOT_FIND_BUNDLE_MESSAGE = "Unable to load resource bundle with name: ";
    private static String CANNOT_FIND_RESOURCE_MESSAGE = "Unable to load error message with key: ";

    public LocalizedMessage(String errorCode) {
        this.m_errorCode = errorCode;
    }

    public LocalizedMessage(String errorCode, Object parameter) {
        this.m_errorCode = errorCode;
        this.m_params = new Object[1];
        this.m_params[0] = parameter;
    }

    public LocalizedMessage(String errorCode, Object parameter1, Object parameter2) {
        this.m_errorCode = errorCode;
        this.m_params = new Object[2];
        this.m_params[0] = parameter1;
        this.m_params[1] = parameter2;
    }

    public LocalizedMessage(String errorCode, Object parameter1, Object parameter2, Object parameter3) {
        this.m_errorCode = errorCode;
        this.m_params = new Object[3];
        this.m_params[0] = parameter1;
        this.m_params[2] = parameter3;
        this.m_params[1] = parameter2;
    }

    public LocalizedMessage(String errorCode, Object[] parameterArray) {
        this.m_errorCode = errorCode;
        int iLength = parameterArray.length;
        this.m_params = new Object[iLength];
        System.arraycopy(parameterArray, 0, this.m_params, 0, iLength);
    }

    protected abstract String getResourceBundleName();

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale l) {
        this.m_locale = l;
    }

    public String getMessage() {
        Locale locale = this.m_locale != null ? this.m_locale : Locale.getDefault();
        String szBundleName = this.getResourceBundleName();
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundle.getBundle(szBundleName, locale);
        }
        catch (MissingResourceException e) {
            return CANNOT_FIND_BUNDLE_MESSAGE + szBundleName;
        }
        String szMessage = null;
        try {
            szMessage = resBundle.getString(this.m_errorCode);
            if (this.m_params != null && this.m_params.length != 0) {
                szMessage = MessageFormat.format(szMessage, this.m_params);
            }
        }
        catch (MissingResourceException e) {
            return CANNOT_FIND_RESOURCE_MESSAGE + this.m_errorCode;
        }
        return szMessage;
    }

    public String getErrorCode() {
        return this.m_errorCode;
    }

    public String toString() {
        return this.getMessage();
    }
}

