/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader.exceptions;

public class InvalidPropertyValueException
extends RuntimeException {
    public InvalidPropertyValueException(String id, long lLineIdx, String szLine, CauseType type, Class datatype) {
        super("Invalid Property Value '" + id + "' in line #" + lLineIdx + " with content '" + szLine + "',  property value cannot be casted to '" + datatype.getName() + (type != null ? "', value " + InvalidPropertyValueException.getCause(type) : ""));
    }

    public InvalidPropertyValueException(String id, long lLineIdx, String szLine, CauseType type, long size) {
        super("Invalid Property Value '" + id + "' in line #" + lLineIdx + " with content '" + szLine + "',  property value cannot be processed due to " + InvalidPropertyValueException.getCause(type, size));
    }

    public InvalidPropertyValueException(String id, long lLineIdx, String szLine, CauseType type, Class datatype, Throwable t) {
        super("Invalid Property Value '" + id + "' in line #" + lLineIdx + " with content '" + szLine + "',  property value cannot be casted to '" + datatype.getName() + (type != null ? "', value " + InvalidPropertyValueException.getCause(type) : ""), t);
    }

    public static String getCause(CauseType type) {
        return InvalidPropertyValueException.getCause(type, 0L);
    }

    public static String getCause(CauseType type, long size) {
        if (type == null) {
            return null;
        }
        if (CauseType.INVALID_NUMERIC_VALUE.equals((Object)type)) {
            return " must be a numeric value";
        }
        if (CauseType.CANNOT_BE_PARSED.equals((Object)type)) {
            return " cannot be parsed into date format";
        }
        if (CauseType.IO_EXCEPTION.equals((Object)type)) {
            return " cannot be parsed into date format";
        }
        if (CauseType.EXCEEDED_VALUE_SIZE.equals((Object)type)) {
            return " exceeds maximum value length (" + size + ")";
        }
        return null;
    }

    public static enum CauseType {
        INVALID_NUMERIC_VALUE,
        CANNOT_BE_PARSED,
        IO_EXCEPTION,
        INVALID_PROPERTY_TYPE,
        EXCEEDED_VALUE_SIZE;

    }
}

