/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphUtilsBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.loader.CancellableCallable;
import oracle.pg.common.loader.OracleDataLoaderConfigBase;
import oracle.pg.common.loader.exceptions.InvalidArgumentSizeException;
import oracle.pg.common.loader.exceptions.InvalidIdArgumentException;
import oracle.pg.common.loader.exceptions.InvalidLabelException;
import oracle.pg.common.loader.exceptions.InvalidPropertyNameException;
import oracle.pg.common.loader.exceptions.InvalidPropertyTypeException;
import oracle.pg.common.loader.exceptions.InvalidPropertyValueException;

public abstract class PropertyGraphLoader<T extends OracleElementBase>
extends CancellableCallable {
    protected static SimpleLog ms_log = SimpleLog.getLog(PropertyGraphLoader.class);
    private int taskId;
    private InputStream is;
    private OracleDataLoaderConfigBase config;
    private BufferedReader br;
    protected DataLoaderListener m_dll;
    private long lStartTime;
    private long lWindowStartTime;
    protected long lWindowCount;
    private FileWriter fw;
    protected boolean m_bVertex;
    protected OraclePropertyGraphBase opg;
    protected long[] lErrors = new long[1];
    protected String delimiter = ",";
    private static final String EMPTY_KEY = OraclePropertyGraphUtilsBase.unescape("%20");

    public PropertyGraphLoader(int taskId, InputStream is, OracleDataLoaderConfigBase config, OraclePropertyGraphBase opg) throws Exception {
        this(taskId);
        this.is = is;
        this.config = config;
        this.m_dll = config.getDataLoaderListener();
        this.opg = this.clonePropertyGraph(opg);
    }

    public PropertyGraphLoader(int taskId) {
        this.taskId = taskId;
    }

    protected abstract OraclePropertyGraphBase clonePropertyGraph(OraclePropertyGraphBase var1) throws Exception;

    private void setupProgressReportFile() {
        if (ParametersBase.getInstance().showProgress()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
            try {
                this.fw = new FileWriter("/tmp/load_edge_" + this.opg.getGraphName() + "_ts_" + sdf.format(Calendar.getInstance().getTime()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Long call() throws Exception {
        long currentLineNumber = 1L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            String line;
            this.br = new BufferedReader(new InputStreamReader(this.is));
            while ((line = this.br.readLine()) != null) {
                if (this.m_dll != null && currentLineNumber % this.m_dll.reportProgressFrequency() == 0L) {
                    this.m_dll.progressTo(currentLineNumber, "PropertyGraphLoader run: done to line " + line);
                }
                if (this.isTaskFailed()) {
                    throw new RuntimeException();
                }
                this.convertAndStoreLineAsGraphData(currentLineNumber, line, sdf);
                ++currentLineNumber;
                ++this.lWindowCount;
            }
            if (!this.isTaskFailed()) {
                this.commit();
                Long l = currentLineNumber;
                return l;
            }
            this.rollback();
            throw new RuntimeException();
        }
        finally {
            ms_log.debug((Object)"call: finished processing # lines: ", currentLineNumber);
            this.closeResources();
        }
    }

    protected void commit() throws Exception {
        this.opg.commit();
    }

    protected void rollback() throws Exception {
        this.opg.rollback();
    }

    protected void closeResources() throws Exception {
        if (this.br != null) {
            this.br.close();
        }
        this.closeGraphResources();
    }

    protected abstract void closeGraphResources() throws Exception;

    protected abstract String getName();

    protected abstract int getItemsPerLine();

    protected abstract void convertAndStoreLineAsGraphData(long var1, String var3, SimpleDateFormat var4) throws Exception;

    protected void reportProgress(long currentLineNumber, String line) {
        if (currentLineNumber % this.config.getBatchSizeToDebug() == 0L) {
            long lDurationTime = System.currentTimeMillis() - this.lStartTime;
            long lWindowDurTime = System.currentTimeMillis() - this.lWindowStartTime;
            long elementsPerMinute = currentLineNumber * 60000L / lDurationTime;
            long elementsPerMinWindow = this.lWindowCount * 60000L / lWindowDurTime;
            this.reportProgress(this.fw, this.taskId, elementsPerMinute, elementsPerMinWindow, currentLineNumber, lDurationTime, this.config.getDOP());
            if (ms_log.isInfoEnabled()) {
                ms_log.info(this.getName() + ": speed " + elementsPerMinute + " element lines/min,  done to " + currentLineNumber + " in ms " + lDurationTime);
                ms_log.info(this.getName() + ": window speed " + elementsPerMinWindow + " element lines/min,  done to " + currentLineNumber + " in ms " + lWindowDurTime);
            }
            this.lWindowCount = 0L;
            this.lWindowStartTime = System.currentTimeMillis();
        }
    }

    private void reportProgress(FileWriter fw, int id, long elementsPerMin, long elementsPerMinWindow, long currentLineNumber, long lDurationTime, int dop) {
        block4: {
            if (elementsPerMinWindow <= 0L || (long)dop - currentLineNumber <= 0L) {
                return;
            }
            try {
                long next100M = (currentLineNumber * (long)dop / 100000000L + 1L) * 100000000L;
                long estTimeLeftToNext100M = 60L * (next100M / (long)dop - currentLineNumber) / elementsPerMinWindow;
                long next1B = (currentLineNumber * (long)dop / 1000000000L + 1L) * 1000000000L;
                long estTimeLeftToNext1B = 60L * (next1B / (long)dop - currentLineNumber) / elementsPerMinWindow;
                String szVal = "Thread[" + id + "] load to " + currentLineNumber + " , elementsPerMin " + elementsPerMin + " , elementsPerMinWindow " + elementsPerMinWindow + " , lDurationTime_in_s " + lDurationTime / 1000L + " , estTimeLeftToNext100M_in_s  " + estTimeLeftToNext100M + ", elapsedTimeToCompleteNext100M_in_s " + (estTimeLeftToNext100M + lDurationTime / 1000L) + " , estTimeLeftToNext1B_in_s  " + estTimeLeftToNext1B + ", elapsedTimeToCompleteNext1B_in_s " + (estTimeLeftToNext1B + lDurationTime / 1000L);
                System.out.println(szVal);
                System.out.flush();
                if (fw != null) {
                    fw.write(szVal);
                    fw.write("\n");
                    fw.flush();
                }
            }
            catch (Throwable t) {
                if (!ms_log.isDebugEnabled()) break block4;
                ms_log.debug((Object)"reportProgress: ", t);
            }
        }
    }

    protected abstract boolean isValidElementLineSize(int var1);

    protected boolean isValidLineSize(long currentLineNumber, String[] fields, String line) {
        if (!this.isValidElementLineSize(fields.length)) {
            InvalidArgumentSizeException iase = new InvalidArgumentSizeException(currentLineNumber, line, fields.length, this.m_bVertex ? OracleVertexBase.class : OracleEdgeBase.class);
            String msg = iase.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw iase;
                }
                return false;
            }
            throw iase;
        }
        return true;
    }

    protected Long extractIdFromLine(long currentLineNumber, String[] fields, String line) {
        String field = fields[this.getIDItemIndex()];
        try {
            return Long.valueOf(field);
        }
        catch (NumberFormatException ex) {
            InvalidIdArgumentException ive = new InvalidIdArgumentException(field, currentLineNumber, line, this.m_bVertex ? InvalidIdArgumentException.Column.VID : InvalidIdArgumentException.Column.EID, InvalidIdArgumentException.CauseType.INVALID_NUMERIC_VALUE);
            String msg = ive.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ive;
                }
            } else {
                throw ive;
            }
            return null;
        }
    }

    protected abstract int getIDItemIndex();

    protected String extractPropertyKeyFromLine(long currentLineNumber, String[] fields, String line) {
        String szKey = OraclePropertyGraphUtilsBase.unescape(fields[this.getPropertyKeyItemIndex()]);
        if (szKey.isEmpty() || szKey.equals(EMPTY_KEY)) {
            return null;
        }
        if (szKey != null && (long)szKey.toString().getBytes().length > this.opg.getMaxPropertyNameLengthAllowedInBytes()) {
            InvalidPropertyNameException ipve = new InvalidPropertyNameException(szKey, currentLineNumber, line, InvalidPropertyNameException.CauseType.EXCEEDED_SIZE, this.opg.getMaxPropertyNameLengthAllowedInBytes());
            String msg = ipve.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipve;
                }
            } else {
                throw ipve;
            }
        }
        return szKey;
    }

    protected Object extractPropertyValueFromLine(long currentLineNumber, String[] fields, String line, SimpleDateFormat sdf) throws NumberFormatException, ParseException, IOException {
        int type = this.exractPropertyTypeFromLine(currentLineNumber, fields, line);
        if (type != -1) {
            return this.extractPropertyValueFromLine(currentLineNumber, fields, line, type, sdf);
        }
        return null;
    }

    protected String extractLabelFromLine(long currentLineNumber, String[] fields, String line) {
        String szLabel = OraclePropertyGraphUtilsBase.unescape(fields[this.getLabelItemIndex()]);
        if (szLabel != null && (long)szLabel.toString().getBytes().length > this.opg.getMaxLabelLengthAllowedInBytes()) {
            InvalidLabelException ipve = new InvalidLabelException(szLabel, currentLineNumber, line, InvalidLabelException.CauseType.EXCEEDED_SIZE, this.opg.getMaxLabelLengthAllowedInBytes());
            String msg = ipve.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipve;
                }
            } else {
                throw ipve;
            }
        }
        return szLabel;
    }

    private int exractPropertyTypeFromLine(long currentLineNumber, String[] fields, String line) {
        String item = fields[this.getPropertyTypeItemIndex()];
        try {
            return Integer.parseInt(item);
        }
        catch (NumberFormatException ex) {
            InvalidPropertyTypeException ipte = new InvalidPropertyTypeException(item, currentLineNumber, line, InvalidPropertyTypeException.CauseType.INVALID_NUMERIC_VALUE);
            String msg = ipte.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipte;
                }
            } else {
                throw ipte;
            }
            return -1;
        }
    }

    private Object extractPropertyValueFromLine(long currentLineNumber, String[] fields, String line, int type, SimpleDateFormat sdf) throws NumberFormatException, ParseException, IOException {
        int propertyValueIndex = this.getPropertyValueIndexFromType(type, currentLineNumber, line);
        Object value = null;
        String valueAsStr = null;
        if (propertyValueIndex != -1) {
            valueAsStr = OraclePropertyGraphUtilsBase.unescape(fields[propertyValueIndex]);
            if (valueAsStr == null) {
                valueAsStr = "";
            }
            value = this.decodeValueStrAsObject(type, valueAsStr, currentLineNumber, line, sdf);
        }
        if (this.isStringValue(type) && value != null && (long)value.toString().getBytes().length > this.opg.getMaxValueLengthAllowedInBytes()) {
            InvalidPropertyValueException ipve = new InvalidPropertyValueException(valueAsStr, currentLineNumber, line, InvalidPropertyValueException.CauseType.EXCEEDED_VALUE_SIZE, this.opg.getMaxValueLengthAllowedInBytes());
            String msg = ipve.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipve;
                }
            } else {
                throw ipve;
            }
        }
        return value;
    }

    private boolean isStringValue(int type) {
        return type == 6 || type == 10 || type == 25 || type == 101 || type == 20 || type == 1 || type == 30;
    }

    private Object decodeValueStrAsObject(int type, String valueAsStr, long currentLineNumber, String line, SimpleDateFormat sdf) {
        Class classType = OraclePropertyGraphBase.getDatatypeFromDatatypeCode(type);
        try {
            Object value = this.opg.decodeObject(type, valueAsStr, sdf);
            return value;
        }
        catch (NumberFormatException pe) {
            InvalidPropertyValueException ipve = new InvalidPropertyValueException(valueAsStr, currentLineNumber, line, InvalidPropertyValueException.CauseType.INVALID_NUMERIC_VALUE, classType, pe);
            String msg = ipve.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipve;
                }
            }
            throw ipve;
        }
        catch (IOException ioe) {
            InvalidPropertyValueException ipve = new InvalidPropertyValueException(valueAsStr, currentLineNumber, line, InvalidPropertyValueException.CauseType.IO_EXCEPTION, classType, ioe);
            String msg = ipve.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipve;
                }
            }
            throw ipve;
        }
        catch (ParseException pe) {
            InvalidPropertyValueException ipve = new InvalidPropertyValueException(valueAsStr, currentLineNumber, line, InvalidPropertyValueException.CauseType.CANNOT_BE_PARSED, classType, pe);
            String msg = ipve.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ipve;
                }
            }
            throw ipve;
        }
        return null;
    }

    private int getPropertyValueIndexFromType(int type, long currentLineNumber, String line) {
        if (type == 1 || type == 10 || type == 6 || type == 20 || type == 25 || type == 30 || type == 101) {
            return this.getPropertyTypeItemIndex() + 1;
        }
        if (type == 2 || type == 3 || type == 4 || type == 7 || type == 8 || type == 9) {
            return this.getPropertyTypeItemIndex() + 2;
        }
        if (type == 5) {
            return this.getPropertyTypeItemIndex() + 3;
        }
        InvalidPropertyTypeException ipte = new InvalidPropertyTypeException(String.valueOf(type), currentLineNumber, line, InvalidPropertyTypeException.CauseType.INVALID_PROPERTY_TYPE);
        String msg = ipte.getMessage();
        if (this.m_dll != null) {
            this.lErrors[0] = this.lErrors[0] + 1L;
            if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                throw ipte;
            }
        } else {
            throw ipte;
        }
        return -1;
    }

    protected abstract int getPropertyTypeItemIndex();

    protected abstract int getPropertyKeyItemIndex();

    protected abstract int getLabelItemIndex();
}

