/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.SimpleLog;

public class OracleFlatFileSplitterConfig {
    static SimpleLog ms_log = SimpleLog.getLog(OracleFlatFileSplitterConfig.class);
    private long m_lEdgeSrcMaxlines = -1L;
    private long m_lVertexSrcMaxlines = -1L;
    private long m_lVertexSrcOffsetlines = -1L;
    private long m_lEdgeSrcOffsetlines = -1L;
    private long m_lVertexIDOffset = 0L;
    private long m_lEdgeIDOffset = 0L;
    private int m_iDop = -1;
    private int m_iPartitions = -1;
    private int m_iOffset = -1;
    private DataLoaderListener m_dll = null;
    protected long m_lBatchSizeToDebug = 10000L;

    OracleFlatFileSplitterConfig(long lVertexSrcOffsetlines, long lEdgeSrcOffsetlines, long lVertexSrcMaxlines, long lEdgeSrcMaxlines, long lVertexIDOffset, long lEdgeIDOffset, int iDop, int iPartitions, int iOffset, DataLoaderListener dll) {
        this.setVertexSrcOffsetlines(lVertexSrcOffsetlines);
        this.setEdgeSrcMaxlines(lEdgeSrcMaxlines);
        this.setVertexSrcMaxlines(lVertexSrcMaxlines);
        this.setEdgeSrcOffsetlines(lEdgeSrcOffsetlines);
        this.setVertexIDOffset(lVertexIDOffset);
        this.setEdgeIDOffset(lEdgeIDOffset);
        this.setDOP(iDop);
        this.setTotalPartitions(iPartitions);
        this.setPartitionsOffset(iOffset);
        this.setDataLoaderListener(dll);
    }

    public OracleFlatFileSplitterConfig() {
    }

    public long getBatchSizeToDebug() {
        return this.m_lBatchSizeToDebug;
    }

    public void setBatchSizeToDebug(long size) {
        if (size <= 0L) {
            ms_log.debug("setBatchSizeToDebug: size should be positive, no op.");
        } else {
            this.m_lBatchSizeToDebug = size;
        }
    }

    public long getVertexSrcOffsetlines() {
        if (this.m_lVertexSrcOffsetlines < 0L) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: offset of vertex input data source must be larger than or equal to 0; set to default(0)");
            }
            this.m_lVertexSrcOffsetlines = 0L;
        }
        return this.m_lVertexSrcOffsetlines;
    }

    public void setVertexSrcOffsetlines(long lSrcOffsetlines) {
        this.m_lVertexSrcOffsetlines = lSrcOffsetlines;
    }

    public long getEdgeSrcOffsetlines() {
        if (this.m_lEdgeSrcOffsetlines < 0L) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: offset of edge input data source must be larger than or equal to 0; set to default(0)");
            }
            this.m_lEdgeSrcOffsetlines = 0L;
        }
        return this.m_lEdgeSrcOffsetlines;
    }

    public void setEdgeSrcOffsetlines(long lSrcOffsetlines) {
        this.m_lEdgeSrcOffsetlines = lSrcOffsetlines;
    }

    public long getVertexSrcMaxlines() {
        if (this.m_lVertexSrcMaxlines < 0L && this.m_lVertexSrcMaxlines != -1L) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: max lines of vertex input data source must be larger than or equal to 0, or equal to -1; set to default(-1)");
            }
            this.m_lVertexSrcMaxlines = -1L;
        }
        return this.m_lVertexSrcMaxlines;
    }

    public void setVertexSrcMaxlines(long lSrcMaxlines) {
        this.m_lVertexSrcMaxlines = lSrcMaxlines;
    }

    public long getEdgeSrcMaxlines() {
        if (this.m_lEdgeSrcMaxlines < 0L && this.m_lEdgeSrcMaxlines != -1L) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: max lines of edge input data source must be larger than or equal to 0, or equal to -1; set to default(-1)");
            }
            this.m_lEdgeSrcMaxlines = -1L;
        }
        return this.m_lEdgeSrcMaxlines;
    }

    public void setEdgeSrcMaxlines(long lSrcMaxlines) {
        this.m_lEdgeSrcMaxlines = lSrcMaxlines;
    }

    public long getVertexIDOffset() {
        return this.m_lVertexIDOffset;
    }

    public void setVertexIDOffset(long lVertexIDOffset) {
        this.m_lVertexIDOffset = lVertexIDOffset;
    }

    public long getEdgeIDOffset() {
        return this.m_lEdgeIDOffset;
    }

    public void setEdgeIDOffset(long lEdgeIDOffset) {
        this.m_lEdgeIDOffset = lEdgeIDOffset;
    }

    public int getDOP() {
        if (this.m_iDop <= 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: Dop must be positive; set to default(4)");
            }
            this.m_iDop = 4;
        }
        return this.m_iDop;
    }

    public void setDOP(int iDop) {
        this.m_iDop = iDop;
    }

    public int getTotalPartitions() {
        if (this.m_iPartitions <= 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: number of partitions must be positive; set to default(1)");
            }
            this.m_iPartitions = 1;
        }
        return this.m_iPartitions;
    }

    public void setTotalPartitions(int iPartitions) {
        this.m_iPartitions = iPartitions;
    }

    public int getPartitionsOffset() {
        if (this.m_iOffset < 0 || this.m_iOffset >= this.m_iPartitions) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: offset must be non-negative and less than number of partitions; set to default(0)");
            }
            this.m_iOffset = 0;
        }
        return this.m_iOffset;
    }

    public void setPartitionsOffset(int iOffset) {
        this.m_iOffset = iOffset;
    }

    public DataLoaderListener getDataLoaderListener() {
        return this.m_dll;
    }

    public void setDataLoaderListener(DataLoaderListener dll) {
        this.m_dll = dll;
    }

    public static OracleFlatFileSplitterConfig getInstance(long lVertexSrcOffsetlines, long lEdgeSrcOffsetlines, long lVertexSrcMaxlines, long lEdgeSrcMaxlines, long lVertexIDOffset, long lEdgeIDOffset, int iDop, int iPartitions, int iOffset, DataLoaderListener dll) {
        return new OracleFlatFileSplitterConfig(lVertexSrcOffsetlines, lEdgeSrcOffsetlines, lVertexSrcMaxlines, lEdgeSrcMaxlines, lVertexIDOffset, lEdgeIDOffset, iDop, iPartitions, iOffset, dll);
    }

    public static OracleFlatFileSplitterConfig getInstance() {
        return new OracleFlatFileSplitterConfig();
    }
}

