/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphUtilsBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.loader.CancellableCallable;
import oracle.pg.common.loader.OracleFlatFileSplitterConfig;
import oracle.pg.common.loader.exceptions.InvalidArgumentSizeException;
import oracle.pg.common.loader.exceptions.InvalidIdArgumentException;

public class OracleFlatFileSplitter
extends CancellableCallable {
    static final String FLAT_FILE_DELIMITER = ",";
    boolean m_bVertex;
    Object[] m_oaFlatFileNames;
    OutputStream[] m_osa;
    BufferedReader brIn;
    InputStreamReader isr = null;
    InputStream is = null;
    OutputStreamWriter[] bwOuts;
    OracleFlatFileSplitterConfig m_fileSplitterConfig;
    private int partitions;
    private int offset;
    private int dop;
    private DataLoaderListener dll;
    private long srcOffsetlines;
    private long srcMaxlines;
    private long vertexIDOffset;
    private long edgeIDOffset;
    protected long[] lErrors = new long[1];
    static SimpleLog ms_log = SimpleLog.getLog(OracleFlatFileSplitter.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();

    public OracleFlatFileSplitter(boolean bVertex, Object[] oaFlatFileNames, OutputStream[] osa, OracleFlatFileSplitterConfig fileSplitterConfig) {
        int i;
        this.m_bVertex = bVertex;
        this.m_oaFlatFileNames = new Object[oaFlatFileNames.length];
        for (i = 0; i < oaFlatFileNames.length; ++i) {
            this.m_oaFlatFileNames[i] = oaFlatFileNames[i];
        }
        this.m_osa = new OutputStream[osa.length];
        for (i = 0; i < osa.length; ++i) {
            this.m_osa[i] = osa[i];
        }
        this.m_fileSplitterConfig = fileSplitterConfig;
        this.partitions = this.m_fileSplitterConfig.getTotalPartitions();
        this.offset = this.m_fileSplitterConfig.getPartitionsOffset();
        this.dop = this.m_fileSplitterConfig.getDOP();
        this.dll = this.m_fileSplitterConfig.getDataLoaderListener();
        if (this.m_bVertex) {
            this.srcOffsetlines = this.m_fileSplitterConfig.getVertexSrcOffsetlines();
            this.srcMaxlines = this.m_fileSplitterConfig.getVertexSrcMaxlines();
        } else {
            this.srcOffsetlines = this.m_fileSplitterConfig.getEdgeSrcOffsetlines();
            this.srcMaxlines = this.m_fileSplitterConfig.getEdgeSrcMaxlines();
        }
        this.vertexIDOffset = this.m_fileSplitterConfig.getVertexIDOffset();
        this.edgeIDOffset = this.m_fileSplitterConfig.getEdgeIDOffset();
    }

    public String getName() {
        if (this.m_bVertex) {
            return "VertexFileSplitter";
        }
        return "EdgeFileSplitter";
    }

    public void closeResources() {
        int idx = 0;
        if (ms_bDebug) {
            ms_log.debug("(" + this.getName() + ") closeResources: close buffered reader");
        }
        OraclePropertyGraphUtilsBase.quietlyClose(this.brIn);
        OraclePropertyGraphUtilsBase.quietlyClose(this.is);
        for (OutputStreamWriter outputStreamWriter : this.bwOuts) {
            if (outputStreamWriter == null) continue;
            try {
                outputStreamWriter.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ms_bDebug) {
                ms_log.debug("(" + this.getName() + ") closeResources: close output stream writer (pipe) " + idx);
            }
            ++idx;
        }
        for (Closeable closeable : this.m_osa) {
            OraclePropertyGraphUtilsBase.quietlyClose((OutputStream)closeable);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("(" + this.getName() + ") closeResources: close output stream " + idx);
            }
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        long lStartTime;
        block18: {
            if (ms_bDebug) {
                ms_log.debug("call(" + this.getName() + "): starts");
            }
            lStartTime = System.currentTimeMillis();
            int dop = this.m_fileSplitterConfig.getDOP();
            DataLoaderListener dll = this.m_fileSplitterConfig.getDataLoaderListener();
            if (ms_bDebug) {
                ms_log.debug((Object)("call(" + this.getName() + "): using DOP "), dop);
            }
            this.brIn = null;
            this.bwOuts = new OutputStreamWriter[dop];
            String msg = null;
            long[] lErrors = new long[]{0L};
            try {
                int i;
                for (int i2 = 0; i2 < dop; ++i2) {
                    this.bwOuts[i2] = new OutputStreamWriter(this.m_osa[i2]);
                }
                int iFileCounter = this.m_oaFlatFileNames.length;
                for (i = 0; i < iFileCounter; ++i) {
                    try {
                        this.brIn = this.getBufferReaderFromInputObject(this.m_oaFlatFileNames[i]);
                        this.processFile(this.brIn, this.bwOuts, lErrors);
                        continue;
                    }
                    finally {
                        if (ms_bDebug) {
                            ms_log.debug("call(" + this.getName() + "): done reading close stream");
                        }
                        if (this.brIn != null) {
                            this.brIn.close();
                        }
                    }
                }
                for (i = 0; i < dop; ++i) {
                    if (this.bwOuts[i] == null) continue;
                    this.bwOuts[i].flush();
                }
            }
            catch (Exception ex) {
                if (dll != null) {
                    lErrors[0] = lErrors[0] + 1L;
                    if (!dll.continueOnError(lErrors[0], -1L, null, msg)) {
                        ms_log.error("call(" + this.getName() + "): exception found and cannot continue. Exception is ", ex);
                        throw ex;
                    }
                    break block18;
                }
                ms_log.error("call(" + this.getName() + "): exception found. Exception is ", ex);
                throw new RuntimeException(ex);
            }
            finally {
                this.closeResources();
            }
        }
        if (ms_bDebug) {
            ms_log.debug("(" + this.getName() + ") finished file splitting. Execution done in: " + (System.currentTimeMillis() - lStartTime) + " ms.");
        }
        return 0L;
    }

    private BufferedReader getBufferReaderFromInputObject(Object flatFileInput) throws FileNotFoundException, IOException {
        if (flatFileInput instanceof String) {
            this.is = new FileInputStream(new File((String)flatFileInput));
            this.isr = new InputStreamReader(OraclePropertyGraphUtilsBase.handleGZipInputStream(this.is));
        } else {
            this.isr = new InputStreamReader((InputStream)flatFileInput);
        }
        return new BufferedReader(this.isr, 0x100000);
    }

    protected boolean isValidElementLineSize(int size) {
        if (this.m_bVertex) {
            return size == 7 || size == 6;
        }
        return size == 9;
    }

    protected boolean isValidLineSize(long currentLineNumber, String[] fields, String line) {
        if (!this.isValidElementLineSize(fields.length)) {
            InvalidArgumentSizeException iase = new InvalidArgumentSizeException(currentLineNumber, line, fields.length, this.m_bVertex ? OracleVertexBase.class : OracleEdgeBase.class);
            String msg = iase.getMessage();
            if (this.m_fileSplitterConfig.getDataLoaderListener() != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_fileSplitterConfig.getDataLoaderListener().continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw iase;
                }
                return false;
            }
            throw iase;
        }
        return true;
    }

    private void processFile(BufferedReader brIn, OutputStreamWriter[] bwOuts, long[] lErrors) throws IOException {
        String szLine;
        long lLineIdx;
        for (lLineIdx = 0L; lLineIdx < this.srcOffsetlines && (szLine = brIn.readLine()) != null; ++lLineIdx) {
        }
        String subStr = null;
        while ((this.srcMaxlines == -1L || lLineIdx < this.srcMaxlines) && (szLine = brIn.readLine()) != null) {
            String[] fields = szLine.split(FLAT_FILE_DELIMITER, -1);
            if (!this.isValidLineSize(lLineIdx, fields, szLine)) continue;
            int iFirstSpace = szLine.indexOf(FLAT_FILE_DELIMITER);
            long lFirstID = 0L;
            try {
                subStr = szLine.substring(0, iFirstSpace);
                lFirstID = Long.parseLong(subStr);
            }
            catch (NumberFormatException ex) {
                InvalidIdArgumentException ive = new InvalidIdArgumentException(subStr, lLineIdx, szLine, this.m_bVertex ? InvalidIdArgumentException.Column.VID : InvalidIdArgumentException.Column.EID, InvalidIdArgumentException.CauseType.INVALID_NUMERIC_VALUE);
                String msg = ive.getMessage();
                if (this.dll != null) {
                    lErrors[0] = lErrors[0] + 1L;
                    if (!this.dll.continueOnError(lErrors[0], lLineIdx, szLine, msg)) {
                        throw ive;
                    }
                }
                throw ive;
            }
            long iRemainder = lFirstID % (long)(this.partitions * this.dop);
            if (iRemainder < 0L) {
                iRemainder = -iRemainder;
            }
            if (iRemainder >= (long)(this.offset * this.dop) && iRemainder <= (long)((this.offset + 1) * this.dop - 1)) {
                int idxOutStream = (int)(iRemainder % (long)this.dop);
                StringBuilder sbLineWithNewID = new StringBuilder();
                if (this.m_bVertex) {
                    sbLineWithNewID.append(String.valueOf(lFirstID + this.vertexIDOffset));
                    sbLineWithNewID.append(',');
                    sbLineWithNewID.append(szLine.substring(iFirstSpace + 1));
                } else {
                    long lSecondID = 0L;
                    int iSecondSpace = szLine.indexOf(FLAT_FILE_DELIMITER, iFirstSpace + 1);
                    try {
                        subStr = szLine.substring(iFirstSpace + 1, iSecondSpace);
                        lSecondID = Long.parseLong(subStr);
                    }
                    catch (NumberFormatException ex) {
                        InvalidIdArgumentException ive = new InvalidIdArgumentException(subStr, lLineIdx, szLine, InvalidIdArgumentException.Column.SVID, InvalidIdArgumentException.CauseType.INVALID_NUMERIC_VALUE);
                        String msg = ive.getMessage();
                        if (this.dll != null) {
                            lErrors[0] = lErrors[0] + 1L;
                            if (!this.dll.continueOnError(lErrors[0], lLineIdx, szLine, msg)) {
                                throw ive;
                            }
                        }
                        throw ive;
                    }
                    long lThirdID = 0L;
                    int iThirdSpace = szLine.indexOf(FLAT_FILE_DELIMITER, iSecondSpace + 1);
                    try {
                        subStr = szLine.substring(iSecondSpace + 1, iThirdSpace);
                        lThirdID = Long.parseLong(subStr);
                    }
                    catch (NumberFormatException ex) {
                        InvalidIdArgumentException ive = new InvalidIdArgumentException(subStr, lLineIdx, szLine, InvalidIdArgumentException.Column.DVID, InvalidIdArgumentException.CauseType.INVALID_NUMERIC_VALUE);
                        String msg = ive.getMessage();
                        if (this.dll != null) {
                            lErrors[0] = lErrors[0] + 1L;
                            if (!this.dll.continueOnError(lErrors[0], lLineIdx, szLine, msg)) {
                                throw ive;
                            }
                        }
                        throw ive;
                    }
                    sbLineWithNewID.append(String.valueOf(lFirstID + this.edgeIDOffset));
                    sbLineWithNewID.append(',');
                    sbLineWithNewID.append(String.valueOf(lSecondID + this.vertexIDOffset));
                    sbLineWithNewID.append(',');
                    sbLineWithNewID.append(String.valueOf(lThirdID + this.vertexIDOffset));
                    sbLineWithNewID.append(',');
                    sbLineWithNewID.append(szLine.substring(iThirdSpace + 1));
                }
                bwOuts[idxOutStream].write(sbLineWithNewID.toString());
                bwOuts[idxOutStream].write("\n");
                ++lLineIdx;
                continue;
            }
            ++lLineIdx;
        }
    }
}

