/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.loader.OracleFlatFileSplitterConfig;

public class OracleDataLoaderConfigBase
extends OracleFlatFileSplitterConfig {
    protected static SimpleLog ms_log = SimpleLog.getLog(OracleDataLoaderConfigBase.class);
    private int m_iBatchSize;
    private boolean m_bSkipGhostVertices = false;

    OracleDataLoaderConfigBase(long lVertexSrcOffsetlines, long lEdgeSrcOffsetlines, long lVertexSrcMaxlines, long lEdgeSrcMaxlines, long lVertexIDOffset, long lEdgeIDOffset, int iDop, int iPartitions, int iOffset, int batchSize, DataLoaderListener dll) {
        this.setVertexSrcOffsetlines(lVertexSrcOffsetlines);
        this.setEdgeSrcMaxlines(lEdgeSrcMaxlines);
        this.setVertexSrcMaxlines(lVertexSrcMaxlines);
        this.setEdgeSrcOffsetlines(lEdgeSrcOffsetlines);
        this.setVertexIDOffset(lVertexIDOffset);
        this.setEdgeIDOffset(lEdgeIDOffset);
        this.setDOP(iDop);
        this.setTotalPartitions(iPartitions);
        this.setPartitionsOffset(iOffset);
        this.setDataLoaderListener(dll);
        this.setBatchSize(batchSize);
    }

    public OracleDataLoaderConfigBase() {
    }

    @Override
    public long getBatchSizeToDebug() {
        return this.m_lBatchSizeToDebug;
    }

    public int getBatchSize() {
        if (this.m_iBatchSize <= 0) {
            if (ms_log.isDebugEnabled()) {
                ms_log.error("loadData: batch size must be positive; set to default(1000)");
            }
            this.m_iBatchSize = 1000;
        }
        return this.m_iBatchSize;
    }

    public void setBatchSize(int batchSize) {
        this.m_iBatchSize = batchSize;
    }

    public void setSkipGhostVertices(boolean skip) {
        this.m_bSkipGhostVertices = skip;
    }

    public boolean isSkipGhostVerticesOn() {
        return this.m_bSkipGhostVertices;
    }

    public static OracleDataLoaderConfigBase getInstance(long lVertexSrcOffsetlines, long lEdgeSrcOffsetlines, long lVertexSrcMaxlines, long lEdgeSrcMaxlines, long lVertexIDOffset, long lEdgeIDOffset, int iDop, int iPartitions, int iOffset, int batchSize, DataLoaderListener dll) {
        return new OracleDataLoaderConfigBase(lVertexSrcOffsetlines, lEdgeSrcOffsetlines, lVertexSrcMaxlines, lEdgeSrcMaxlines, lVertexIDOffset, lEdgeIDOffset, iDop, iPartitions, iOffset, batchSize, dll);
    }
}

