/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.loader.OracleDataLoaderConfigBase;
import oracle.pg.common.loader.PropertyGraphLoader;
import oracle.pg.common.loader.exceptions.InvalidIdArgumentException;

public abstract class EdgeLoader
extends PropertyGraphLoader<OracleEdgeBase> {
    static final int EDGE_ITEMS_PER_LINE = 9;
    private static final int ID_ITEM_INDEX = 0;
    private static final int SVID_ITEM_INDEX = 1;
    private static final int DVID_ITEM_INDEX = 2;
    private static final int EDGE_LABEL_ITEM_INDEX = 3;
    private static final int EDGE_PROPERTY_KEY_ITEM_INDEX = 4;
    private static final int EDGE_PROPERTY_TYPE_ITEM_INDEX = 5;
    protected boolean skipGhostVertices;

    public EdgeLoader(int taskId, InputStream is, OracleDataLoaderConfigBase config, OraclePropertyGraphBase opg) throws Exception {
        super(taskId, is, config, opg);
        this.m_bVertex = false;
        this.skipGhostVertices = config.isSkipGhostVerticesOn();
    }

    public EdgeLoader(int taskId) {
        super(taskId);
        this.m_bVertex = false;
    }

    @Override
    protected String getName() {
        return "EdgeLoader";
    }

    @Override
    protected boolean isValidElementLineSize(int size) {
        return size == this.getItemsPerLine();
    }

    @Override
    protected void convertAndStoreLineAsGraphData(long currentLineNumber, String line, SimpleDateFormat sdf) throws Exception {
        this.reportProgress(currentLineNumber, line);
        String[] fields = line.split(",", -1);
        if (!this.isValidLineSize(currentLineNumber, fields, line)) {
            return;
        }
        Long eid = this.extractIdFromLine(currentLineNumber, fields, line);
        Long svid = this.extractSVIDFromLine(currentLineNumber, fields, line);
        Long dvid = this.extractDVIDFromLine(currentLineNumber, fields, line);
        String label = this.extractLabelFromLine(currentLineNumber, fields, line);
        String propertyKey = this.extractPropertyKeyFromLine(currentLineNumber, fields, line);
        Object propertyValue = null;
        if (propertyKey != null && !propertyKey.isEmpty()) {
            propertyValue = this.extractPropertyValueFromLine(currentLineNumber, fields, line, sdf);
        }
        if (this.isTaskFailed()) {
            throw new RuntimeException();
        }
        this.loadDataIntoDb(eid, svid, dvid, label, propertyKey, propertyValue, currentLineNumber, line, sdf);
    }

    protected abstract void loadDataIntoDb(Long var1, Long var2, Long var3, String var4, String var5, Object var6, long var7, String var9, SimpleDateFormat var10) throws Exception;

    private Long extractSVIDFromLine(long currentLineNumber, String[] fields, String line) {
        return this.extractVIDForEdgeFromLine(currentLineNumber, fields, line, InvalidIdArgumentException.Column.SVID, this.getSourceVertexItemIndex());
    }

    private Long extractDVIDFromLine(long currentLineNumber, String[] fields, String line) {
        return this.extractVIDForEdgeFromLine(currentLineNumber, fields, line, InvalidIdArgumentException.Column.DVID, this.getDestinationVertexItemIndex());
    }

    private Long extractVIDForEdgeFromLine(long currentLineNumber, String[] fields, String line, InvalidIdArgumentException.Column column, int position) {
        String field = fields[position];
        try {
            return Long.valueOf(field);
        }
        catch (NumberFormatException ex) {
            InvalidIdArgumentException ive = new InvalidIdArgumentException(field, currentLineNumber, line, column, InvalidIdArgumentException.CauseType.INVALID_NUMERIC_VALUE);
            String msg = ive.getMessage();
            if (this.m_dll != null) {
                this.lErrors[0] = this.lErrors[0] + 1L;
                if (!this.m_dll.continueOnError(this.lErrors[0], currentLineNumber, line, msg)) {
                    throw ive;
                }
            } else {
                throw ive;
            }
            return null;
        }
    }

    @Override
    protected int getItemsPerLine() {
        return 9;
    }

    private int getSourceVertexItemIndex() {
        return 1;
    }

    @Override
    protected int getIDItemIndex() {
        return 0;
    }

    @Override
    protected int getPropertyTypeItemIndex() {
        return 5;
    }

    @Override
    protected int getPropertyKeyItemIndex() {
        return 4;
    }

    @Override
    protected int getLabelItemIndex() {
        return 3;
    }

    private int getDestinationVertexItemIndex() {
        return 2;
    }
}

