/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.loader.CancellableCallable;

public abstract class CompositeCallable
extends CancellableCallable {
    protected static SimpleLog ms_log = SimpleLog.getLog(CompositeCallable.class);

    public abstract ThreadPoolExecutor getThreadPoolExecutor();

    public abstract List<Future<Long>> getTasksFutures(ExecutorCompletionService<Long> var1) throws Exception;

    @Override
    public Long call() throws Exception {
        return this.executeTasks();
    }

    public Long executeTasks() throws Exception {
        ThreadPoolExecutor executor = this.getThreadPoolExecutor();
        ExecutorCompletionService<Long> completionService = new ExecutorCompletionService<Long>(executor);
        List<Future<Long>> tasks = this.getTasksFutures(completionService);
        return HelperUtilities.executeTasks(executor, tasks);
    }
}

