/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.exporter.ffiles;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.exporter.ExporterUtils;

public class OraclePropertyGraphFlatFileExporter {
    static SimpleLog ms_log = SimpleLog.getLog(OraclePropertyGraphFlatFileExporter.class);
    static boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    protected static final String ms_szCS = ParametersBase.getCharset();

    public static void exportEdges(Iterator<OracleEdgeBase>[] itEdgeArray, OutputStream osEdge) throws IOException, FileNotFoundException {
        int idx;
        if (itEdgeArray == null) {
            throw new OraclePropertyGraphException();
        }
        Thread[] edgeExporters = new Thread[itEdgeArray.length];
        for (idx = 0; idx < itEdgeArray.length; ++idx) {
            ms_log.debug("exportEdge: start exporting edges at index " + idx);
            edgeExporters[idx] = new Thread(new ExportWorker<OracleEdgeBase>(itEdgeArray[idx], OracleEdgeBase.class, osEdge));
            edgeExporters[idx].start();
        }
        for (idx = 0; idx < itEdgeArray.length; ++idx) {
            try {
                edgeExporters[idx].join();
                if (!ms_bShowProgress) continue;
                ms_log.debug("exportEdges: finish exporting edges at split " + idx);
                continue;
            }
            catch (InterruptedException e) {
                ms_log.error("exportEdges: operation not completed, exception is ", e);
            }
        }
        ms_log.debug("exportEdges: edges - flush streams");
        osEdge.flush();
        ms_log.debug("exportEdges: end");
    }

    public static void exportVertices(Iterator<OracleVertexBase>[] itVertexArray, OutputStream osVertex) throws IOException, FileNotFoundException {
        int idx;
        if (itVertexArray == null) {
            throw new OraclePropertyGraphException();
        }
        Thread[] vertexExporters = new Thread[itVertexArray.length];
        for (idx = 0; idx < itVertexArray.length; ++idx) {
            ms_log.debug("exportVertices: start exporting vertices at index " + idx);
            vertexExporters[idx] = new Thread(new ExportWorker<OracleVertexBase>(itVertexArray[idx], OracleVertexBase.class, osVertex));
            vertexExporters[idx].start();
        }
        for (idx = 0; idx < itVertexArray.length; ++idx) {
            try {
                vertexExporters[idx].join();
                if (!ms_bShowProgress) continue;
                ms_log.debug("exportVertices: finish exporting vertices at split " + idx);
                continue;
            }
            catch (InterruptedException e) {
                ms_log.error("exportFlatFiles: operation not completed, exception is ", e);
            }
        }
        ms_log.debug("exportVertices: vertices - flush streams");
        osVertex.flush();
        ms_log.debug("exportVertices: end");
    }

    public static void exportVertexFlatFile(OraclePropertyGraphBase pg, OutputStream osVertex, int dop, boolean append, boolean closeStream) throws IOException, FileNotFoundException {
        Iterator<OracleVertexBase> vertices = pg.vertices();
        OraclePropertyGraphFlatFileExporter.exportVertices(new Iterator[]{vertices}, osVertex);
        if (closeStream) {
            ms_log.debug("exportVertexFlatFile: edges - close streams");
            osVertex.close();
        }
    }

    public static void exportEdgeFlatFile(OraclePropertyGraphBase pg, OutputStream osEdge, int dop, boolean append, boolean closeStream) throws IOException, FileNotFoundException {
        Iterator<OracleEdgeBase> edges = pg.edges();
        OraclePropertyGraphFlatFileExporter.exportEdges(new Iterator[]{edges}, osEdge);
        if (closeStream) {
            ms_log.debug("exportEdgeFlatFile: edges - close streams");
            osEdge.close();
        }
    }

    public static void exportFlatFiles(OraclePropertyGraphBase pg, OutputStream osVertex, OutputStream osEdge, int dop, boolean append) throws IOException, FileNotFoundException {
        ms_log.debug("exportFlatFiles: start");
        int iCountVertices = 0;
        int iCountEdges = 0;
        int iCountVertexRows = 0;
        int iCountEdgeRows = 0;
        Iterator<OracleVertexBase> itVertices = pg.vertices();
        while (itVertices != null && itVertices.hasNext()) {
            ++iCountVertices;
            OracleVertexBase v = itVertices.next();
            iCountVertexRows = (int)((long)iCountVertexRows + ExporterUtils.outputVertex(osVertex, v));
        }
        if (ms_bShowProgress) {
            ms_log.debug("exportFlatFiles: finished exporting vertices, processed vertices {} " + iCountVertices + ", generated records " + iCountVertexRows);
        }
        Iterator<OracleEdgeBase> itEdges = pg.edges();
        while (itEdges != null && itEdges.hasNext()) {
            ++iCountEdges;
            OracleEdgeBase e = itEdges.next();
            iCountEdgeRows = (int)((long)iCountEdgeRows + ExporterUtils.outputEdge(osEdge, e));
        }
        if (ms_bShowProgress) {
            ms_log.debug("exportFlatFiles: finished exporting edges, processed edges {} " + iCountEdges + ", generated records " + iCountEdgeRows);
        }
        osVertex.flush();
        osEdge.flush();
        osVertex.close();
        osEdge.close();
        ms_log.debug("exportFlatFiles: end");
    }

    protected static final class ExportWorker<T extends OracleElementBase>
    implements Runnable {
        Iterator<T> iterator;
        Class<T> theClass;
        OutputStream os;
        ByteArrayOutputStream baos;

        public ExportWorker(Iterator<T> iterator, Class<T> theClass, OutputStream os) {
            this.iterator = iterator;
            this.theClass = theClass;
            this.os = os;
            this.baos = new ByteArrayOutputStream(0x1000000);
        }

        @Override
        public void run() {
            if (OracleVertexBase.class.isAssignableFrom(this.theClass)) {
                this.exportVertices(this.iterator, this.os);
            }
            if (OracleEdgeBase.class.isAssignableFrom(this.theClass)) {
                this.exportEdges(this.iterator, this.os);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportVertices(Iterator<OracleVertexBase> itVertices, OutputStream os) {
            try {
                int iCountVertices = 0;
                int iCountVertexRows = 0;
                while (itVertices != null && itVertices.hasNext()) {
                    ++iCountVertices;
                    OracleVertexBase v = itVertices.next();
                    ExporterUtils.outputVertex(this.baos, v);
                    if (this.baos.size() <= 0xC00000) continue;
                    this.baos.flush();
                    OutputStream outputStream = os;
                    synchronized (outputStream) {
                        this.baos.writeTo(os);
                        this.baos.reset();
                    }
                    if (!ms_bShowProgress) continue;
                    ms_log.debug("exportVertices: flush baos, size go down to " + this.baos.size());
                }
                if (ms_bShowProgress) {
                    ms_log.debug("exportFlatFiles: finished exporting vertices, processed vertices {} " + iCountVertices + ", generated records " + iCountVertexRows);
                }
                this.baos.flush();
                OutputStream outputStream = os;
                synchronized (outputStream) {
                    this.baos.writeTo(os);
                    this.baos.reset();
                    os.flush();
                }
                if (ms_bShowProgress) {
                    ms_log.debug("exportVertices: last batch flush baos, size go down to " + this.baos.size());
                }
            }
            catch (IOException ioe) {
                ms_log.error("hit IOException when exporting vertices");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportEdges(Iterator<OracleEdgeBase> itEdges, OutputStream os) {
            try {
                int iCountEdges = 0;
                int iCountEdgeRows = 0;
                while (itEdges != null && itEdges.hasNext()) {
                    ++iCountEdges;
                    OracleEdgeBase e = itEdges.next();
                    ExporterUtils.outputEdge(this.baos, e);
                    if (this.baos.size() <= 0xC00000) continue;
                    this.baos.flush();
                    OutputStream outputStream = os;
                    synchronized (outputStream) {
                        this.baos.writeTo(os);
                        this.baos.reset();
                    }
                    if (!ms_bShowProgress) continue;
                    ms_log.debug("exportEdges: flush baos, size go down to " + this.baos.size());
                }
                if (ms_bShowProgress) {
                    ms_log.debug("exportFlatFiles: finished exporting edges, processed edges {} " + iCountEdges + ", generated records " + iCountEdgeRows);
                }
                this.baos.flush();
                OutputStream outputStream = os;
                synchronized (outputStream) {
                    this.baos.writeTo(os);
                    this.baos.reset();
                    os.flush();
                }
                if (ms_bShowProgress) {
                    ms_log.debug("exportEdges: last batch flush baos, size go down to " + this.baos.size());
                }
            }
            catch (IOException ioe) {
                ms_log.error("hit IOException when exporting edges");
            }
        }
    }
}

