/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import oracle.pg.common.BackendConfig;
import oracle.pg.common.DataConverterListener;
import oracle.pg.common.HelperUtilities;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.OracleVertexPropertyBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SQLUtils;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.pg.common.Util;
import oracle.pg.common.exceptions.FeatureNotSupportedException;

public class ExporterUtils {
    static SimpleLog ms_log = SimpleLog.getLog(ExporterUtils.class);
    private static final String szFieldDelimiter = ",";
    protected static final byte[] baFieldDelimiter = ",".getBytes();
    private static final String szRecordDelimiter = "\n";
    protected static final byte[] baRecordDelimiter = "\n".getBytes();
    static OraclePropertyGraphException ms_opge = new OraclePropertyGraphException();
    protected static final String ms_szCS = ParametersBase.getCharset();
    public static final String SPACE_DELIMITER = " ";

    public static final void writeOneVertexLineWithoutKV(OutputStream os, long lvid) throws IOException {
        ExporterUtils.writeOneVertexLineWithLabelWithoutKV(os, lvid, null);
    }

    public static final void writeOneVertexLineWithLabelWithoutKV(OutputStream os, long lvid, String szLabel) throws IOException {
        ExporterUtils.outputVertexRecord(os, lvid, szLabel, null, null);
    }

    public static final void writeOneVertexLineWithKV(OutputStream os, long lvid, String szPropertyKey, Object value) throws IOException {
        ExporterUtils.writeOneVertexLineWithKV(os, lvid, szPropertyKey, value, null, null, null);
    }

    public static final void writeOneVertexLineWithKV(OutputStream os, long lvid, String vertexLabel, String szPropertyKey, Object value) throws IOException {
        ExporterUtils.writeOneVertexLineWithKV(os, lvid, szPropertyKey, value, vertexLabel, null, null);
    }

    public static final void writeOneVertexLineWithKV(OutputStream os, long lvid, String szPropertyKey, Object value, BackendConfig bc) throws IOException {
        ExporterUtils.writeOneVertexLineWithKV(os, lvid, szPropertyKey, value, null, bc, null);
    }

    public static final void writeOneVertexLineWithKV(OutputStream os, long lvid, String szPropertyKey, Object value, String vertexLabel, BackendConfig bc, DataConverterListener dcl) throws IOException {
        ExporterUtils.writeOneVertexLineWithKV(os, lvid, szPropertyKey, value, vertexLabel, bc, dcl, null);
    }

    public static final void writeOneVertexLineWithKV(OutputStream os, long lvid, String szPropertyKey, Object value, String vertexLabel, BackendConfig bc, DataConverterListener dcl, long[] lErrors) throws IOException {
        block4: {
            if (bc == null) {
                ExporterUtils.writeOneVertexLineWithKV(os, lvid, vertexLabel, szPropertyKey, value, null);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
                try {
                    ExporterUtils.writeOneVertexLineWithKV(baos, lvid, vertexLabel, szPropertyKey, value, bc);
                    baos.writeTo(os);
                }
                catch (OraclePropertyGraphException e) {
                    lErrors[0] = lErrors[0] + 1L;
                    StringBuilder sb = new StringBuilder();
                    sb.append("hit Exception when converting vertex: ");
                    sb.append(lvid);
                    sb.append(" ,property String value exceed the limit: ");
                    sb.append(bc.getPropertyStringValueSizeLimit());
                    if (dcl != null && dcl.continueOnError(0L, 0L, 0, sb.toString())) break block4;
                    ms_log.error("convertRDBMSTable2OPV: did not pass BackendConfig check " + sb.toString());
                    throw e;
                }
            }
        }
    }

    public static final void writeOneVertexLineWithKV(OutputStream os, long lvid, String szLabel, String szPropertyKey, Object value, BackendConfig bc) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        os.write(String.valueOf(lvid).getBytes());
        os.write(baFieldDelimiter);
        if (szPropertyKey == null || szPropertyKey.isEmpty()) {
            szPropertyKey = SPACE_DELIMITER;
        }
        os.write(HelperUtilities.escape(szPropertyKey));
        os.write(baFieldDelimiter);
        ExporterUtils.writeValue(os, value, baFieldDelimiter, sdf, bc);
        ExporterUtils.includeLabelTokens(os, true, szLabel);
        os.write(baRecordDelimiter);
    }

    public static final void writeOneEdgeLineWithoutKV(OutputStream os, long leid, long lsvid, long ldvid, String el) throws IOException {
        ExporterUtils.outputEdgeRecord(os, leid, lsvid, ldvid, el, null, null);
    }

    public static final void writeOneEdgeLineWithKV(OutputStream os, long leid, long lsvid, long ldvid, String el, String szPropertyKey, Object value) throws IOException {
        ExporterUtils.writeOneEdgeLineWithKV(os, leid, lsvid, ldvid, el, szPropertyKey, value, null);
    }

    public static final void writeOneEdgeLineWithKV(OutputStream os, long leid, long lsvid, long ldvid, String el, String szPropertyKey, Object value, BackendConfig bc, DataConverterListener dcl, long[] lErrors) throws IOException {
        block4: {
            if (bc == null) {
                ExporterUtils.writeOneEdgeLineWithKV(os, leid, lsvid, ldvid, el, szPropertyKey, value, null);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
                try {
                    ExporterUtils.writeOneEdgeLineWithKV(baos, leid, lsvid, ldvid, el, szPropertyKey, value, bc);
                    baos.writeTo(os);
                }
                catch (OraclePropertyGraphException e) {
                    lErrors[0] = lErrors[0] + 1L;
                    StringBuilder sb = new StringBuilder();
                    sb.append("hit Exception when converting edge: ");
                    sb.append(leid);
                    sb.append(" ,property String value exceed the limit: ");
                    sb.append(bc.getPropertyStringValueSizeLimit());
                    if (dcl != null && dcl.continueOnError(0L, 0L, 0, sb.toString())) break block4;
                    ms_log.error("convertRDBMSTable2OPE: did not pass BackendConfig check " + sb.toString());
                    throw e;
                }
            }
        }
    }

    public static final void writeOneEdgeLineWithKV(OutputStream os, long leid, long lsvid, long ldvid, String el, String szPropertyKey, Object value, BackendConfig bc) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        os.write(String.valueOf(leid).getBytes());
        os.write(baFieldDelimiter);
        os.write(String.valueOf(lsvid).getBytes());
        os.write(baFieldDelimiter);
        os.write(String.valueOf(ldvid).getBytes());
        os.write(baFieldDelimiter);
        os.write(HelperUtilities.escape(el));
        os.write(baFieldDelimiter);
        if (szPropertyKey == null || szPropertyKey.isEmpty()) {
            szPropertyKey = SPACE_DELIMITER;
        }
        os.write(HelperUtilities.escape(szPropertyKey));
        os.write(baFieldDelimiter);
        ExporterUtils.writeValue(os, value, baFieldDelimiter, sdf, bc);
        os.write(baRecordDelimiter);
    }

    public static final void writeValue(OutputStream os, Object value, byte[] baFieldDelimiter, SimpleDateFormat sdf) throws IOException {
        ExporterUtils.writeValue(os, value, baFieldDelimiter, sdf, null);
    }

    public static final void writeValue(OutputStream os, Object value, byte[] baFieldDelimiter, SimpleDateFormat sdf, BackendConfig bc) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("writeValue: value is null");
        }
        if (value instanceof String) {
            byte[] baValueToinsert = HelperUtilities.escape(value.toString());
            if (bc != null && bc.doesPropertyStringValueSizeExceedLimit(baValueToinsert)) {
                throw ms_opge;
            }
            os.write(Integer.toString(1).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baValueToinsert);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else if (value instanceof Float) {
            os.write(Integer.toString(3).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
        } else if (value instanceof Integer) {
            os.write(Integer.toString(2).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
        } else if (value instanceof Double) {
            os.write(Integer.toString(4).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
        } else if (value instanceof Long) {
            os.write(Integer.toString(7).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
        } else if (value instanceof Short) {
            os.write(Integer.toString(8).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
        } else if (value instanceof Byte) {
            os.write(Integer.toString(9).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
        } else if (value instanceof Character) {
            os.write(Integer.toString(10).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(value.toString()));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else if (value instanceof Date) {
            os.write(Integer.toString(5).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(sdf.format((Date)value)));
        } else if (value instanceof Boolean) {
            os.write(Integer.toString(6).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape((Boolean)value != false ? "Y" : "N"));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else if (value instanceof SimpleSpatialDataWrapper) {
            byte[] baValueToinsert = HelperUtilities.escape(((SimpleSpatialDataWrapper)value).serialize());
            if (bc != null && bc.doesPropertyStringValueSizeExceedLimit(baValueToinsert)) {
                throw ms_opge;
            }
            os.write(Integer.toString(20).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baValueToinsert);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else if (value instanceof SimpleJsonDataWrapper) {
            byte[] baValueToinsert = HelperUtilities.escape(((SimpleJsonDataWrapper)value).serialize());
            if (bc != null && bc.doesPropertyStringValueSizeExceedLimit(baValueToinsert)) {
                throw ms_opge;
            }
            os.write(Integer.toString(25).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baValueToinsert);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else if (value instanceof SimpleRdfDataWrapper) {
            byte[] baValueToinsert = HelperUtilities.escape(((SimpleRdfDataWrapper)value).serialize());
            if (bc != null && bc.doesPropertyStringValueSizeExceedLimit(baValueToinsert)) {
                throw ms_opge;
            }
            os.write(Integer.toString(30).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baValueToinsert);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else if (value instanceof Serializable) {
            byte[] baValueToInsert = HelperUtilities.escape(OraclePropertyGraphBase.serializableToStr((Serializable)value));
            if (bc != null && bc.doesPropertyStringValueSizeExceedLimit(baValueToInsert)) {
                throw ms_opge;
            }
            os.write(Integer.toString(101).getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(baValueToInsert);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
        } else {
            throw new OraclePropertyGraphException("writeValue: Unknown value type : " + value.getClass().getName());
        }
    }

    public static void insertOneVertexLineWithoutKVIntoDB(Connection conn, String pgName, long lvid) {
        String user = ExporterUtils.getValidSchemaName(conn);
        String table = ExporterUtils.getValidName(conn, pgName + "VT$");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(user).append(".").append(table);
        sb.append(" ( VID, K, T, V, VN, VT, SL, VTS, VTE, FE ) values ( :1, :2, :3, :4, :5, :6, :7, :8, :9, :10 )");
        try (PreparedStatement stmt2 = conn.prepareStatement(sb.toString());){
            stmt2.setLong(1, lvid);
            stmt2.setString(2, SPACE_DELIMITER);
            stmt2.setNull(3, 8);
            stmt2.setNull(4, -9);
            stmt2.setNull(5, 8);
            stmt2.setNull(6, 91);
            stmt2.setNull(7, 8);
            stmt2.setNull(8, 91);
            stmt2.setNull(9, 91);
            stmt2.setNull(10, -9);
            stmt2.execute();
            conn.commit();
        }
        catch (SQLIntegrityConstraintViolationException stmt2) {
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    public static void insertOneVertexLineWithKVIntoDB(Connection conn, String pgName, long lvid, String szPropertyKey, Object value) throws IOException {
        String user = ExporterUtils.getValidSchemaName(conn);
        String table = ExporterUtils.getValidName(conn, pgName + "VT$");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(user).append(".").append(table);
        sb.append(" ( VID, K, T, V, VN, VT, SL, VTS, VTE, FE ) values ( :1, :2, :3, :4, :5, :6, :7, :8, :9, :10 )");
        try (PreparedStatement stmt2 = conn.prepareStatement(sb.toString());){
            stmt2.setLong(1, lvid);
            SQLUtils.setStmtArgumentForDml(2, stmt2, szPropertyKey, value);
            stmt2.setNull(7, 8);
            stmt2.setNull(8, 91);
            stmt2.setNull(9, 91);
            stmt2.setNull(10, -9);
            stmt2.execute();
            conn.commit();
        }
        catch (SQLIntegrityConstraintViolationException stmt2) {
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    private static String getValidSchemaName(Connection conn) {
        try {
            return ExporterUtils.getValidName(conn, "\"" + conn.getSchema() + "\"");
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    private static String getValidName(Connection conn, String name) {
        try {
            return Util.enquoteNameSQLName(conn, name);
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    public static void insertOneEdgeLineWithoutKVIntoDB(Connection conn, String pgName, long leid, long lsvid, long ldvid, String el) {
        String user = ExporterUtils.getValidSchemaName(conn);
        String table = ExporterUtils.getValidName(conn, pgName + "GE$");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(user).append(".").append(table);
        sb.append(" ( EID, SVID, DVID, EL, K, T, V, VN, VT, SL, VTS, VTE, FE ) values ( :1, :2, :3, :4, :5, :6, :7, :8, :9, :10, :11, :12, :13)");
        try (PreparedStatement stmt2 = conn.prepareStatement(sb.toString());){
            stmt2.setLong(1, leid);
            stmt2.setLong(2, lsvid);
            stmt2.setLong(3, ldvid);
            stmt2.setString(4, el);
            stmt2.setString(5, SPACE_DELIMITER);
            stmt2.setNull(6, 8);
            stmt2.setNull(7, -9);
            stmt2.setNull(8, 8);
            stmt2.setNull(9, 91);
            stmt2.setNull(10, 8);
            stmt2.setNull(11, 91);
            stmt2.setNull(12, 91);
            stmt2.setNull(13, -9);
            stmt2.execute();
            conn.commit();
        }
        catch (SQLIntegrityConstraintViolationException stmt2) {
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    public static void insertOneEdgeLineWithKVIntoDB(Connection conn, String pgName, long leid, long lsvid, long ldvid, String el, String szPropertyKey, Object value) throws IOException {
        String user = ExporterUtils.getValidSchemaName(conn);
        String table = ExporterUtils.getValidName(conn, pgName + "GE$");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(user).append(".").append(table);
        sb.append(" ( EID, SVID, DVID, EL, K, T, V, VN, VT, SL, VTS, VTE, FE ) values ");
        sb.append("( :1, :2, :3, :4, :5, :6, :7, :8, :9, :10, :11, :12, :13)");
        try (PreparedStatement stmt2 = conn.prepareStatement(sb.toString());){
            stmt2.setLong(1, leid);
            stmt2.setLong(2, lsvid);
            stmt2.setLong(3, ldvid);
            stmt2.setString(4, el);
            SQLUtils.setStmtArgumentForDml(5, stmt2, szPropertyKey, value);
            stmt2.setNull(10, 8);
            stmt2.setNull(11, 91);
            stmt2.setNull(12, 91);
            stmt2.setNull(13, -9);
            stmt2.execute();
            conn.commit();
        }
        catch (SQLIntegrityConstraintViolationException stmt2) {
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    public static void outputVertexRecord(OutputStream os, Long vid, String szLabel, String szPropertyKey, Object value) throws IOException {
        ExporterUtils.outputVertexRecord(os, vid, szLabel, szPropertyKey, value, true);
    }

    public static void outputVertexRecord(OutputStream os, Long vid, String szLabel, String szPropertyKey, Object value, boolean supportsVertexLabels) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        if (szPropertyKey == null || szPropertyKey.isEmpty()) {
            os.write(vid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(SPACE_DELIMITER));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            ExporterUtils.includeLabelTokens(os, supportsVertexLabels, szLabel);
            os.write(baRecordDelimiter);
        } else {
            os.write(vid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(szPropertyKey));
            os.write(baFieldDelimiter);
            ExporterUtils.writeValue(os, value, baFieldDelimiter, sdf);
            ExporterUtils.includeLabelTokens(os, supportsVertexLabels, szLabel);
            os.write(baRecordDelimiter);
        }
    }

    private static void includeLabelTokens(OutputStream os, boolean supportsVertexLabels, String szLabel) throws IOException {
        if (supportsVertexLabels && szLabel != null) {
            os.write(baFieldDelimiter);
            if (!szLabel.isEmpty()) {
                os.write(HelperUtilities.escape(szLabel));
            }
        }
    }

    public static void outputEdgeRecord(OutputStream os, Long eid, Long svid, Long dvid, String label, String szPropertyKey, Object value) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        if (szPropertyKey == null || szPropertyKey.isEmpty()) {
            os.write(eid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(svid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(dvid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(label));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(SPACE_DELIMITER));
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(baFieldDelimiter);
            os.write(baRecordDelimiter);
        } else {
            os.write(eid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(svid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(dvid.toString().getBytes(ms_szCS));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(label));
            os.write(baFieldDelimiter);
            os.write(HelperUtilities.escape(szPropertyKey));
            os.write(baFieldDelimiter);
            ExporterUtils.writeValue(os, value, baFieldDelimiter, sdf);
            os.write(baRecordDelimiter);
        }
    }

    public static long outputVertex(OutputStream osVertex, OracleVertexBase v) throws IOException {
        String szLabel = null;
        try {
            szLabel = v.label();
        }
        catch (FeatureNotSupportedException e) {
            szLabel = null;
        }
        Set<String> vertexKeys = v.keys();
        long iCountVertexRows = 0L;
        if (vertexKeys.isEmpty()) {
            ++iCountVertexRows;
            ExporterUtils.outputVertexRecord(osVertex, (Long)v.id(), szLabel, null, null, v.graph().supportVertexLabels());
        } else {
            Iterator<String> vertexKeyIterator = vertexKeys.iterator();
            while (vertexKeyIterator != null && vertexKeyIterator.hasNext()) {
                ++iCountVertexRows;
                String szPropertyKey = vertexKeyIterator.next();
                if (szPropertyKey == null || szPropertyKey.isEmpty()) {
                    szPropertyKey = SPACE_DELIMITER;
                }
                Object value = ((OracleVertexPropertyBase)v.property(szPropertyKey)).value();
                ExporterUtils.outputVertexRecord(osVertex, (Long)v.id(), szLabel, szPropertyKey, value, v.graph().supportVertexLabels());
            }
        }
        return iCountVertexRows;
    }

    public static long outputEdge(OutputStream osEdge, OracleEdgeBase e) throws IOException {
        Set<String> edgeKeys = e.keys();
        long iCountEdgeRows = 0L;
        if (edgeKeys.isEmpty()) {
            ++iCountEdgeRows;
            ExporterUtils.outputEdgeRecord(osEdge, (Long)e.id(), (Long)e.outVertex().id(), (Long)e.inVertex().id(), e.label(), null, null);
        } else {
            Iterator<String> edgeKeyIterator = edgeKeys.iterator();
            while (edgeKeyIterator != null && edgeKeyIterator.hasNext()) {
                ++iCountEdgeRows;
                String szPropertyKey = edgeKeyIterator.next();
                if (szPropertyKey == null || szPropertyKey.isEmpty()) {
                    szPropertyKey = SPACE_DELIMITER;
                }
                Object value = e.property(szPropertyKey).value();
                ExporterUtils.outputEdgeRecord(osEdge, (Long)e.id(), (Long)e.outVertex().id(), (Long)e.inVertex().id(), e.label(), szPropertyKey, value);
            }
        }
        return iCountEdgeRows;
    }
}

