/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import oracle.jdbc.OracleStatement;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;

public class Util {
    static SimpleLog ms_log = SimpleLog.getLog(Util.class);

    public static String checkSQLName(String string, int maxStringLength) throws SQLException {
        if (string == null) {
            return null;
        }
        if (string.contains(".")) {
            throw new SQLException("The input string cannot contain '.'");
        }
        return oracle.spatial.util.Util.checkSQLName((String)string, (int)maxStringLength);
    }

    public static String myCheckName(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String tmpString = string.trim();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tmpString.length(); ++i) {
            char ch = tmpString.charAt(i);
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String qualifiedSQLName(Connection conn, String name) throws SQLException {
        return oracle.spatial.util.Util.qualifiedSQLName((Connection)conn, (String)name);
    }

    public static int getMaxLengthAllowed() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String enquoteLiteral(Connection conn, String name) throws SQLException {
        String sqlName = null;
        try (Statement stmt = null;){
            if (name != null) {
                stmt = conn.createStatement();
                sqlName = ((OracleStatement)stmt).enquoteLiteral(name);
            }
        }
        return sqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String simpleSqlNameCheck(Connection conn, String name) throws SQLException {
        String sqlName = null;
        try (Statement stmt = null;){
            if (name != null) {
                stmt = conn.createStatement();
                sqlName = ((OracleStatement)stmt).enquoteIdentifier(name, false);
            }
        }
        return sqlName;
    }

    public static String enquoteLiteral(Connection conn, String literal, int maxLengthAllowed) throws SQLException {
        String newLiteral = null;
        try {
            newLiteral = Util.checkSQLName(literal, maxLengthAllowed);
            newLiteral = '\'' + newLiteral + '\'';
        }
        catch (SQLException sqle) {
            ms_log.debug("enquoteLiteral: make a DB roundtrip");
            newLiteral = Util.enquoteLiteral(conn, literal);
        }
        return newLiteral;
    }

    public static String getValidatedGraphName(Connection conn, String graphName, int maxLengthAllowed) throws SQLException {
        String newLiteral = null;
        try {
            newLiteral = Util.checkSQLName(graphName, maxLengthAllowed);
        }
        catch (SQLException sqle) {
            ms_log.debug("getValidatedGraphName: make a DB roundtrip");
            newLiteral = Util.simpleSqlNameCheck(conn, graphName);
        }
        return newLiteral;
    }

    public static String getValidatedGraphName(Connection conn, String graphName) throws SQLException {
        return Util.getValidatedGraphName(conn, graphName, Util.getMaxLengthAllowed());
    }

    public static String enquoteNameSQLName(Connection conn, String name) throws SQLException {
        String newName = null;
        if (name == null) {
            return null;
        }
        try {
            newName = Util.checkSQLName(name, Util.getMaxLengthAllowed());
            if (newName != null) {
                newName = '\"' + newName.toUpperCase() + '\"';
            }
        }
        catch (SQLException sqle) {
            ms_log.debug("enquoteNameSQLName: make a DB roundtrip");
            newName = oracle.spatial.util.Util.enquoteNameSQLName((Connection)conn, (String)name);
        }
        return newName;
    }

    public static String enquoteTableName(Connection conn, String tableName) throws SQLException {
        return oracle.spatial.util.Util.enquoteTableName((Connection)conn, (String)tableName);
    }

    public static String enquoteColumnName(Connection conn, String columnName) throws SQLException {
        return oracle.spatial.util.Util.enquoteTableName((Connection)conn, (String)columnName);
    }

    public static String enquoteColumnNameCaseSensitive(Connection conn, String name) throws SQLException {
        return oracle.spatial.util.Util.enquoteNameSQLName((Connection)conn, (String)name, (boolean)false);
    }

    public static String sanitizeSimpleFileName(String fileName) throws IllegalArgumentException {
        String allowedChars = ParametersBase.getInstance().getAllowedCharactersForSimpleFileNames();
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("sanitizeSimpleFileName: file name should not be null or empty");
        }
        for (int index = 0; index < fileName.length(); ++index) {
            char c = fileName.charAt(index);
            if (allowedChars.indexOf(c) >= 0) continue;
            throw new IllegalArgumentException("sanitizeSimpleFileName: character " + c + " in file name " + fileName + " is not allowed");
        }
        return fileName;
    }

    public static boolean compareDates(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!(o1 instanceof Date) && !(o1 instanceof String)) {
            return false;
        }
        if (!(o2 instanceof Date) && !(o2 instanceof String)) {
            return false;
        }
        String s1 = o1 instanceof String ? (String)o1 : (o1 instanceof Timestamp ? ((Date)((Timestamp)o1)).toString() : ((Date)o1).toString());
        String s2 = o2 instanceof String ? (String)o2 : (o2 instanceof Timestamp ? ((Date)((Timestamp)o2)).toString() : ((Date)o2).toString());
        return s1.equals(s2);
    }
}

