/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLog {
    private static final int LEVEL_FATAL = 1;
    private static final int LEVEL_ERROR = 2;
    private static final int LEVEL_INFO = 3;
    private static final int LEVEL_WARN = 4;
    private static final int LEVEL_DEBUG = 5;
    private static final boolean ms_bQuiet = "true".equalsIgnoreCase(System.getProperty("oracle.spatial.opg.skipLog"));
    private static Writer ms_writerGlobalConsole = null;
    private static long ms_lOpStartTime = 0L;
    private static int ms_iLevel = 3;
    private static String ms_szConsoleFile = null;
    private static boolean ms_bThreadedConsoleModel = false;
    static Map<String, FileWriter> ms_consoleFiles = null;
    private Logger m_log = null;
    private boolean m_bInConsoleMode = false;
    private int m_iConsoleLogLevel = 3;
    private String m_szClsName = null;
    private Writer m_writerConsole = null;

    public static SimpleLog getLog(Class c) {
        Logger logger = LoggerFactory.getLogger((Class)c);
        SimpleLog sl = new SimpleLog(logger);
        if ("true".equalsIgnoreCase(System.getProperty("oracle.spatial.rdf.client.jena.inConsole"))) {
            sl.setInConsoleMode(true);
            ms_szConsoleFile = System.getProperty("oracle.spatial.rdf.client.jena.consoleFile");
            if (ms_szConsoleFile == null || ms_szConsoleFile.trim().length() <= 0) {
                ms_szConsoleFile = "/tmp/semconsole.output";
            }
            sl.setClassName(c.getName());
            if (ms_writerGlobalConsole == null) {
                ms_lOpStartTime = System.currentTimeMillis();
                ms_iLevel = Integer.parseInt(System.getProperty("oracle.spatial.rdf.client.jena.consoleLogLevel"));
                try {
                    ms_writerGlobalConsole = new FileWriter(FilenameUtils.normalize((String)ms_szConsoleFile));
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            sl.setConsoleWriter(ms_writerGlobalConsole);
            sl.setConsoleLogLevel(ms_iLevel);
        } else {
            sl.setInConsoleMode(false);
        }
        return sl;
    }

    private SimpleLog(Logger log) {
        this.m_log = log;
    }

    public void info(Object mesg1, Object mesg2) {
        if (ms_bQuiet) {
            return;
        }
        this.info(new StringBuffer().append(mesg1).append(mesg2).toString());
    }

    public void info(Object mesg) {
        if (ms_bQuiet) {
            return;
        }
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 3) {
                this.consoleOutput(mesg.toString());
            }
        } else {
            this.m_log.info(mesg.toString());
        }
    }

    public void info(Object mesg, Throwable t) {
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 3) {
                this.consoleOutput(mesg.toString(), t.toString());
            }
            return;
        }
        this.m_log.info(mesg.toString(), t);
    }

    public boolean isInfoEnabled() {
        if (this.m_bInConsoleMode) {
            return this.m_iConsoleLogLevel >= 3;
        }
        return this.m_log.isInfoEnabled();
    }

    public void warn(Object mesg1, Object mesg2) {
        if (ms_bQuiet) {
            return;
        }
        this.warn(new StringBuffer().append(mesg1).append(mesg2).toString());
    }

    public void warn(Object mesg) {
        if (ms_bQuiet) {
            return;
        }
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 4) {
                this.consoleOutput(mesg.toString());
            }
            return;
        }
        this.m_log.warn(mesg.toString());
    }

    public void warn(Object mesg, Throwable t) {
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 4) {
                this.consoleOutput(mesg.toString(), t.toString());
            }
            return;
        }
        this.m_log.warn(mesg.toString(), t);
    }

    public boolean isWarnEnabled() {
        if (this.m_bInConsoleMode) {
            return this.m_iConsoleLogLevel >= 4;
        }
        return this.m_log.isWarnEnabled();
    }

    public void debug(Object mesg1, Object mesg2) {
        if (ms_bQuiet) {
            return;
        }
        this.debug(new StringBuffer().append(mesg1).append(mesg2).toString());
    }

    public void debug(Object mesg) {
        if (ms_bQuiet) {
            return;
        }
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 5) {
                this.consoleOutput(mesg.toString());
            }
            return;
        }
        this.m_log.debug(mesg.toString());
    }

    public void debug(Object mesg, Throwable t) {
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 5) {
                this.consoleOutput(mesg.toString(), t.toString());
            }
            return;
        }
        this.m_log.debug(mesg.toString(), t);
    }

    public boolean isDebugEnabled() {
        if (this.m_bInConsoleMode) {
            return this.m_iConsoleLogLevel >= 5;
        }
        return this.m_log.isDebugEnabled();
    }

    public void fatal(Object mesg) {
        if (ms_bQuiet) {
            return;
        }
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 1) {
                this.consoleOutput(mesg.toString());
            }
            return;
        }
        this.m_log.error(mesg.toString());
    }

    public void fatal(Object mesg, Throwable t) {
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 1) {
                this.consoleOutput(mesg.toString(), t.toString());
            }
            return;
        }
        this.m_log.error(mesg.toString(), t);
    }

    public boolean isFatalEnabled() {
        if (this.m_bInConsoleMode) {
            return this.m_iConsoleLogLevel >= 2;
        }
        return this.m_log.isErrorEnabled();
    }

    public void error(Object mesg) {
        if (ms_bQuiet) {
            return;
        }
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 2) {
                this.consoleOutput(mesg.toString());
            }
            return;
        }
        this.m_log.error(mesg.toString());
    }

    public void error(Object mesg, Throwable t) {
        if (this.m_bInConsoleMode) {
            if (this.m_iConsoleLogLevel >= 2) {
                this.consoleOutput(mesg.toString(), t.toString());
            }
            return;
        }
        this.m_log.error(mesg.toString(), t);
    }

    public boolean isErrorEnabled() {
        return this.m_log.isErrorEnabled();
    }

    void setConsoleLogLevel(int i) {
        this.m_iConsoleLogLevel = i;
    }

    void setInConsoleMode(boolean b) {
        this.m_bInConsoleMode = b;
    }

    void setConsoleWriter(Writer w) {
        this.m_writerConsole = w;
    }

    private FileWriter getFW(String szThread) throws Exception {
        FileWriter fw = ms_consoleFiles.get(szThread);
        if (fw != null) {
            return fw;
        }
        fw = new FileWriter(FilenameUtils.normalize((String)(ms_szConsoleFile + "_" + szThread)));
        ms_consoleFiles.put(szThread, fw);
        return fw;
    }

    private void consoleOutput(String s1) {
        if (this.m_writerConsole != null) {
            if (ms_bThreadedConsoleModel) {
                Thread thread = Thread.currentThread();
                String szThread = thread.toString();
                if (szThread == null) {
                    szThread = "_empty_thread_";
                }
                try {
                    FileWriter fw = this.getFW(szThread);
                    fw.write("\nconsole> [");
                    fw.write(this.m_szClsName);
                    fw.write(" ");
                    fw.write(Long.toString(System.currentTimeMillis() - ms_lOpStartTime));
                    fw.write("ms ] ");
                    fw.write(s1);
                    fw.flush();
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    this.m_writerConsole.write("\nconsole> [");
                    this.m_writerConsole.write(this.m_szClsName);
                    this.m_writerConsole.write(" ");
                    this.m_writerConsole.write(Long.toString(System.currentTimeMillis() - ms_lOpStartTime));
                    this.m_writerConsole.write("ms ] ");
                    this.m_writerConsole.write(s1);
                    this.m_writerConsole.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void setClassName(String s) {
        this.m_szClsName = s.substring(s.lastIndexOf(".") + 1);
    }

    private void consoleOutput(String s1, String s2) {
        if (this.m_writerConsole != null) {
            try {
                this.m_writerConsole.write("\nconsole> [");
                this.m_writerConsole.write(this.m_szClsName);
                this.m_writerConsole.write(" ");
                this.m_writerConsole.write(Long.toString(System.currentTimeMillis() - ms_lOpStartTime));
                this.m_writerConsole.write("ms ] ");
                this.m_writerConsole.write(s1);
                this.m_writerConsole.write(s2);
                this.m_writerConsole.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        String s = System.getProperty("oracle.spatial.rdf.client.jena.threadedConsoleFile");
        try {
            ms_bThreadedConsoleModel = "true".equalsIgnoreCase(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ms_bThreadedConsoleModel) {
            ms_consoleFiles = Collections.synchronizedMap(new HashMap());
        }
    }
}

