/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.PropertyReadWorker;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;

class PropertyReader
implements Callable<Map<String, Class>>,
MesgConsts {
    static SimpleLog ms_log = SimpleLog.getLog(PropertyReader.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    static boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    boolean m_bVertex;
    InputStream[] m_isa;
    Map<String, Class> m_properties = new HashMap<String, Class>();
    int m_dop = 4;
    static String DELIMITER = ",";
    static String SPACE = "%20";
    DataLoaderListener m_dll = null;

    PropertyReader(boolean bVertex, InputStream[] isa, int dop, DataLoaderListener dll) {
        this.m_bVertex = bVertex;
        if (isa != null) {
            this.m_isa = new InputStream[isa.length];
            for (int i = 0; i < isa.length; ++i) {
                this.m_isa[i] = isa[i];
            }
        } else {
            this.m_isa = null;
        }
        this.m_dop = dop;
        this.m_dll = dll;
    }

    public Map<String, Class> getPropertyMap() {
        return this.m_properties;
    }

    public static Class getDatatypeClass(int datatype) {
        switch (datatype) {
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Float.class;
            }
            case 4: {
                return Double.class;
            }
            case 7: {
                return Long.class;
            }
            case 8: {
                return Short.class;
            }
            case 9: {
                return Byte.class;
            }
            case 10: {
                return Character.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 5: {
                return LocalDate.class;
            }
            case 20: {
                return SimpleSpatialDataWrapper.class;
            }
            case 25: {
                return SimpleJsonDataWrapper.class;
            }
            case 30: {
                return SimpleRdfDataWrapper.class;
            }
            case 101: {
                return Serializable.class;
            }
        }
        Message mesg = new Message("ERR_INVALID_NUMBER", "getDatatypeClass: invalid datatype, t => [" + datatype + "], not in (1, 2, 3, 4, 5, 6, 101)");
        throw new OraclePropertyGraphException(mesg.toString());
    }

    public static Map<String, Class> updateMap(Map<String, Class> original, Map<String, Class> mapToCopy) {
        Set<Map.Entry<String, Class>> properties = mapToCopy.entrySet();
        for (Map.Entry<String, Class> property : properties) {
            original = PropertyReader.addPropertyToMap(original, property.getKey(), property.getValue());
        }
        return original;
    }

    public static Map<String, Class> addPropertyToMap(Map<String, Class> properties, String key, Class datatypeClass) {
        if (!properties.containsKey(key)) {
            properties.put(key, datatypeClass);
        } else {
            Class existingDatatypeClass = properties.get(key);
            if (!existingDatatypeClass.equals(datatypeClass)) {
                if (PropertyReader.isNumericDatatype(existingDatatypeClass) && PropertyReader.isNumericDatatype(datatypeClass)) {
                    if (Double.class.equals((Object)existingDatatypeClass)) {
                        ms_log.debug("addPropertyToMap: already top numeric datatype set to double");
                    } else {
                        datatypeClass = PropertyReader.getTopNumericDatatype(datatypeClass, existingDatatypeClass);
                        properties.put(key, datatypeClass);
                    }
                } else {
                    if (ms_bDebug) {
                        ms_log.debug("addPropertyToMap: override existing datatype " + existingDatatypeClass.getName() + " with String datatype");
                    }
                    properties.put(key, String.class);
                }
            }
        }
        return properties;
    }

    public static boolean isNumericDatatype(Class dtClass) {
        return Short.class.equals((Object)dtClass) || Integer.class.equals((Object)dtClass) || Long.class.equals((Object)dtClass) || Float.class.equals((Object)dtClass) || Double.class.equals((Object)dtClass);
    }

    public static Class getTopNumericDatatype(Class dtClass, Class oldDtClass) {
        if (Double.class.equals((Object)dtClass) || Double.class.equals((Object)dtClass)) {
            return Double.class;
        }
        if (Float.class.equals((Object)dtClass) || Float.class.equals((Object)dtClass)) {
            return Double.class;
        }
        if (Long.class.equals((Object)dtClass) || Long.class.equals((Object)dtClass)) {
            return Long.class;
        }
        if (Integer.class.equals((Object)dtClass) || Integer.class.equals((Object)dtClass)) {
            return Integer.class;
        }
        return dtClass;
    }

    public static void setExceptionHandlers(Thread currentThread, final Thread[] siblingThreadAr) {
        currentThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ms_log.debug("uncaughtException: caught exception on splitter, stop threads");
                for (int idx = 0; idx < siblingThreadAr.length; ++idx) {
                    if (siblingThreadAr[idx] == null || !siblingThreadAr[idx].isAlive()) continue;
                    siblingThreadAr[idx].interrupt();
                }
            }
        });
    }

    @Override
    public Map<String, Class> call() throws ExecutionException {
        if (ms_bDebug) {
            ms_log.debug("PropertyReader run: graph loader starts");
        }
        long lStartTime = System.currentTimeMillis();
        PropertyReadWorker[] propertyWorkers = new PropertyReadWorker[this.m_dop];
        for (int idx = 0; idx < this.m_isa.length; ++idx) {
            propertyWorkers[idx] = new PropertyReadWorker(idx, this.m_isa[idx], this.m_bVertex, this.m_dll);
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.m_isa.length);
        ExecutorCompletionService<Map<String, Class>> completionService = new ExecutorCompletionService<Map<String, Class>>(executor);
        ArrayList<Future<Map<String, Class>>> tasks = new ArrayList<Future<Map<String, Class>>>();
        for (PropertyReadWorker propertyReadWorker : propertyWorkers) {
            Future<Map<String, Class>> propertyReadFuture = completionService.submit(propertyReadWorker);
            tasks.add(propertyReadFuture);
        }
        long loadedItems = 0L;
        for (Future future : tasks) {
            try {
                Map result = (Map)future.get();
                this.m_properties = PropertyReader.updateMap(this.m_properties, result);
            }
            catch (InterruptedException result) {
            }
            catch (ExecutionException e) {
                for (Future future2 : tasks) {
                    future2.cancel(true);
                }
                tasks.clear();
                executor.shutdownNow();
                throw e;
            }
        }
        executor.shutdown();
        return this.m_properties;
    }
}

