/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import oracle.pg.common.DataLoaderListener;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OraclePropertyGraphUtilsBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.PropertyReader;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;

class PropertyReadWorker
implements Callable<Map<String, Class>>,
MesgConsts {
    boolean m_bVertex = false;
    int m_idx = 0;
    InputStream m_is;
    Map<String, Class> m_propertyNames = new HashMap<String, Class>();
    static String DELIMITER = ",";
    static String SPACE = "%20";
    DataLoaderListener m_dll = null;
    static SimpleLog ms_log = SimpleLog.getLog(PropertyReadWorker.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    static boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();

    PropertyReadWorker(int idx, InputStream is, boolean bVertex, DataLoaderListener dll) {
        this.m_idx = idx;
        this.m_is = is;
        this.m_bVertex = bVertex;
        this.m_dll = dll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Class> call() throws IOException {
        Map<String, Class> map;
        String delimiter = ",";
        String emptyKey = "%20";
        long[] lErrors = new long[]{0L};
        long lLine = 0L;
        String line = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.m_is));
            while ((line = br.readLine()) != null) {
                if (this.m_dll != null && lLine % this.m_dll.reportProgressFrequency() == 0L) {
                    this.m_dll.progressTo(lLine, "PropertyReadWorker run: done to " + lLine);
                }
                String[] saFields = line.split(DELIMITER, -1);
                if (!this.m_bVertex) {
                    this.getKeyValue(lLine, line, lErrors, 3, saFields, emptyKey, this.m_dll);
                } else {
                    this.getKeyValue(lLine, line, lErrors, 0, saFields, emptyKey, this.m_dll);
                }
                ++lLine;
            }
            map = this.m_propertyNames;
        }
        catch (Throwable throwable) {
            OraclePropertyGraphUtilsBase.quietlyClose(br);
            throw throwable;
        }
        OraclePropertyGraphUtilsBase.quietlyClose(br);
        return map;
    }

    private void getKeyValue(long lLine, String line, long[] lErrors, int fieldIdx, String[] saFields, String emptyKey, DataLoaderListener dll) {
        String msg = null;
        String szKey = OraclePropertyGraphUtilsBase.unescape(saFields[fieldIdx + 1]);
        if (!szKey.isEmpty() && !szKey.equals(emptyKey)) {
            int t = 0;
            try {
                t = Integer.parseInt(saFields[fieldIdx + 2]);
                Class datatypeClass = PropertyReader.getDatatypeClass(t);
                this.m_propertyNames = PropertyReader.addPropertyToMap(this.m_propertyNames, szKey, datatypeClass);
            }
            catch (NumberFormatException ex) {
                Message mesg = new Message("ERR_INVALID_NUMBER", "getKeyValue: line " + lLine + ": [" + line + "] ", "t => [" + saFields[fieldIdx + 2] + "]");
                msg = mesg.toString();
                if (ms_log.isDebugEnabled()) {
                    ms_log.error(msg);
                }
                if (dll != null) {
                    lErrors[0] = lErrors[0] + 1L;
                    if (!dll.continueOnError(lErrors[0], lLine, line, msg)) {
                        throw new OraclePropertyGraphException(msg, ex);
                    }
                }
                throw new OraclePropertyGraphException(msg, ex);
            }
        }
    }

    public Map<String, Class> getPropertyMap() {
        return this.m_propertyNames;
    }
}

