/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import oracle.pg.common.SimpleLog;

public class ParametersBase {
    static SimpleLog ms_log = SimpleLog.getLog(ParametersBase.class);
    protected static ParametersBase ms_parameters = new ParametersBase();
    static String ms_szInitialKVArraySize = System.getProperty("oracle.pg.initialKVAS");
    static int ms_iInitialKVAS = 1;
    static String ms_szGrowthKVArraySize;
    static int ms_iGrowthKVAS;
    static boolean bSuperVerboseDebug;
    static boolean bUseTinkerpop2;
    static boolean bShowProgress;
    static String ms_szWaitTime;
    static long ms_lWaitTime;
    static boolean bSyncCache;
    static String ms_szCS;
    static String ms_szObjectInputStreamAllowList;
    static String ms_szTempIoDir;
    static String ms_iDOP;
    static int ms_iDefaultDOP;
    static String ms_szDefaultAllowedCharactersForSimpleFileNames;
    static String ms_szCachePtnNum;
    static int ms_iCachePtnNum;
    static String ms_szVertexCacheSize;
    static long ms_lVertexCacheSize;
    static String ms_szEdgeCacheSize;
    static long ms_lEdgeCacheSize;
    static boolean ms_bDisableGraphElementsCache;

    public static ParametersBase getInstance() {
        return ms_parameters;
    }

    int getInitialKVAS() {
        return ms_iInitialKVAS;
    }

    int getGrowthKVAS() {
        return ms_iGrowthKVAS;
    }

    public boolean isSuperVerboseOn() {
        return bSuperVerboseDebug;
    }

    public boolean useTinkerpop2() {
        return bUseTinkerpop2;
    }

    public boolean showProgress() {
        return bShowProgress;
    }

    long getExecutorWaitTime() {
        return ms_lWaitTime;
    }

    public boolean getUseWildcards() {
        return "true".equals(System.getProperty("oracle.pg.useWildCards"));
    }

    public boolean syncCache() {
        return bSyncCache;
    }

    public static String getCharset() {
        if (ms_szCS == null || ms_szCS.length() <= 0) {
            return "UTF8";
        }
        return ms_szCS;
    }

    public static String getObjectInputStreamAllowList() {
        if (ms_szObjectInputStreamAllowList == null || ms_szObjectInputStreamAllowList.length() <= 0) {
            return "java.*;[Ljava.*;javax.*;[Ljavax.*;org.codehaus.jettison.json.JSONObject;oracle.pgql.*;oracle.pgql.lang.spatial.*;";
        }
        return ms_szObjectInputStreamAllowList;
    }

    public static String getTemporaryIODirectory() {
        if (ms_szTempIoDir == null || ms_szTempIoDir.length() <= 0) {
            return "/tmp";
        }
        return ms_szTempIoDir;
    }

    int getDOP() {
        return ms_iDefaultDOP;
    }

    public String getAllowedCharactersForSimpleFileNames() {
        return ms_szDefaultAllowedCharactersForSimpleFileNames;
    }

    int getCachePtnNum() {
        return ms_iCachePtnNum;
    }

    long getVertexCacheSize() {
        return ms_lVertexCacheSize;
    }

    long getEdgeCacheSize() {
        return ms_lEdgeCacheSize;
    }

    public boolean isGraphElementsCacheDisabled() {
        return ms_bDisableGraphElementsCache;
    }

    static {
        try {
            ms_iInitialKVAS = Integer.parseInt(ms_szInitialKVArraySize);
            if (ms_iInitialKVAS <= 0) {
                ms_iInitialKVAS = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szGrowthKVArraySize = System.getProperty("oracle.pg.growthKVAS");
        ms_iGrowthKVAS = 2;
        try {
            ms_iGrowthKVAS = Integer.parseInt(ms_szGrowthKVArraySize);
            if (ms_iGrowthKVAS <= 0) {
                ms_iGrowthKVAS = 2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bSuperVerboseDebug = "true".equalsIgnoreCase(System.getProperty("oracle.pg.superVerbose"));
        bUseTinkerpop2 = "true".equalsIgnoreCase(System.getProperty("oracle.pg.useTinkerpop2"));
        bShowProgress = "true".equalsIgnoreCase(System.getProperty("oracle.pg.showProgress"));
        ms_szWaitTime = System.getProperty("oracle.pg.common.executor.waitTime");
        ms_lWaitTime = 100L;
        try {
            ms_lWaitTime = Long.parseLong(ms_szWaitTime);
            if (ms_lWaitTime <= 0L) {
                ms_lEdgeCacheSize = 100L;
            }
        }
        catch (Throwable t) {
            ms_lEdgeCacheSize = 100L;
        }
        bSyncCache = "true".equalsIgnoreCase(System.getProperty("oracle.pg.syncCache"));
        ms_szCS = System.getProperty("oracle.pg.charset");
        ms_szObjectInputStreamAllowList = System.getProperty("oracle.pg.objectInputStreamAllowList");
        ms_szTempIoDir = System.getProperty("java.io.tmpdir");
        ms_iDOP = System.getProperty("oracle.pg.dop");
        ms_iDefaultDOP = 16;
        try {
            ms_iDefaultDOP = Integer.decode(ms_iDOP);
            if (ms_iDefaultDOP <= 0 && ms_iDefaultDOP > 40) {
                ms_iDefaultDOP = 20;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bShowProgress) {
            ms_log.info((Object)"getDOP: key length", ms_iDefaultDOP);
        }
        ms_szDefaultAllowedCharactersForSimpleFileNames = null;
        try {
            ms_szDefaultAllowedCharactersForSimpleFileNames = System.getProperty("oracle.pg.allowedCharactersForSimpleFileNames");
            if (ms_szDefaultAllowedCharactersForSimpleFileNames == null || ms_szDefaultAllowedCharactersForSimpleFileNames.length() == 0) {
                ms_szDefaultAllowedCharactersForSimpleFileNames = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_/:\\.";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szCachePtnNum = System.getProperty("oracle.pg.rdbms.cachePtnNum");
        ms_iCachePtnNum = 1;
        try {
            ms_iCachePtnNum = Integer.parseInt(ms_szCachePtnNum);
            if (ms_iCachePtnNum <= 0) {
                ms_iCachePtnNum = 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szVertexCacheSize = System.getProperty("oracle.pg.rdbms.vertexCacheSize");
        ms_lVertexCacheSize = 4000L;
        try {
            ms_lVertexCacheSize = Long.parseLong(ms_szVertexCacheSize);
            if (ms_lVertexCacheSize <= 0L) {
                ms_lVertexCacheSize = 4000L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_szEdgeCacheSize = System.getProperty("oracle.pg.rdbms.edgeCacheSize");
        ms_lEdgeCacheSize = 4000L;
        try {
            ms_lEdgeCacheSize = Long.parseLong(ms_szEdgeCacheSize);
            if (ms_lEdgeCacheSize <= 0L) {
                ms_lEdgeCacheSize = 4000L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ms_bDisableGraphElementsCache = "true".equalsIgnoreCase(System.getProperty("oracle.pg.disableGraphElementsCache"));
    }
}

