/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import oracle.pg.common.Direction;
import oracle.pg.common.OracleCommonUtils;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;

public abstract class OracleEdgeBase
extends OracleElementBase {
    protected String m_szEdgeLabel = null;
    public static final String NULL_LBL = Character.toString('\u0000');
    public static final String EMPTY_LBL = Character.toString('\u0000');
    static SimpleLog ms_log = SimpleLog.getLog(OracleEdgeBase.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    protected OracleVertexBase m_vOut;
    protected OracleVertexBase m_vIn;

    protected OracleEdgeBase(OraclePropertyGraphBase opg, Long eid) {
        super(opg, eid);
        this.m_bPartial = true;
        this.m_opg = opg;
        this.m_lID = eid;
    }

    protected OracleEdgeBase(OraclePropertyGraphBase opg, Long eid, String label) {
        this.m_bPartial = true;
        this.m_opg = opg;
        this.m_lID = eid;
        this.m_szEdgeLabel = label;
    }

    protected OracleEdgeBase(OraclePropertyGraphBase opg, OracleVertexBase outVertex, OracleVertexBase inVertex, Long eid) {
        super(opg, eid);
        this.m_bPartial = true;
        this.m_vOut = outVertex;
        this.m_vIn = inVertex;
    }

    protected OracleEdgeBase(OraclePropertyGraphBase opg, OracleVertexBase outVertex, OracleVertexBase inVertex, String edgeLabel, Long eid) {
        this(opg, outVertex, inVertex, eid);
        this.m_szEdgeLabel = edgeLabel;
    }

    public OracleEdgeBase() {
    }

    public Object inVertexID() {
        return this.m_vIn.id();
    }

    public Object outVertexID() {
        return this.m_vOut.id();
    }

    public OracleVertexBase inVertex() {
        return this.m_vIn;
    }

    public OracleVertexBase outVertex() {
        return this.m_vOut;
    }

    public final Iterator<OracleVertexBase> vertices(Direction direction) {
        ArrayList<OracleVertexBase> vertices = new ArrayList<OracleVertexBase>();
        if (Direction.IN.equals((Object)direction) || Direction.BOTH.equals((Object)direction)) {
            vertices.add(this.inVertex());
        } else if (Direction.IN.equals((Object)direction) || Direction.BOTH.equals((Object)direction)) {
            vertices.add(this.outVertex());
        }
        return vertices.iterator();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("Edge ID ").append(this.m_lID).append(" from ").append(this.m_vOut).append(" =[").append(this.m_szEdgeLabel == null ? "NULL" : this.m_szEdgeLabel).append("]=> ").append(this.m_vIn).append(" edgeKV[").append(this.getAttributes()).append("]");
        return sb.toString();
    }

    public final Iterator<OraclePropertyBase<Object>> properties(String ... propertyKeys) {
        ArrayList<OraclePropertyBase<Object>> properties = new ArrayList<OraclePropertyBase<Object>>();
        if (propertyKeys == null || propertyKeys.length <= 0) {
            Set<String> keys = this.keys();
            propertyKeys = new String[keys.size()];
            propertyKeys = keys.toArray(propertyKeys);
        }
        for (String key : propertyKeys) {
            properties.add(this.property(key));
        }
        return properties.iterator();
    }

    public final OraclePropertyBase<Object> property(String key) {
        return new OraclePropertyBase<Object>(this, key, this.propertyValue(key));
    }

    public final OraclePropertyBase<Object> property(String key, Object value) {
        this.property(key, value, false);
        return new OraclePropertyBase<Object>(this, key, value);
    }

    public final int hashCode() {
        ms_log.debug("hashCode: start");
        int hc = this.id().hashCode();
        Set<String> setKeys = this.keys();
        hc = OracleCommonUtils.revolve(hc, setKeys.size());
        for (String szKey : setKeys) {
            hc = OracleCommonUtils.revolve(hc, szKey.hashCode());
            Object obj = this.propertyValue(szKey);
            hc = OracleCommonUtils.revolve(hc, obj.hashCode());
        }
        if (this.label() != null) {
            hc = OracleCommonUtils.revolve(hc, this.label().hashCode());
        }
        if (this.inVertex() != null) {
            hc = OracleCommonUtils.revolve(hc, this.inVertex().hashCode());
        }
        if (this.outVertex() != null) {
            hc = OracleCommonUtils.revolve(hc, this.outVertex().hashCode());
        }
        return hc;
    }

    public final boolean equals(Object o) {
        ms_log.debug("equals: starts");
        if (o == null) {
            ms_log.debug("equals: object to compare is null, return false");
            return false;
        }
        if (this == o) {
            ms_log.debug("equals: object is the same, return true");
            return true;
        }
        if (this.getClass() != o.getClass()) {
            if (ms_bDebug) {
                ms_log.debug((Object)"equals: object class are different, o class is ", o.getClass().getName());
            }
            return false;
        }
        if (ms_bDebug) {
            ms_log.debug("equals: refresh this object, to get most updated state");
        }
        this.refresh();
        if (ms_bDebug) {
            ms_log.debug("equals: refresh object to compare, to get most updated state");
        }
        OracleEdgeBase oe = (OracleEdgeBase)o;
        oe.refresh();
        if (!this.id().equals(oe.id())) {
            if (ms_bDebug) {
                ms_log.debug("equals: ids are different, return false");
            }
            return false;
        }
        Set<String> setKeys = this.keys();
        Set<String> setKeys2 = oe.keys();
        if (setKeys.size() != setKeys2.size()) {
            if (ms_bDebug) {
                ms_log.debug("equals: different key sets, return false");
            }
            return false;
        }
        for (String szKey : setKeys) {
            Object obj = this.propertyValue(szKey);
            Object obj1 = oe.propertyValue(szKey);
            if (obj == null && obj1 != null) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"equals: value exists for key ----- in the object", " to compare but not in this one ");
                }
                return false;
            }
            if (obj1 == null) {
                if (!ms_bDebug) continue;
                ms_log.debug((Object)"equals: value exists for key ----- in this object", " but not in object to compare ");
                continue;
            }
            if (obj.equals(obj1)) continue;
            if (ms_bDebug) {
                ms_log.debug((Object)("equals: different values for key -----, this object: " + obj), ", other vertex: " + obj1);
            }
            if (obj instanceof String || obj instanceof Integer || obj instanceof Long || obj instanceof Double || obj instanceof Float || obj instanceof Date || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Character) {
                if (ms_bDebug) {
                    ms_log.debug("equals: primitive types return false");
                }
                return false;
            }
            if (obj instanceof Serializable && obj1 instanceof Serializable) {
                ms_log.debug("equals: parse serializable objects and compare");
                try {
                    String str1 = OraclePropertyGraphBase.serializableToStr((Serializable)obj);
                    String str2 = OraclePropertyGraphBase.serializableToStr((Serializable)obj);
                    if (ms_bDebug) {
                        ms_log.debug("equals: str1: ----, str2: ----");
                    }
                    if (str1 == null || str2 == null || !str1.equals(str2)) continue;
                    continue;
                }
                catch (Exception e) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"equals: exception found when trying to parse serializable ", e);
                    }
                    return false;
                }
            }
            if (ms_bDebug) {
                ms_log.debug("equals: different values for key -----, this object: , other vertex: ");
            }
            return false;
        }
        String szEdgeLabel = this.label();
        if (szEdgeLabel == null && oe.label() != null) {
            return false;
        }
        if (szEdgeLabel != null && !szEdgeLabel.equals(oe.label())) {
            return false;
        }
        OracleVertexBase ovIn = this.inVertex();
        if (ovIn == null && oe.inVertex() != null) {
            return false;
        }
        if (ovIn != null && !ovIn.equals(oe.inVertex())) {
            return false;
        }
        OracleVertexBase ovOut = this.outVertex();
        if (ovOut == null && oe.outVertex() != null) {
            return false;
        }
        if (ovOut != null && !ovOut.equals(oe.outVertex())) {
            return false;
        }
        ms_log.debug("equals: true");
        return true;
    }

    public final int compareTo(Object o) {
        long lthat;
        if (o == null) {
            throw new NullPointerException("Input argument must not be null");
        }
        OracleEdgeBase v = (OracleEdgeBase)o;
        long lthis = this.m_lID;
        if (lthis < (lthat = ((Long)v.id()).longValue())) {
            return -1;
        }
        if (lthis == lthat) {
            return 0;
        }
        return 1;
    }

    @Override
    public final void remove() {
        ms_log.debug("remove: start");
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        this.m_opg.removeEdge(this);
        this.cleanup();
    }

    @Override
    public final String label() {
        return this.m_szEdgeLabel;
    }

    public final void setLabel(String label) {
        this.setLabel(label, false);
    }

    public final void setLabel(String label, boolean skipUpdate) {
        if (label == null && this.m_szEdgeLabel == null) {
            ms_log.debug("setLabel: both labels are equal to NULL, do nothing");
            return;
        }
        if (label != null && this.m_szEdgeLabel != null && label.equals(this.m_szEdgeLabel)) {
            ms_log.debug("setLabel: both labels are not null, but the same, do nothing");
            return;
        }
        ms_log.debug("setLabel: label changed, update and add to queue");
        this.m_szEdgeLabel = label;
        if (!skipUpdate) {
            if (this.m_opg.isTransientPropertyGraphInstance()) {
                throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
            }
            this.m_opg.addUpdatedEdge(this);
        }
    }

    public final void setInVertex(OracleVertexBase v) {
        this.m_vIn = v;
    }

    public final void setOutVertex(OracleVertexBase v) {
        this.m_vOut = v;
    }

    @Override
    public final void forceRefresh() throws Exception {
        this.m_opg.readEdgeFromDB(this.m_lID, this, true);
    }
}

