/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.pg.common.OracleDBTaskRunnable;
import oracle.pg.common.OraclePropertyGraphUtilsBase;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;

public class OracleDBTaskThread
extends Thread {
    static SimpleLog ms_log = SimpleLog.getLog(OracleDBTaskThread.class);
    protected static final boolean ms_bShowProgress = ParametersBase.getInstance().showProgress();
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    OracleDBTaskRunnable m_innerRunnable;
    public boolean m_bIsTaskFailed = false;

    public OracleDBTaskThread(OracleDBTaskRunnable target, String szName) {
        super(target);
        this.m_innerRunnable = target;
    }

    public OracleDBTaskRunnable getRunnable() {
        return this.m_innerRunnable;
    }

    public boolean isOracleDBTaskFailed() {
        if (ms_bDebug) {
            ms_log.debug("isOracleDBTaskFailed: db task " + this.getName() + " failed? " + this.m_bIsTaskFailed);
        }
        return this.m_bIsTaskFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPaddingQuery(Connection conn) {
        if (conn != null) {
            ms_log.debug("runPaddingQuery: run a padding query to consume any unused cancel at the DB side ");
            PreparedStatement st = null;
            ResultSet rsNew = null;
            try {
                ms_log.debug("runPaddingQuery: padding query start");
                st = conn.prepareStatement("select 1 from dual where rownum <= 1");
                rsNew = st.executeQuery();
                ms_log.debug("runPaddingQuery: done");
            }
            catch (SQLException sqle) {
                block7: {
                    try {
                        if (sqle.getErrorCode() == 1013) {
                            ms_log.debug("runPaddingQuery: padding query takes the hit of 1013. Good! ");
                            break block7;
                        }
                        if (sqle.getMessage().contains("Closed Connection")) {
                            ms_log.debug("runPaddingQuery: padding query takes the hit of Closed Connection. Good! ");
                            break block7;
                        }
                        ms_log.debug((Object)"runPaddingQuery: padding query error ", sqle);
                    }
                    catch (Throwable throwable) {
                        OraclePropertyGraphUtilsBase.quietlyCloseResultSet(rsNew);
                        OraclePropertyGraphUtilsBase.quietlyCloseStmt(st);
                        throw throwable;
                    }
                }
                OraclePropertyGraphUtilsBase.quietlyCloseResultSet(rsNew);
                OraclePropertyGraphUtilsBase.quietlyCloseStmt(st);
            }
            OraclePropertyGraphUtilsBase.quietlyCloseResultSet(rsNew);
            OraclePropertyGraphUtilsBase.quietlyCloseStmt(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAndCloseActiveStmt(Statement ps, String szStmt) {
        Connection conn = null;
        if (ms_bDebug) {
            ms_log.debug((Object)"cancelAndCloseActiveStmt: statement is ", ps);
            ms_log.debug((Object)"cancelAndCloseActiveStmt: statement string is ", szStmt);
        }
        if (ps != null) {
            try {
                conn = ps.getConnection();
                ms_log.debug("cancelAndCloseActiveStmt: cancel statement");
                if (!ps.isClosed()) {
                    ps.cancel();
                }
            }
            catch (SQLException sqle) {
                ms_log.debug((Object)"cancelAndCloseActiveStmt: exception found, Exception is ", sqle);
            }
            finally {
                ms_log.debug("cancelAndCloseActiveStmt: close statement");
                OraclePropertyGraphUtilsBase.quietlyCloseStmt(ps);
                ps = null;
                ms_log.debug("cancelAndCloseActiveStmt: run padding query, just for safety");
                this.runPaddingQuery(conn);
            }
        }
        ms_log.debug("cancelAndCloseActiveStmt: cancel statement done");
    }

    public void stopOracleDbTask() {
        if (ms_bDebug) {
            ms_log.debug((Object)"stopOracleDbTask: started with thread ", this.getName());
        }
        if (ms_bDebug) {
            String szRunnableName = this.m_innerRunnable.getName();
            ms_log.debug("stopOracleDbTask: inner runnable " + szRunnableName + " is OracleDBTaskRunnable, close active statement");
        }
        this.m_bIsTaskFailed = true;
        ms_log.debug("stopOracleDbTask: get active statement from runnable");
        Statement stmt = this.m_innerRunnable.getActiveStatement();
        String szStmt = this.m_innerRunnable.getActiveStatementString();
        ms_log.debug("stopOracleDbTask: cancel and quietly close active statement");
        this.cancelAndCloseActiveStmt(stmt, szStmt);
        this.m_innerRunnable.resetActiveStatement();
    }
}

