/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.IOException;
import oracle.pg.common.OracleMessageConstants;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;

public abstract class OracleCommonIteratorBase
implements MesgConsts,
AutoCloseable {
    static SimpleLog ms_log = SimpleLog.getLog(OracleCommonIteratorBase.class);
    public static final boolean ms_bDebug = ms_log.isDebugEnabled();
    protected static final Message MSG_ERR_NO_OP_SUPPORTED = new Message("ERR_NO_OP_SUPPORTED", "remove");
    protected static final Message MSG_ERR_NO_ELEM_TO_BE_CONSUMED = new Message("ERR_NO_ELEM_TO_BE_CONSUMED");
    protected static final Message MG_ERR_USER_REQ_OP_CANCEL = new Message("ERR_USER_REQ_OP_CANCEL");
    protected long m_lNextCallCount = 0L;
    protected boolean bNextInovked = false;
    protected boolean bNextExhausted = false;
    protected long m_lQueryStartTime = 0L;
    protected boolean m_gracefulTimeout = false;
    protected long m_lQueryTimeOut = 0L;
    protected long m_lQueryDeadLine = 0L;
    protected boolean m_bHitTimeoutAlready = false;
    protected boolean m_bNoMoreItems = false;
    protected boolean m_bTimedOut = false;

    public final void setGracefulTimeout(boolean gracefulTimeout) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"setGracefulTimeout ", Boolean.toString(gracefulTimeout));
        }
        this.m_gracefulTimeout = gracefulTimeout;
    }

    public final void remove() {
        throw new UnsupportedOperationException(OracleMessageConstants.MSG_ERR_NO_OP_SUPPORTED.toString());
    }

    public final boolean hasNext() {
        if (this.m_bNoMoreItems) {
            return false;
        }
        boolean b = this.hasNextInternal();
        if (!b) {
            this.m_bNoMoreItems = true;
            this.close();
        }
        return b;
    }

    protected abstract boolean hasNextInternal();

    @Override
    public abstract void close();

    public final long getQueryStartTime() {
        return this.m_lQueryStartTime;
    }

    public final void setQueryStartTime(long queryStartTime) {
        this.m_lQueryStartTime = queryStartTime;
        ms_log.debug((Object)"setQueryStartTime:", queryStartTime);
    }

    public final long getQueryDeadline() {
        return this.m_lQueryDeadLine;
    }

    public final long getQueryTimeOut() {
        return this.m_lQueryTimeOut;
    }

    public final void setQueryTimeOut(long timeOut) {
        this.m_lQueryTimeOut = timeOut;
        this.m_lQueryStartTime = System.currentTimeMillis();
        this.m_lQueryDeadLine = this.getQueryStartTime() + 1000L * timeOut;
    }

    protected final boolean checkGracefulTimeout() {
        if (!this.m_gracefulTimeout) {
            return false;
        }
        long queryStart = this.getQueryStartTime();
        long queryDeadline = this.getQueryDeadline();
        if (queryStart == 0L || queryDeadline == 0L) {
            return false;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"checkGracefulTimeout: time and deadline:", System.currentTimeMillis() + " " + queryDeadline);
        }
        return System.currentTimeMillis() > queryDeadline + 10L;
    }

    protected final void checkQueryExecutionTimeOut() throws IOException {
        long queryStart = this.getQueryStartTime();
        long queryDeadline = this.getQueryDeadline();
        if (queryStart == 0L || queryDeadline == 0L) {
            return;
        }
        long lCurrent = System.currentTimeMillis();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"checkQueryExecutionTimeOut: called, time out in (ms, negative means due already) = ", Long.toString(queryDeadline - lCurrent));
        }
        if (lCurrent > queryDeadline + 10L) {
            ms_log.debug("checkQueryExecutionTimeOut: time out due. send out 1013 exception");
            this.m_bHitTimeoutAlready = true;
            throw new IOException(MG_ERR_USER_REQ_OP_CANCEL.toString());
        }
    }
}

