/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.bind.DatatypeConverter;
import oracle.pg.common.OracleMessageConstants;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.messages.MesgConsts;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;

public class HelperUtilities
implements OracleMessageConstants,
MesgConsts {
    static SimpleLog ms_log = SimpleLog.getLog(HelperUtilities.class);
    protected static final String ms_szCS = ParametersBase.getCharset();

    public static final long hash64(CharSequence s, int start, int end, long initval) {
        int c;
        int b = c = -559038737 + (int)initval;
        int a = c;
        c += (int)(initval >>> 32);
        int i = start;
        boolean mixed = true;
        while (i < end) {
            int ch;
            mixed = false;
            a += Character.isHighSurrogate((char)(ch = s.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s.charAt(i++)) : ch;
            if (i >= end) break;
            b += Character.isHighSurrogate((char)(ch = (int)s.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s.charAt(i++)) : ch;
            if (i >= end) break;
            c += Character.isHighSurrogate((char)(ch = (int)s.charAt(i++))) && i < end ? Character.toCodePoint((char)ch, s.charAt(i++)) : ch;
            if (i >= end) break;
            a -= c;
            a ^= c << 4 | c >>> -4;
            c += b;
            b -= a;
            b ^= a << 6 | a >>> -6;
            a += c;
            c -= b;
            c ^= b << 8 | b >>> -8;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> -16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> -19;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> -4;
            b += a;
            mixed = true;
        }
        if (!mixed) {
            c ^= b;
            a ^= (c -= b << 14 | b >>> -14);
            b ^= (a -= c << 11 | c >>> -11);
            c ^= (b -= a << 25 | a >>> -25);
            a ^= (c -= b << 16 | b >>> -16);
            b ^= (a -= c << 4 | c >>> -4);
            c ^= (b -= a << 14 | a >>> -14);
            c -= b << 24 | b >>> -24;
        }
        return (long)c + ((long)b << 32);
    }

    public static String sanitizeSimpleFileName(String fileName) throws IllegalArgumentException {
        String allowedChars = ParametersBase.getInstance().getAllowedCharactersForSimpleFileNames();
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("sanitizeSimpleFileName: file name should not be null or empty");
        }
        for (int index = 0; index < fileName.length(); ++index) {
            char c = fileName.charAt(index);
            if (allowedChars.indexOf(c) >= 0) continue;
            throw new IllegalArgumentException("sanitizeSimpleFileName: character " + c + " in file name " + fileName + " is not allowed");
        }
        return fileName;
    }

    public static boolean compareDates(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!(o1 instanceof Date) && !(o1 instanceof String)) {
            return false;
        }
        if (!(o2 instanceof Date) && !(o2 instanceof String)) {
            return false;
        }
        String s1 = o1 instanceof String ? (String)o1 : (o1 instanceof Timestamp ? ((Date)((Timestamp)o1)).toString() : ((Date)o1).toString());
        String s2 = o2 instanceof String ? (String)o2 : (o2 instanceof Timestamp ? ((Date)((Timestamp)o2)).toString() : ((Date)o2).toString());
        return s1.equals(s2);
    }

    public static void flushIfReachLimit(ByteArrayOutputStream baos, OutputStream os) throws IOException {
        HelperUtilities.flushIfReachLimit(baos, os, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushIfReachLimit(ByteArrayOutputStream baos, OutputStream os, long limit) throws IOException {
        if ((long)baos.size() > limit) {
            baos.flush();
            OutputStream outputStream = os;
            synchronized (outputStream) {
                baos.writeTo(os);
                baos.reset();
            }
        }
    }

    public static final byte[] escape(String s) {
        try {
            if (s == null) {
                return null;
            }
            int len = s.length();
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '%') {
                    sb.append("%25");
                    continue;
                }
                if (ch == '\t') {
                    sb.append("%09");
                    continue;
                }
                if (ch == ' ') {
                    sb.append("%20");
                    continue;
                }
                if (ch == '\n') {
                    sb.append("%0A");
                    continue;
                }
                if (ch == '\r') {
                    sb.append("%0D");
                    continue;
                }
                if (ch == ',') {
                    sb.append("%2C");
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString().getBytes(ms_szCS);
        }
        catch (Exception e) {
            throw new OraclePropertyGraphException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String serializableToStr(Serializable seri) throws IOException {
        String s = null;
        if (seri == null) {
            throw new IllegalArgumentException(MSG_ERR_ARG_CANNOT_BE_NULL.toString());
        }
        try (ObjectOutputStream os = null;){
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bs);
            os.writeObject(seri);
            s = DatatypeConverter.printBase64Binary((byte[])bs.toByteArray());
        }
        return s;
    }

    public static final Object strToSerializable(String s) throws IOException {
        Object o = null;
        if (s == null) {
            throw new IllegalArgumentException(MSG_ERR_ARG_CANNOT_BE_NULL.toString());
        }
        try (ValidatingObjectInputStream vos = null;){
            byte[] bytes = DatatypeConverter.parseBase64Binary((String)s);
            ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
            vos = new ValidatingObjectInputStream((InputStream)bs);
            vos.accept(ParametersBase.getObjectInputStreamAllowList().split(";"));
            o = vos.readObject();
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"strToSerializable: o type is ", o.getClass().getName());
        }
        return o;
    }

    public static void waitForTermination(ThreadPoolExecutor executor) {
        long timeout = ParametersBase.getInstance().getExecutorWaitTime();
        while (!executor.isTerminated()) {
            try {
                Thread.currentThread();
                Thread.sleep(timeout);
            }
            catch (InterruptedException ex) {
                ms_log.error("waitForTermination: thread interrupted, ignore");
            }
        }
    }

    public static void cancelSubTasks(List<Future<Long>> tasks, ThreadPoolExecutor executor) {
        if (tasks != null) {
            ms_log.debug("cancelSubTasks: existing tasks, cancel all");
            for (int idx = 0; idx < tasks.size(); ++idx) {
                ms_log.debug("cancelSubTasks: cancelling subtask " + idx);
                Future<Long> f = tasks.get(idx);
                f.cancel(true);
            }
            tasks.clear();
        }
        ms_log.debug("cancelSubTasks: shutdown immediatly executor");
        executor.shutdownNow();
        HelperUtilities.waitForTermination(executor);
    }

    public static long executeTasks(ThreadPoolExecutor executor, List<Future<Long>> tasks) throws Exception {
        try {
            long loadedItems = 0L;
            for (Future<Long> future : tasks) {
                try {
                    Long result = future.get();
                    loadedItems += result.longValue();
                }
                catch (InterruptedException e) {
                    ms_log.debug("executeTasks: Operation already interupted, cancel all remaining tasks");
                    HelperUtilities.cancelSubTasks(tasks, executor);
                }
                catch (ExecutionException e) {
                    HelperUtilities.cancelSubTasks(tasks, executor);
                    throw e;
                }
            }
            executor.shutdown();
            HelperUtilities.waitForTermination(executor);
            return loadedItems;
        }
        catch (Exception e) {
            ms_log.debug("call: current thread interrupted, cancel all sub-tasks");
            HelperUtilities.cancelSubTasks(tasks, executor);
            throw e;
        }
    }
}

