/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.UnsupportedEncodingException;

public interface BackendConfig {
    public boolean hasVectorLabelSizeLimit();

    public int getVectorLabelSizeLimit();

    public boolean hasEdgeLabelSizeLimit();

    public int getEdgeLabelSizeLimit();

    public boolean hasPropertyNameSizeLimit();

    public int getPropertyNameSizeLimit();

    public boolean hasPropertyStringValueSizeLimit();

    public int getPropertyStringValueSizeLimit();

    default public boolean doesVectorLabelSizeExceedLimit(String szLabel) {
        boolean exceedLimt = false;
        if (this.hasVectorLabelSizeLimit() && szLabel != null) {
            try {
                byte[] byteArr = szLabel.getBytes("UTF8");
                if (byteArr.length > this.getVectorLabelSizeLimit()) {
                    exceedLimt = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return exceedLimt;
    }

    default public boolean doesVectorLabelSizeExceedLimit(byte[] baLabel) {
        boolean exceedLimt = false;
        if (this.hasVectorLabelSizeLimit() && baLabel != null && baLabel.length > this.getVectorLabelSizeLimit()) {
            exceedLimt = true;
        }
        return exceedLimt;
    }

    default public boolean doesEdgeLabelSizeExceedLimit(String szLabel) {
        boolean exceedLimt = false;
        if (this.hasEdgeLabelSizeLimit() && szLabel != null) {
            try {
                byte[] byteArr = szLabel.getBytes("UTF8");
                if (byteArr.length > this.getEdgeLabelSizeLimit()) {
                    exceedLimt = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return exceedLimt;
    }

    default public boolean doesEdgeLabelSizeExceedLimit(byte[] baLabel) {
        boolean exceedLimt = false;
        if (this.hasEdgeLabelSizeLimit() && baLabel != null && baLabel.length > this.getEdgeLabelSizeLimit()) {
            exceedLimt = true;
        }
        return exceedLimt;
    }

    default public boolean doesPropertyNameSizeExceedLimit(String szPropertyName) {
        boolean exceedLimt = false;
        if (szPropertyName == null) {
            return exceedLimt;
        }
        if (this.hasPropertyNameSizeLimit()) {
            try {
                byte[] byteArr = szPropertyName.getBytes("UTF8");
                if (byteArr.length > this.getPropertyNameSizeLimit()) {
                    exceedLimt = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return exceedLimt;
    }

    default public boolean doesPropertyNameSizeExceedLimit(byte[] baPropertyName) {
        boolean exceedLimt = false;
        if (baPropertyName == null) {
            return exceedLimt;
        }
        if (this.hasPropertyNameSizeLimit() && baPropertyName.length > this.getPropertyNameSizeLimit()) {
            exceedLimt = true;
        }
        return exceedLimt;
    }

    default public boolean doesPropertyStringValueSizeExceedLimit(String szPropertyValue) {
        boolean exceedLimt = false;
        if (szPropertyValue == null) {
            return exceedLimt;
        }
        if (this.hasPropertyStringValueSizeLimit()) {
            try {
                byte[] byteArr = szPropertyValue.getBytes("UTF8");
                if (byteArr.length > this.getPropertyStringValueSizeLimit()) {
                    exceedLimt = true;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return exceedLimt;
    }

    default public boolean doesPropertyStringValueSizeExceedLimit(byte[] baPropertyValue) {
        boolean exceedLimt = false;
        if (baPropertyValue == null) {
            return exceedLimt;
        }
        if (this.hasPropertyStringValueSizeLimit() && baPropertyValue.length > this.getPropertyStringValueSizeLimit()) {
            exceedLimt = true;
        }
        return exceedLimt;
    }
}

