# Copyright 2013 Isotoma Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from fuselage.tests.base import TestCaseWithRunner
from fuselage.resources import Package, Checkout
from fuselage import error


class TestSubversion(TestCaseWithRunner):

    def test_checkout(self):
        self.bundle.add(Package(name="subversion"))
        self.bundle.add(Checkout(
            name="/subversion",
            repository='https://github.com/isotoma/isotoma.recipe.django',
            branch='trunk',
            scm='subversion'
        ))
        self.check_apply()
        self.failUnlessExists("/subversion/setup.py")

    def test_checkout_branch(self):
        self.bundle.add(Package(name="subversion"))
        self.bundle.add(Checkout(
            name="/subversion",
            repository='https://github.com/isotoma/isotoma.recipe.django',
            branch='branches/version3',
            scm='subversion'
        ))
        self.check_apply()
        self.failUnlessExists("/subversion/setup.py")

    def test_checkout_tag(self, tag="3.0.2"):
        self.bundle.add(Package(name="subversion"))
        self.bundle.add(Checkout(
            name="/subversion",
            repository='https://github.com/isotoma/isotoma.recipe.django',
            tag=tag,
            scm='subversion'
        ))
        self.check_apply()
        self.failUnlessExists("/subversion/setup.py")

    def test_change_to_branch(self):
        self.test_checkout()
        self.bundle.clear()
        self.test_checkout_branch()
        self.bundle.clear()
        self.test_checkout()

    def test_change_trunk_to_tag(self):
        self.test_checkout()
        self.bundle.clear()
        self.test_checkout_tag()
        self.bundle.clear()
        self.test_checkout()

    def test_change_tag_to_tag(self):
        self.test_checkout_tag()
        self.bundle.clear()
        self.test_checkout_tag("3.1.6")

    def test_missing_svn(self):
        self.bundle.add(Package(name="subversion", policy="uninstall"))
        self.bundle.add(Checkout(
            name="/dest",
            repository='/source',
            branch='trunk',
            scm='subversion'
        ))
        self.assertRaises(error.MissingDependency, self.apply)
