/*
 Copyright 2009-2012 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Sat Sep 15 21:23:01 2012 by Lino version 1.5.0.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ];
STRENGTH_CHOICES = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "segr gerne" ] ];
KNOWLEDGE_CHOICES = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
MEDIA_URL = '/media';
ROOT_URL = '';

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See http://lino.saffre-rumma.net/blog/2012/0307.html
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;
    Lino.eventStore.setBaseParam("su",id);
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}


//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 8; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : ROOT_URL + '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});



Lino.open_window = function(win,st) {
  //~ console.log("20120203 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st);
  win.show();
};

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url = ROOT_URL + "/"
      //~ console.log("20120222 Lino.close_all_windows() : location.replace(",ROOT_URL,")");
      //~ if (ROOT_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      location.replace(url);
  } else {
    //~ console.log("20120222 Lino.close_all_windows()",Lino.window_history);
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.5.0.'});


Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}





/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Bitte ein Datum im Format YYYY-MM-DD eingeben (0 für unbekannte Teile).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;
      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,reponse,arg) {
  //~ throw reponse;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "reponse=",reponse,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Tabelle in eigenem Fenster bearbeiten.", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run({base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: 'Confirmation',
    msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    buttons: Ext.MessageBox.YESNOCANCEL,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url: ROOT_URL + '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
      if (on_success && result.success) on_success(result);
      if (on_confirm && result.confirm_message) {
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = result.confirm_message;
          config.fn = function(buttonId,text,opt) {
            if (buttonId == "yes") {
                on_confirm(panel,undefined,result.step);
            }
          }
          Ext.MessageBox.show(config);
          return;
      }
      if (result.message) {
          //~ if (result.alert && ! gridmode) {
          if (result.alert) { // 20120628b 
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              if (result.alert === true) result.alert = "Warnung";
              Ext.MessageBox.alert(result.alert,result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      // 
      if (result.data_record && ! gridmode) {
          //~ not used
          panel.set_status({data_record:result.data_record});
      }
      else if (result.new_status && ! gridmode) {
          //~ not used
          //~ console.log('20120607 new_status');
          panel.set_status(result.new_status);
      }
      else if (result.goto_record_id != undefined && ! gridmode) {
          //~ console.log('20120607 new_status');
          panel.load_record_id(result.goto_record_id);
      }
      else if (result.refresh_all) {
          var cw = panel.get_containing_window();
          //~ console.log("20120123 refresh_all");
          if (cw) {
            cw.main_item.refresh();
          }
          else console.log("20120123 cannot refresh_all",panel);
      } else {
          if (result.refresh) panel.refresh();
      }
      if (result.open_url) {
          //~ console.log(20111126,result.open_url);
          //~ if (!result.message)
              //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
          window.open(result.open_url,'foo',"");
          //~ document.location = result.open_url;
      }
      if (result.eval_js) {
          //~ console.log(20120618,result.eval_js);
          eval(result.eval_js);
      }
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    location.replace(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { return true; } // overridden by subclasses
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = ROOT_URL + '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = ROOT_URL + '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return ROOT_URL+'/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p['an'] = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          text: "[Parameter]", // gear
          enableToggle: true,
          pressed: ! this.params_panel.hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox)
              f.on('check',function() {t.refresh()});
          else if (f instanceof Ext.form.TriggerField)
              f.on('select',function() {t.refresh()});
          else
              f.on('change',function() {t.refresh()});
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      //~ var formdata = Lino.form2dict(this.params_panel);
      //~ console.log('20120203 add_param_values formdata', formdata);
      //~ p.pv = formdata;
      //~ return;
      //~ var formdata = Ext.lib.Ajax.serializeForm(frm);
      var fields = this.params_panel.fields;
      //~ console.log('20120116 gonna loop on', fields);
      var pv = Array(fields.length);
      for(var i=0; i < fields.length;i++) {
          var f = fields[i]
          if (f.formatDate) {
              pv[i] = f.formatDate(f.getValue()); 
          } else {
              pv[i] = f.getValue(); 
          }
      }
      p.pv = pv;
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
    
  },
  set_param_values : function(pv) {
    //~ console.log('20120203 set_param_values', pv);
    if (this.params_panel) {
      if (pv) this.params_panel.form.my_loadRecord(pv);
      else this.params_panel.form.reset(); 
      
      //~ var fields = this.params_panel.fields;
      //~ console.log('20120116 gonna loop on', fields);
      //~ for(var i=0; i < fields.length;i++) {
          //~ var f = fields[i]
          //~ f.setValue(pv[i]); 
      //~ }
      //~ this.refresh();
      //~ console.log(20120113,options);
    }
    //~ var test = {test:"foo"};
    //~ this.add_param_values(test);
    //~ console.log('20120203 set_param_values test is ', test);
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 

Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    var t = c.getEl();
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};

  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  Lino.lino.ContentTypes.detail_action.run({record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

//~ Lino.hide_zero_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ console.log("20120510");
  //~ if (value == 0) return ''
  //~ return value;
//~ }

//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run({record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_row_action = function(panel,url,actionName,step,fn) {
//~ Lino.call_row_action = function(panel,rec_id,actionName,step,fn) {
  //~ var url = panel.get_record_url(rec_id);
  var p = {an : actionName};
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  panel.loadMask.show(); 
  //~ p.su = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  if (step) p['as'] = step;
  Ext.Ajax.request({
    method: 'GET',
    url: url,
    params: p,
    success: Lino.action_handler(panel,undefined,fn)
  });
};

Lino.row_action_handler = function(actionName) {
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_row_action(panel,rec.id,actionName,step,fn);
      Lino.call_row_action(panel,panel.get_record_url(rec.id),actionName,step,fn);
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName) {
  //~ var panel = action.get_window().main_item;
  url = ROOT_URL + '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_row_action(panel,pk,actionName,step,fn);
    Lino.call_row_action(panel,url,actionName,step,fn);
  }
  fn(panel,null,null);
}


Lino.list_action_handler = function(actionName,gridmode) {
  var fn = function(panel,btn,step) {
    //~ console.log(panel);
    var url = ROOT_URL + '/api' + panel.ls_url ;
    var p = Ext.apply({},panel.get_base_params());
    p.an = actionName;
    //~ p.su = Lino.subst_user;
    //~ Lino.insert_subst_user(p);
    if (step) p['as'] = step;
    panel.loadMask.show(); // 20120211
    Ext.Ajax.request({
      method: 'GET',
      url: url,
      params: p,
      success: Lino.action_handler(panel,undefined,fn)
    });
  };
  return fn;
};

Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      panel.ls_detail_handler.run({
        record_id:rec.id,
        base_params:panel.get_base_params()
      });
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run({record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  panel.ls_insert_handler.run({record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run({data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};


//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      //~ Lino.do_when_visible(this,todo.createDelegate(this));
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);


Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: ROOT_URL + '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Text in eigenem Fenster bearbeiten.", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = ROOT_URL + '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('query',null); // 20111018
    //~ this.set_base_param('query',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    this.bbar = actions.bbar;
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: config.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: ROOT_URL + '/choices' + config.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        config.tbar = config.tbar.concat([this.record_selector]);
        
        config.tbar = config.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erste",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Vorige",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzte",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      config.tbar = this.add_params_panel(config.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      config.tbar = config.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Aktuellen Record neu laden",
          scope:this}
      ]);
          
      config.tbar = config.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    if (config.content_type && this.action_name != 'insert') {
      config.bbar = config.bbar.concat([
        '->',
        { text: "[Hilfetexte bearbeiten]",
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this}
        //~ ,{ text: '[Layout Editor]',
          //~ handler: this.edit_detail_config,
          //~ qtip: "Edit Detail layout",
          //~ scope: this}
      ])
    }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  is_loading : function() { 
    if (this.current_record == null) return true; 
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      return st;
  },
  set_status : function(status){
    //~ console.log('20120622 FormPanel.set_status()',this,status);
    this.clear_base_params();
    if (status == undefined) status = {};
    if (status.param_values) this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Formular speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = 'json';
    p.rp = this.getId();
    //~ p.su = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['query'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20120622 load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('goto_record_id success',rec);
          if (rec.navinfo && rec.navinfo.recno == 0) {
              /* 
                recno 0 means "the requested pk exists but is not contained in the requested queryset".
                This can happen e.g. after search_change on a detail.
              */
              //~ this_.goto_record_id(rec.navinfo.first);
              if (rec.navinfo.first) {
                  this.load_record_id(rec.navinfo.first);
              } else this.abandon();
                  
          } else {
              this.set_current_record(rec,after);
          }
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Records vorhanden. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          this.getBottomToolbar().items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        this.first.setDisabled(!record.navinfo.first);
        this.prev.setDisabled(!record.navinfo.prev);
        this.next.setDisabled(!record.navinfo.next);
        this.last.setDisabled(!record.navinfo.last);
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return ROOT_URL + '/api' + this.ls_url + '/' + rec.id;
      return ROOT_URL + '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after) {
    //~ var panel = this;
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      p.an = this.action_name;
      if (rec.phantom) {
        if (this.action_name != 'insert') 
            console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ROOT_URL + '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run({
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        if (this.action_name != 'detail') 
            console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ROOT_URL + '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{tab : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ROOT_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ROOT_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
      
    var ps = this.grid_panel.calculatePageSize();
    
    if (!ps) {
        //~ this.gridpanel.on('render',this.load())
      //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
      return false;
        //~ params.limit = 1;
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    } 
    
    options.params.limit = ps;
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
    } else {
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  //~ quick_search_text : '',
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"Keine Daten anzuzeigen."
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){
    config.plugins = [new Lino.GridFilters()];
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  is_loading : function() { 
    //~ return this.store.getCount() > 0; 
    return !this.loadMask.disabled; 
  },
  
  config_containing_window : function(wincfg) { 
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"Save Grid Data",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: ROOT_URL + '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ROOT_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (this_.selModel.getSelectedCell){
            if (this_.getStore().getCount()) // there may be no data
                this_.selModel.select(0,0); 
        } else {
            this_.selModel.selectFirstRow();
            this_.getView().focusEl.focus();
        }
      }, this
    );
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.search_field = new Ext.form.TextField({ 
          fieldLabel: "Search", 
          listeners: { scope:this_, change:this_.search_change }
          //~ value: text
          //~ scope:this, 
          //~ enableKeyEvents: true, 
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          text: "[csv]", 
          handler: function() { 
            var p = Ext.apply({},this.get_base_params());
            p['fmt'] = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.fmt = "printer";
            //~ this.add_param_values(p);
            //~ window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          text: "[html]", 
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "plain";
            this.add_param_values(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          text: "[pdf]", 
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    delete this.page_length
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    this.cmenu = actions.cmenu;
    
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("Dieses Feld ist deaktiviert");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var p = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        p.current_page = this.getTopToolbar().current;
    }
    //~ console.log("20120213 GridPanel.get_status",p);
    return p;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120717 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    if (status.param_values) this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
    
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5;
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:ROOT_URL + '/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20120514 GridPanel.on_beforeedit()',e,e.record.data.disabled_fields);
    if(e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      //~ Lino.notify(String.format("Feld '{0}' ist deaktiviert",e.field));
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    p['an'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      Ext.apply(req,{
        method: 'POST',
        url: ROOT_URL + '/api' + this.ls_url
      });
    } else {
      Ext.apply(req,{
        method: 'PUT',
        url: ROOT_URL + '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'Bitte warten...',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  autoSelect: false,
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      config.tools = config.tools.concat([ 
        { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(record_data){
    //~ loadRecord : function(record){
        /* Forward also `record` to field.setValue() 
        so that Lino.Combobox can use it. 
        Lino never uses an array record here, so we can ignore this case. 
        */
        //~ console.log('20110214e loadRecord',record.data)
        var field, id;
        for(id in record_data){
            if(!Ext.isFunction(record_data[id]) && (field = this.findField(id))){
                field.setValue(record_data[id],record_data);
                if(this.trackResetOnLoad){
                    field.originalValue = field.getValue();
                    //~ if (field.hiddenField) {
                      //~ field.hiddenField.originalValue = field.hiddenField.value;
                    //~ }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}


Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run({record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert('Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.');
    }
  } else {
    Lino.notify('No current record.');
  }
};




/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail_action.run({record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail_action.run({record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: ROOT_URL + '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: ROOT_URL + '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.tv = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: ROOT_URL + '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"Team-Ansicht",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{tv:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();



/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 



try {

  var cardReader = new be.belgium.eid.CardReader();

  function noCardPresentHandler() {
    window.alert("No card present!");
  }
  cardReader.setNoCardPresentHandler(noCardPresentHandler);

  function noReaderDetectedHandler() {
    window.alert("No reader detected!");
  }
  cardReader.setNoReaderDetectedHandler(noReaderDetectedHandler);

  function appletNotFoundHandler() {
    window.alert("Applet not found!");
  }
  cardReader.setAppletNotFoundHandler(appletNotFoundHandler);

  function appletExceptionHandler(e) {
    window.alert("Error reading card!\r\nException: " + e + "\r\nPlease try again.");
  }
  cardReader.setAppletExceptionHandler(appletExceptionHandler);

  //~ function clearPicture() {
    //~ document.getElementById("encoded_picture").src = "data:image/jpeg;base64,";
  //~ }

  Lino.read_beid_card = function(requesting_panel) {
    //~ clearPicture();
    var panel = Ext.getCmp(requesting_panel);
    console.log("readCard",panel);
    //~ document.getElementById("content").value = "Please wait ...";
    var card = cardReader.read();
    if (card != null) {
      var content = card.toString();
      Lino.alert(content);
      //~ if (typeof(base64) != "undefined") {
        //~ var encodedPicture = base64.encode(card.getPicture(), false, false);
        //~ document.getElementById("encoded_picture").src = "data:image/jpeg;base64," + encodedPicture;
        //~ content += "\r\n\r\n" + encodedPicture;
      //~ } else {
        //~ window.alert("base64 object not defined");
        //~ content += "\r\n\r\n" + "base64 object not defined";
      //~ }
      //~ document.getElementById("content").value = content;
    } else {
        Lino.alert("No card returned.");
    }
  }
} catch (err){
  Lino.read_beid_card = function(requesting_panel) {
      Lino.alert("`Lino.use_beid_jslib` is True, but `/media/beid-jslib/be_belgium_eid.js` not found");
  }
}  


Lino.main_menu = [ { "menu": { "items": [ { "text": "Organisationen", "handler": function(){Lino.contacts.Companies.default_action.run({ "record_id": -99998 })} }, { "text": "Personen", "handler": function(){Lino.contacts.Persons.default_action.run({ "record_id": -99998 })} }, { "text": "Clients", "handler": function(){Lino.pcsw.Clients.default_action.run({ "record_id": -99998 })} }, { "text": "Alle partners", "handler": function(){Lino.contacts.AllPartners.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Personensuchen", "handler": function(){Lino.pcsw.MyPersonSearches.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Personen", "handler": function(){Lino.contacts.Persons.default_action.run({ "record_id": -99998 })} }, { "text": "partners", "handler": function(){Lino.contacts.Partners.default_action.run({ "record_id": -99998 })} }, { "text": "partners", "handler": function(){Lino.contacts.Partners.default_action.run({ "record_id": -99998 })} } ] }, "text": "Kontakte" }, { "text": "Haushalte", "handler": function(){Lino.households.Households.default_action.run({ "record_id": -99998 })} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Meine Notizen", "handler": function(){Lino.notes.MyNotes.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Uploads", "handler": function(){Lino.uploads.MyUploads.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Mein E-Mail-Ausgang", "handler": function(){Lino.outbox.MyOutbox.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Postsendungen", "handler": function(){Lino.postings.MyPostings.default_action.run({ "record_id": -99998 })} } ] }, "text": "E-Mail-Ausgang" }, { "text": "Meine VSEs", "handler": function(){Lino.isip.MyContracts.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Art.60\u00a77-Konventionen", "handler": function(){Lino.jobs.MyContracts.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Klienten", "handler": function(){Lino.pcsw.MyClients.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Coachings", "handler": function(){Lino.pcsw.MyCoachings.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Einf\u00fcgetexte", "handler": function(){Lino.lino.MyTextFieldTemplates.default_action.run({ "record_id": -99998 })} } ] }, "text": "Mein Men\u00fc" }, { "menu": { "items": [ { "text": "Kalender", "handler": function(){Lino.cal.CalendarPanel.default_action.run({ "record_id": -99998 })} }, { "text": "Meine Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function(){Lino.cal.MyEvents.default_action.run({ "record_id": -99998 })} }, { "text": "Meine vorgeschlagenen Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Liste der Terminvorschl\u00e4ge an mich.") }, "handler": function(){Lino.cal.MyEventsSuggested.default_action.run({ "record_id": -99998 })} }, { "text": "Meine mitgeteilten Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Meine mitgeteilten Termine, die \"Geplant\" werden m\u00fcssen.") }, "handler": function(){Lino.cal.MyEventsNotified.default_action.run({ "record_id": -99998 })} }, "-", "-", { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function(){Lino.cal.MyTasks.default_action.run({ "record_id": -99998 })} }, { "text": "To-Do-Liste", "listeners": { "render": Lino.quicktip_renderer("Foo","Meine zu erledigenden Aufgaben.") }, "handler": function(){Lino.cal.MyTasksToDo.default_action.run({ "record_id": -99998 })} }, "-", { "text": "Meine erhaltenen Einladungen", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my received invitations, independently of their state.") }, "handler": function(){Lino.cal.MyInvitations.default_action.run({ "record_id": -99998 })} }, { "text": "Meine offenen erhaltenen Einladungen", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function(){Lino.cal.MyPendingInvitations.default_action.run({ "record_id": -99998 })} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Stellenanbieter", "handler": function(){Lino.jobs.JobProviders.default_action.run({ "record_id": -99998 })} }, { "text": "Stellen", "handler": function(){Lino.jobs.Jobs.default_action.run({ "record_id": -99998 })} }, { "text": "Stellenangebote", "handler": function(){Lino.jobs.Offers.default_action.run({ "record_id": -99998 })} }, { "text": "Suche Art.60\u00a77-Konventionen", "handler": function(){Lino.jobs.ContractsSearch.default_action.run({ "record_id": -99998 })} } ] }, "text": "Stellen" }, { "menu": { "items": [ { "text": "Kursanbieter", "handler": function(){Lino.courses.CourseProviders.default_action.run({ "record_id": -99998 })} }, { "text": "Kursangebote", "handler": function(){Lino.courses.CourseOffers.default_action.run({ "record_id": -99998 })} }, { "text": "Offene Kursanfragen", "handler": function(){Lino.courses.PendingCourseRequests.default_action.run({ "record_id": -99998 })} } ] }, "text": "Kurse" }, { "menu": { "items": [ { "text": "\u00dcbersicht Art.60\u00a77-Konventionen", "handler": function(){Lino.jobs.JobsOverview.detail_action.run({ "record_id": -99998 })} }, { "text": "Benutzer und ihre Klienten", "handler": function(){Lino.pcsw.UsersWithClients.default_action.run({ "record_id": -99998 })} } ] }, "text": "Listings" }, { "menu": { "items": [ { "text": "Info", "handler": function(){Lino.lino.About.default_action.run({ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() { location.replace('javascript:Lino.close_all_windows()'); }, "xtype": "button" } ];
Ext.namespace('Lino.lino.SiteConfigs')
Ext.namespace('Lino.lino.ContentTypes')
Ext.namespace('Lino.lino.HelpTexts')
Ext.namespace('Lino.lino.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Memberships')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsSuggested')
Ext.namespace('Lino.cal.EventsNotified')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cv.LanguageKnowledges')
Ext.namespace('Lino.cv.PersonProperties')
Ext.namespace('Lino.isip.ContractTypes')
Ext.namespace('Lino.isip.ExamPolicies')
Ext.namespace('Lino.isip.ContractEndings')
Ext.namespace('Lino.isip.Contracts')
Ext.namespace('Lino.pcsw.Partners')
Ext.namespace('Lino.contacts.AllPartners')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.pcsw.Clients')
Ext.namespace('Lino.pcsw.MyClients')
Ext.namespace('Lino.pcsw.ClientsTest')
Ext.namespace('Lino.pcsw.PersonGroups')
Ext.namespace('Lino.pcsw.Activities')
Ext.namespace('Lino.pcsw.ExclusionTypes')
Ext.namespace('Lino.pcsw.Exclusions')
Ext.namespace('Lino.pcsw.AidTypes')
Ext.namespace('Lino.pcsw.PersonSearches')
Ext.namespace('Lino.pcsw.OverlappingContracts')
Ext.namespace('Lino.pcsw.HealthInsurances')
Ext.namespace('Lino.pcsw.Pharmacies')
Ext.namespace('Lino.pcsw.Attorneys')
Ext.namespace('Lino.pcsw.JobOffices')
Ext.namespace('Lino.pcsw.ClientContacts')
Ext.namespace('Lino.pcsw.CoachingTypes')
Ext.namespace('Lino.pcsw.Coachings')
Ext.namespace('Lino.jobs.Schedules')
Ext.namespace('Lino.jobs.Regimes')
Ext.namespace('Lino.jobs.JobProviders')
Ext.namespace('Lino.jobs.ContractTypes')
Ext.namespace('Lino.jobs.Sectors')
Ext.namespace('Lino.jobs.Functions')
Ext.namespace('Lino.jobs.Contracts')
Ext.namespace('Lino.jobs.Offers')
Ext.namespace('Lino.jobs.StudyTypes')
Ext.namespace('Lino.jobs.Studies')
Ext.namespace('Lino.jobs.Experiences')
Ext.namespace('Lino.jobs.Candidatures')
Ext.namespace('Lino.jobs.Jobs')
Ext.namespace('Lino.jobs.JobTypes')
Ext.namespace('Lino.jobs.ContractsSearch')
Ext.namespace('Lino.cbss.Sectors')
Ext.namespace('Lino.cbss.Purposes')
Ext.namespace('Lino.cbss.IdentifyPersonRequests')
Ext.namespace('Lino.cbss.ManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequests')
Ext.namespace('Lino.newcomers.Brokers')
Ext.namespace('Lino.newcomers.Faculties')
Ext.namespace('Lino.newcomers.Competences')
Ext.namespace('Lino.newcomers.Newcomers')
Ext.namespace('Lino.newcomers.NewClients')
Ext.namespace('Lino.newcomers.UsersByNewcomer')
Ext.namespace('Lino.debts.Budgets')
Ext.namespace('Lino.debts.Actors')
Ext.namespace('Lino.debts.Entries')
Ext.namespace('Lino.debts.EntriesByType')
Ext.namespace('Lino.courses.CourseProviders')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.CourseContents')
Ext.namespace('Lino.courses.CourseOffers')
Ext.namespace('Lino.courses.CourseRequests')
Ext.namespace('Lino.courses.PendingCourseRequests')
Ext.namespace('Lino.pcsw.WantedLanguageKnowledgeTable')
Ext.namespace('Lino.properties.WantedSkillTable')
Ext.namespace('Lino.properties.UnwantedSkillTable')
Ext.namespace('Lino.lino.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.MembershipsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPartner')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyEventsSuggested')
Ext.namespace('Lino.cal.MyEventsNotified')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyInvitations')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.cal.RemindersByUser')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cv.LanguageKnowledgesByPerson')
Ext.namespace('Lino.cv.KnowledgesByLanguage')
Ext.namespace('Lino.cv.PropsByPerson')
Ext.namespace('Lino.cv.PersonPropsByProp')
Ext.namespace('Lino.cv.ConfiguredPropsByPerson')
Ext.namespace('Lino.cv.SkillsByPerson')
Ext.namespace('Lino.cv.SoftSkillsByPerson')
Ext.namespace('Lino.cv.ObstaclesByPerson')
Ext.namespace('Lino.isip.ContractsByPerson')
Ext.namespace('Lino.isip.ContractsByType')
Ext.namespace('Lino.isip.MyContracts')
Ext.namespace('Lino.pcsw.ClientsByNationality')
Ext.namespace('Lino.pcsw.ExclusionsByPerson')
Ext.namespace('Lino.pcsw.MyPersonSearches')
Ext.namespace('Lino.pcsw.LanguageKnowledgesBySearch')
Ext.namespace('Lino.pcsw.WantedPropsBySearch')
Ext.namespace('Lino.pcsw.UnwantedPropsBySearch')
Ext.namespace('Lino.pcsw.ClientsBySearch')
Ext.namespace('Lino.pcsw.ContactsByClient')
Ext.namespace('Lino.pcsw.CoachingsByProject')
Ext.namespace('Lino.pcsw.CoachingsByUser')
Ext.namespace('Lino.pcsw.MyCoachings')
Ext.namespace('Lino.pcsw.NotesByPerson')
Ext.namespace('Lino.pcsw.NotesByCompany')
Ext.namespace('Lino.jobs.FunctionsBySector')
Ext.namespace('Lino.jobs.ContractsByPerson')
Ext.namespace('Lino.jobs.ContractsByProvider')
Ext.namespace('Lino.jobs.ContractsByJob')
Ext.namespace('Lino.jobs.ContractsByRegime')
Ext.namespace('Lino.jobs.ContractsBySchedule')
Ext.namespace('Lino.jobs.MyContracts')
Ext.namespace('Lino.jobs.StudiesByCountry')
Ext.namespace('Lino.jobs.StudiesByCity')
Ext.namespace('Lino.jobs.StudiesByPerson')
Ext.namespace('Lino.jobs.ExperiencesByFunction')
Ext.namespace('Lino.jobs.ExperiencesByPerson')
Ext.namespace('Lino.jobs.CandidaturesByPerson')
Ext.namespace('Lino.jobs.CandidaturesBySector')
Ext.namespace('Lino.jobs.CandidaturesByFunction')
Ext.namespace('Lino.jobs.CandidaturesByJob')
Ext.namespace('Lino.jobs.CandidaturesByOffer')
Ext.namespace('Lino.jobs.ExperiencesByOffer')
Ext.namespace('Lino.jobs.JobsByProvider')
Ext.namespace('Lino.jobs.JobsByType')
Ext.namespace('Lino.jobs.ContractsByType')
Ext.namespace('Lino.cbss.MyIdentifyPersonRequests')
Ext.namespace('Lino.cbss.IdentifyRequestsByPerson')
Ext.namespace('Lino.cbss.ManageAccessRequestsByPerson')
Ext.namespace('Lino.cbss.MyManageAccessRequests')
Ext.namespace('Lino.cbss.RetrieveTIGroupsRequestsByPerson')
Ext.namespace('Lino.cbss.MyRetrieveTIGroupsRequests')
Ext.namespace('Lino.newcomers.CompetencesByUser')
Ext.namespace('Lino.newcomers.CompetencesByFaculty')
Ext.namespace('Lino.newcomers.MyCompetences')
Ext.namespace('Lino.newcomers.NewcomersByFaculty')
Ext.namespace('Lino.debts.MyBudgets')
Ext.namespace('Lino.debts.BudgetsByPartner')
Ext.namespace('Lino.debts.ActorsByBudget')
Ext.namespace('Lino.debts.EntriesByBudget')
Ext.namespace('Lino.debts.ExpensesByBudget')
Ext.namespace('Lino.debts.IncomesByBudget')
Ext.namespace('Lino.debts.LiabilitiesByBudget')
Ext.namespace('Lino.debts.AssetsByBudget')
Ext.namespace('Lino.debts.DistByBudget')
Ext.namespace('Lino.courses.CoursesByOffer')
Ext.namespace('Lino.courses.CourseOffersByProvider')
Ext.namespace('Lino.courses.CourseRequestsByPerson')
Ext.namespace('Lino.courses.RequestsByCourse')
Ext.namespace('Lino.courses.ParticipantsByCourse')
Ext.namespace('Lino.courses.CandidatesByCourse')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.lino.HelpTextsByModel')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.lino.Models')
Ext.namespace('Lino.lino.FieldsByModel')
Ext.namespace('Lino.lino.Inspector')
Ext.namespace('Lino.pcsw.UsersWithClients')
Ext.namespace('Lino.cbss.IdentifyPersonResult')
Ext.namespace('Lino.cbss.RetrieveTIGroupsResult')
Ext.namespace('Lino.debts.PrintEntriesByBudget')
Ext.namespace('Lino.debts.PrintExpensesByBudget')
Ext.namespace('Lino.debts.PrintIncomesByBudget')
Ext.namespace('Lino.debts.PrintLiabilitiesByBudget')
Ext.namespace('Lino.debts.PrintAssetsByBudget')
Ext.namespace('Lino.debts.BudgetSummary')
Ext.namespace('Lino.lino.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.jobs.JobsOverview')

Lino.cbss.IdentifyPersonRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id29 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person30 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var user31 = new Lino.TwinCombo({ "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/user", "method": "GET" }) }), "name": "user" });
    var environment32 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent33 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status34 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Status", "name": "status", "anchor": "-20", "store": [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ], "hiddenName": "statusHidden" });
    var ticket35 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel36 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id29, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person30, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user31, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment32, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent33, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status34, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket35, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var national_id44 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var p1_panel46 = new Ext.form.FieldSet({ "flex": 25, "labelWidth": 90, "title": "Suche per NISS", "layoutConfig": { "align": "stretch" }, "frame": false, "bodyBorder": true, "items": [ { "items": national_id44, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "flex": 50, "html": "<br/>", "xtype": "label" } ], "hideCheckBoxLabels": true, "layout": "vbox", "border": true, "labelAlign": "top" });
    var first_name48 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var middle_name49 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name50 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var p2_1_panel51 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name48, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name49, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name50, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date55 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Geburtsdatum", "anchor": "-20", "name": "birth_date" });
    var tolerance56 = { "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "xtype": "numberfield", "value": 0, "name": "tolerance", "listeners": { "render": Lino.quicktip_renderer("Toleranz","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var gender57 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var p2_2_panel58 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date55, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance56, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender57, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel62 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel51, p2_2_panel58 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var parameters_panel63 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "items": [ p1_panel46, p2_panel62 ], "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var IdentifyPersonResult_grid73 = new Lino.cbss.IdentifyPersonResult.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cbss.IdentifyPersonResult.default_action) ], "master_panel": this });
    var request_panel74 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ info_1_panel36, parameters_panel63, IdentifyPersonResult_grid73 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var response_xml75 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages76 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Info-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages77 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Debug-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel78 = new Lino.VBorderPanel({ "labelWidth": 144, "title": "Technisch", "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml75, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages76, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages77, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel82 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ request_panel74, technical_panel78 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel82;
    this.before_row_edit = function(record) {
      IdentifyPersonResult_grid73.on_master_changed();
    }
    Lino.cbss.IdentifyPersonRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person30.on("change",function(){this.save()},this);
  }
});


Lino.pcsw.Clients.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var last_name83 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name84 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var title85 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var box1_1_panel86 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name83, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name84, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title85, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country90 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/country", "method": "GET" }) }) });
    var city91 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/city", "method": "GET" }) }) });
    var zip_code92 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel93 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country90, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city91, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code92, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix97 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street98 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no99 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box100 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel101 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix97, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street98, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no99, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box100, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2106 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_panel107 = new Ext.form.FieldSet({ "flex": 61, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ box1_1_panel86, box1_2_panel93, box1_3_panel101, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2106, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id109 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language110 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var box2_1_panel111 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id109, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language110, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email114 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var phone115 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var fax116 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var box2_3_panel117 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone115, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax116, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm120 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box2_panel121 = new Ext.form.FieldSet({ "flex": 38, "autoHeight": true, "labelWidth": 63, "title": "Kontakt", "items": [ box2_1_panel111, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email114, "anchor": "-20", "labelAlign": "top" }, box2_3_panel117, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm120, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var general_1_panel124 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box1_panel107, box2_panel121 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender125 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var birth_date126 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Unkomplette Geburtsdaten sind erlaubt, z.B. \n<ul>\n<li>00.00.1980 : irgendwann in 1980</li>\n<li>00.07.1980 : im Juli 1980</li>\n<li>23.07.0000 : Geburtstag am 23. Juli, Alter unbekannt</li>\n</ul>") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp127 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var civil_state128 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zivilstand", "name": "civil_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Ledig" ], [ "13", "Ledig zusammenwohnend" ], [ "18", "Ledig mit Kind" ], [ "20", "Verheiratet" ], [ "21", "Verheirated (allein lebend)" ], [ "22", "Verheirated (mit anderem Partner lebend)" ], [ "30", "Verwitwet" ], [ "33", "Verwitwet (zusammenwohnend)" ], [ "40", "Geschieden" ], [ "50", "Getrennt von Tisch und Bett" ] ], "hiddenName": "civil_stateHidden" });
    var noble_condition129 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adelstitel","The eventual noble condition of this person. Imported from TIM.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adelstitel</span>", "name": "noble_condition", "maxLength": 50, "selectOnFocus": true, "anchor": "-20" });
    var box3_1_panel130 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender125, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date126, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp127, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": civil_state128, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": noble_condition129, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_country136 = new Lino.TwinCombo({ "fieldLabel": "Geburtsland", "name": "birth_country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "birth_countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/birth_country", "method": "GET" }) }) });
    var birth_place137 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Geburtsort", "anchor": "-20", "name": "birth_place" });
    var nationality138 = new Lino.TwinCombo({ "fieldLabel": "Staatsangeh\u00f6rigkeit", "name": "nationality", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "nationalityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/nationality", "method": "GET" }) }) });
    var national_id139 = new Ext.form.TextField({ "fieldLabel": "NR-Nummer", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var box3_2_panel140 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_country136, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_place137, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": nationality138, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id139, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel145 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Geburtsangaben", "items": [ box3_1_panel130, box3_2_panel140 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var read_beid_card_disp146 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Actions", "name": "read_beid_card", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var card_number147 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "Nummer", "anchor": "-20", "name": "card_number" });
    var card_valid_from148 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "G\u00fcltig von", "anchor": "-20", "name": "card_valid_from" });
    var card_valid_until149 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "card_valid_until" });
    var card_issuer150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50, "fieldLabel": "Ausgestellt durch", "anchor": "-20", "name": "card_issuer" });
    var card_type151 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "eID-Kartenart", "name": "card_type", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Belgischer Staatsb\u00fcrger" ], [ "6", "Kind unter 12 Jahren" ], [ "8", "Habilitierung" ], [ "11", "A (Bescheinigung der Eintragung im Ausl\u00e4nderregister - Vor\u00fcbergehender Aufenthalt)" ], [ "12", "B (Bescheinigung der Eintragung im Ausl\u00e4nderregister)" ], [ "13", "C (Personalausweis f\u00fcr Ausl\u00e4nder)" ], [ "14", "D (Daueraufenthalt - EG)" ], [ "15", "E (Anmeldebescheinigung)" ], [ "16", "E+" ], [ "17", "F (Aufenthaltskarte f\u00fcr Familienangeh\u00f6rige eines Unionsb\u00fcrgers)" ], [ "18", "F+" ] ], "hiddenName": "card_typeHidden" });
    var eid_panel_1_panel152 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "eID-Karte", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": read_beid_card_disp146, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_number147, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_from148, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_valid_until149, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_issuer150, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": card_type151, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 252, "border": true, "anchor": "-20", "labelAlign": "top" });
    var box4_panel159 = new Ext.Panel({ "flex": 82, "autoHeight": true, "layout": "form", "items": [ box3_panel145, eid_panel_1_panel152 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var image_htmlbox160 = new Lino.HtmlBoxPanel({ "flex": 17, "layout": "fit", "name": "image", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var general_2_panel161 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box4_panel159, image_htmlbox160 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel162 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Person", "items": [ general_1_panel124, general_2_panel161 ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var in_belgium_since163 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Lebt in Belgien seit","Since when this person in Belgium lives.\n<b>Important:</b> help_text can be formatted.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Lebt in Belgien seit</span>", "anchor": "-20", "name": "in_belgium_since" });
    var residence_type164 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Register", "name": "residence_type", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Bev\u00f6lkerungsregister" ], [ "2", "Fremdenregister" ], [ "3", "Warteregister" ] ], "hiddenName": "residence_typeHidden" });
    var gesdos_id165 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Gesdos-Nr", "anchor": "-20", "name": "gesdos_id" });
    var status_1_panel166 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": in_belgium_since163, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_type164, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gesdos_id165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var bank_account1170 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account2171 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var status_2_panel172 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account1170, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account2171, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var status_panel175 = new Ext.Panel({ "flex": 68, "autoHeight": true, "layout": "form", "items": [ status_1_panel166, status_2_panel172 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var aid_type176 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Sozialhilfeart", "name": "aid_type", "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "aid_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }) });
    var income_ag177 = new Ext.form.Checkbox({ "boxLabel": "Arbeitslosengeld", "hideLabel": true, "checked": false, "name": "income_ag", "selectOnFocus": true, "anchor": "-20" });
    var income_wg178 = new Ext.form.Checkbox({ "boxLabel": "Wartegeld", "hideLabel": true, "checked": false, "name": "income_wg", "selectOnFocus": true, "anchor": "-20" });
    var income_2_panel179 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_ag177, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_wg178, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_kg182 = new Ext.form.Checkbox({ "boxLabel": "Krankengeld", "hideLabel": true, "checked": false, "name": "income_kg", "selectOnFocus": true, "anchor": "-20" });
    var income_rente183 = new Ext.form.Checkbox({ "boxLabel": "Rente", "hideLabel": true, "checked": false, "name": "income_rente", "selectOnFocus": true, "anchor": "-20" });
    var income_3_panel184 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_kg182, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_rente183, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var income_misc187 = new Ext.form.Checkbox({ "boxLabel": "andere Einkommen", "hideLabel": true, "checked": false, "name": "income_misc", "selectOnFocus": true, "anchor": "-20" });
    var income_panel188 = new Ext.Panel({ "flex": 31, "autoHeight": true, "labelWidth": 153, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": aid_type176, "anchor": "-20", "labelAlign": "top" }, income_2_panel179, income_3_panel184, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": income_misc187, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var tab2_1_panel191 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ status_panel175, income_panel188 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var is_seeking192 = new Ext.form.Checkbox({ "boxLabel": "Arbeit suchend", "hideLabel": true, "checked": false, "name": "is_seeking", "selectOnFocus": true, "anchor": "-20" });
    var unemployed_since193 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "eingetragen seit", "anchor": "-20", "name": "unemployed_since" });
    var work_permit_suspended_until194 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Wartezeit bis", "anchor": "-20", "name": "work_permit_suspended_until" });
    var suche_1_panel195 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_seeking192, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unemployed_since193, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_suspended_until194, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var unavailable_until199 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Nicht verf\u00fcgbar bis", "anchor": "-20", "name": "unavailable_until" });
    var unavailable_why200 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Grund", "anchor": "-20", "name": "unavailable_why" });
    var suche_2_panel201 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_until199, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unavailable_why200, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "labelAlign": "top" });
    var pcsw_ExclusionsByPerson_grid209 = new Lino.pcsw.ExclusionsByPerson.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ExclusionsByPerson.default_action) ], "master_panel": this });
    var suche_panel210 = new Ext.form.FieldSet({ "flex": 50, "layout": "vbox", "title": "Arbeitssuche", "layoutConfig": { "align": "stretch" }, "frame": false, "bodyBorder": true, "items": [ suche_1_panel195, suche_2_panel201, pcsw_ExclusionsByPerson_grid209 ], "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var needs_residence_permit211 = new Ext.form.Checkbox({ "boxLabel": "Braucht Aufenthaltserlaubnis", "hideLabel": true, "checked": false, "name": "needs_residence_permit", "selectOnFocus": true, "anchor": "-20" });
    var needs_work_permit212 = new Ext.form.Checkbox({ "boxLabel": "Braucht Arb.Erl.", "hideLabel": true, "checked": false, "name": "needs_work_permit", "selectOnFocus": true, "anchor": "-20" });
    var papers_1_panel213 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_residence_permit211, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": needs_work_permit212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 261, "border": false, "labelAlign": "top" });
    var residence_permit_disp216 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Aufenthaltserlaubnis", "name": "residence_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var work_permit_disp217 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitserlaubnis", "name": "work_permit", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var driving_licence_disp218 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "F\u00fchrerschein", "name": "driving_licence", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var papers_2_panel219 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": residence_permit_disp216, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": work_permit_disp217, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": driving_licence_disp218, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var UploadsByController_htmlbox223 = new Lino.HtmlBoxPanel({ "flex": 55, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var papers_panel224 = new Ext.form.FieldSet({ "flex": 50, "labelWidth": 72, "title": "Papiere", "layoutConfig": { "align": "stretch" }, "frame": false, "bodyBorder": true, "items": [ papers_1_panel213, papers_2_panel219, UploadsByController_htmlbox223 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": true, "labelAlign": "top" });
    var tab2_2_panel225 = new Ext.Panel({ "flex": 69, "layout": "hbox", "items": [ suche_panel210, papers_panel224 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var tab2_panel226 = new Ext.Panel({ "layout": "vbox", "title": "Status", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ tab2_1_panel191, tab2_2_panel225 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var broker227 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vermittler", "name": "broker", "pageSize": 20, "emptyText": "Vermittler ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "brokerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/broker", "method": "GET" }) }) });
    var faculty228 = new Lino.TwinCombo({ "fieldLabel": "Fachbereich", "name": "faculty", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.newcomers.Faculties.detail_action)}, "emptyText": "Fachbereich ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "facultyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/faculty", "method": "GET" }) }) });
    var coaching_1_panel229 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": broker227, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": faculty228, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var group232 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
    var client_state233 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "allowBlank": false, "hiddenName": "client_stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "name": "client_state" });
    var coaching_2_panel234 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group232, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state233, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "labelAlign": "top" });
    var job_agents237 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Interim-Agenturen", "anchor": "-20", "name": "job_agents" });
    var ContactsByClient_grid244 = new Lino.pcsw.ContactsByClient.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ContactsByClient.default_action) ], "master_panel": this });
    var CoachingsByProject_grid259 = new Lino.pcsw.CoachingsByProject.GridPanel({ "flex": 50, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByProject.default_action) ], "master_panel": this, "containing_panel": this });
    var coaching_4_panel260 = new Ext.Panel({ "flex": 62, "layout": "hbox", "items": [ ContactsByClient_grid244, CoachingsByProject_grid259 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var coaching_panel261 = new Ext.Panel({ "labelWidth": 162, "title": "Coaching", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ coaching_1_panel229, coaching_2_panel234, { "items": job_agents237, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, coaching_4_panel260 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var jobs_StudiesByPerson_grid275 = new Lino.jobs.StudiesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByPerson.default_action) ] });
    var jobs_ExperiencesByPerson_grid285 = new Lino.jobs.ExperiencesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByPerson.default_action) ] });
    var tab3_panel286 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Ausbildung", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ jobs_StudiesByPerson_grid275, jobs_ExperiencesByPerson_grid285 ], "border": false, "labelAlign": "top" });
    var cv_LanguageKnowledgesByPerson_grid293 = new Lino.cv.LanguageKnowledgesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.LanguageKnowledgesByPerson.default_action) ] });
    var courses_CourseRequestsByPerson_grid329 = new Lino.courses.CourseRequestsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseRequestsByPerson.default_action) ] });
    var tab4_panel330 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Sprachen", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ cv_LanguageKnowledgesByPerson_grid293, courses_CourseRequestsByPerson_grid329 ], "border": false, "labelAlign": "top" });
    var cv_SkillsByPerson_grid337 = new Lino.cv.SkillsByPerson.GridPanel({ "flex": 35, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.SkillsByPerson.default_action) ], "master_panel": this });
    var cv_SoftSkillsByPerson_grid344 = new Lino.cv.SoftSkillsByPerson.GridPanel({ "flex": 35, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.SoftSkillsByPerson.default_action) ], "master_panel": this });
    var skills345 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Sonstige F\u00e4hikeiten", "anchor": "-20 -10", "growMax": 2000, "name": "skills" });
    var tab5_1_panel346 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_SkillsByPerson_grid337, cv_SoftSkillsByPerson_grid344, { "items": skills345, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 28 } ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 180, "border": false, "region": "north", "labelAlign": "top" });
    var cv_ObstaclesByPerson_grid354 = new Lino.cv.ObstaclesByPerson.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.ObstaclesByPerson.default_action) ], "master_panel": this });
    var obstacles355 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Hindernisse", "anchor": "-20 -10", "growMax": 2000, "name": "obstacles" });
    var tab5_2_panel356 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ cv_ObstaclesByPerson_grid354, { "items": obstacles355, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 44 } ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "region": "center", "labelAlign": "top" });
    var tab5_panel358 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Kompetenzen", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ tab5_1_panel346, tab5_2_panel356 ], "border": false, "labelAlign": "top" });
    var jobs_CandidaturesByPerson_grid366 = new Lino.jobs.CandidaturesByPerson.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Stellenanfragen", "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByPerson.default_action) ], "master_panel": this });
    var pcsw_NotesByPerson_grid530 = new Lino.pcsw.NotesByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByPerson.default_action) ] });
    var outbox_MailsByProject_grid542 = new Lino.outbox.MailsByProject.GridPanel({ "flex": 60, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByProject.default_action) ], "master_panel": this });
    var postings_PostingsByProject_grid553 = new Lino.postings.PostingsByProject.GridPanel({ "flex": 40, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByProject.default_action) ], "master_panel": this });
    var history_2_panel554 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ outbox_MailsByProject_grid542, postings_PostingsByProject_grid553 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "border": false, "region": "center", "labelAlign": "top" });
    var history_panel555 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Historie", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ pcsw_NotesByPerson_grid530, history_2_panel554 ], "border": false, "labelAlign": "top" });
    var isip_ContractsByPerson_grid732 = new Lino.isip.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.isip.ContractsByPerson.default_action) ] });
    var jobs_ContractsByPerson_grid817 = new Lino.jobs.ContractsByPerson.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByPerson.default_action) ] });
    var contracts_panel818 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Vertr\u00e4ge", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ isip_ContractsByPerson_grid732, jobs_ContractsByPerson_grid817 ], "border": false, "labelAlign": "top" });
    var cal_EventsByProject_grid843 = new Lino.cal.EventsByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByProject.default_action) ] });
    var cal_TasksByProject_grid866 = new Lino.cal.TasksByProject.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByProject.default_action) ] });
    var calendar_panel867 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Kalender", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ cal_EventsByProject_grid843, cal_TasksByProject_grid866 ], "border": false, "labelAlign": "top" });
    var activity868 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/activity", "method": "GET" }) }) });
    var is_cpas869 = new Ext.form.Checkbox({ "boxLabel": "Sozialhilfeempf\u00e4nger", "hideLabel": true, "checked": false, "name": "is_cpas", "selectOnFocus": true, "anchor": "-20" });
    var is_senior870 = new Ext.form.Checkbox({ "boxLabel": "Altenheim", "hideLabel": true, "checked": false, "name": "is_senior", "selectOnFocus": true, "anchor": "-20" });
    var is_deprecated871 = new Ext.form.Checkbox({ "boxLabel": "Altdaten", "hideLabel": true, "checked": false, "name": "is_deprecated", "selectOnFocus": true, "anchor": "-20" });
    var misc_2_panel872 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_cpas869, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_senior870, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_deprecated871, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var remarks876 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var remarks2877 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen (Sozialsekretariat)", "anchor": "-20 -10", "growMax": 2000, "name": "remarks2" });
    var contacts_RolesByPerson_grid882 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.default_action) ], "master_panel": this });
    var households_MembersByPerson_grid889 = new Lino.households.MembersByPerson.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.default_action) ], "master_panel": this });
    var misc_3_panel890 = new Ext.Panel({ "flex": 71, "layout": "hbox", "items": [ { "items": remarks876, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, { "items": remarks2877, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, contacts_RolesByPerson_grid882, households_MembersByPerson_grid889 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 288, "border": false, "labelAlign": "top" });
    var misc_panel893 = new Ext.Panel({ "labelWidth": 54, "title": "Sonstiges", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ { "items": activity868, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, misc_2_panel872, misc_3_panel890 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var cbss_identify_person_disp895 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "IdentifyPerson-Anfragen", "name": "cbss_identify_person", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_manage_access_disp896 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "ManageAccess-Anfragen", "name": "cbss_manage_access", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_retrieve_ti_groups_disp897 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Tx25-Anfragen", "name": "cbss_retrieve_ti_groups", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var cbss_1_panel898 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_identify_person_disp895, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_manage_access_disp896, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cbss_retrieve_ti_groups_disp897, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var cbss_summary_htmlbox902 = new Lino.HtmlBoxPanel({ "flex": 62, "layout": "fit", "name": "cbss_summary", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "CBSS summary", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var cbss_panel903 = new Ext.Panel({ "labelWidth": 117, "title": "KBSS", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ cbss_1_panel898, cbss_summary_htmlbox902 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var main_panel1005 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel162, tab2_panel226, coaching_panel261, tab3_panel286, tab4_panel330, tab5_panel358, jobs_CandidaturesByPerson_grid366, history_panel555, contracts_panel818, calendar_panel867, misc_panel893, cbss_panel903 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1005;
    this.before_row_edit = function(record) {
      city91.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city91.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      image_htmlbox160.refresh();
      pcsw_ExclusionsByPerson_grid209.on_master_changed();
      UploadsByController_htmlbox223.refresh();
      ContactsByClient_grid244.on_master_changed();
      CoachingsByProject_grid259.on_master_changed();
      jobs_StudiesByPerson_grid275.on_master_changed();
      jobs_ExperiencesByPerson_grid285.on_master_changed();
      cv_LanguageKnowledgesByPerson_grid293.on_master_changed();
      courses_CourseRequestsByPerson_grid329.on_master_changed();
      cv_SkillsByPerson_grid337.on_master_changed();
      cv_SoftSkillsByPerson_grid344.on_master_changed();
      cv_ObstaclesByPerson_grid354.on_master_changed();
      jobs_CandidaturesByPerson_grid366.on_master_changed();
      pcsw_NotesByPerson_grid530.on_master_changed();
      outbox_MailsByProject_grid542.on_master_changed();
      postings_PostingsByProject_grid553.on_master_changed();
      isip_ContractsByPerson_grid732.on_master_changed();
      jobs_ContractsByPerson_grid817.on_master_changed();
      cal_EventsByProject_grid843.on_master_changed();
      cal_TasksByProject_grid866.on_master_changed();
      contacts_RolesByPerson_grid882.on_master_changed();
      households_MembersByPerson_grid889.on_master_changed();
      cbss_summary_htmlbox902.refresh();
    }
    this.onRender = function(ct, position) {
      country90.on('change',Lino.chooser_handler(city91,'country'));
      Lino.pcsw.Clients.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Clients.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var containing_panel = this;
    var id1006 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1007 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1008 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1009 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var choicelist1010 = new Lino.ChoicesFieldElement({ "fieldLabel": "Auswahliste", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "CityTypes", "Settlement Type" ], [ "DoYouLike", "blo\u00df nicht ... sehr gerne" ], [ "Gender", "Geschlecht" ], [ "HowWell", "gar nicht ... sehr gut" ], [ "UserGroups", "Benutzergruppe" ], [ "UserLevels", "Benutzer-Level" ], [ "UserProfiles", "Benutzerprofil" ] ], "hiddenName": "choicelistHidden" });
    var default_value1011 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Standardwert", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel1012 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1006, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1007, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1008, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1009, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist1010, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value1011, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "region": "north", "labelAlign": "top" });
    var ChoicesByType_grid1025 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.default_action) ] });
    var PropsByType_grid1032 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.default_action) ] });
    var main_panel1033 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "items": [ main_1_panel1012, ChoicesByType_grid1025, PropsByType_grid1032 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1033;
    this.before_row_edit = function(record) {
      default_value1011.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid1025.on_master_changed();
      PropsByType_grid1032.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist1010.on('change',Lino.chooser_handler(default_value1011,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var id7 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var group8 = new Lino.TwinCombo({ "fieldLabel": "Eigenschaftsgruppe", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropGroups.detail_action)}, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "name": "group" });
    var type9 = new Lino.TwinCombo({ "fieldLabel": "Eigenschafts-Datentyp", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.properties.PropTypes.detail_action)}, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "name": "type" });
    var main_1_panel10 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id7, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group8, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type9, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var name14 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr15 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en16 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_2_panel17 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name14, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr15, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en16, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var cv_PersonPropsByProp_grid27 = new Lino.cv.PersonPropsByProp.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.PersonPropsByProp.default_action) ], "master_panel": this });
    var main_panel28 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel10, main_2_panel17, cv_PersonPropsByProp_grid27 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel28;
    this.before_row_edit = function(record) {
      cv_PersonPropsByProp_grid27.on_master_changed();
    }
    Lino.properties.Properties.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var id1034 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1035 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1037 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1038 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1034, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1035, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1036, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1037, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method1043 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1044 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "name": "template" });
    var email_template1045 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email1046 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1047 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1043, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1044, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1045, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1046, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var cal_GuestsByRole_grid1061 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.default_action) ], "master_panel": this });
    var main_panel1062 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1038, main_2_panel1047, cal_GuestsByRole_grid1061 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1062;
    this.before_row_edit = function(record) {
      template1044.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid1061.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1043.on('change',Lino.chooser_handler(template1044,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var id1459 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person1460 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var user1461 = new Lino.TwinCombo({ "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/user", "method": "GET" }) }), "name": "user" });
    var environment1462 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent1463 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status1464 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Status", "name": "status", "anchor": "-20", "store": [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ], "hiddenName": "statusHidden" });
    var ticket1465 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel1466 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1459, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1460, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1461, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment1462, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1463, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status1464, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket1465, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var national_id1474 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var language1475 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ], "hiddenName": "languageHidden" });
    var history1476 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "hideLabel": true, "checked": false, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var parameters_panel1477 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1474, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1475, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": history1476, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var cbss_RetrieveTIGroupsResult_grid1486 = new Lino.cbss.RetrieveTIGroupsResult.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cbss.RetrieveTIGroupsResult.default_action) ], "master_panel": this });
    var request_panel1487 = new Ext.Panel({ "layout": "vbox", "title": "Abfrage", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ info_1_panel1466, parameters_panel1477, cbss_RetrieveTIGroupsResult_grid1486 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var response_xml1488 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages1489 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Info-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages1490 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Debug-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel1491 = new Lino.VBorderPanel({ "labelWidth": 144, "title": "Technisch", "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml1488, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages1489, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages1490, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel1495 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ request_panel1487, technical_panel1491 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1495;
    this.before_row_edit = function(record) {
      cbss_RetrieveTIGroupsResult_grid1486.on_master_changed();
    }
    Lino.cbss.RetrieveTIGroupsRequests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Offers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 56,
  initComponent : function() {
    var containing_panel = this;
    var name1096 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Name", "anchor": "-20", "name": "name" });
    var provider1097 = new Lino.TwinCombo({ "fieldLabel": "Stellenanbieter", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail_action)}, "emptyText": "Stellenanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/provider", "method": "GET" }) }) });
    var sector1098 = new Lino.TwinCombo({ "fieldLabel": "Sektor", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail_action)}, "emptyText": "Sektor ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/sector", "method": "GET" }) }) });
    var function1099 = new Lino.TwinCombo({ "fieldLabel": "Funktion", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail_action)}, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Offers/function", "method": "GET" }) }) });
    var main_1_panel1100 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1096, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1097, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1098, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1099, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var selection_from1105 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginn Auswahl", "anchor": "-20", "name": "selection_from" });
    var selection_until1106 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Ende Auswahl", "anchor": "-20", "name": "selection_until" });
    var start_date1107 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "beginnt am", "anchor": "-20", "name": "start_date" });
    var main_2_panel1108 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_from1105, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": selection_until1106, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1107, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var remark1112 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var ExperiencesByOffer_grid1124 = new Lino.jobs.ExperiencesByOffer.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ExperiencesByOffer.default_action) ], "master_panel": this });
    var CandidaturesByOffer_grid1133 = new Lino.jobs.CandidaturesByOffer.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByOffer.default_action) ], "master_panel": this });
    var main_4_panel1134 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ ExperiencesByOffer_grid1124, CandidaturesByOffer_grid1133 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel1135 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel1100, main_2_panel1108, { "items": remark1112, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel1134 ], "autoScroll": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel1135;
    this.before_row_edit = function(record) {
      function1099.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      ExperiencesByOffer_grid1124.on_master_changed();
      CandidaturesByOffer_grid1133.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1098.on('change',Lino.chooser_handler(function1099,'sector'));
      Lino.jobs.Offers.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Offers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var id1137 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1138 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1139 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1140 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1141 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1137, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1138, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1139, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1140, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var main_panel1171 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1141 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1171;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var person1172 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/RetrieveTIGroupsRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id1173 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var language1174 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Sprache", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "nl", "Niederl\u00e4ndisch" ], [ "fr", "Franz\u00f6sisch" ], [ "de", "Deutsch" ] ], "hiddenName": "languageHidden" });
    var main_2_panel1175 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1173, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1174, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var history1178 = new Ext.form.Checkbox({ "boxLabel": "Historie", "listeners": { "render": Lino.quicktip_renderer("Historie","Whatever this means.") }, "hideLabel": true, "checked": false, "name": "history", "selectOnFocus": true, "anchor": "-20" });
    var main_panel1179 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1172, "anchor": "-20", "labelAlign": "top" }, main_2_panel1175, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": history1178, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    this.items = main_panel1179;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.RetrieveTIGroupsRequests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var containing_panel = this;
    var prefix1182 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name1183 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1184 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language1185 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var intro_box_1_panel1186 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix1182, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1183, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1184, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1185, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id1191 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "MWSt.-Nr.", "anchor": "-20", "name": "vat_id" });
    var activity1192 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }) });
    var type1193 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var intro_box_2_panel1194 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id1191, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity1192, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1193, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel1198 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ intro_box_1_panel1186, intro_box_2_panel1194 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var country1199 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region1200 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var box3_1_panel1201 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1199, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1200, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1204 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code1205 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1206 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1204, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1209 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1210 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1211 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1212 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1213 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1209, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1210, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1211, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21218 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel1219 = new Ext.Panel({ "flex": 62, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel1201, box3_2_panel1206, box3_3_panel1213, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21218, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email1221 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url1222 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1223 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm1224 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1225 = new Ext.Panel({ "flex": 37, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1221, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1222, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1223, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1224, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel1230 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel1219, box4_panel1225 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks1231 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_courseprovider1232 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "is Kursanbieter (<a href=\"javascript:Lino.show_mti_child('is_courseprovider',Lino.courses.CourseProviders.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_courseprovider" });
    var is_jobprovider1233 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "Stellenanbieter (<a href=\"javascript:Lino.show_mti_child('is_jobprovider',Lino.jobs.JobProviders.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_jobprovider" });
    var is_health_insurance1234 = new Ext.form.Checkbox({ "boxLabel": "Krankenkasse", "hideLabel": true, "checked": false, "name": "is_health_insurance", "selectOnFocus": true, "anchor": "-20" });
    var is_pharmacy1235 = new Ext.form.Checkbox({ "boxLabel": "Apotheke", "hideLabel": true, "checked": false, "name": "is_pharmacy", "selectOnFocus": true, "anchor": "-20" });
    var is_attorney1236 = new Ext.form.Checkbox({ "boxLabel": "Attorney", "hideLabel": true, "checked": false, "name": "is_attorney", "selectOnFocus": true, "anchor": "-20" });
    var is_job_office1237 = new Ext.form.Checkbox({ "boxLabel": "Job office", "hideLabel": true, "checked": false, "name": "is_job_office", "selectOnFocus": true, "anchor": "-20" });
    var box5_2_panel1238 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_courseprovider1232, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_jobprovider1233, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_health_insurance1234, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_pharmacy1235, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_attorney1236, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_job_office1237, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var box5_panel1245 = new Ext.Panel({ "flex": 57, "labelWidth": 108, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks1231, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, box5_2_panel1238 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var contacts_RolesByCompany_grid1251 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel1252 = new Ext.Panel({ "flex": 50, "layout": "hbox", "items": [ box5_panel1245, contacts_RolesByCompany_grid1251 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var general_panel1253 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_panel1198, address_box_panel1230, bottom_box_panel1252 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid1265 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.default_action) ], "master_panel": this });
    var main_panel1266 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel1253, pcsw_NotesByCompany_grid1265 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1266;
    this.before_row_edit = function(record) {
      region1200.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1204.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1204.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid1251.on_master_changed();
      pcsw_NotesByCompany_grid1265.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1199.on('change',Lino.chooser_handler(region1200,'country'));
      country1199.on('change',Lino.chooser_handler(city1204,'country'));
      region1200.on('change',Lino.chooser_handler(city1204,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var startup_time1268 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Server l\u00e4uft seit", "anchor": "-20", "value": "<br>", "name": "startup_time" });
    var main_1_panel1269 = new Ext.Panel({ "flex": 5, "autoHeight": true, "labelWidth": 162, "items": [ { "flex": 57, "html": "<a href=\"http://code.google.com/p/lino-welfare/\" target=\"_blank\">Lino/Welfare</a> 0.1.0<br/><a href=\"http://lino.saffre-rumma.net\" target=\"_blank\">Lino</a> 1.5.0<br/><a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.dev17942<br/><a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 1.5<br/><a href=\"http://cheetahtemplate.org/\" target=\"_blank\">Cheetah</a> 2.4.4<br/><a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.4<br/><a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.7<br/><a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4.1<br/><a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.08<br/><a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.0 (2011/12/15 22:41)<br/><a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.1<br/><a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>", "xtype": "label" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": startup_time1268, "labelAlign": "top" } ], "frame": false, "split": true, "hideCheckBoxLabels": true, "layout": "hbox", "border": false, "region": "north", "labelAlign": "top" });
    var Models_htmlbox1271 = new Lino.HtmlBoxPanel({ "flex": 10, "layout": "fit", "name": "Models", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Modelle", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.lino.Models.default_action) ] });
    var main_panel1272 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 72, "items": [ main_1_panel1269, Models_htmlbox1271 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1272;
    this.before_row_edit = function(record) {
      Models_htmlbox1271.refresh();
    }
    Lino.lino.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name1273 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country1274 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region1275 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city1276 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code1277 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1278 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1274, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1275, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1276, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1277, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11283 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1284 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1285 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1286 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1287 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1288 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1284, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1285, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1286, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1287, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21293 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1294 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1273, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel1278, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11283, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1288, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21293, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id1298 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language1299 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var info_box_panel1300 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1298, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1299, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1303 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url1304 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1305 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm1306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax1307 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel1308 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1306, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1307, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1311 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 72, "title": "Kontakt", "items": [ info_box_panel1300, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1303, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1304, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1305, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1308 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var general_1_panel1315 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel1294, contact_box_panel1311 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks1316 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_person1317 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_person" });
    var is_company1318 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_company" });
    var bottom_box_2_panel1319 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person1317, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company1318, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var bottom_box_panel1322 = new Ext.Panel({ "flex": 54, "labelWidth": 108, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks1316, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel1319 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var general_panel1324 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel1315, bottom_box_panel1322 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel1326 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel1324 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1326;
    this.before_row_edit = function(record) {
      region1275.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1276.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1276.setContextValue('region',record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1274.on('change',Lino.chooser_handler(region1275,'country'));
      country1274.on('change',Lino.chooser_handler(city1276,'country'));
      region1275.on('change',Lino.chooser_handler(city1276,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.CourseProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 93,
  initComponent : function() {
    var containing_panel = this;
    var prefix2794 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2795 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2796 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language2797 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var intro_box_1_panel2798 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2794, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2795, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2796, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2797, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2803 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "MWSt.-Nr.", "anchor": "-20", "name": "vat_id" });
    var activity2804 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/activity", "method": "GET" }) }) });
    var type2805 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2806 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2803, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2804, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2805, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2810 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ intro_box_1_panel2798, intro_box_2_panel2806 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var country2811 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/country", "method": "GET" }) }) });
    var region2812 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/region", "method": "GET" }) }) });
    var box3_1_panel2813 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2811, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2812, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2816 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseProviders/city", "method": "GET" }) }) });
    var zip_code2817 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2818 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2816, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2817, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2821 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2822 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2823 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2824 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2825 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2821, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2822, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2823, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2824, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22830 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2831 = new Ext.Panel({ "flex": 62, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel2813, box3_2_panel2818, box3_3_panel2825, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22830, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email2833 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url2834 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2835 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm2836 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2837 = new Ext.Panel({ "flex": 37, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2833, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2834, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2835, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2836, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel2842 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel2831, box4_panel2837 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2843 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2844 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel2845 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ { "items": remarks2843, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2844 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel2847 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_panel2810, address_box_panel2842, bottom_box_panel2845 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2848 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.default_action) ], "master_panel": this });
    var CourseOffersByProvider_grid2854 = new Lino.courses.CourseOffersByProvider.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Kursangebote", "tools": [ Lino.show_in_own_window_button(Lino.courses.CourseOffersByProvider.default_action) ], "master_panel": this });
    var main_panel2855 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel2847, pcsw_NotesByCompany_grid2848, CourseOffersByProvider_grid2854 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2855;
    this.before_row_edit = function(record) {
      region2812.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2816.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2816.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2844.on_master_changed();
      pcsw_NotesByCompany_grid2848.on_master_changed();
      CourseOffersByProvider_grid2854.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2811.on('change',Lino.chooser_handler(region2812,'country'));
      country2811.on('change',Lino.chooser_handler(city2816,'country'));
      region2812.on('change',Lino.chooser_handler(city2816,'region'));
      Lino.courses.CourseProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.CourseProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var file1363 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1364 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1365 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1363, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1364, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 54, "border": false, "labelAlign": "top" });
    var type1368 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1369 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var valid_until1370 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel1371 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1368, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1369, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until1370, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var modified1375 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created1376 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp1377 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel1378 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1375, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1376, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1377, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var cal_TasksByController_grid1382 = new Lino.cal.TasksByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ], "master_panel": this });
    var main_panel1383 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1365, main_2_panel1371, main_3_panel1378, cal_TasksByController_grid1382 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1383;
    this.before_row_edit = function(record) {
      cal_TasksByController_grid1382.on_master_changed();
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var event_type517 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail_action)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type518 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail_action)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel519 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type517, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type518, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject522 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var project523 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company524 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var main_3_panel525 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project523, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company524, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel528 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel519, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject522, "anchor": "-20", "labelAlign": "top" }, main_3_panel525 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 54, "border": false, "labelAlign": "top" });
    this.items = main_panel528;
    this.before_row_edit = function(record) {
    }
    Lino.notes.Notes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name1496 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1497 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var email1498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var main_2_panel1499 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1497, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1498, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1502 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1496, "anchor": "-20", "labelAlign": "top" }, main_2_panel1499 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 45, "border": false, "labelAlign": "top" });
    this.items = main_panel1502;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var id758 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person759 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/person", "method": "GET" }) }), "name": "person" });
    var user760 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user", "method": "GET" }) }) });
    var user_asd761 = new Lino.TwinCombo({ "fieldLabel": "Verantwortlicher (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/user_asd", "method": "GET" }) }) });
    var language762 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var box1_1_panel763 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id758, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person759, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user760, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd761, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language762, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 207, "border": false, "labelAlign": "top" });
    var job769 = new Lino.TwinCombo({ "fieldLabel": "Stelle", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Jobs.detail_action)}, "emptyText": "Stelle ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "jobHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/job", "method": "GET" }) }), "name": "job" });
    var type770 = new Lino.TwinCombo({ "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail_action)}, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/type", "method": "GET" }) }) });
    var company771 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Organisation ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/company", "method": "GET" }) }) });
    var contact772 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vertreten durch", "name": "contact", "pageSize": 20, "emptyText": "Kontaktperson ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contactHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/contact", "method": "GET" }) }) });
    var box1_2_panel773 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": job769, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type770, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company771, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact772, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var applies_from778 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Laufzeit von", "anchor": "-20", "name": "applies_from" });
    var duration779 = new Lino.SimpleRemoteComboFieldElement({ "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/duration", "method": "GET" }) }), "fieldLabel": "Dauer (Arbeitstage)", "name": "duration", "selectOnFocus": true, "anchor": "-20", "value": null });
    var applies_until780 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Laufzeit bis", "anchor": "-20", "name": "applies_until" });
    var exam_policy781 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/exam_policy", "method": "GET" }) }) });
    var box1_3_panel782 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from778, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": duration779, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until780, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy781, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var regime787 = new Lino.TwinCombo({ "fieldLabel": "Regime", "name": "regime", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Regimes.detail_action)}, "emptyText": "Regime ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regimeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/regime", "method": "GET" }) }) });
    var schedule788 = new Lino.TwinCombo({ "fieldLabel": "Stundenplan", "name": "schedule", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Schedules.detail_action)}, "emptyText": "Stundenplan ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "scheduleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/schedule", "method": "GET" }) }) });
    var hourly_rate789 = { "decimalPrecision": 2, "fieldLabel": "Stundensatz", "xtype": "numberfield", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "name": "hourly_rate" };
    var refund_rate790 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "R\u00fcckzahlung", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/refund_rate", "method": "GET" }) }), "name": "refund_rate" });
    var box1_4_panel791 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": regime787, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": schedule788, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate789, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": refund_rate790, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var date_decided796 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beschlossen am", "anchor": "-20", "name": "date_decided" });
    var date_issued797 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Ausgestellt am", "anchor": "-20", "name": "date_issued" });
    var date_ended798 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beendet am", "anchor": "-20", "name": "date_ended" });
    var ending799 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beendigung", "name": "ending", "pageSize": 20, "emptyText": "Vertragsbeendigung ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Contracts/ending", "method": "GET" }) }) });
    var box1_5_panel800 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided796, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued797, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended798, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending799, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var reference_person805 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Referenzperson", "anchor": "-20", "name": "reference_person" });
    var build_time806 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Druckdatum", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var box1_6_panel807 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reference_person805, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time806, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var responsibilities810 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "responsibilities", "title": "Aufgabenbereich" });
    var box1_panel811 = new Ext.Panel({ "flex": 70, "labelWidth": 0, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ box1_1_panel763, box1_2_panel773, box1_3_panel782, box1_4_panel791, box1_5_panel800, box1_6_panel807, responsibilities810 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var cal_EventsByController_grid812 = new Lino.cal.EventsByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.default_action) ] });
    var cal_TasksByController_grid813 = new Lino.cal.TasksByController.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ] });
    var right_panel814 = new Lino.VBorderPanel({ "flex": 30, "items": [ cal_EventsByController_grid812, cal_TasksByController_grid813 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var main_1_panel815 = new Ext.Panel({ "layout": "hbox", "items": [ box1_panel811, right_panel814 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel816 = new Ext.Panel({ "hideCheckBoxLabels": true, "layout": "fit", "autoScroll": true, "items": [ main_1_panel815 ], "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel816;
    this.before_row_edit = function(record) {
      contact772.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      responsibilities810.refresh();
      cal_EventsByController_grid812.on_master_changed();
      cal_TasksByController_grid813.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company771.on('change',Lino.chooser_handler(contact772,'company'));
      Lino.jobs.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    job769.on("change",function(){this.save()},this);
    company771.on("change",function(){this.save()},this);
    contact772.on("change",function(){this.save()},this);
  }
});


Lino.courses.CourseOffers.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 91,
  initComponent : function() {
    var containing_panel = this;
    var id1504 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var title1505 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var content1506 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Kursinhalt", "allowBlank": false, "pageSize": 20, "emptyText": "Kursinhalt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/content", "method": "GET" }) }), "name": "content" });
    var provider1507 = new Lino.TwinCombo({ "fieldLabel": "Kursanbieter", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseProviders.detail_action)}, "emptyText": "Kursanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseOffers/provider", "method": "GET" }) }), "name": "provider" });
    var main_1_panel1508 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1504, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1505, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content1506, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1507, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "region": "north", "labelAlign": "top" });
    var description1513 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Beschreibung", "name": "description" });
    var CoursesByOffer_grid1546 = new Lino.courses.CoursesByOffer.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByOffer.default_action) ] });
    var main_panel1547 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 0, "items": [ main_1_panel1508, description1513, CoursesByOffer_grid1546 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1547;
    this.before_row_edit = function(record) {
      description1513.refresh();
      CoursesByOffer_grid1546.on_master_changed();
    }
    Lino.courses.CourseOffers.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var person1548 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var action1549 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Eintragen" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ], "name": "action" });
    var start_date1550 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date1551 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Periode bis", "anchor": "-20", "name": "end_date" });
    var p1_1_panel1552 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action1549, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1550, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1551, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose1556 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register1557 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ], "name": "query_register" });
    var p1_2_panel1558 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose1556, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register1557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel1561 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel1552, p1_2_panel1558 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var national_id1562 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no1563 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no1564 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel1565 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1562, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no1563, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no1564, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1569 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name1570 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var birth_date1571 = new Lino.IncompleteDateField({ "selectOnFocus": true, "fieldLabel": "Geburtsdatum", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel1572 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1569, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1570, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1571, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel1576 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel1565, proof_2_panel1572 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var main_panel1577 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1548, "anchor": "-20", "labelAlign": "top" }, p1_panel1561, proof_panel1576 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    this.items = main_panel1577;
    this.before_row_edit = function(record) {
      purpose1556.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
    }
    Lino.cbss.ManageAccessRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person1548.on("change",function(){this.save()},this);
  }
});


Lino.pcsw.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name1594 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country1595 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/country", "method": "GET" }) }) });
    var region1596 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/region", "method": "GET" }) }) });
    var city1597 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/city", "method": "GET" }) }) });
    var zip_code1598 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel1599 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1595, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1596, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1597, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1598, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr11604 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix1605 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1606 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1607 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1608 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel1609 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1605, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1606, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1607, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1608, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21614 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel1615 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1594, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel1599, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr11604, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel1609, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21614, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id1619 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language1620 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var info_box_panel1621 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1619, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1620, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1624 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url1625 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1626 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm1627 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax1628 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel1629 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1627, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax1628, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel1632 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 72, "title": "Kontakt", "items": [ info_box_panel1621, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1624, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1625, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1626, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel1629 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var main_1_panel1636 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel1615, contact_box_panel1632 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks1637 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_person1638 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_person" });
    var is_company1639 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_company" });
    var is_household1640 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "ist ein Haushalt (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_household" });
    var created1641 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1642 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel1643 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person1638, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company1639, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household1640, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1641, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1642, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var bottom_box_panel1649 = new Ext.Panel({ "flex": 54, "labelWidth": 108, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks1637, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel1643 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var main_panel1651 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1636, bottom_box_panel1649 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1651;
    this.before_row_edit = function(record) {
      region1596.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1597.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1597.setContextValue('region',record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country1595.on('change',Lino.chooser_handler(region1596,'country'));
      country1595.on('change',Lino.chooser_handler(city1597,'country'));
      region1596.on('change',Lino.chooser_handler(city1597,'region'));
      Lino.pcsw.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.pcsw.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var containing_panel = this;
    var username1652 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1653 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var profile1654 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": [ [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Senior))" ], [ "200", "200 (Newcomers consultant)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Readonly User)" ], [ "500", "500 (CBSS only)" ], [ "900", "900 (Administrator)" ] ], "hiddenName": "profileHidden" });
    var box1_1_panel1655 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1652, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1653, "labelAlign": "top" }, { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile1654, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1659 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name1660 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var partner1661 = new Lino.TwinCombo({ "fieldLabel": "partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.AllPartners.detail_action)}, "emptyText": "partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel1662 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1659, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1660, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1661, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email1666 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var language1667 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var box1_3_panel1668 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1666, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1667, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created1671 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1672 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel1673 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1671, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1672, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel1676 = new Ext.Panel({ "flex": 66, "autoHeight": true, "layout": "form", "items": [ box1_1_panel1655, box1_2_panel1662, box1_3_panel1668, box1_4_panel1673 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var newcomer_quota1677 = { "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Quote NZ</span>", "xtype": "numberfield", "value": 0, "name": "newcomer_quota", "listeners": { "render": Lino.quicktip_renderer("Quote NZ","Relative number expressing \n          how many Newcomer requests this User is able to treat.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var general_1_panel1678 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box1_panel1676, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": newcomer_quota1677, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var remarks1680 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid1683 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 20, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.default_action) ], "master_panel": this });
    var general_2_panel1684 = new Ext.Panel({ "flex": 55, "layout": "hbox", "items": [ { "items": remarks1680, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 80 }, AuthoritiesGiven_grid1683 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel1686 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel1678, general_2_panel1684 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var calendar1687 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class1688 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ], "name": "access_class" });
    var cal_left_1_panel1689 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1687, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1688, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 270, "border": false, "region": "north", "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid1696 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.default_action) ] });
    var cal_MembershipsByUser_grid1700 = new Lino.cal.MembershipsByUser.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.MembershipsByUser.default_action) ] });
    var cal_left_panel1701 = new Lino.VBorderPanel({ "flex": 33, "items": [ cal_left_1_panel1689, cal_SubscriptionsByUser_grid1696, cal_MembershipsByUser_grid1700 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var cal_RemindersByUser_grid1723 = new Lino.cal.RemindersByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.RemindersByUser.default_action) ], "master_panel": this });
    var cal_1_panel1724 = new Ext.Panel({ "layout": "hbox", "title": "Kalender", "items": [ cal_left_panel1701, cal_RemindersByUser_grid1723 ], "frame": false, "layoutConfig": { "align": "stretch" }, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var newcomers_CompetencesByUser_grid1729 = new Lino.newcomers.CompetencesByUser.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Kompetenzen", "tools": [ Lino.show_in_own_window_button(Lino.newcomers.CompetencesByUser.default_action) ], "master_panel": this });
    var pcsw_CoachingsByUser_grid1744 = new Lino.pcsw.CoachingsByUser.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "containing_panel": this, "title": "Coachings", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.CoachingsByUser.default_action) ], "master_panel": this });
    var main_panel1745 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel1686, cal_1_panel1724, newcomers_CompetencesByUser_grid1729, pcsw_CoachingsByUser_grid1744 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel1745;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid1683.on_master_changed();
      cal_SubscriptionsByUser_grid1696.on_master_changed();
      cal_MembershipsByUser_grid1700.on_master_changed();
      cal_RemindersByUser_grid1723.on_master_changed();
      newcomers_CompetencesByUser_grid1729.on_master_changed();
      pcsw_CoachingsByUser_grid1744.on_master_changed();
    }
    Lino.users.MySettings.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var title1775 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var first_name1776 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name1777 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1778 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1775, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1776, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender1782 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var language1783 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var main_2_panel1784 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1782, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1783, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1787 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel1778, main_2_panel1784 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1787;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var name1579 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1580 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1581 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1582 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1579, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1580, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1581, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1586 = new Lino.ChoicesFieldElement({ "fieldLabel": "Typ", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members1587 = new Ext.form.Checkbox({ "boxLabel": "Team-Mitglieder einladen", "hideLabel": true, "checked": false, "name": "invite_team_members", "selectOnFocus": true, "anchor": "-20" });
    var color1588 = { "fieldLabel": "Farbe", "xtype": "numberfield", "value": 1, "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var main_2_panel1589 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1586, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1587, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1588, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1593 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel1582, main_2_panel1589 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1593;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelCalendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 86,
  initComponent : function() {
    var containing_panel = this;
    var id1828 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1829 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1830 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1831 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1832 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1828, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1829, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1830, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1831, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "region": "north", "labelAlign": "top" });
    var remark1837 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByEventType_grid1849 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.default_action) ] });
    var main_panel1850 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 108, "items": [ main_1_panel1832, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark1837, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid1849 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1850;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid1849.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 6,
  initComponent : function() {
    var containing_panel = this;
    var username1852 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Benutzername","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email1853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var main_1_panel1854 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1852, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1853, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1857 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name1858 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var main_2_panel1859 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1857, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1858, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner1862 = new Lino.TwinCombo({ "fieldLabel": "partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.AllPartners.detail_action)}, "emptyText": "partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language1863 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var profile1864 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": [ [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Senior))" ], [ "200", "200 (Newcomers consultant)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Readonly User)" ], [ "500", "500 (CBSS only)" ], [ "900", "900 (Administrator)" ] ], "hiddenName": "profileHidden" });
    var main_4_panel1865 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1863, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile1864, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1868 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel1854, main_2_panel1859, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1862, "anchor": "-20", "labelAlign": "top" }, main_4_panel1865 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    this.items = main_panel1868;
    this.before_row_edit = function(record) {
    }
    Lino.users.MySettings.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.IdentifyPersonRequests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var person1870 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/IdentifyPersonRequests/person", "method": "GET" }) }), "name": "person" });
    var national_id1871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "NR-Nummer", "anchor": "-20", "name": "national_id" });
    var main_1_panel1872 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person1870, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id1871, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name1875 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var middle_name1876 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Mittelnamen","Whatever this means...") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Mittelnamen</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name1877 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var p2_1_panel1878 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name1875, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name1876, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name1877, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var birth_date1882 = new Lino.IncompleteDateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Geburtsdatum", "anchor": "-20", "name": "birth_date" });
    var tolerance1883 = { "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Toleranz</span>", "xtype": "numberfield", "value": 0, "name": "tolerance", "listeners": { "render": Lino.quicktip_renderer("Toleranz","\n      Falls Monat oder Tag des Geburtsdatums unbekannt sind, \n      um wieviel Monate bzw. Tage die Suche nach unten/oben ausgeweitet wird.\n      G\u00fcltige Werte: 0 bis 10.\n      ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var gender1884 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var p2_2_panel1885 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date1882, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tolerance1883, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender1884, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p2_panel1889 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "form", "title": "Phonetische Suche", "items": [ p2_1_panel1878, p2_2_panel1885 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "anchor": "-20", "labelAlign": "top" });
    var main_panel1890 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel1872, p2_panel1889 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1890;
    this.before_row_edit = function(record) {
    }
    Lino.cbss.IdentifyPersonRequests.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person1870.on("change",function(){this.save()},this);
  }
});


Lino.lino.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id1891 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name1892 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1893 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel1894 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1891, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1892, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1893, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "region": "north", "labelAlign": "top" });
    var description1898 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "center", "title": "Beschreibung", "name": "description" });
    var text1899 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel1900 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 0, "items": [ main_1_panel1894, description1898, text1899 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1900;
    this.before_row_edit = function(record) {
      description1898.refresh();
      text1899.refresh();
    }
    Lino.lino.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var type1901 = new Lino.ChoicesFieldElement({ "fieldLabel": "Typ", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name1902 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1904 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var id1905 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_1_panel1906 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1901, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1902, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1903, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1904, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1905, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var url_template1912 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL-Vorlage", "anchor": "-20", "name": "url_template" });
    var username1913 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Benutzername", "anchor": "-20", "name": "username" });
    var password1914 = new Ext.form.TextField({ "fieldLabel": "Passwort", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel1915 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template1912, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1913, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password1914, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var readonly1919 = new Ext.form.Checkbox({ "boxLabel": "schreibgesch\u00fctzt", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var invite_team_members1920 = new Ext.form.Checkbox({ "boxLabel": "Team-Mitglieder einladen", "hideLabel": true, "checked": false, "name": "invite_team_members", "selectOnFocus": true, "anchor": "-20" });
    var color1921 = { "fieldLabel": "Farbe", "xtype": "numberfield", "value": 1, "name": "color", "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var start_date1922 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var main_3_panel1923 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly1919, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1920, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1921, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1922, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 225, "border": false, "labelAlign": "top" });
    var build_method1928 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1929 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "name": "template" });
    var email_template1930 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email1931 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1932 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1928, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1929, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1930, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1931, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var main_panel1969 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1906, main_2_panel1915, main_3_panel1923, main_4_panel1932 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1969;
    this.before_row_edit = function(record) {
      template1929.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method1928.on('change',Lino.chooser_handler(template1929,'build_method'));
      Lino.cal.PanelCalendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.PanelCalendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id2775 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2776 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label2777 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model2778 = new Ext.form.TextField({ "fieldLabel": "Python Modell-Klassenname", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp2779 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel2780 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2775, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2776, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label2777, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model2778, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp2779, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var lino_HelpTextsByModel_grid2792 = new Lino.lino.HelpTextsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.HelpTextsByModel.default_action) ], "master_panel": this });
    var main_panel2793 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2780, lino_HelpTextsByModel_grid2792 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2793;
    this.before_row_edit = function(record) {
      lino_HelpTextsByModel_grid2792.on_master_changed();
    }
    Lino.lino.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var type2088 = new Lino.TwinCombo({ "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail_action)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name2089 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language2090 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var id2091 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var intro_box_1_panel2092 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2088, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2089, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2090, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2091, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var country2097 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region2098 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel2099 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2097, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2098, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2102 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code2103 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2104 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2102, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2103, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2107 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2108 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2109 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2110 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2111 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2107, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2108, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2109, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2110, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22116 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var activity2117 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }) });
    var bank_account12118 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 1", "anchor": "-20", "name": "bank_account1" });
    var bank_account22119 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Bankkonto 2", "anchor": "-20", "name": "bank_account2" });
    var box3_5_panel2120 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2117, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account12118, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": bank_account22119, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box3_panel2124 = new Ext.Panel({ "flex": 62, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel2099, box3_2_panel2104, box3_3_panel2111, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22116, "anchor": "-20", "labelAlign": "top" }, box3_5_panel2120 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email2126 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url2127 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2128 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm2129 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2130 = new Ext.Panel({ "flex": 37, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2126, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2127, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2128, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2129, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel2135 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel2124, box4_panel2130 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2136 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid2143 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.default_action) ], "master_panel": this });
    var bottom_box_panel2144 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ { "items": remarks2136, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid2143 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel2146 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_1_panel2092, address_box_panel2135, bottom_box_panel2144 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel2148 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel2146 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2148;
    this.before_row_edit = function(record) {
      region2098.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2102.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2102.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid2143.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2097.on('change',Lino.chooser_handler(region2098,'country'));
      country2097.on('change',Lino.chooser_handler(city2102,'country'));
      region2098.on('change',Lino.chooser_handler(city2102,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox2149 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true });
    var UsersWithClients_htmlbox2150 = new Lino.HtmlBoxPanel({ "flex": 8, "layout": "fit", "name": "UsersWithClients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Benutzer und ihre Klienten", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.UsersWithClients.default_action) ] });
    var coming_reminders_htmlbox2151 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Ausblick", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var missed_reminders_htmlbox2152 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Verpasste Erinnerungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var main_3_panel2153 = new Ext.Panel({ "flex": 16, "layout": "hbox", "items": [ coming_reminders_htmlbox2151, missed_reminders_htmlbox2152 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 207, "border": false, "region": "south", "labelAlign": "top" });
    var main_panel2154 = new Lino.VBorderPanel({ "hideCheckBoxLabels": true, "labelWidth": 243, "items": [ quick_links_htmlbox2149, UsersWithClients_htmlbox2150, main_3_panel2153 ], "autoScroll": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2154;
    this.before_row_edit = function(record) {
      quick_links_htmlbox2149.refresh();
      UsersWithClients_htmlbox2150.refresh();
      coming_reminders_htmlbox2151.refresh();
      missed_reminders_htmlbox2152.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var containing_panel = this;
    var name1990 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country1991 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var inscode1992 = new Ext.form.TextField({ "fieldLabel": "INS-Code", "name": "inscode", "maxLength": 5, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "anchor": "-20" });
    var main_1_panel1993 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1990, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1991, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1992, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var parent1997 = new Lino.TwinCombo({ "fieldLabel": "Part of", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var type1998 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Settlement Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var id1999 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_2_panel2000 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1997, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1998, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1999, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var CitiesByCity_grid2067 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.default_action) ], "master_panel": this });
    var contacts_PartnersByCity_grid2068 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.default_action) ], "master_panel": this });
    var jobs_StudiesByCity_grid2069 = new Lino.jobs.StudiesByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCity.default_action) ], "master_panel": this });
    var main_4_panel2070 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ contacts_PartnersByCity_grid2068, jobs_StudiesByCity_grid2069 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel2071 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1993, main_2_panel2000, CitiesByCity_grid2067, main_4_panel2070 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2071;
    this.before_row_edit = function(record) {
      type1998.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid2067.on_master_changed();
      contacts_PartnersByCity_grid2068.on_master_changed();
      jobs_StudiesByCity_grid2069.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1991.on('change',Lino.chooser_handler(type1998,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 89,
  initComponent : function() {
    var containing_panel = this;
    var id1519 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var start_date1520 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "beginnt am", "anchor": "-20", "name": "start_date" });
    var offer1521 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail_action)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/offer", "method": "GET" }) }), "name": "offer" });
    var title1522 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Name", "anchor": "-20", "name": "title" });
    var main_1_panel1523 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1519, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1520, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer1521, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1522, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var remark1528 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bemerkungen", "anchor": "-20", "name": "remark" });
    var courses_ParticipantsByCourse_grid1535 = new Lino.courses.ParticipantsByCourse.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.ParticipantsByCourse.default_action) ], "master_panel": this });
    var courses_CandidatesByCourse_grid1543 = new Lino.courses.CandidatesByCourse.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.courses.CandidatesByCourse.default_action) ], "master_panel": this });
    var main_panel1544 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel1523, { "items": remark1528, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, courses_ParticipantsByCourse_grid1535, courses_CandidatesByCourse_grid1543 ], "autoScroll": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel1544;
    this.before_row_edit = function(record) {
      courses_ParticipantsByCourse_grid1535.on_master_changed();
      courses_CandidatesByCourse_grid1543.on_master_changed();
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var name2231 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2232 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2233 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2234 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2231, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2232, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2233, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var HouseholdsByType_grid2265 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.default_action) ], "master_panel": this });
    var main_panel2266 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2234, HouseholdsByType_grid2265 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2266;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid2265.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var id2311 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2312 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2313 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2314 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2315 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2311, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2312, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2313, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2314, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var GroupsByChart_grid2358 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.default_action) ], "master_panel": this });
    var main_panel2359 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2315, GroupsByChart_grid2358 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2359;
    this.before_row_edit = function(record) {
      GroupsByChart_grid2358.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp2360 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp2361 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp2362 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows_disp2363 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Zeilen", "name": "rows", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel2364 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp2360, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp2361, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp2362, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows_disp2363, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var lino_FieldsByModel_grid2373 = new Lino.lino.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.FieldsByModel.default_action) ], "master_panel": this });
    var main_panel2374 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2364, lino_FieldsByModel_grid2373 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2374;
    this.before_row_edit = function(record) {
      lino_FieldsByModel_grid2373.on_master_changed();
    }
    Lino.lino.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var last_name2375 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var first_name2376 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender2377 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var title2378 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var name_box_panel2379 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2375, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2376, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2377, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2378, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country2384 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region2385 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city2386 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code2387 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel2388 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2384, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2385, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2386, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr12393 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix2394 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2395 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2396 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2397 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel2398 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2394, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2395, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2396, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2397, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22403 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel2404 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 216, "title": "Adresse", "items": [ name_box_panel2379, address_box_2_panel2388, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr12393, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel2398, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22403, "anchor": "-20", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id2407 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language2408 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var info_box_panel2409 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2407, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2408, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email2412 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url2413 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2414 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm2415 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax2416 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel2417 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2415, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax2416, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel2420 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 72, "title": "Kontakt", "items": [ info_box_panel2409, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2412, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2413, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2414, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel2417 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var main_1_panel2424 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel2404, contact_box_panel2420 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2425 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid2426 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.default_action) ], "master_panel": this });
    var bottom_box_1_panel2427 = new Ext.Panel({ "flex": 83, "layout": "hbox", "items": [ { "items": remarks2425, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid2426 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var is_client2429 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "is Client (<a href=\"javascript:Lino.show_mti_child('is_client',Lino.pcsw.Clients.detail_action)\">zeigen</a>)", "hideLabel": true, "anchor": "-20", "name": "is_client" });
    var created2430 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified2431 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var bottom_box_2_panel2432 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_client2429, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created2430, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified2431, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var bottom_box_panel2436 = new Ext.Panel({ "flex": 54, "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "items": [ bottom_box_1_panel2427, bottom_box_2_panel2432 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel2437 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2424, bottom_box_panel2436 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2437;
    this.before_row_edit = function(record) {
      region2385.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2386.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2386.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid2426.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2384.on('change',Lino.chooser_handler(region2385,'country'));
      country2384.on('change',Lino.chooser_handler(city2386,'country'));
      region2385.on('change',Lino.chooser_handler(city2386,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var calendar638 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary639 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user640 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var project641 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel642 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar638, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary639, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user640, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project641, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var start_date647 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time648 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel649 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date647, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time648, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date652 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time653 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel654 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date652, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time653, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var general_2_panel657 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ start_panel649, end_panel654 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var place658 = new Lino.TwinCombo({ "fieldLabel": "Ort", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority659 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class660 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ], "name": "access_class" });
    var transparent661 = new Ext.form.Checkbox({ "boxLabel": "nicht blockierend", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel662 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place658, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority659, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class660, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent661, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "labelAlign": "top" });
    var owner_disp667 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var state668 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Status", "name": "state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Entwurf" ], [ "20", "Vorgeschlagen" ], [ "30", "Mitgeteilt" ], [ "40", "Geplant" ], [ "50", "Stattgefunden" ], [ "60", "Verschoben" ], [ "70", "Storniert" ], [ "80", "Abwesend" ], [ "90", "Verj\u00e4hrt" ] ], "hiddenName": "stateHidden" });
    var workflow_buttons_disp669 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflows", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel670 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp667, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state668, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp669, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var description674 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var GuestsByEvent_grid684 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.default_action) ], "master_panel": this });
    var general_5_panel685 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ description674, GuestsByEvent_grid684 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    var general_panel686 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel642, general_2_panel657, general_3_panel662, general_4_panel670, general_5_panel685 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var id687 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var created688 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified689 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var more_1_panel690 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id687, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created688, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified689, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var outbox_MailsByController_grid694 = new Lino.outbox.MailsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.default_action) ], "master_panel": this });
    var postings_PostingsByController_grid695 = new Lino.postings.PostingsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.default_action) ], "master_panel": this });
    var more_2_panel696 = new Ext.Panel({ "flex": 83, "layout": "hbox", "items": [ outbox_MailsByController_grid694, postings_PostingsByController_grid695 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var more_panel697 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ more_1_panel690, more_2_panel696 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel698 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel686, more_panel697 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel698;
    this.before_row_edit = function(record) {
      description674.refresh();
      GuestsByEvent_grid684.on_master_changed();
      outbox_MailsByController_grid694.on_master_changed();
      postings_PostingsByController_grid695.on_master_changed();
    }
    Lino.cal.PanelEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.Jobs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var name1399 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var provider1400 = new Lino.TwinCombo({ "fieldLabel": "Stellenanbieter", "name": "provider", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobProviders.detail_action)}, "emptyText": "Stellenanbieter ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "providerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/provider", "method": "GET" }) }) });
    var contract_type1401 = new Lino.TwinCombo({ "fieldLabel": "Vertragsart", "name": "contract_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.ContractTypes.detail_action)}, "emptyText": "Art.60\u00a77-Konventionsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contract_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/contract_type", "method": "GET" }) }) });
    var type1402 = new Lino.TwinCombo({ "fieldLabel": "Stellenart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.JobTypes.detail_action)}, "emptyText": "Stellenart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/type", "method": "GET" }) }) });
    var id1403 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_1_panel1404 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1399, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": provider1400, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contract_type1401, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1402, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1403, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var sector1410 = new Lino.TwinCombo({ "fieldLabel": "Sektor", "name": "sector", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Sectors.detail_action)}, "emptyText": "Sektor ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "sectorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/sector", "method": "GET" }) }) });
    var function1411 = new Lino.TwinCombo({ "fieldLabel": "Funktion", "name": "function", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.jobs.Functions.detail_action)}, "emptyText": "Funktion ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "functionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/Jobs/function", "method": "GET" }) }) });
    var capacity1412 = { "fieldLabel": "Kapazit\u00e4t", "xtype": "numberfield", "value": 1, "name": "capacity", "selectOnFocus": true, "anchor": "-20", "allowBlank": false };
    var hourly_rate1413 = { "decimalPrecision": 2, "fieldLabel": "Stundensatz", "xtype": "numberfield", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "name": "hourly_rate" };
    var main_2_panel1414 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sector1410, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": function1411, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": capacity1412, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": hourly_rate1413, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var remark1419 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var CandidaturesByJob_grid1427 = new Lino.jobs.CandidaturesByJob.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.CandidaturesByJob.default_action) ], "master_panel": this });
    var main_3_panel1428 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ { "items": remark1419, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, CandidaturesByJob_grid1427 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var ContractsByJob_grid1455 = new Lino.jobs.ContractsByJob.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByJob.default_action) ], "master_panel": this });
    var main_panel1456 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1404, main_2_panel1414, main_3_panel1428, ContractsByJob_grid1455 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel1456;
    this.before_row_edit = function(record) {
      function1411.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      CandidaturesByJob_grid1427.on_master_changed();
      ContractsByJob_grid1455.on_master_changed();
    }
    this.onRender = function(ct, position) {
      sector1410.on('change',Lino.chooser_handler(function1411,'sector'));
      Lino.jobs.Jobs.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.Jobs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var summary505 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user506 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project507 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel508 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user506, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project507, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel511 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary505, "anchor": "-20", "labelAlign": "top" }, main_2_panel508 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    this.items = main_panel511;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var name2438 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2439 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2440 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var name_giving2441 = new Ext.form.Checkbox({ "boxLabel": "namensgebend", "listeners": { "render": Lino.quicktip_renderer("namensgebend","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel2442 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2438, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2439, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2440, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving2441, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var MembersByRole_grid2453 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.default_action) ], "master_panel": this });
    var main_panel2454 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2442, MembersByRole_grid2453 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2454;
    this.before_row_edit = function(record) {
      MembersByRole_grid2453.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cbss.ManageAccessRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var id2455 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person2456 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail_action)}, "emptyText": "Person ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/person", "method": "GET" }) }), "name": "person" });
    var user2457 = new Lino.TwinCombo({ "fieldLabel": "Autor", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/user", "method": "GET" }) }), "name": "user" });
    var environment2458 = new Ext.form.TextField({ "disabled": true, "fieldLabel": "T/A/B", "name": "environment", "maxLength": 4, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var sent2459 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Versendet","The date and time when this request has been executed. \nThis is empty for requests than haven't been sent.\nRead-only.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Versendet</span>", "name": "sent", "anchor": "-20", "value": "<br>" });
    var status2460 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "fieldLabel": "Status", "name": "status", "anchor": "-20", "store": [ [ "10", "Versendet" ], [ "20", "Fehlgeschlagen" ], [ "25", "Validiert" ], [ "30", "OK" ], [ "40", "Warnungen" ], [ "50", "Fehlermeldungen" ] ], "hiddenName": "statusHidden" });
    var ticket2461 = new Ext.form.TextField({ "disabled": true, "maxLength": 36, "fieldLabel": "Ticket", "anchor": "-20", "name": "ticket" });
    var info_1_panel2462 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Info zur Anfrage", "layoutConfig": { "align": "stretchmax" }, "frame": false, "bodyBorder": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2455, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person2456, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2457, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": environment2458, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent2459, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": status2460, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket2461, "labelAlign": "top" } ], "hideCheckBoxLabels": true, "labelWidth": 90, "border": true, "labelAlign": "top" });
    var action2470 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Aktion", "allowBlank": false, "hiddenName": "actionHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Eintragen" ], [ "2", "Austragen" ], [ "3", "Auflisten" ] ], "name": "action" });
    var start_date2471 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Periode vom", "anchor": "-20", "name": "start_date" });
    var end_date2472 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Periode bis", "anchor": "-20", "name": "end_date" });
    var p1_1_panel2473 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": action2470, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2471, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2472, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purpose2477 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Eigenschafts-Code</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Code ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Eigenschafts-Code","The purpose for which the inscription needs to be \nregistered/unregistered or listed. \nFor listing this field is optional, \nfor register/unregister it is mandatory.") }, "selectOnFocus": true, "hiddenName": "purposeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cbss/ManageAccessRequests/purpose", "method": "GET" }) }), "name": "purpose" });
    var query_register2478 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Abfrageregister", "allowBlank": false, "hiddenName": "query_registerHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "1", "Prim\u00e4r" ], [ "2", "Sekund\u00e4r" ], [ "3", "Alle" ] ], "name": "query_register" });
    var p1_2_panel2479 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purpose2477, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": query_register2478, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var p1_panel2482 = new Ext.form.FieldSet({ "flex": 34, "autoHeight": true, "layout": "form", "title": "Angefragte Aktion", "items": [ p1_1_panel2473, p1_2_panel2479 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var national_id2483 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("NR-Nummer","The SSIN of the person to register/unregister/list.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">NR-Nummer</span>", "name": "national_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sis_card_no2484 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("SIS-Karten-Nr","The number of the SIS card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">SIS-Karten-Nr</span>", "name": "sis_card_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var id_card_no2485 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ID-Karten-Nr","The number of the ID card used to authenticate the person.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ID-Karten-Nr</span>", "name": "id_card_no", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var proof_1_panel2486 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": national_id2483, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sis_card_no2484, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id_card_no2485, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name2490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name2491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var birth_date2492 = new Lino.IncompleteDateField({ "selectOnFocus": true, "fieldLabel": "Geburtsdatum", "anchor": "-20", "name": "birth_date" });
    var proof_2_panel2493 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2490, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2491, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date2492, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var proof_panel2497 = new Ext.form.FieldSet({ "flex": 65, "autoHeight": true, "layout": "form", "title": "Authentifizierungsbeleg", "items": [ proof_1_panel2486, proof_2_panel2493 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var parameters_panel2498 = new Ext.form.FieldSet({ "autoHeight": true, "layout": "hbox", "title": "Parameter", "bodyBorder": true, "frame": false, "layoutConfig": { "align": "stretchmax" }, "items": [ p1_panel2482, proof_panel2497 ], "hideCheckBoxLabels": true, "border": true, "labelAlign": "top" });
    var result_htmlbox2499 = new Lino.HtmlBoxPanel({ "flex": 62, "layout": "fit", "name": "result", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Resultat", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;" });
    var request_panel2500 = new Ext.Panel({ "labelWidth": 81, "title": "Abfrage", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ info_1_panel2462, parameters_panel2498, result_htmlbox2499 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var response_xml2501 = new Ext.form.TextArea({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Antwort","The raw XML response received. \n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Antwort</span>", "name": "response_xml", "growMax": 2000, "anchor": "-20 -10" });
    var info_messages2502 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Info-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "info_messages" });
    var debug_messages2503 = new Ext.form.TextArea({ "disabled": true, "fieldLabel": "Debug-Meldungen", "anchor": "-20 -10", "growMax": 2000, "name": "debug_messages" });
    var technical_panel2504 = new Lino.VBorderPanel({ "labelWidth": 144, "title": "Technisch", "items": [ { "flex": 5, "layout": "form", "xtype": "panel", "items": response_xml2501, "region": "north", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": info_messages2502, "region": "center", "labelAlign": "top", "split": true }, { "flex": 5, "layout": "form", "xtype": "panel", "items": debug_messages2503, "region": "south", "labelAlign": "top", "split": true } ], "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var main_panel2508 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ request_panel2500, technical_panel2504 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2508;
    this.before_row_edit = function(record) {
      purpose2477.setContextValue('sector',record ? record.data['sectorHidden'] : undefined);
      result_htmlbox2499.refresh();
    }
    Lino.cbss.ManageAccessRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    person2456.on("change",function(){this.save()},this);
  }
});


Lino.jobs.JobProviders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var prefix2509 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "-20", "name": "prefix" });
    var name2510 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2511 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var language2512 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var intro_box_1_panel2513 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix2509, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2510, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2511, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2512, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var vat_id2518 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "MWSt.-Nr.", "anchor": "-20", "name": "vat_id" });
    var activity2519 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beruf", "name": "activity", "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "activityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/activity", "method": "GET" }) }) });
    var type2520 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/type", "method": "GET" }) }) });
    var intro_box_2_panel2521 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id2518, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": activity2519, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2520, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var intro_box_panel2525 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ intro_box_1_panel2513, intro_box_2_panel2521 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var country2526 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/country", "method": "GET" }) }) });
    var region2527 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/region", "method": "GET" }) }) });
    var box3_1_panel2528 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country2526, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region2527, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city2531 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/jobs/JobProviders/city", "method": "GET" }) }) });
    var zip_code2532 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel2533 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city2531, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code2532, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix2536 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street2537 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no2538 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box2539 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel2540 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix2536, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street2537, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no2538, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box2539, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr22545 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel2546 = new Ext.Panel({ "flex": 62, "autoHeight": true, "labelWidth": 216, "items": [ box3_1_panel2528, box3_2_panel2533, box3_3_panel2540, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr22545, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var email2548 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url2549 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone2550 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm2551 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel2552 = new Ext.Panel({ "flex": 37, "autoHeight": true, "labelWidth": 72, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email2548, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url2549, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone2550, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm2551, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "layout": "form", "border": false, "labelAlign": "top" });
    var address_box_panel2557 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ box3_panel2546, box4_panel2552 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks2558 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid2559 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel2560 = new Ext.Panel({ "flex": 45, "layout": "hbox", "items": [ { "items": remarks2558, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid2559 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var general_panel2562 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ intro_box_panel2525, address_box_panel2557, bottom_box_panel2560 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var pcsw_NotesByCompany_grid2563 = new Lino.pcsw.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Notizen", "tools": [ Lino.show_in_own_window_button(Lino.pcsw.NotesByCompany.default_action) ], "master_panel": this });
    var JobsByProvider_grid2575 = new Lino.jobs.JobsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.JobsByProvider.default_action) ] });
    var ContractsByProvider_grid2601 = new Lino.jobs.ContractsByProvider.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.ContractsByProvider.default_action) ] });
    var jobs_panel2602 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "Stellen", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ JobsByProvider_grid2575, ContractsByProvider_grid2601 ], "border": false, "labelAlign": "top" });
    var main_panel2603 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel2562, pcsw_NotesByCompany_grid2563, jobs_panel2602 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel2603;
    this.before_row_edit = function(record) {
      region2527.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2531.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2531.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid2559.on_master_changed();
      pcsw_NotesByCompany_grid2563.on_master_changed();
      JobsByProvider_grid2575.on_master_changed();
      ContractsByProvider_grid2601.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country2526.on('change',Lino.chooser_handler(region2527,'country'));
      country2526.on('change',Lino.chooser_handler(city2531,'country'));
      region2527.on('change',Lino.chooser_handler(city2531,'region'));
      Lino.jobs.JobProviders.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.jobs.JobProviders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var summary699 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var start_date700 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time701 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel702 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date700, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time701, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date705 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time706 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel707 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date705, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time706, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel710 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ start_panel702, end_panel707 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "border": false, "anchor": "-20", "labelAlign": "top" });
    var calendar711 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project712 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel713 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar711, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project712, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel716 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary699, "anchor": "-20", "labelAlign": "top" }, main_2_panel710, main_3_panel713 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    this.items = main_panel716;
    this.before_row_edit = function(record) {
    }
    Lino.cal.PanelEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var ref2328 = new Ext.form.TextField({ "fieldLabel": "ref", "name": "ref", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name2329 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2330 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2331 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2332 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref2328, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2329, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2330, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2331, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var account_type2337 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Kontenart", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ] ], "hiddenName": "account_typeHidden" });
    var id2338 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_2_panel2339 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type2337, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2338, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var help_text2342 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Einleitung" });
    var AccountsByGroup_grid2356 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.default_action) ], "master_panel": this });
    var main_panel2357 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel2332, main_2_panel2339, help_text2342, AccountsByGroup_grid2356 ], "autoScroll": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel2357;
    this.before_row_edit = function(record) {
      help_text2342.refresh();
      AccountsByGroup_grid2356.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 88,
  initComponent : function() {
    var containing_panel = this;
    var id2604 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2605 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2606 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2607 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2608 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2604, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2605, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2606, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2607, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method2613 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template2614 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "name": "template" });
    var email_template2615 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var attach_to_email2616 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2617 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2613, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2614, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template2615, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email2616, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 198, "border": false, "labelAlign": "top" });
    var remark2622 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var notes_NotesByType_grid2634 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.default_action) ], "master_panel": this });
    var main_panel2635 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel2608, main_2_panel2617, { "items": remark2622, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid2634 ], "autoScroll": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel2635;
    this.before_row_edit = function(record) {
      template2614.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid2634.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2613.on('change',Lino.chooser_handler(template2614,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var start_date476 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date477 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "F\u00e4llig am", "anchor": "-20", "name": "due_date" });
    var id478 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var state479 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Status", "name": "state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "40", "Schl\u00e4ft" ], [ "50", "Storniert" ] ], "hiddenName": "stateHidden" });
    var workflow_buttons_disp480 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflows", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel481 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date476, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date477, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id478, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state479, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp480, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var summary487 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user488 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project489 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel490 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user488, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project489, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var calendar493 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail_action)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp494 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created495 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified496 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel497 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar493, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp494, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created495, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified496, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var description502 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 38, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var main_panel503 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel481, { "items": summary487, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel490, main_4_panel497, description502 ], "autoScroll": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    this.items = main_panel503;
    this.before_row_edit = function(record) {
      description502.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.jobs.JobsOverview.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var body_disp2637 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Inhalt", "name": "body", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel2638 = new Ext.Panel({ "hideCheckBoxLabels": true, "labelWidth": 63, "items": [ { "items": body_disp2637, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "autoScroll": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel2638;
    this.before_row_edit = function(record) {
    }
    Lino.jobs.JobsOverview.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var file2762 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user2763 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel2764 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2762, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2763, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type2767 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var valid_until2768 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "g\u00fcltig bis", "anchor": "-20", "name": "valid_until" });
    var main_2_panel2769 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2767, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": valid_until2768, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var description2772 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var main_panel2773 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel2764, main_2_panel2769, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2772, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    this.items = main_panel2773;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var id578 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var person579 = new Lino.TwinCombo({ "fieldLabel": "Klient", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/person", "method": "GET" }) }), "name": "person" });
    var user580 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }) });
    var user_asd581 = new Lino.TwinCombo({ "fieldLabel": "Verantwortlicher (ASD)", "name": "user_asd", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "user_asdHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }) });
    var language582 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var general_1_panel583 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id578, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person579, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user580, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user_asd581, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language582, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 207, "border": false, "labelAlign": "top" });
    var type589 = new Lino.TwinCombo({ "fieldLabel": "Vertragsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.isip.ContractTypes.detail_action)}, "emptyText": "VSE-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }) });
    var company590 = new Lino.TwinCombo({ "fieldLabel": "Organisation", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Organisation ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }) });
    var contact591 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Vertreten durch", "name": "contact", "pageSize": 20, "emptyText": "Kontaktperson ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "contactHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact", "method": "GET" }) }) });
    var general_2_panel592 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type589, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company590, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact591, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var applies_from596 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Laufzeit von", "anchor": "-20", "name": "applies_from" });
    var applies_until597 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Laufzeit bis", "anchor": "-20", "name": "applies_until" });
    var exam_policy598 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Auswertungsstrategie", "name": "exam_policy", "pageSize": 20, "emptyText": "Auswertungsstrategie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "exam_policyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }) });
    var general_3_panel599 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_from596, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": applies_until597, "labelAlign": "top" }, { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": exam_policy598, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" });
    var date_decided603 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beschlossen am", "anchor": "-20", "name": "date_decided" });
    var date_issued604 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Ausgestellt am", "anchor": "-20", "name": "date_issued" });
    var general_4_panel605 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_decided603, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_issued604, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "labelAlign": "top" });
    var date_ended608 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beendet am", "anchor": "-20", "name": "date_ended" });
    var ending609 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Beendigung", "name": "ending", "pageSize": 20, "emptyText": "Vertragsbeendigung ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "endingHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }) });
    var general_5_panel610 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended608, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ending609, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var cal_TasksByController_grid613 = new Lino.cal.TasksByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ], "master_panel": this });
    var cal_EventsByController_grid718 = new Lino.cal.EventsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.default_action) ], "master_panel": this });
    var general_6_panel719 = new Ext.Panel({ "flex": 50, "layout": "hbox", "items": [ cal_TasksByController_grid613, cal_EventsByController_grid718 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var general_panel720 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel583, general_2_panel592, general_3_panel599, general_4_panel605, general_5_panel610, general_6_panel719 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var stages721 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "stages", "title": "Etappen" });
    var goals722 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "goals", "title": "Zielsetzungen" });
    var isip_1_panel723 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ stages721, goals722 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "region": "north", "labelAlign": "top" });
    var duties_asd724 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_asd", "title": "Verpflichtungen ASD" });
    var duties_dsbe725 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_dsbe", "title": "Verpflichtungen DSBE" });
    var isip_2_panel726 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_asd724, duties_dsbe725 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "region": "center", "labelAlign": "top" });
    var duties_company727 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_company", "title": "Verpflichtungen Firma" });
    var duties_person728 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "containing_panel": this, "name": "duties_person", "title": "Verpflichtungen Person" });
    var isip_3_panel729 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ duties_company727, duties_person728 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "region": "south", "labelAlign": "top" });
    var isip_panel730 = new Lino.VBorderPanel({ "listeners": { "activate": Lino.on_tab_activate }, "title": "VSE", "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "items": [ isip_1_panel723, isip_2_panel726, isip_3_panel729 ], "border": false, "labelAlign": "top" });
    var main_panel731 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "split": true, "autoScroll": true, "items": [ general_panel720, isip_panel730 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel731;
    this.before_row_edit = function(record) {
      contact591.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      cal_TasksByController_grid613.on_master_changed();
      cal_EventsByController_grid718.on_master_changed();
      stages721.refresh();
      goals722.refresh();
      duties_asd724.refresh();
      duties_dsbe725.refresh();
      duties_company727.refresh();
      duties_person728.refresh();
    }
    this.onRender = function(ct, position) {
      company590.on('change',Lino.chooser_handler(contact591,'company'));
      Lino.isip.Contracts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.isip.Contracts.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    company590.on("change",function(){this.save()},this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var isocode1970 = new Ext.form.TextField({ "fieldLabel": "isocode", "name": "isocode", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20", "allowBlank": false });
    var name1971 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en1973 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var short_code1974 = new Ext.form.TextField({ "fieldLabel": "short code", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var inscode1975 = new Ext.form.TextField({ "fieldLabel": "INS-Code", "name": "inscode", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20" });
    var main_1_panel1976 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode1970, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1971, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1972, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1973, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code1974, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inscode1975, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var countries_CitiesByCountry_grid2072 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 37, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.default_action) ], "master_panel": this });
    var jobs_StudiesByCountry_grid2085 = new Lino.jobs.StudiesByCountry.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.jobs.StudiesByCountry.default_action) ], "master_panel": this });
    var main_2_panel2086 = new Ext.Panel({ "flex": 83, "layout": "hbox", "items": [ countries_CitiesByCountry_grid2072, jobs_StudiesByCountry_grid2085 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel2087 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1976, main_2_panel2086 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2087;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid2072.on_master_changed();
      jobs_StudiesByCountry_grid2085.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 75,
  initComponent : function() {
    var containing_panel = this;
    var title2747 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var first_name2748 = new Ext.form.TextField({ "fieldLabel": "Vorname", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name2749 = new Ext.form.TextField({ "fieldLabel": "Familienname", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2750 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2747, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name2748, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name2749, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender2754 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var language2755 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var main_2_panel2756 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2754, "labelAlign": "top" }, { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2755, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2759 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel2750, main_2_panel2756 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2759;
    this.before_row_edit = function(record) {
    }
    Lino.pcsw.Clients.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 87,
  initComponent : function() {
    var containing_panel = this;
    var date378 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var event_type379 = new Lino.TwinCombo({ "fieldLabel": "Ereignisart (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail_action)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type380 = new Lino.TwinCombo({ "fieldLabel": "Notizart (Inhalt)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail_action)}, "emptyText": "Notizart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var left_1_panel381 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date378, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type379, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type380, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "labelAlign": "top" });
    var subject385 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var project386 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var company387 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Organisation</span>", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail_action)}, "emptyText": "Organisation ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisation","    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var left_3_panel388 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project386, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var id391 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var user392 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language393 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var build_time394 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Druckdatum", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var left_4_panel395 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id391, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user392, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language393, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time394, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var body400 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 55, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var left_panel401 = new Ext.Panel({ "flex": 66, "labelWidth": 54, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ left_1_panel381, { "items": subject385, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, left_3_panel388, left_4_panel395, body400 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var UploadsByController_htmlbox403 = new Lino.HtmlBoxPanel({ "flex": 25, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var outbox_MailsByController_grid443 = new Lino.outbox.MailsByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.default_action) ], "master_panel": this });
    var postings_PostingsByController_grid454 = new Lino.postings.PostingsByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.postings.PostingsByController.default_action) ], "master_panel": this });
    var cal_TasksByController_grid513 = new Lino.cal.TasksByController.GridPanel({ "flex": 25, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByController.default_action) ], "master_panel": this });
    var right_panel514 = new Ext.Panel({ "flex": 33, "labelWidth": 72, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ UploadsByController_htmlbox403, outbox_MailsByController_grid443, postings_PostingsByController_grid454, cal_TasksByController_grid513 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var main_1_panel515 = new Ext.Panel({ "layout": "hbox", "items": [ left_panel401, right_panel514 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel516 = new Ext.Panel({ "hideCheckBoxLabels": true, "layout": "fit", "autoScroll": true, "items": [ main_1_panel515 ], "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel516;
    this.before_row_edit = function(record) {
      body400.refresh();
      UploadsByController_htmlbox403.refresh();
      outbox_MailsByController_grid443.on_master_changed();
      postings_PostingsByController_grid454.on_master_changed();
      cal_TasksByController_grid513.on_master_changed();
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var id2856 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var name2857 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2858 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2859 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2860 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2856, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2857, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2858, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2859, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var PropsByGroup_grid2865 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.default_action) ], "master_panel": this });
    var main_panel2866 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2860, PropsByGroup_grid2865 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2866;
    this.before_row_edit = function(record) {
      PropsByGroup_grid2865.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PendingCourseRequests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 92,
  initComponent : function() {
    var containing_panel = this;
    var date_submitted304 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("eingereicht am ","Das Datum, an dem die Anfrage erstellt wurde.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">eingereicht am </span>", "name": "date_submitted", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var person305 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Person</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Person","Die Person, die die Anfrage macht.") }, "selectOnFocus": true, "hiddenName": "personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/person", "method": "GET" }) }), "name": "person" });
    var content306 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kursinhalt</span>", "allowBlank": false, "pageSize": 20, "emptyText": "Kursinhalt ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Kursinhalt","Der gew\u00fcnschte Kursinhalt (ein Objekt vom Typ :class:`CourseConent`.)") }, "selectOnFocus": true, "hiddenName": "contentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/content", "method": "GET" }) }), "name": "content" });
    var offer307 = new Lino.TwinCombo({ "fieldLabel": "Kursangebot", "name": "offer", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.CourseOffers.detail_action)}, "emptyText": "Kursangebot ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "offerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/offer", "method": "GET" }) }) });
    var urgent308 = new Ext.form.Checkbox({ "boxLabel": "professionelle Eingliederung", "listeners": { "render": Lino.quicktip_renderer("professionelle Eingliederung","Ankreuzen, wenn der Kurs f\u00fcr die Arbeitssuche ben\u00f6tigt wird.") }, "hideLabel": true, "checked": false, "name": "urgent", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel309 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_submitted304, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": person305, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content306, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": offer307, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": urgent308, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 261, "border": false, "labelAlign": "top" });
    var course315 = new Lino.TwinCombo({ "fieldLabel": "Kurs gefunden", "name": "course", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail_action)}, "emptyText": "Kurs ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/CourseRequests/course", "method": "GET" }) }) });
    var state316 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Status", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Kandidat" ], [ "20", "Eingetragen" ], [ "30", "Bestanden" ], [ "40", "Gut bestanden" ], [ "50", "Nicht bestanden" ], [ "60", "Abgebrochen" ] ], "name": "state" });
    var date_ended317 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beendet am", "anchor": "-20", "name": "date_ended" });
    var id318 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var main_2_panel319 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course315, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state316, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_ended317, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id318, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var remark324 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var UploadsByController_htmlbox325 = new Lino.HtmlBoxPanel({ "flex": 33, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var main_3_panel326 = new Ext.Panel({ "flex": 71, "layout": "hbox", "items": [ { "items": remark324, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, UploadsByController_htmlbox325 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var main_panel328 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel309, main_2_panel319, main_3_panel326 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel328;
    this.before_row_edit = function(record) {
      offer307.setContextValue('content',record ? record.data['contentHidden'] : undefined);
      UploadsByController_htmlbox325.refresh();
    }
    this.onRender = function(ct, position) {
      content306.on('change',Lino.chooser_handler(offer307,'content'));
      Lino.courses.PendingCourseRequests.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.PendingCourseRequests.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    offer307.on("change",function(){this.save()},this);
  }
});


Lino.outbox.MyOutbox.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var subject415 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Thema", "anchor": "-20", "name": "subject" });
    var project416 = new Lino.TwinCombo({ "fieldLabel": "Klient", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pcsw.Clients.detail_action)}, "emptyText": "Klient ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date417 = new Lino.DateField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Datum","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "anchor": "-20", "name": "date" });
    var main_1_panel418 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject415, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project416, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date417, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var user422 = new Lino.TwinCombo({ "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent423 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id424 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var owner_disp425 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel426 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user422, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent423, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id424, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp425, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var RecipientsByMail_grid437 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.default_action) ], "master_panel": this });
    var AttachmentsByMail_htmlbox438 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.default_action) ] });
    var UploadsByController_htmlbox439 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var main_3_panel440 = new Ext.Panel({ "flex": 26, "layout": "hbox", "items": [ RecipientsByMail_grid437, AttachmentsByMail_htmlbox438, UploadsByController_htmlbox439 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var body441 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 52, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel442 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "items": [ main_1_panel418, main_2_panel426, main_3_panel440, body441 ], "autoScroll": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel442;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid437.on_master_changed();
      AttachmentsByMail_htmlbox438.refresh();
      UploadsByController_htmlbox439.refresh();
      body441.refresh();
    }
    Lino.outbox.MyOutbox.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var id2867 = new Ext.form.TextField({ "fieldLabel": "id", "name": "id", "maxLength": 3, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "anchor": "-20", "allowBlank": false });
    var iso22868 = new Ext.form.TextField({ "fieldLabel": "iso2", "name": "iso2", "maxLength": 2, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "anchor": "-20" });
    var name2869 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr2870 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_en2871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel2872 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2867, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": iso22868, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2869, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2870, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en2871, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var cv_KnowledgesByLanguage_grid2884 = new Lino.cv.KnowledgesByLanguage.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.cv.KnowledgesByLanguage.default_action) ], "master_panel": this });
    var main_panel2885 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2872, cv_KnowledgesByLanguage_grid2884 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2885;
    this.before_row_edit = function(record) {
      cv_KnowledgesByLanguage_grid2884.on_master_changed();
    }
    Lino.countries.Languages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.PersonSearches.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 80,
  initComponent : function() {
    var containing_panel = this;
    var id2886 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "id" };
    var title2887 = new Ext.form.TextField({ "fieldLabel": "Titel Suchliste", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel2888 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2886, "labelAlign": "top" }, { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title2887, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var only_my_persons2891 = new Ext.form.Checkbox({ "boxLabel": "Only my clients", "hideLabel": true, "checked": false, "name": "only_my_persons", "selectOnFocus": true, "anchor": "-20" });
    var coached_by2892 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/PersonSearches/coached_by", "method": "GET" }) }) });
    var period_from2893 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Periode vom", "anchor": "-20", "name": "period_from" });
    var period_until2894 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "bis", "anchor": "-20", "name": "period_until" });
    var aged_from2895 = { "fieldLabel": "Alter von", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "aged_from" };
    var aged_to2896 = { "fieldLabel": "Alter bis", "xtype": "numberfield", "selectOnFocus": true, "anchor": "-20", "name": "aged_to" };
    var gender2897 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ], "hiddenName": "genderHidden" });
    var main_2_panel2898 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_my_persons2891, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by2892, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": period_from2893, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": period_until2894, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_from2895, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": aged_to2896, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender2897, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var pcsw_LanguageKnowledgesBySearch_grid2911 = new Lino.pcsw.LanguageKnowledgesBySearch.GridPanel({ "flex": 30, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.LanguageKnowledgesBySearch.default_action) ], "master_panel": this });
    var pcsw_WantedPropsBySearch_grid2917 = new Lino.pcsw.WantedPropsBySearch.GridPanel({ "flex": 34, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.WantedPropsBySearch.default_action) ], "master_panel": this });
    var pcsw_UnwantedPropsBySearch_grid2923 = new Lino.pcsw.UnwantedPropsBySearch.GridPanel({ "flex": 34, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.UnwantedPropsBySearch.default_action) ], "master_panel": this });
    var main_3_panel2924 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ pcsw_LanguageKnowledgesBySearch_grid2911, pcsw_WantedPropsBySearch_grid2917, pcsw_UnwantedPropsBySearch_grid2923 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var pcsw_ClientsBySearch_grid2956 = new Lino.pcsw.ClientsBySearch.GridPanel({ "flex": 41, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." }, "tools": [ Lino.show_in_own_window_button(Lino.pcsw.ClientsBySearch.default_action) ], "master_panel": this, "containing_panel": this });
    var main_panel2957 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel2888, main_2_panel2898, main_3_panel2924, pcsw_ClientsBySearch_grid2956 ], "autoScroll": true, "border": false, "labelAlign": "top" });
    this.items = main_panel2957;
    this.before_row_edit = function(record) {
      pcsw_LanguageKnowledgesBySearch_grid2911.on_master_changed();
      pcsw_WantedPropsBySearch_grid2917.on_master_changed();
      pcsw_UnwantedPropsBySearch_grid2923.on_master_changed();
      pcsw_ClientsBySearch_grid2956.on_master_changed();
    }
    Lino.pcsw.PersonSearches.DetailFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.ContentTypesHandle
Lino.lino.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/ContentTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Inhaltstypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    var ww = this.containing_window;
    var id2993 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name2994 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label2995 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model2996 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id2993, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name2994 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "app_label", "hidden": false, "editor": app_label2995 }, { "colIndex": 3, "sortable": true, "header": "Python Modell-Klassenname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "model", "hidden": false, "editor": model2996 } ];
    Lino.lino.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.insert_actionPanel = Ext.extend(Lino.lino.ContentTypes.DetailFormPanel,{
  empty_title: "Neu Inhaltstypen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    Lino.lino.ContentTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.lino.ContentTypes.insert_actionPanel(p);
});

Lino.lino.ContentTypes.detail_actionPanel = Ext.extend(Lino.lino.ContentTypes.DetailFormPanel,{
  empty_title: "Detail Inhaltstypen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    Lino.lino.ContentTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ContentTypes.detail_actionPanel(p);
});
Lino.lino.ContentTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.HelpTextsHandle
Lino.lino.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/HelpTexts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" },'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field3002 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name3003 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text3004 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id3005 = { "selectOnFocus": true, "xtype": "numberfield" };
    var content_type3006 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      field3002.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type3006.on('change',Lino.chooser_handler(field3002,'content_type'));
      Lino.lino.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "field", "hidden": false, "editor": field3002 }, { "colIndex": 1, "sortable": false, "header": "Feldbezeichnung", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "verbose_name", "hidden": false }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text3004, "dataIndex": "help_text" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3005, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Modell", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('content_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": content_type3006, "dataIndex": "content_type" } ];
    Lino.lino.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.HelpTexts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIlino.TextFieldTemplatesHandle
Lino.lino.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/lino/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "name" }, { "name": "description" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    var ww = this.containing_window;
    var id3013 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user3014 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var name3015 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description3016 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var text3017 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Vorlagentext" });
    this.before_row_edit = function(record) {
      description3016.refresh();
      text3017.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3013, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3014 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3015 }, { "colIndex": 3, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3016, "dataIndex": "description" }, { "colIndex": 4, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": text3017, "dataIndex": "text" } ];
    Lino.lino.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.TextFieldTemplates.insert_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Neu Einf\u00fcgetexte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    Lino.lino.TextFieldTemplates.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.TextFieldTemplates.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.lino.TextFieldTemplates.insert_actionPanel(p);
});

Lino.lino.TextFieldTemplates.detail_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Einf\u00fcgetexte",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    Lino.lino.TextFieldTemplates.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.TextFieldTemplates.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.TextFieldTemplates.detail_actionPanel(p);
});
Lino.lino.TextFieldTemplates.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIusers.MySettingsHandle
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" },'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" },'languageHidden', { "name": "partner" },'partnerHidden', { "name": "access_class" },'access_classHidden', { "name": "calendar" },'calendarHidden', { "type": "int", "name": "newcomer_quota" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    var ww = this.containing_window;
    var username3053 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile3054 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "100", "100 (Integration Agent)" ], [ "110", "110 (Integration Agent (Senior))" ], [ "200", "200 (Newcomers consultant)" ], [ "300", "300 (Debts consultant)" ], [ "400", "400 (Readonly User)" ], [ "500", "500 (CBSS only)" ], [ "900", "900 (Administrator)" ] ] });
    var first_name3055 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name3056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id3057 = { "selectOnFocus": true, "xtype": "numberfield" };
    var created3058 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3059 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var email3060 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks3061 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language3062 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var partner3063 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "partner ausw\u00e4hlen..." });
    var access_class3064 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ] });
    var calendar3065 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var newcomer_quota3066 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "username", "hidden": false, "editor": username3053 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(32), "dataIndex": "profile", "hidden": false, "editor": profile3054 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "hidden": false, "editor": first_name3055 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "hidden": false, "editor": last_name3056 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3057, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email3060 }, { "colIndex": 8, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3061, "dataIndex": "remarks" }, { "colIndex": 9, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3062 }, { "colIndex": 10, "sortable": true, "header": "partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner3063, "dataIndex": "partner" }, { "colIndex": 11, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(31), "dataIndex": "access_class", "hidden": false, "editor": access_class3064 }, { "colIndex": 12, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar3065 }, { "colIndex": 13, "sortable": true, "header": "Quote NZ", "editable": true, "tooltip": "Relative number expressing \n          how many Newcomer requests this User is able to treat.", "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "newcomer_quota", "hidden": false, "editor": newcomer_quota3066 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detail_actionPanel = Ext.extend(Lino.users.MySettings.DetailFormPanel,{
  empty_title: "Detail",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    Lino.users.MySettings.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detail_actionPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.LanguagesHandle
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Sprachen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail_action;
    this.ls_insert_handler = Lino.countries.Languages.insert_action;
    var ww = this.containing_window;
    var name3089 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3090 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3091 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3092 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso23093 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3089 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3090 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3091 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "id", "hidden": false, "editor": id3092 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "iso2", "hidden": false, "editor": iso23093 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Languages.insert_actionPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Neu Sprachen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Languages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail_action;
    this.ls_insert_handler = Lino.countries.Languages.insert_action;
    Lino.countries.Languages.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Languages.insert_actionPanel(p);
});

Lino.countries.Languages.detail_actionPanel = Ext.extend(Lino.countries.Languages.DetailFormPanel,{
  empty_title: "Detail Sprachen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Languages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Languages.detail_action;
    this.ls_insert_handler = Lino.countries.Languages.insert_action;
    Lino.countries.Languages.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.detail_actionPanel(p);
});
Lino.countries.Languages.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CountriesHandle
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    var ww = this.containing_window;
    var name3100 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3101 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3102 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode3103 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code3104 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso33105 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    var inscode3106 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3100 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3101 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3102 }, { "colIndex": 3, "sortable": true, "header": "isocode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "isocode", "hidden": false, "editor": isocode3103 }, { "colIndex": 4, "sortable": true, "header": "short code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "short_code", "hidden": false, "editor": short_code3104 }, { "colIndex": 5, "sortable": true, "header": "iso3", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "iso3", "hidden": false, "editor": iso33105 }, { "colIndex": 6, "sortable": true, "header": "INS-Code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "inscode", "hidden": false, "editor": inscode3106 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insert_actionPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    Lino.countries.Countries.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insert_actionPanel(p);
});

Lino.countries.Countries.detail_actionPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    Lino.countries.Countries.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detail_actionPanel(p);
});
Lino.countries.Countries.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcountries.CitiesHandle
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" },'countryHidden', { "name": "name" }, { "name": "type" },'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" },'parentHidden', { "name": "inscode" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    var ww = this.containing_window;
    var country3115 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var name3116 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type3117 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code3118 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id3119 = { "selectOnFocus": true, "xtype": "numberfield" };
    var parent3120 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var inscode3121 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(5), "maxLength": 5 });
    this.before_row_edit = function(record) {
      type3117.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3115.on('change',Lino.chooser_handler(type3117,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3115, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3116 }, { "colIndex": 2, "sortable": true, "header": "Settlement Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "hidden": false, "editor": type3117 }, { "colIndex": 3, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3118 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3119, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Part of", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": parent3120, "dataIndex": "parent" }, { "colIndex": 6, "sortable": true, "header": "INS-Code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "inscode", "hidden": false, "editor": inscode3121 } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insert_actionPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    Lino.countries.Cities.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insert_actionPanel(p);
});

Lino.countries.Cities.detail_actionPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    Lino.countries.Cities.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detail_actionPanel(p);
});
Lino.countries.Cities.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropGroupsHandle
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Eigenschaftsgruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    var ww = this.containing_window;
    var id3130 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3131 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3132 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3130, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3131 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3132 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3133 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.insert_actionPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Neu Eigenschaftsgruppen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    Lino.properties.PropGroups.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insert_actionPanel(p);
});

Lino.properties.PropGroups.detail_actionPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Detail Eigenschaftsgruppen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    Lino.properties.PropGroups.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detail_actionPanel(p);
});
Lino.properties.PropGroups.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropTypesHandle
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Eigenschafts-Datentypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "choicelist" },'choicelistHidden', { "name": "default_value" },'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    var ww = this.containing_window;
    var id3139 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3140 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3141 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3142 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist3143 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "CityTypes", "Settlement Type" ], [ "DoYouLike", "blo\u00df nicht ... sehr gerne" ], [ "Gender", "Geschlecht" ], [ "HowWell", "gar nicht ... sehr gut" ], [ "UserGroups", "Benutzergruppe" ], [ "UserLevels", "Benutzer-Level" ], [ "UserProfiles", "Benutzerprofil" ] ] });
    var default_value3144 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices3145 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices3146 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value3144.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist3143.on('change',Lino.chooser_handler(default_value3144,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3139, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3140 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3141 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3142 }, { "colIndex": 4, "sortable": true, "header": "Auswahliste", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "choicelist", "hidden": false, "editor": choicelist3143 }, { "colIndex": 5, "sortable": true, "header": "Standardwert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "default_value", "hidden": false, "editor": default_value3144 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Beschr\u00e4nken auf Auswahl", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "limit_to_choices", "hidden": false }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Mehrfachauswahl", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "multiple_choices", "hidden": false } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.insert_actionPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Neu Eigenschafts-Datentypen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    Lino.properties.PropTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insert_actionPanel(p);
});

Lino.properties.PropTypes.detail_actionPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Detail Eigenschafts-Datentypen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    Lino.properties.PropTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detail_actionPanel(p);
});
Lino.properties.PropTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropertiesHandle
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "group" },'groupHidden', { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail_action;
    this.ls_insert_handler = Lino.properties.Properties.insert_action;
    var ww = this.containing_window;
    var id3156 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3157 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group3160 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    var type3161 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3156, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3157 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3158 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3159 }, { "colIndex": 4, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail_action'), "hidden": false, "editor": group3160, "dataIndex": "group" }, { "colIndex": 5, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type3161, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.Properties.insert_actionPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Neu Eigenschaften",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/Properties",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail_action;
    this.ls_insert_handler = Lino.properties.Properties.insert_action;
    Lino.properties.Properties.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.Properties.insert_actionPanel(p);
});

Lino.properties.Properties.detail_actionPanel = Ext.extend(Lino.properties.Properties.DetailFormPanel,{
  empty_title: "Detail Eigenschaften",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/Properties",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.Properties.detail_action;
    this.ls_insert_handler = Lino.properties.Properties.insert_action;
    Lino.properties.Properties.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.detail_actionPanel(p);
});
Lino.properties.Properties.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIproperties.PropChoicesHandle
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" },'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id3169 = { "selectOnFocus": true, "xtype": "numberfield" };
    var type3170 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value3171 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text3172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr3173 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_en3174 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3169, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type3170, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "value", "hidden": false, "editor": value3171 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text", "hidden": false, "editor": text3172 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text_fr", "hidden": false, "editor": text_fr3173 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "text_en", "hidden": false, "editor": text_en3174 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.PartnersHandle
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    var ww = this.containing_window;
    var name3197 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3198 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3199 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3200 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3201 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3202 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3203 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3204 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3207 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3208 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3209 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3211 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url3212 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3213 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3214 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3216 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated3217 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3218 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13219 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23220 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id3221 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city3202.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3202.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3203.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3201.on('change',Lino.chooser_handler(city3202,'country'));
      region3203.on('change',Lino.chooser_handler(city3202,'region'));
      country3201.on('change',Lino.chooser_handler(region3203,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3197 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email3198 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3201, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city3202, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region3203, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3204 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr13205 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix3206 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street3207 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no3208 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box3209 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr23210 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3211 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url3212 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone3213 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm3214 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax3215 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3216, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity3218 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account13219 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account23220 }, { "colIndex": 24, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3221, "dataIndex": "id" } ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    Lino.contacts.Partners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insert_actionPanel(p);
});

Lino.contacts.Partners.detail_actionPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    Lino.contacts.Partners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detail_actionPanel(p);
});
Lino.contacts.Partners.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.PersonsHandle
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Personen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" },'languageHidden', { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "birth_date" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "title" }, { "name": "gender" },'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    var ww = this.containing_window;
    var name_column_disp3248 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp3249 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email3250 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone3251 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3252 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3253 = { "selectOnFocus": true, "xtype": "numberfield" };
    var language3254 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var created3255 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3256 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3257 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3258 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3259 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3260 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name3261 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr13262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3263 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3265 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3266 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23267 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url3268 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3269 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3270 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated3271 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3272 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13273 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23274 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var birth_date3275 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var first_name3276 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name3277 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title3278 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender3279 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ] });
    this.before_row_edit = function(record) {
      city3258.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3258.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3259.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3257.on('change',Lino.chooser_handler(city3258,'country'));
      region3259.on('change',Lino.chooser_handler(city3258,'region'));
      country3257.on('change',Lino.chooser_handler(region3259,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "hidden": false, "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email3250 }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone3251 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm3252 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3253, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language3254 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3257, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city3258, "dataIndex": "city" }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region3259, "dataIndex": "region" }, { "colIndex": 12, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3260 }, { "colIndex": 13, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3261 }, { "colIndex": 14, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr13262 }, { "colIndex": 15, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix3263 }, { "colIndex": 16, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street3264 }, { "colIndex": 17, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no3265 }, { "colIndex": 18, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box3266 }, { "colIndex": 19, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr23267 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url3268 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax3269 }, { "colIndex": 22, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3270, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 24, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity3272 }, { "colIndex": 25, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account13273 }, { "colIndex": 26, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account23274 }, { "colIndex": 27, "sortable": true, "header": "Geburtsdatum", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "birth_date", "hidden": false, "editor": birth_date3275 }, { "colIndex": 28, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "hidden": false, "editor": first_name3276 }, { "colIndex": 29, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "hidden": false, "editor": last_name3277 }, { "colIndex": 30, "sortable": true, "header": "Anrede", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title3278 }, { "colIndex": 31, "sortable": true, "header": "Geschlecht", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "gender", "hidden": false, "editor": gender3279 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insert_actionPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu Personen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    Lino.contacts.Persons.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insert_actionPanel(p);
});

Lino.contacts.Persons.detail_actionPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Personen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    Lino.contacts.Persons.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detail_actionPanel(p);
});
Lino.contacts.Persons.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIoutbox.AttachmentsHandle
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Anh\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mail" },'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id3388 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type3389 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3390 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail3391 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "E-Mail-Ausgang ausw\u00e4hlen..." });
    var owner_disp3392 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3390.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3389.on('change',Lino.chooser_handler(owner_id3390,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3388, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type3389, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id3390 }, { "colIndex": 3, "sortable": true, "header": "E-Mail-Ausgang", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "mail", "hidden": false, "editor": mail3391 }, { "width": Lino.chars2width(30), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PlacesHandle
Lino.cal.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Places",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail_action;
    this.ls_insert_handler = Lino.cal.Places.insert_action;
    var ww = this.containing_window;
    var id3450 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3451 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3452 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3453 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3450, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3451 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3452 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3453 } ];
    Lino.cal.Places.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.insert_actionPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail_action;
    this.ls_insert_handler = Lino.cal.Places.insert_action;
    Lino.cal.Places.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Places.insert_actionPanel(p);
});

Lino.cal.Places.detail_actionPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail_action;
    this.ls_insert_handler = Lino.cal.Places.insert_action;
    Lino.cal.Places.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.detail_actionPanel(p);
});
Lino.cal.Places.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PrioritiesHandle
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Priorit\u00e4ten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name3459 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3460 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3461 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3462 = { "selectOnFocus": true, "xtype": "numberfield" };
    var ref3463 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3459 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3460 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3461 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3462, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "hidden": false, "editor": ref3463 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.TasksHandle
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Aufgaben",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "start_time" }, { "name": "uid" }, { "name": "description" }, { "name": "calendar" },'calendarHidden', { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    var ww = this.containing_window;
    var start_date3621 = new Lino.DateField({ "selectOnFocus": true });
    var summary3622 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state3623 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "40", "Schl\u00e4ft" ], [ "50", "Storniert" ] ] });
    var id3624 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type3625 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user3627 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created3628 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3629 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project3630 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var start_time3631 = new Lino.TimeField({ "selectOnFocus": true });
    var uid3632 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description3633 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var calendar3634 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class3635 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ] });
    var sequence3636 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type3637 = { "disabled": true, "xtype": "numberfield" };
    var due_date3638 = new Lino.DateField({ "selectOnFocus": true });
    var due_time3639 = new Lino.TimeField({ "selectOnFocus": true });
    var percent3640 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_disp3641 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3626.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description3633.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type3625.on('change',Lino.chooser_handler(owner_id3626,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date3621 }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "summary", "hidden": false, "editor": summary3622 }, { "colIndex": 2, "sortable": true, "header": "Status", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "state", "hidden": false, "editor": state3623 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3624, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type3625, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id3626 }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3627 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail_action'), "hidden": false, "editor": project3630, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Beginnt um", "editable": true, "width": Lino.chars2width(8), "dataIndex": "start_time", "hidden": false, "editor": start_time3631 }, { "colIndex": 11, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "uid", "hidden": false, "editor": uid3632 }, { "colIndex": 12, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3633, "dataIndex": "description" }, { "colIndex": 13, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar3634 }, { "colIndex": 14, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(31), "dataIndex": "access_class", "hidden": false, "editor": access_class3635 }, { "colIndex": 15, "sortable": true, "header": "Revisionsnummer", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "sequence", "hidden": false, "editor": sequence3636 }, { "colIndex": 16, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "auto_type", "hidden": false }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "F\u00e4llig am", "dataIndex": "due_date", "hidden": false, "width": Lino.chars2width(8), "editor": due_date3638 }, { "colIndex": 18, "sortable": true, "header": "F\u00e4llig um", "editable": true, "width": Lino.chars2width(8), "dataIndex": "due_time", "hidden": false, "editor": due_time3639 }, { "colIndex": 19, "sortable": true, "header": "Dauer (Anzahl)", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "percent", "hidden": false, "editor": percent3640 }, { "width": Lino.chars2width(30), "colIndex": 20, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.mark_10 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_10");
};
Lino.cal.Tasks.mark_20 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_20");
};
Lino.cal.Tasks.mark_30 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_30");
};
Lino.cal.Tasks.mark_40 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_40");
};
Lino.cal.Tasks.mark_50 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"mark_50");
};

Lino.cal.Tasks.insert_actionPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu Aufgaben",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    Lino.cal.Tasks.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insert_actionPanel(p);
});

Lino.cal.Tasks.detail_actionPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail Aufgaben",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    Lino.cal.Tasks.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detail_actionPanel(p);
});
Lino.cal.Tasks.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.GuestRolesHandle
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Gastrollen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    var ww = this.containing_window;
    var id3664 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3665 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3666 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3667 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method3668 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3669 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var attach_to_email3670 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template3671 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template3669.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method3668.on('change',Lino.chooser_handler(template3669,'build_method'));
      Lino.cal.GuestRoles.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3664, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3665 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3666 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3667 }, { "colIndex": 4, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "build_method", "hidden": false, "editor": build_method3668 }, { "colIndex": 5, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "template", "hidden": false, "editor": template3669 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "email_template", "hidden": false, "editor": email_template3671 } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.insert_actionPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Neu Gastrollen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    Lino.cal.GuestRoles.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestRoles.insert_actionPanel(p);
});

Lino.cal.GuestRoles.detail_actionPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Detail Gastrollen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    Lino.cal.GuestRoles.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.detail_actionPanel(p);
});
Lino.cal.GuestRoles.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.GuestsHandle
Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_mail", "text": "per E-Mail", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "G\u00e4ste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" },'partnerHidden', { "name": "role" },'roleHidden', { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" },'eventHidden', { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var partner3681 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "partner ausw\u00e4hlen..." });
    var role3682 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var state3683 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ] });
    var workflow_buttons_disp3684 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark3685 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event3686 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var id3687 = { "selectOnFocus": true, "xtype": "numberfield" };
    var build_time3688 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner3681, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "Rolle", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail_action'), "hidden": false, "editor": role3682, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Status", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "state", "hidden": false, "editor": state3683 }, { "width": Lino.chars2width(30), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "remark", "hidden": false, "editor": remark3685 }, { "colIndex": 5, "sortable": true, "header": "Termin", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "event", "hidden": false, "editor": event3686 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3687, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.mark_10 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_10");
};
Lino.cal.Guests.mark_20 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_20");
};
Lino.cal.Guests.mark_30 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_30");
};
Lino.cal.Guests.mark_40 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_40");
};
Lino.cal.Guests.mark_50 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"mark_50");
};
Lino.cal.Guests.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Guests",pk,"duplicate_row");
};
Lino.cal.Guests.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Guests.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PanelCalendarsHandle
Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "babel_name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    var ww = this.containing_window;
    var id3698 = { "selectOnFocus": true, "xtype": "numberfield" };
    var babel_name_disp3699 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description3700 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var color3701 = { "selectOnFocus": true, "xtype": "numberfield", "value": 1, "allowBlank": false };
    var is_hidden_disp3702 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description3700.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3698, "dataIndex": "id" }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "babel_name", "header": "babel_name", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3700, "dataIndex": "description" }, { "colIndex": 3, "sortable": true, "header": "Farbe", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "color", "hidden": false, "editor": color3701 }, { "width": Lino.chars2width(20), "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "header": "versteckt", "hidden": false, "editable": false } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.insert_actionPanel = Ext.extend(Lino.cal.PanelCalendars.InsertFormPanel,{
  empty_title: "Neu Kalenderliste",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    Lino.cal.PanelCalendars.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelCalendars.insert_actionPanel(p);
});

Lino.cal.PanelCalendars.detail_actionPanel = Ext.extend(Lino.cal.PanelCalendars.DetailFormPanel,{
  empty_title: "Detail Kalenderliste",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    Lino.cal.PanelCalendars.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.detail_actionPanel(p);
});
Lino.cal.PanelCalendars.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcal.PanelEventsHandle
Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "per Post", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "per E-Mail", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Termine",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" },'userHidden', { "name": "place" },'placeHidden', { "name": "calendar" },'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    var ww = this.containing_window;
    var id3709 = { "selectOnFocus": true, "xtype": "numberfield" };
    var start_dt3710 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_dt3711 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var summary3712 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var description3713 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var user3714 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var place3715 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var calendar3716 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var url_disp3717 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day3718 = new Ext.form.Checkbox({ "disabled": true });
    var reminder_disp3719 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description3713.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3709, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 1, "sortable": false, "dataIndex": "start_dt", "header": "Beginn", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": false, "dataIndex": "end_dt", "header": "Ende", "hidden": false, "editable": false }, { "colIndex": 3, "sortable": false, "header": "Kurzbeschreibung", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "summary", "hidden": false }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": description3713, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3714 }, { "colIndex": 6, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail_action'), "hidden": false, "editor": place3715, "dataIndex": "place" }, { "colIndex": 7, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "calendar", "hidden": false, "editor": calendar3716 }, { "width": Lino.chars2width(30), "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(10), "editable": false, "filter": { "type": "boolean" }, "header": "ganztags", "dataIndex": "all_day", "hidden": false }, { "width": Lino.chars2width(30), "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Erinnerung", "hidden": false, "editable": false } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.mark_10 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_10");
};
Lino.cal.PanelEvents.mark_20 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_20");
};
Lino.cal.PanelEvents.mark_30 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_30");
};
Lino.cal.PanelEvents.mark_40 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_40");
};
Lino.cal.PanelEvents.mark_50 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_50");
};
Lino.cal.PanelEvents.mark_60 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_60");
};
Lino.cal.PanelEvents.mark_70 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_70");
};
Lino.cal.PanelEvents.mark_80 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_80");
};
Lino.cal.PanelEvents.mark_90 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"mark_90");
};

Lino.cal.PanelEvents.insert_actionPanel = Ext.extend(Lino.cal.PanelEvents.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    Lino.cal.PanelEvents.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelEvents.insert_actionPanel(p);
});
Lino.cal.PanelEvents.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/PanelEvents",pk,"duplicate_row");
};

Lino.cal.PanelEvents.detail_actionPanel = Ext.extend(Lino.cal.PanelEvents.DetailFormPanel,{
  empty_title: "Detail Termine",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "per Post", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "per E-Mail", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    Lino.cal.PanelEvents.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.detail_actionPanel(p);
});
Lino.cal.PanelEvents.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadTypesHandle
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Upload-Arten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var name3732 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id3733 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3732 }, { "colIndex": 1, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3733, "dataIndex": "id" } ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIuploads.UploadsHandle
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mimetype" }, { "name": "type" },'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    var ww = this.containing_window;
    var file3737 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user3738 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created3739 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3740 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var id3741 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type3742 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id3743 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype3744 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type3745 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen..." });
    var valid_until3746 = new Lino.DateField({ "selectOnFocus": true });
    var description3747 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp3748 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id3743.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type3742.on('change',Lino.chooser_handler(owner_id3743,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Datei", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "file", "hidden": false, "editor": file3737 }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3738 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3741, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type3742, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "owner_id", "hidden": false, "editor": owner_id3743 }, { "colIndex": 7, "sortable": true, "header": "MIME-Art", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "mimetype", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Upload-Art", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type3745 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "g\u00fcltig bis", "dataIndex": "valid_until", "hidden": false, "width": Lino.chars2width(8), "editor": valid_until3746 }, { "colIndex": 10, "sortable": true, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "description", "hidden": false, "editor": description3747 }, { "width": Lino.chars2width(30), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": false, "editable": false } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.insert_actionPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "Neu Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    Lino.uploads.Uploads.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insert_actionPanel(p);
});

Lino.uploads.Uploads.detail_actionPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    Lino.uploads.Uploads.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detail_actionPanel(p);
});
Lino.uploads.Uploads.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.TypesHandle
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Haushaltsarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail_action;
    this.ls_insert_handler = Lino.households.Types.insert_action;
    var ww = this.containing_window;
    var id3762 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3763 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3764 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3765 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3762, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3763 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3764 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3765 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.insert_actionPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Neu Haushaltsarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail_action;
    this.ls_insert_handler = Lino.households.Types.insert_action;
    Lino.households.Types.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insert_actionPanel(p);
});

Lino.households.Types.detail_actionPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Haushaltsarten",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail_action;
    this.ls_insert_handler = Lino.households.Types.insert_action;
    Lino.households.Types.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detail_actionPanel(p);
});
Lino.households.Types.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.HouseholdsHandle
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail_action;
    this.ls_insert_handler = Lino.households.Households.insert_action;
    var ww = this.containing_window;
    var name3771 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email3772 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created3773 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified3774 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country3775 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city3776 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region3777 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code3778 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr13779 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix3780 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street3781 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no3782 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box3783 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr23784 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language3785 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url3786 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone3787 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm3788 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax3789 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks3790 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated3791 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity3792 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account13793 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account23794 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix3795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type3796 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Haushaltsart ausw\u00e4hlen..." });
    var id3797 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city3776.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city3776.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region3777.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country3775.on('change',Lino.chooser_handler(city3776,'country'));
      region3777.on('change',Lino.chooser_handler(city3776,'region'));
      country3775.on('change',Lino.chooser_handler(region3777,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3771 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email3772 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country3775, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city3776, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region3777, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code3778 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr13779 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix3780 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street3781 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no3782 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box3783 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr23784 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3785 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url3786 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone3787 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm3788 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax3789 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks3790, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity3792 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account13793 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account23794 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "hidden": false, "editor": prefix3795 }, { "colIndex": 25, "sortable": true, "header": "Haushaltsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail_action'), "hidden": false, "editor": type3796, "dataIndex": "type" }, { "colIndex": 26, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3797, "dataIndex": "id" } ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Haushalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail_action;
    this.ls_insert_handler = Lino.households.Households.insert_action;
    Lino.households.Households.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insert_actionPanel(p);
});

Lino.households.Households.detail_actionPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Haushalte",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail_action;
    this.ls_insert_handler = Lino.households.Households.insert_action;
    Lino.households.Households.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detail_actionPanel(p);
});
Lino.households.Households.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.RolesHandle
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Rollen in Haushalt",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail_action;
    this.ls_insert_handler = Lino.households.Roles.insert_action;
    var ww = this.containing_window;
    var id3826 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3827 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3828 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3829 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving3830 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3826, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3827 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3828 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3829 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "namensgebend", "editable": true, "tooltip": "When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "name_giving", "hidden": false } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.insert_actionPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Neu Rollen in Haushalt",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail_action;
    this.ls_insert_handler = Lino.households.Roles.insert_action;
    Lino.households.Roles.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insert_actionPanel(p);
});

Lino.households.Roles.detail_actionPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Rollen in Haushalt",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail_action;
    this.ls_insert_handler = Lino.households.Roles.insert_action;
    Lino.households.Roles.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detail_actionPanel(p);
});
Lino.households.Roles.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIhouseholds.MembersHandle
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" },'roleHidden', { "name": "household" },'householdHidden', { "name": "person" },'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id3837 = { "selectOnFocus": true, "xtype": "numberfield" };
    var role3838 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var household3839 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var person3840 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var start_date3841 = new Lino.DateField({ "selectOnFocus": true });
    var end_date3842 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3837, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "header": "Rolle in Haushalt", "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail_action'), "hidden": false, "editor": role3838, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Haushalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail_action'), "hidden": false, "editor": household3839, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail_action'), "hidden": false, "editor": person3840, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "hidden": false, "width": Lino.chars2width(8), "editor": start_date3841 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "hidden": false, "width": Lino.chars2width(8), "editor": end_date3842 } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.ChartsHandle
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Kontenpl\u00e4ne",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail_action;
    this.ls_insert_handler = Lino.accounts.Charts.insert_action;
    var ww = this.containing_window;
    var id3850 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3851 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3852 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3850, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3851 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3852 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3853 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insert_actionPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Neu Kontenpl\u00e4ne",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail_action;
    this.ls_insert_handler = Lino.accounts.Charts.insert_action;
    Lino.accounts.Charts.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insert_actionPanel(p);
});

Lino.accounts.Charts.detail_actionPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Kontenpl\u00e4ne",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail_action;
    this.ls_insert_handler = Lino.accounts.Charts.insert_action;
    Lino.accounts.Charts.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detail_actionPanel(p);
});
Lino.accounts.Charts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.GroupsHandle
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Kontengruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" },'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "account_type" },'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail_action;
    this.ls_insert_handler = Lino.accounts.Groups.insert_action;
    var ww = this.containing_window;
    var chart3859 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var ref3860 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var name3861 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3862 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3863 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type3864 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ] ] });
    var id3865 = { "selectOnFocus": true, "xtype": "numberfield" };
    var help_text3866 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    this.before_row_edit = function(record) {
      help_text3866.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail_action'), "hidden": false, "editor": chart3859, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "hidden": false, "editor": ref3860 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3861 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3862 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3863 }, { "colIndex": 5, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "account_type", "hidden": false, "editor": account_type3864 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3865, "dataIndex": "id" }, { "colIndex": 7, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text3866, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insert_actionPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Neu Kontengruppen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail_action;
    this.ls_insert_handler = Lino.accounts.Groups.insert_action;
    Lino.accounts.Groups.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insert_actionPanel(p);
});

Lino.accounts.Groups.detail_actionPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Kontengruppen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail_action;
    this.ls_insert_handler = Lino.accounts.Groups.insert_action;
    Lino.accounts.Groups.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detail_actionPanel(p);
});
Lino.accounts.Groups.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIaccounts.AccountsHandle
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "seqno" }, { "name": "chart" },'chartHidden', { "name": "group" },'groupHidden', { "name": "ref" }, { "name": "type" },'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "required_for_household" }, { "type": "boolean", "name": "required_for_person" }, { "type": "float", "name": "periods" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var id3876 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name3877 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3878 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3879 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var seqno3880 = { "selectOnFocus": true, "xtype": "numberfield" };
    var chart3881 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var group3882 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontengruppe ausw\u00e4hlen..." });
    var ref3883 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var type3884 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ] ] });
    var help_text3885 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    var required_for_household3886 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var required_for_person3887 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var periods3888 = { "xtype": "numberfield", "allowDecimals": false, "selectOnFocus": true, "value": 1, "allowBlank": false };
    this.before_row_edit = function(record) {
      help_text3885.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3876, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3877 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3878 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3879 }, { "colIndex": 4, "sortable": true, "header": "Seq.-Nr.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "seqno", "hidden": false, "editor": seqno3880 }, { "colIndex": 5, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail_action'), "hidden": false, "editor": chart3881, "dataIndex": "chart" }, { "colIndex": 6, "sortable": true, "header": "Kontengruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail_action'), "hidden": false, "editor": group3882, "dataIndex": "group" }, { "colIndex": 7, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "ref", "hidden": false, "editor": ref3883 }, { "colIndex": 8, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "type", "hidden": false, "editor": type3884 }, { "colIndex": 9, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": help_text3885, "dataIndex": "help_text" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Haushalte", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_household", "hidden": false }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "verpflichtend f\u00fcr Personen", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "required_for_person", "hidden": false }, { "colIndex": 12, "sortable": true, "xtype": "numbercolumn", "format": "0/i", "align": "right", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(3), "dataIndex": "periods", "header": "Perioden", "hidden": false, "editor": periods3888 } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"duplicate_row");
};

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NoteTypesHandle
Lino.notes.NoteTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/NoteTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Notizarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 88,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail_action;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert_action;
    var ww = this.containing_window;
    var name3903 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3904 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3905 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method3906 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template3907 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var id3908 = { "selectOnFocus": true, "xtype": "numberfield" };
    var attach_to_email3909 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template3910 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var important3911 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark3912 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template3907.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method3906.on('change',Lino.chooser_handler(template3907,'build_method'));
      Lino.notes.NoteTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3903 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3904 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3905 }, { "colIndex": 3, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "build_method", "hidden": false, "editor": build_method3906 }, { "colIndex": 4, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "template", "hidden": false, "editor": template3907 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3908, "dataIndex": "id" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "email_template", "hidden": false, "editor": email_template3910 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "wichtig", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "important", "hidden": false }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark3912, "dataIndex": "remark" } ];
    Lino.notes.NoteTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.insert_actionPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Neu Notizarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/notes/NoteTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail_action;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert_action;
    Lino.notes.NoteTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NoteTypes.insert_actionPanel(p);
});

Lino.notes.NoteTypes.detail_actionPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Detail Notizarten",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/notes/NoteTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail_action;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert_action;
    Lino.notes.NoteTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.detail_actionPanel(p);
});
Lino.notes.NoteTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.EventTypesHandle
Lino.notes.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/EventTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Ereignisarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "remark" }, { "name": "body" }, { "name": "body_fr" }, { "name": "body_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 86,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail_action;
    this.ls_insert_handler = Lino.notes.EventTypes.insert_action;
    var ww = this.containing_window;
    var name3924 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr3925 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en3926 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id3927 = { "selectOnFocus": true, "xtype": "numberfield" };
    var remark3928 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var body3929 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    var body_fr3930 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt (fr)" });
    var body_en3931 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt (en)" });
    this.before_row_edit = function(record) {
      body3929.refresh();
      body_fr3930.refresh();
      body_en3931.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name3924 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "hidden": false, "editor": name_fr3925 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_en", "hidden": false, "editor": name_en3926 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3927, "dataIndex": "id" }, { "colIndex": 4, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remark3928, "dataIndex": "remark" }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body3929, "dataIndex": "body" }, { "colIndex": 6, "sortable": false, "header": "body_fr", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body_fr3930, "dataIndex": "body_fr" }, { "colIndex": 7, "sortable": false, "header": "body_en", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body_en3931, "dataIndex": "body_en" } ];
    Lino.notes.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.insert_actionPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Neu Ereignisarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/notes/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail_action;
    this.ls_insert_handler = Lino.notes.EventTypes.insert_action;
    Lino.notes.EventTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.EventTypes.insert_actionPanel(p);
});

Lino.notes.EventTypes.detail_actionPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Detail Ereignisarten",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/notes/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail_action;
    this.ls_insert_handler = Lino.notes.EventTypes.insert_action;
    Lino.notes.EventTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.detail_actionPanel(p);
});
Lino.notes.EventTypes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUInotes.NotesHandle
Lino.notes.Notes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/notes/Notes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "per Post", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "per E-Mail", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Ereignisse/Notizen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "event_type" },'event_typeHidden', { "name": "type" },'typeHidden', { "name": "project" },'projectHidden', { "name": "subject" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "company" },'companyHidden', { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 87,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail_action;
    this.ls_insert_handler = Lino.notes.Notes.insert_action;
    var ww = this.containing_window;
    var id3941 = { "selectOnFocus": true, "xtype": "numberfield" };
    var date3942 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user3943 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var event_type3944 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var type3945 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Notizart ausw\u00e4hlen..." });
    var project3946 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var subject3947 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_time3948 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language3949 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ] });
    var company3950 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var body3951 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      body3951.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3941, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "hidden": false, "width": Lino.chars2width(8), "editor": date3942 }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user3943 }, { "colIndex": 3, "sortable": true, "header": "Ereignisart (Form)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail_action'), "hidden": false, "editor": event_type3944, "dataIndex": "event_type" }, { "colIndex": 4, "sortable": true, "header": "Notizart (Inhalt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail_action'), "hidden": false, "editor": type3945, "dataIndex": "type" }, { "colIndex": 5, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('projectHidden','Lino.pcsw.Clients.detail_action'), "hidden": false, "editor": project3946, "dataIndex": "project" }, { "colIndex": 6, "sortable": true, "header": "Thema", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "hidden": false, "editor": subject3947 }, { "width": Lino.chars2width(16), "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 8, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language3949 }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(20), "editable": true, "tooltip": "    An optional third-party Organization that is related to this Note.\n    The note will then be visible in that company's history panel.\n    ", "filter": { "type": "string" }, "header": "Organisation", "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company3950, "dataIndex": "company" }, { "colIndex": 10, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": body3951, "dataIndex": "body" } ];
    Lino.notes.Notes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.insert_actionPanel = Ext.extend(Lino.notes.Notes.InsertFormPanel,{
  empty_title: "Neu Ereignisse/Notizen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/notes/Notes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail_action;
    this.ls_insert_handler = Lino.notes.Notes.insert_action;
    Lino.notes.Notes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.Notes.insert_actionPanel(p);
});
Lino.notes.Notes.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/notes/Notes",pk,"duplicate_row");
};

Lino.notes.Notes.detail_actionPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Ereignisse/Notizen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "per Post", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "per E-Mail", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/notes/Notes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail_action;
    this.ls_insert_handler = Lino.notes.Notes.insert_action;
    Lino.notes.Notes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.detail_actionPanel(p);
});
Lino.notes.Notes.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcv.LanguageKnowledgesHandle
Lino.cv.LanguageKnowledges.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cv/LanguageKnowledges",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Sprachkenntnisse",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "person" },'personHidden', { "name": "language" },'languageHidden', { "name": "spoken" },'spokenHidden', { "name": "written" },'writtenHidden', { "type": "boolean", "name": "native" }, { "name": "cef_level" },'cef_levelHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var id3964 = { "selectOnFocus": true, "xtype": "numberfield" };
    var person3965 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/LanguageKnowledges/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var language3966 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/LanguageKnowledges/language", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Sprache ausw\u00e4hlen..." });
    var spoken3967 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ] });
    var written3968 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ] });
    var native3969 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var cef_level3970 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "A1", "A1 (Elementare Sprachverwendung)" ], [ "A2", "A2 (Elementare Sprachverwendung)" ], [ "A2+", "A2+ (Elementare Sprachverwendung)" ], [ "B1", "B1 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2", "B2 (Selbstst\u00e4ndige Sprachverwendung)" ], [ "B2+", "B2+ (Selbstst\u00e4ndige Sprachverwendung)" ], [ "C1", "C1 (Exzellente Sprachverwendung)" ], [ "C2", "C2 (Exzellente Sprachverwendung)" ], [ "C2+", "C2+ (Exzellente Sprachverwendung)" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3964, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail_action'), "hidden": false, "editor": person3965, "dataIndex": "person" }, { "colIndex": 2, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('languageHidden','Lino.countries.Languages.detail_action'), "hidden": false, "editor": language3966, "dataIndex": "language" }, { "colIndex": 3, "sortable": true, "header": "Wort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "spoken", "hidden": false, "editor": spoken3967 }, { "colIndex": 4, "sortable": true, "header": "Schrift", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "written", "hidden": false, "editor": written3968 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Muttersprache", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "native", "hidden": false }, { "colIndex": 6, "sortable": true, "header": "CEF-Kategorie", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(37), "dataIndex": "cef_level", "hidden": false, "editor": cef_level3970 } ];
    Lino.cv.LanguageKnowledges.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cv.LanguageKnowledges.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cv.LanguageKnowledges.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcv.PersonPropertiesHandle
Lino.cv.PersonProperties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cv/PersonProperties",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "group" },'groupHidden', { "name": "property" },'propertyHidden', { "name": "value" },'valueHidden', { "name": "person" },'personHidden', { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var id3979 = { "selectOnFocus": true, "xtype": "numberfield" };
    var group3980 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    var property3981 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/property", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaft ausw\u00e4hlen..." });
    var value3982 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/value", "method": "GET" }) }) });
    var person3983 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cv/PersonProperties/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var remark3984 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      property3981.setContextValue('group',record ? record.data['groupHidden'] : undefined);
      value3982.setContextValue('property',record ? record.data['propertyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      group3980.on('change',Lino.chooser_handler(property3981,'group'));
      property3981.on('change',Lino.chooser_handler(value3982,'property'));
      Lino.cv.PersonProperties.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id3979, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail_action'), "hidden": true, "editor": group3980, "dataIndex": "group" }, { "colIndex": 2, "sortable": true, "header": "Eigenschaft", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('propertyHidden','Lino.properties.Properties.detail_action'), "hidden": false, "editor": property3981, "dataIndex": "property" }, { "colIndex": 3, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "value", "hidden": false, "editor": value3982 }, { "colIndex": 4, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail_action'), "hidden": false, "editor": person3983, "dataIndex": "person" }, { "colIndex": 5, "sortable": true, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "remark", "hidden": false, "editor": remark3984 } ];
    Lino.cv.PersonProperties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cv.PersonProperties.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cv.PersonProperties.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIisip.ContractsHandle
Lino.isip.Contracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/isip/Contracts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "VSEs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "build_time" }, { "name": "company" },'companyHidden', { "name": "contact" },'contactHidden', { "name": "person" },'personHidden', { "name": "language" },'languageHidden', { "type": "date", "name": "date_decided", "dateFormat": "d.m.Y" }, { "type": "date", "name": "date_issued", "dateFormat": "d.m.Y" }, { "name": "user_asd" },'user_asdHidden', { "name": "exam_policy" },'exam_policyHidden', { "name": "ending" },'endingHidden', { "type": "date", "name": "date_ended", "dateFormat": "d.m.Y" }, { "name": "stages" }, { "name": "goals" }, { "name": "duties_asd" }, { "name": "duties_dsbe" }, { "name": "duties_company" }, { "name": "duties_person" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 32,
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail_action;
    this.ls_insert_handler = Lino.isip.Contracts.insert_action;
    var ww = this.containing_window;
    var id4045 = { "selectOnFocus": true, "xtype": "numberfield" };
    var applies_from4046 = new Lino.DateField({ "selectOnFocus": true });
    var applies_until4047 = new Lino.DateField({ "selectOnFocus": true });
    var user4048 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var type4049 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "VSE-Art ausw\u00e4hlen..." });
    var build_time4050 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var company4051 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var contact4052 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/contact", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kontaktperson ausw\u00e4hlen..." });
    var person4053 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Klient ausw\u00e4hlen..." });
    var language4054 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var date_decided4055 = new Lino.DateField({ "selectOnFocus": true });
    var date_issued4056 = new Lino.DateField({ "selectOnFocus": true });
    var user_asd4057 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/user_asd", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var exam_policy4058 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/exam_policy", "method": "GET" }) }), "pageSize": 20, "emptyText": "Auswertungsstrategie ausw\u00e4hlen..." });
    var ending4059 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/isip/Contracts/ending", "method": "GET" }) }), "pageSize": 20, "emptyText": "Vertragsbeendigung ausw\u00e4hlen..." });
    var date_ended4060 = new Lino.DateField({ "selectOnFocus": true });
    var stages4061 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Etappen" });
    var goals4062 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Zielsetzungen" });
    var duties_asd4063 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Verpflichtungen ASD" });
    var duties_dsbe4064 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Verpflichtungen DSBE" });
    var duties_company4065 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Verpflichtungen Firma" });
    var duties_person4066 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Verpflichtungen Person" });
    this.before_row_edit = function(record) {
      contact4052.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      stages4061.refresh();
      goals4062.refresh();
      duties_asd4063.refresh();
      duties_dsbe4064.refresh();
      duties_company4065.refresh();
      duties_person4066.refresh();
    };
    this.onRender = function(ct, position) {
      company4051.on('change',Lino.chooser_handler(contact4052,'company'));
      Lino.isip.Contracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4045, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Laufzeit von", "dataIndex": "applies_from", "hidden": false, "width": Lino.chars2width(8), "editor": applies_from4046 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Laufzeit bis", "dataIndex": "applies_until", "hidden": false, "width": Lino.chars2width(8), "editor": applies_until4047 }, { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user4048 }, { "colIndex": 4, "sortable": true, "header": "Vertragsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4049 }, { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company4051, "dataIndex": "company" }, { "colIndex": 7, "sortable": true, "header": "Vertreten durch", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "contact", "hidden": false, "editor": contact4052 }, { "colIndex": 8, "sortable": true, "header": "Klient", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.pcsw.Clients.detail_action'), "hidden": false, "editor": person4053, "dataIndex": "person" }, { "colIndex": 9, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4054 }, { "colIndex": 10, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beschlossen am", "dataIndex": "date_decided", "hidden": false, "width": Lino.chars2width(8), "editor": date_decided4055 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Ausgestellt am", "dataIndex": "date_issued", "hidden": false, "width": Lino.chars2width(8), "editor": date_issued4056 }, { "colIndex": 12, "sortable": true, "header": "Verantwortlicher (ASD)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user_asd", "hidden": false, "editor": user_asd4057 }, { "colIndex": 13, "sortable": true, "header": "Auswertungsstrategie", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "exam_policy", "hidden": false, "editor": exam_policy4058 }, { "colIndex": 14, "sortable": true, "header": "Beendigung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "ending", "hidden": false, "editor": ending4059 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beendet am", "dataIndex": "date_ended", "hidden": false, "width": Lino.chars2width(8), "editor": date_ended4060 }, { "colIndex": 16, "sortable": false, "header": "stages", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": stages4061, "dataIndex": "stages" }, { "colIndex": 17, "sortable": false, "header": "goals", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": goals4062, "dataIndex": "goals" }, { "colIndex": 18, "sortable": false, "header": "duties_asd", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_asd4063, "dataIndex": "duties_asd" }, { "colIndex": 19, "sortable": false, "header": "duties_dsbe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_dsbe4064, "dataIndex": "duties_dsbe" }, { "colIndex": 20, "sortable": false, "header": "duties_company", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_company4065, "dataIndex": "duties_company" }, { "colIndex": 21, "sortable": false, "header": "duties_person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": duties_person4066, "dataIndex": "duties_person" } ];
    Lino.isip.Contracts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.isip.Contracts.insert_actionPanel = Ext.extend(Lino.isip.Contracts.DetailFormPanel,{
  empty_title: "Neu VSEs",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/isip/Contracts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail_action;
    this.ls_insert_handler = Lino.isip.Contracts.insert_action;
    Lino.isip.Contracts.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.Contracts.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.isip.Contracts.insert_actionPanel(p);
});
Lino.isip.Contracts.duplicate_row = function(rp,pk) { 
  Lino.run_row_action(rp,"/isip/Contracts",pk,"duplicate_row");
};

Lino.isip.Contracts.detail_actionPanel = Ext.extend(Lino.isip.Contracts.DetailFormPanel,{
  empty_title: "Detail VSEs",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Cache l\u00f6schen", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplizieren", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/isip/Contracts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.isip.Contracts.detail_action;
    this.ls_insert_handler = Lino.isip.Contracts.insert_action;
    Lino.isip.Contracts.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.isip.Contracts.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.Contracts.detail_actionPanel(p);
});
Lino.isip.Contracts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.isip.Contracts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.PartnersHandle
Lino.pcsw.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Partners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Partners.detail_action;
    this.ls_insert_handler = Lino.pcsw.Partners.insert_action;
    var ww = this.containing_window;
    var name4090 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4091 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4092 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4093 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4094 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4096 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4097 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4101 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4102 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4104 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4105 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4106 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4107 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4109 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4110 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4111 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Partners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14112 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24113 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id4114 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4095.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4095.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4096.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4094.on('change',Lino.chooser_handler(city4095,'country'));
      region4096.on('change',Lino.chooser_handler(city4095,'region'));
      country4094.on('change',Lino.chooser_handler(region4096,'country'));
      Lino.pcsw.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4090 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4091 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4094, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4095, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4096, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4097 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14098 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4099 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4100 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4101 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4102 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24103 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4104 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4105 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4106 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4107 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4108 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4109, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4111 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14112 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24113 }, { "colIndex": 24, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4114, "dataIndex": "id" } ];
    Lino.pcsw.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Partners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Partners.detail_action;
    this.ls_insert_handler = Lino.pcsw.Partners.insert_action;
    Lino.pcsw.Partners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Partners.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Partners.insert_actionPanel(p);
});

Lino.pcsw.Partners.detail_actionPanel = Ext.extend(Lino.pcsw.Partners.DetailFormPanel,{
  empty_title: "Detail partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/pcsw/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Partners.detail_action;
    this.ls_insert_handler = Lino.pcsw.Partners.insert_action;
    Lino.pcsw.Partners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Partners.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Partners.detail_actionPanel(p);
});
Lino.pcsw.Partners.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Partners.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.AllPartnersHandle
Lino.contacts.AllPartners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/AllPartners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Alle partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    var ww = this.containing_window;
    var name4141 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4142 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4143 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4144 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4145 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4147 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4148 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14149 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4151 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4152 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4153 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24154 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4155 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4156 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4157 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4160 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4161 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4162 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14163 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24164 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var id4165 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4146.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4146.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4147.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4145.on('change',Lino.chooser_handler(city4146,'country'));
      region4147.on('change',Lino.chooser_handler(city4146,'region'));
      country4145.on('change',Lino.chooser_handler(region4147,'country'));
      Lino.contacts.AllPartners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4141 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4142 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4145, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4146, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4147, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4148 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14149 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4150 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4151 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4152 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4153 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24154 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4155 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4156 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4157 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4158 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4159 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4160, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4162 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14163 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24164 }, { "colIndex": 24, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4165, "dataIndex": "id" } ];
    Lino.contacts.AllPartners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.AllPartners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Alle partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/AllPartners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    Lino.contacts.AllPartners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.AllPartners.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.AllPartners.insert_actionPanel(p);
});

Lino.contacts.AllPartners.detail_actionPanel = Ext.extend(Lino.pcsw.Partners.DetailFormPanel,{
  empty_title: "Detail Alle partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/AllPartners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    Lino.contacts.AllPartners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.AllPartners.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.AllPartners.detail_actionPanel(p);
});
Lino.contacts.AllPartners.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.AllPartners.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIcontacts.CompaniesHandle
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "boolean", "name": "is_health_insurance" }, { "type": "boolean", "name": "is_pharmacy" }, { "type": "boolean", "name": "is_attorney" }, { "type": "boolean", "name": "is_job_office" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    var ww = this.containing_window;
    var name4192 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4193 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4194 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4195 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4196 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4197 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4198 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4199 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14200 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4201 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4202 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4203 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4204 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4206 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4207 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4208 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4211 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4212 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4213 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14214 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4216 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4217 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4218 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var is_health_insurance4219 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_pharmacy4220 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_attorney4221 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_job_office4222 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id4223 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4197.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4197.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4198.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4196.on('change',Lino.chooser_handler(city4197,'country'));
      region4198.on('change',Lino.chooser_handler(city4197,'region'));
      country4196.on('change',Lino.chooser_handler(region4198,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4192 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4193 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4196, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4197, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4198, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4199 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14200 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4201 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4202 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4203 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4204 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24205 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4206 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4207 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4208 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4209 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4210 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4211, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4213 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14214 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24215 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "hidden": false, "editor": prefix4216 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "hidden": false, "editor": vat_id4217 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4218 }, { "colIndex": 27, "sortable": false, "xtype": "checkcolumn", "header": "Krankenkasse", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_health_insurance", "hidden": false }, { "colIndex": 28, "sortable": false, "xtype": "checkcolumn", "header": "Apotheke", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_pharmacy", "hidden": false }, { "colIndex": 29, "sortable": false, "xtype": "checkcolumn", "header": "Attorney", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_attorney", "hidden": false }, { "colIndex": 30, "sortable": false, "xtype": "checkcolumn", "header": "Job office", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_job_office", "hidden": false }, { "colIndex": 31, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4223, "dataIndex": "id" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Organisationen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    Lino.contacts.Companies.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insert_actionPanel(p);
});

Lino.contacts.Companies.detail_actionPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisationen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    Lino.contacts.Companies.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detail_actionPanel(p);
});
Lino.contacts.Companies.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.ClientsHandle
Lino.pcsw.Clients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Clients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "eID-Inhalt", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Clients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" },'client_stateHidden', { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" },'aid_typeHidden', { "name": "coach1" },'coach1Hidden', { "name": "language" },'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail_action;
    this.ls_insert_handler = Lino.pcsw.Clients.insert_action;
    var ww = this.containing_window;
    var name_column_disp4257 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state4258 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ] });
    var national_id4259 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gsm4260 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4261 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4262 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4263 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4265 = { "selectOnFocus": true, "xtype": "numberfield" };
    var bank_account14266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4267 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var coach14268 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var language4269 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Client state", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "client_state", "hidden": false, "editor": client_state4258 }, { "colIndex": 2, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "national_id", "hidden": false, "editor": national_id4259 }, { "colIndex": 3, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm4260 }, { "width": Lino.chars2width(30), "colIndex": 4, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 5, "sortable": false, "dataIndex": "age", "header": "Alter", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4263 }, { "colIndex": 7, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone4264 }, { "colIndex": 8, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4265, "dataIndex": "id" }, { "colIndex": 9, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14266 }, { "colIndex": 10, "sortable": true, "header": "Sozialhilfeart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "aid_type", "hidden": false, "editor": aid_type4267 }, { "colIndex": 11, "sortable": true, "header": "Begleiter 1", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coach1", "hidden": false }, { "colIndex": 12, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language4269 } ];
    Lino.pcsw.Clients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Clients.insert_actionPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Clients",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/Clients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail_action;
    this.ls_insert_handler = Lino.pcsw.Clients.insert_action;
    Lino.pcsw.Clients.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  var only_coached_on4271 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Only coached on", "anchor": "-20", "name": "only_coached_on" });
  var group4272 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
  var coached_by4273 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
  var coached_since4274 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Coached since", "anchor": "-20", "name": "coached_since" });
  var only_primary4275 = new Ext.form.Checkbox({ "boxLabel": "Only primary clients", "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
  var show_deprecated4276 = new Ext.form.Checkbox({ "boxLabel": "Show deprecated", "hideLabel": true, "checked": false, "name": "show_deprecated", "selectOnFocus": true, "anchor": "-20" });
  var only_active4277 = new Ext.form.Checkbox({ "boxLabel": "Only active clients", "listeners": { "render": Lino.quicktip_renderer("Only active clients","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
  var client_state4278 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "name": "client_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "hiddenName": "client_stateHidden" });
  var main_panel4279 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_coached_on4271, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4272, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4273, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_since4274, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4275, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_deprecated4276, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4277, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4278, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel4279;
  p.params_panel.fields = [ only_coached_on4271, group4272, coached_by4273, coached_since4274, only_primary4275, show_deprecated4276, only_active4277, client_state4278 ];
  return new Lino.pcsw.Clients.insert_actionPanel(p);
});

Lino.pcsw.Clients.detail_actionPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Clients",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "eID-Inhalt", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') } ],
  ls_url: "/pcsw/Clients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Clients.detail_action;
    this.ls_insert_handler = Lino.pcsw.Clients.insert_action;
    Lino.pcsw.Clients.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Clients.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  var only_coached_on4271 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Only coached on", "anchor": "-20", "name": "only_coached_on" });
  var group4272 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
  var coached_by4273 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
  var coached_since4274 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Coached since", "anchor": "-20", "name": "coached_since" });
  var only_primary4275 = new Ext.form.Checkbox({ "boxLabel": "Only primary clients", "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
  var show_deprecated4276 = new Ext.form.Checkbox({ "boxLabel": "Show deprecated", "hideLabel": true, "checked": false, "name": "show_deprecated", "selectOnFocus": true, "anchor": "-20" });
  var only_active4277 = new Ext.form.Checkbox({ "boxLabel": "Only active clients", "listeners": { "render": Lino.quicktip_renderer("Only active clients","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
  var client_state4278 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "name": "client_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "hiddenName": "client_stateHidden" });
  var main_panel4279 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_coached_on4271, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4272, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4273, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_since4274, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4275, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_deprecated4276, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4277, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4278, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel4279;
  p.params_panel.fields = [ only_coached_on4271, group4272, coached_by4273, coached_since4274, only_primary4275, show_deprecated4276, only_active4277, client_state4278 ];
  return new Lino.pcsw.Clients.detail_actionPanel(p);
});
Lino.pcsw.Clients.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  var only_coached_on4271 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Only coached on", "anchor": "-20", "name": "only_coached_on" });
  var group4272 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/group", "method": "GET" }) }) });
  var coached_by4273 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Clients/coached_by", "method": "GET" }) }) });
  var coached_since4274 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Coached since", "anchor": "-20", "name": "coached_since" });
  var only_primary4275 = new Ext.form.Checkbox({ "boxLabel": "Only primary clients", "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
  var show_deprecated4276 = new Ext.form.Checkbox({ "boxLabel": "Show deprecated", "hideLabel": true, "checked": false, "name": "show_deprecated", "selectOnFocus": true, "anchor": "-20" });
  var only_active4277 = new Ext.form.Checkbox({ "boxLabel": "Only active clients", "listeners": { "render": Lino.quicktip_renderer("Only active clients","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
  var client_state4278 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "name": "client_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "hiddenName": "client_stateHidden" });
  var main_panel4279 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_coached_on4271, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4272, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4273, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_since4274, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4275, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_deprecated4276, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4277, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4278, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel4279;
  p.params_panel.fields = [ only_coached_on4271, group4272, coached_by4273, coached_since4274, only_primary4275, show_deprecated4276, only_active4277, client_state4278 ];
  return new Lino.pcsw.Clients.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.MyClientsHandle
Lino.pcsw.MyClients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/MyClients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "eID-Inhalt", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Meine Klienten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "client_state" },'client_stateHidden', { "type": "date", "name": "applies_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "applies_until", "dateFormat": "d.m.Y" }, { "name": "national_id" }, { "name": "gsm" }, { "name": "address_column" }, { "name": "age" }, { "name": "email" }, { "name": "phone" }, { "type": "int", "name": "id" }, { "name": "bank_account1" }, { "name": "aid_type" },'aid_typeHidden', { "name": "coach1" },'coach1Hidden', { "name": "language" },'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 75,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyClients.insert_action;
    var ww = this.containing_window;
    var name_column_disp4301 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var client_state4302 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ] });
    var applies_from4303 = new Lino.DateField({ "disabled": true });
    var applies_until4304 = new Lino.DateField({ "disabled": true });
    var national_id4305 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gsm4306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var address_column_disp4307 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var age_disp4308 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email4309 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone4310 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id4311 = { "selectOnFocus": true, "xtype": "numberfield" };
    var bank_account14312 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var aid_type4313 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/aid_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Sozialhilfeart ausw\u00e4hlen..." });
    var coach14314 = new Lino.RemoteComboFieldElement({ "disabled": true, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var language4315 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Client state", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "client_state", "hidden": false, "editor": client_state4302 }, { "colIndex": 2, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Vertrag beginnt", "dataIndex": "applies_from", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 3, "sortable": false, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Vertrag endet", "dataIndex": "applies_until", "hidden": false, "width": Lino.chars2width(8) }, { "colIndex": 4, "sortable": true, "header": "NR-Nummer", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "national_id", "hidden": false, "editor": national_id4305 }, { "colIndex": 5, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "hidden": false, "editor": gsm4306 }, { "width": Lino.chars2width(30), "colIndex": 6, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "hidden": false, "editable": false }, { "width": Lino.chars2width(10), "colIndex": 7, "sortable": false, "dataIndex": "age", "header": "Alter", "hidden": false, "editable": false }, { "colIndex": 8, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4309 }, { "colIndex": 9, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "hidden": false, "editor": phone4310 }, { "colIndex": 10, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4311, "dataIndex": "id" }, { "colIndex": 11, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14312 }, { "colIndex": 12, "sortable": true, "header": "Sozialhilfeart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "aid_type", "hidden": false, "editor": aid_type4313 }, { "colIndex": 13, "sortable": true, "header": "Begleiter 1", "editable": false, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coach1", "hidden": false }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "hidden": false, "editor": language4315 } ];
    Lino.pcsw.MyClients.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.MyClients.insert_actionPanel = Ext.extend(Lino.pcsw.Clients.InsertFormPanel,{
  empty_title: "Neu Meine Klienten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/MyClients",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyClients.insert_action;
    Lino.pcsw.MyClients.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyClients.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  var only_coached_on4317 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Only coached on", "anchor": "-20", "name": "only_coached_on" });
  var group4318 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/group", "method": "GET" }) }) });
  var coached_by4319 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/coached_by", "method": "GET" }) }) });
  var coached_since4320 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Coached since", "anchor": "-20", "name": "coached_since" });
  var only_primary4321 = new Ext.form.Checkbox({ "boxLabel": "Only primary clients", "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
  var show_deprecated4322 = new Ext.form.Checkbox({ "boxLabel": "Show deprecated", "hideLabel": true, "checked": false, "name": "show_deprecated", "selectOnFocus": true, "anchor": "-20" });
  var only_active4323 = new Ext.form.Checkbox({ "boxLabel": "Only active clients", "listeners": { "render": Lino.quicktip_renderer("Only active clients","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
  var client_state4324 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "name": "client_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "hiddenName": "client_stateHidden" });
  var main_panel4325 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_coached_on4317, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4318, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4319, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_since4320, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4321, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_deprecated4322, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4323, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel4325;
  p.params_panel.fields = [ only_coached_on4317, group4318, coached_by4319, coached_since4320, only_primary4321, show_deprecated4322, only_active4323, client_state4324 ];
  return new Lino.pcsw.MyClients.insert_actionPanel(p);
});

Lino.pcsw.MyClients.detail_actionPanel = Ext.extend(Lino.pcsw.Clients.DetailFormPanel,{
  empty_title: "Detail Meine Klienten",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_eid_content", "text": "eID-Inhalt", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_eid_content') } ],
  ls_url: "/pcsw/MyClients",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.MyClients.detail_action;
    this.ls_insert_handler = Lino.pcsw.MyClients.insert_action;
    Lino.pcsw.MyClients.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.MyClients.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  var only_coached_on4317 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Only coached on", "anchor": "-20", "name": "only_coached_on" });
  var group4318 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/group", "method": "GET" }) }) });
  var coached_by4319 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/coached_by", "method": "GET" }) }) });
  var coached_since4320 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Coached since", "anchor": "-20", "name": "coached_since" });
  var only_primary4321 = new Ext.form.Checkbox({ "boxLabel": "Only primary clients", "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
  var show_deprecated4322 = new Ext.form.Checkbox({ "boxLabel": "Show deprecated", "hideLabel": true, "checked": false, "name": "show_deprecated", "selectOnFocus": true, "anchor": "-20" });
  var only_active4323 = new Ext.form.Checkbox({ "boxLabel": "Only active clients", "listeners": { "render": Lino.quicktip_renderer("Only active clients","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
  var client_state4324 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "name": "client_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "hiddenName": "client_stateHidden" });
  var main_panel4325 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_coached_on4317, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4318, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4319, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_since4320, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4321, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_deprecated4322, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4323, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel4325;
  p.params_panel.fields = [ only_coached_on4317, group4318, coached_by4319, coached_since4320, only_primary4321, show_deprecated4322, only_active4323, client_state4324 ];
  return new Lino.pcsw.MyClients.detail_actionPanel(p);
});
Lino.pcsw.MyClients.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  var only_coached_on4317 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Only coached on", "anchor": "-20", "name": "only_coached_on" });
  var group4318 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Integrationsphase", "name": "group", "pageSize": 20, "emptyText": "Integrationsphase ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/group", "method": "GET" }) }) });
  var coached_by4319 = new Lino.TwinCombo({ "fieldLabel": "Begleitet durch", "name": "coached_by", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "coached_byHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/MyClients/coached_by", "method": "GET" }) }) });
  var coached_since4320 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Coached since", "anchor": "-20", "name": "coached_since" });
  var only_primary4321 = new Ext.form.Checkbox({ "boxLabel": "Only primary clients", "hideLabel": true, "checked": false, "name": "only_primary", "selectOnFocus": true, "anchor": "-20" });
  var show_deprecated4322 = new Ext.form.Checkbox({ "boxLabel": "Show deprecated", "hideLabel": true, "checked": false, "name": "show_deprecated", "selectOnFocus": true, "anchor": "-20" });
  var only_active4323 = new Ext.form.Checkbox({ "boxLabel": "Only active clients", "listeners": { "render": Lino.quicktip_renderer("Only active clients","Show only clients in 'active' integration phases") }, "hideLabel": true, "checked": false, "name": "only_active", "selectOnFocus": true, "anchor": "-20" });
  var client_state4324 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Client state", "name": "client_state", "selectOnFocus": true, "anchor": "-20", "store": [ [ "10", "Newcomer" ], [ "20", "Active" ], [ "30", "Official" ], [ "40", "Former" ], [ "50", "Invalid" ] ], "hiddenName": "client_stateHidden" });
  var main_panel4325 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_coached_on4317, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group4318, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_by4319, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": coached_since4320, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_primary4321, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_deprecated4322, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": only_active4323, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": client_state4324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 189, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel4325;
  p.params_panel.fields = [ only_coached_on4317, group4318, coached_by4319, coached_since4320, only_primary4321, show_deprecated4322, only_active4323, client_state4324 ];
  return new Lino.pcsw.MyClients.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.PersonSearchesHandle
Lino.pcsw.PersonSearches.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/PersonSearches",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_suchliste", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_suchliste') }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Personensuchen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "title" }, { "type": "int", "name": "aged_from" }, { "type": "int", "name": "aged_to" }, { "name": "gender" },'genderHidden', { "type": "boolean", "name": "only_my_persons" }, { "name": "coached_by" },'coached_byHidden', { "type": "date", "name": "period_from", "dateFormat": "d.m.Y" }, { "type": "date", "name": "period_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 80,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.PersonSearches.detail_action;
    this.ls_insert_handler = Lino.pcsw.PersonSearches.insert_action;
    var ww = this.containing_window;
    var id4408 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user4409 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/PersonSearches/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var title4410 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var aged_from4411 = { "selectOnFocus": true, "xtype": "numberfield" };
    var aged_to4412 = { "selectOnFocus": true, "xtype": "numberfield" };
    var gender4413 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ] });
    var only_my_persons4414 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var coached_by4415 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/PersonSearches/coached_by", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var period_from4416 = new Lino.DateField({ "selectOnFocus": true });
    var period_until4417 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4408, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "user", "hidden": false, "editor": user4409 }, { "colIndex": 2, "sortable": true, "header": "Titel Suchliste", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title4410 }, { "colIndex": 3, "sortable": true, "header": "Alter von", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "aged_from", "hidden": false, "editor": aged_from4411 }, { "colIndex": 4, "sortable": true, "header": "Alter bis", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "dataIndex": "aged_to", "hidden": false, "editor": aged_to4412 }, { "colIndex": 5, "sortable": true, "header": "Geschlecht", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "gender", "hidden": false, "editor": gender4413 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Only my clients", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "only_my_persons", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Begleitet durch", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "coached_by", "hidden": false, "editor": coached_by4415 }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Periode vom", "dataIndex": "period_from", "hidden": false, "width": Lino.chars2width(8), "editor": period_from4416 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "bis", "dataIndex": "period_until", "hidden": false, "width": Lino.chars2width(8), "editor": period_until4417 } ];
    Lino.pcsw.PersonSearches.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.PersonSearches.insert_actionPanel = Ext.extend(Lino.pcsw.PersonSearches.DetailFormPanel,{
  empty_title: "Neu Personensuchen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/PersonSearches",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.PersonSearches.detail_action;
    this.ls_insert_handler = Lino.pcsw.PersonSearches.insert_action;
    Lino.pcsw.PersonSearches.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.PersonSearches.insert_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.PersonSearches.insert_actionPanel(p);
});

Lino.pcsw.PersonSearches.detail_actionPanel = Ext.extend(Lino.pcsw.PersonSearches.DetailFormPanel,{
  empty_title: "Detail Personensuchen",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "print_suchliste", "text": "Drucken", "must_save": true, "auto_save": true, "panel_btn_handler": Lino.row_action_handler('print_suchliste') } ],
  ls_url: "/pcsw/PersonSearches",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.PersonSearches.detail_action;
    this.ls_insert_handler = Lino.pcsw.PersonSearches.insert_action;
    Lino.pcsw.PersonSearches.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.PersonSearches.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.PersonSearches.detail_actionPanel(p);
});
Lino.pcsw.PersonSearches.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.PersonSearches.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.OverlappingContractsHandle
Lino.pcsw.OverlappingContracts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/OverlappingContracts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected } ],
  title : "Vertrags\u00fcberschneidungen ",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "birth_date" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "title" }, { "name": "gender" },'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    var ww = this.containing_window;
    var id4429 = { "selectOnFocus": true, "xtype": "numberfield" };
    var created4430 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4431 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4432 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4433 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4434 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4435 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name4436 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr14437 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4438 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4439 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4440 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4441 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24442 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4443 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var email4444 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url4445 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4446 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4447 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4448 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4449 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4450 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4451 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/OverlappingContracts/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14452 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24453 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var birth_date4454 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var first_name4455 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name4456 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title4457 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender4458 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ] });
    this.before_row_edit = function(record) {
      city4433.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4433.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4434.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4432.on('change',Lino.chooser_handler(city4433,'country'));
      region4434.on('change',Lino.chooser_handler(city4433,'region'));
      country4432.on('change',Lino.chooser_handler(region4434,'country'));
      Lino.pcsw.OverlappingContracts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4429, "dataIndex": "id" }, { "width": Lino.chars2width(16), "colIndex": 1, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 3, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4432, "dataIndex": "country" }, { "colIndex": 4, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4433, "dataIndex": "city" }, { "colIndex": 5, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4434, "dataIndex": "region" }, { "colIndex": 6, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4435 }, { "colIndex": 7, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4436 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14437 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4438 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4439 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4440 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4441 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24442 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4443 }, { "colIndex": 15, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4444 }, { "colIndex": 16, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4445 }, { "colIndex": 17, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4446 }, { "colIndex": 18, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4447 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4448 }, { "colIndex": 20, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4449, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 22, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4451 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14452 }, { "colIndex": 24, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24453 }, { "colIndex": 25, "sortable": true, "header": "Geburtsdatum", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "birth_date", "hidden": false, "editor": birth_date4454 }, { "colIndex": 26, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "hidden": false, "editor": first_name4455 }, { "colIndex": 27, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "hidden": false, "editor": last_name4456 }, { "colIndex": 28, "sortable": true, "header": "Anrede", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "hidden": false, "editor": title4457 }, { "colIndex": 29, "sortable": true, "header": "Geschlecht", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "gender", "hidden": false, "editor": gender4458 } ];
    Lino.pcsw.OverlappingContracts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.OverlappingContracts.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.OverlappingContracts.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.HealthInsurancesHandle
Lino.pcsw.HealthInsurances.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/HealthInsurances",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Health insurances",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "boolean", "name": "is_health_insurance" }, { "type": "boolean", "name": "is_pharmacy" }, { "type": "boolean", "name": "is_attorney" }, { "type": "boolean", "name": "is_job_office" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.HealthInsurances.detail_action;
    this.ls_insert_handler = Lino.pcsw.HealthInsurances.insert_action;
    var ww = this.containing_window;
    var name4490 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4492 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4493 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4494 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/HealthInsurances/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4495 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/HealthInsurances/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4496 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/HealthInsurances/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4497 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4499 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4500 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4501 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4502 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24503 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4504 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4505 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4506 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4507 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4508 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4509 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4510 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4511 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/HealthInsurances/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14512 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24513 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4514 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4515 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4516 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/HealthInsurances/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var is_health_insurance4517 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_pharmacy4518 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_attorney4519 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_job_office4520 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id4521 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4495.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4495.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4496.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4494.on('change',Lino.chooser_handler(city4495,'country'));
      region4496.on('change',Lino.chooser_handler(city4495,'region'));
      country4494.on('change',Lino.chooser_handler(region4496,'country'));
      Lino.pcsw.HealthInsurances.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4490 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4491 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4494, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4495, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4496, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4497 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14498 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4499 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4500 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4501 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4502 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24503 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4504 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4505 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4506 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4507 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4508 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4509, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4511 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14512 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24513 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "hidden": false, "editor": prefix4514 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "hidden": false, "editor": vat_id4515 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4516 }, { "colIndex": 27, "sortable": false, "xtype": "checkcolumn", "header": "Krankenkasse", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_health_insurance", "hidden": false }, { "colIndex": 28, "sortable": false, "xtype": "checkcolumn", "header": "Apotheke", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_pharmacy", "hidden": false }, { "colIndex": 29, "sortable": false, "xtype": "checkcolumn", "header": "Attorney", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_attorney", "hidden": false }, { "colIndex": 30, "sortable": false, "xtype": "checkcolumn", "header": "Job office", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_job_office", "hidden": false }, { "colIndex": 31, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4521, "dataIndex": "id" } ];
    Lino.pcsw.HealthInsurances.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.HealthInsurances.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Health insurances",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/HealthInsurances",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.HealthInsurances.detail_action;
    this.ls_insert_handler = Lino.pcsw.HealthInsurances.insert_action;
    Lino.pcsw.HealthInsurances.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.HealthInsurances.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.HealthInsurances.insert_actionPanel(p);
});

Lino.pcsw.HealthInsurances.detail_actionPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Health insurances",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/pcsw/HealthInsurances",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.HealthInsurances.detail_action;
    this.ls_insert_handler = Lino.pcsw.HealthInsurances.insert_action;
    Lino.pcsw.HealthInsurances.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.HealthInsurances.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.HealthInsurances.detail_actionPanel(p);
});
Lino.pcsw.HealthInsurances.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.HealthInsurances.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.PharmaciesHandle
Lino.pcsw.Pharmacies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Pharmacies",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Pharmacies",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "boolean", "name": "is_health_insurance" }, { "type": "boolean", "name": "is_pharmacy" }, { "type": "boolean", "name": "is_attorney" }, { "type": "boolean", "name": "is_job_office" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Pharmacies.detail_action;
    this.ls_insert_handler = Lino.pcsw.Pharmacies.insert_action;
    var ww = this.containing_window;
    var name4555 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4556 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4557 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4558 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4559 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Pharmacies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4560 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Pharmacies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4561 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Pharmacies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4562 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14563 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4564 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4565 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4566 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4567 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24568 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4569 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4570 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4571 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4572 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4573 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4574 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4575 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4576 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Pharmacies/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14577 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24578 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4579 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4580 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4581 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Pharmacies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var is_health_insurance4582 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_pharmacy4583 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_attorney4584 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_job_office4585 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id4586 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4560.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4560.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4561.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4559.on('change',Lino.chooser_handler(city4560,'country'));
      region4561.on('change',Lino.chooser_handler(city4560,'region'));
      country4559.on('change',Lino.chooser_handler(region4561,'country'));
      Lino.pcsw.Pharmacies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4555 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4556 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4559, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4560, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4561, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4562 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14563 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4564 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4565 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4566 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4567 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24568 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4569 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4570 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4571 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4572 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4573 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4574, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4576 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14577 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24578 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "hidden": false, "editor": prefix4579 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "hidden": false, "editor": vat_id4580 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4581 }, { "colIndex": 27, "sortable": false, "xtype": "checkcolumn", "header": "Krankenkasse", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_health_insurance", "hidden": false }, { "colIndex": 28, "sortable": false, "xtype": "checkcolumn", "header": "Apotheke", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_pharmacy", "hidden": false }, { "colIndex": 29, "sortable": false, "xtype": "checkcolumn", "header": "Attorney", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_attorney", "hidden": false }, { "colIndex": 30, "sortable": false, "xtype": "checkcolumn", "header": "Job office", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_job_office", "hidden": false }, { "colIndex": 31, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4586, "dataIndex": "id" } ];
    Lino.pcsw.Pharmacies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Pharmacies.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Pharmacies",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/Pharmacies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Pharmacies.detail_action;
    this.ls_insert_handler = Lino.pcsw.Pharmacies.insert_action;
    Lino.pcsw.Pharmacies.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Pharmacies.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Pharmacies.insert_actionPanel(p);
});

Lino.pcsw.Pharmacies.detail_actionPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Pharmacies",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/pcsw/Pharmacies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Pharmacies.detail_action;
    this.ls_insert_handler = Lino.pcsw.Pharmacies.insert_action;
    Lino.pcsw.Pharmacies.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Pharmacies.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Pharmacies.detail_actionPanel(p);
});
Lino.pcsw.Pharmacies.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Pharmacies.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.AttorneysHandle
Lino.pcsw.Attorneys.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/Attorneys",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Attorneys",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "boolean", "name": "is_health_insurance" }, { "type": "boolean", "name": "is_pharmacy" }, { "type": "boolean", "name": "is_attorney" }, { "type": "boolean", "name": "is_job_office" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Attorneys.detail_action;
    this.ls_insert_handler = Lino.pcsw.Attorneys.insert_action;
    var ww = this.containing_window;
    var name4620 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4621 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4622 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4623 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4624 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Attorneys/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4625 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Attorneys/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Attorneys/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4627 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14628 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4629 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4630 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4631 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4632 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24633 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4634 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4635 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4636 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4637 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4638 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4639 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4640 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4641 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Attorneys/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14642 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24643 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4644 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4645 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4646 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/Attorneys/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var is_health_insurance4647 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_pharmacy4648 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_attorney4649 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_job_office4650 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id4651 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4625.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4625.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4626.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4624.on('change',Lino.chooser_handler(city4625,'country'));
      region4626.on('change',Lino.chooser_handler(city4625,'region'));
      country4624.on('change',Lino.chooser_handler(region4626,'country'));
      Lino.pcsw.Attorneys.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4620 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4621 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4624, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4625, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4626, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4627 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14628 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4629 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4630 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4631 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4632 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24633 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4634 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4635 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4636 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4637 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4638 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4639, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "activity", "hidden": false, "editor": activity4641 }, { "colIndex": 22, "sortable": true, "header": "Bankkonto 1", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account1", "hidden": false, "editor": bank_account14642 }, { "colIndex": 23, "sortable": true, "header": "Bankkonto 2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "bank_account2", "hidden": false, "editor": bank_account24643 }, { "colIndex": 24, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "hidden": false, "editor": prefix4644 }, { "colIndex": 25, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "hidden": false, "editor": vat_id4645 }, { "colIndex": 26, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "hidden": false, "editor": type4646 }, { "colIndex": 27, "sortable": false, "xtype": "checkcolumn", "header": "Krankenkasse", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_health_insurance", "hidden": false }, { "colIndex": 28, "sortable": false, "xtype": "checkcolumn", "header": "Apotheke", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_pharmacy", "hidden": false }, { "colIndex": 29, "sortable": false, "xtype": "checkcolumn", "header": "Attorney", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_attorney", "hidden": false }, { "colIndex": 30, "sortable": false, "xtype": "checkcolumn", "header": "Job office", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_job_office", "hidden": false }, { "colIndex": 31, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(5), "renderer": Lino.id_renderer, "hidden": false, "editor": id4651, "dataIndex": "id" } ];
    Lino.pcsw.Attorneys.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pcsw.Attorneys.insert_actionPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Attorneys",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Erstellen", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/pcsw/Attorneys",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Attorneys.detail_action;
    this.ls_insert_handler = Lino.pcsw.Attorneys.insert_action;
    Lino.pcsw.Attorneys.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Attorneys.insert_action = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pcsw.Attorneys.insert_actionPanel(p);
});

Lino.pcsw.Attorneys.detail_actionPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Attorneys",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Speichern", "auto_save": false, "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/pcsw/Attorneys",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.Attorneys.detail_action;
    this.ls_insert_handler = Lino.pcsw.Attorneys.insert_action;
    Lino.pcsw.Attorneys.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.pcsw.Attorneys.detail_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Attorneys.detail_actionPanel(p);
});
Lino.pcsw.Attorneys.default_action = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pcsw.Attorneys.GridPanel(p);
});

// js_render_GridPanel_class lino.ui.extjs3.ext_ui.ExtUIpcsw.JobOfficesHandle
Lino.pcsw.JobOffices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/pcsw/JobOffices",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "L\u00f6schen", "auto_save": false, "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "Neu", "must_save": true, "auto_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "auto_save": true, "panel_btn_handler": Lino.show_detail } ],
  title : "Job offices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "created" }, { "name": "modified" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "region" },'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "boolean", "name": "is_deprecated" }, { "name": "activity" },'activityHidden', { "name": "bank_account1" }, { "name": "bank_account2" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "boolean", "name": "is_health_insurance" }, { "type": "boolean", "name": "is_pharmacy" }, { "type": "boolean", "name": "is_attorney" }, { "type": "boolean", "name": "is_job_office" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.pcsw.JobOffices.detail_action;
    this.ls_insert_handler = Lino.pcsw.JobOffices.insert_action;
    var ww = this.containing_window;
    var name4685 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email4686 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var created4687 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified4688 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country4689 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/JobOffices/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city4690 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/JobOffices/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region4691 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/JobOffices/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code4692 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr14693 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix4694 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street4695 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no4696 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box4697 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr24698 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language4699 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url4700 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone4701 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm4702 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax4703 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks4704 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var is_deprecated4705 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var activity4706 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/JobOffices/activity", "method": "GET" }) }), "pageSize": 20, "emptyText": "Beruf ausw\u00e4hlen..." });
    var bank_account14707 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var bank_account24708 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var prefix4709 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id4710 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type4711 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pcsw/JobOffices/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var is_health_insurance4712 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_pharmacy4713 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_attorney4714 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_job_office4715 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id4716 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city4690.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city4690.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region4691.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country4689.on('change',Lino.chooser_handler(city4690,'country'));
      region4691.on('change',Lino.chooser_handler(city4690,'region'));
      country4689.on('change',Lino.chooser_handler(region4691,'country'));
      Lino.pcsw.JobOffices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "hidden": false, "editor": name4685 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "hidden": false, "editor": email4686 }, { "width": Lino.chars2width(16), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": Lino.chars2width(16), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country4689, "dataIndex": "country" }, { "colIndex": 5, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city4690, "dataIndex": "city" }, { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": region4691, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "hidden": false, "editor": zip_code4692 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "hidden": false, "editor": addr14693 }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix4694 }, { "colIndex": 10, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "hidden": false, "editor": street4695 }, { "colIndex": 11, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "hidden": false, "editor": street_no4696 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "hidden": false, "editor": street_box4697 }, { "colIndex": 13, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "hidden": false, "editor": addr24698 }, { "colIndex": 14, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "hidden": false, "editor": language4699 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "hidden": false, "editor": url4700 }, { "colIndex": 16, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "hidden": false, "editor": phone4701 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "hidden": false, "editor": gsm4702 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "hidden": false, "editor": fax4703 }, { "colIndex": 19, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": false, "editor": remarks4704, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Altdaten", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "is_deprecated", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Beruf", "editable": true, "filter": { "type": "string" }, "width":