#  _________________________________________________________________________
#
#  PyUtilib: A Python utility library.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  For more information, see the PyUtilib README.txt file.
#  _________________________________________________________________________

from itertools import izip

def as_numeric(value):
    if type(value) in [int, float, long]:
        return value
    if isinstance(value,basestring):
        try:
            tmp = int(value)
            return tmp
        except ValueError:
            pass
        try:
            tmp = long(value)
            return tmp
        except ValueError:
            pass
        try:
            tmp = float(value)
            return tmp
        except ValueError:
            pass
    return value
    
            
def isint(arg):
    """
    Returns true if the argument is an integer
    """
    if type(arg) is int:
       return True
    if type(arg) is float:
       tmp = int(arg)
       return (tmp == arg)
    if isinstance(arg,basestring):
       try:
          num=float(arg)
          tmp = int(num)
          return (tmp == num)
       except ValueError:
          return False
    return False


def argmax(array):
    """ Return the index to the maximum element of an array """
    return max(izip(array, xrange(len(array))))[1]

def argmin(array):
    """ Return the index to the maximum element of an array """
    return min(izip(array, xrange(len(array))))[1]

def mean(mylist):
    """
    Returns the mean value of a list
    """
    total = 1.0*sum(mylist)
    length = len(mylist)
    if length == 0.0:
        raise ArithmeticError, "Attempting to compute the mean of a zero-length list"
    return (total/length)


def median(mylist):
    """
    Returns the median value of a list
    """
    mylist = list(mylist)
    mylist.sort()
    if (len(mylist) == 0):
        raise ArithmeticError, "Attempting to compute the median of a zero-length list"
    elif (len(mylist) == 1):
        return mylist[0]
    elif (divmod(len(mylist),2)[1] == 1):
        return mylist[(len(mylist)-1)/2]
    ndx = len(mylist)/2
    return (mylist[ndx-1]+mylist[ndx])/2.0


def factorial(z):
    """
    Computes z!
    """
    if z<0:
        raise ArithmeticError, "Cannot compute the factorial of a negative number"
    if z==0:
        return 1
    else:
        return z*factorial(z-1)


def perm(x,y):
    """
    Computes 'x choose y'
    """
    w = 1
    for i in range(y+1,x+1):
        w = w * i
    return w/factorial(x-y)
