/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.topology.descriptor.TopologyDescriptor;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ParallelEnvironment
implements Serializable {
    private int nodesNumber;
    private TopologyDescriptor topologyDescriptor = null;
    private static final long serialVersionUID = 121L;

    protected ParallelEnvironment() {
    }

    public ParallelEnvironment(int nodesNumber) {
        if (nodesNumber < 1) {
            throw new IllegalArgumentException("nodesNumber must be greater than 1");
        }
        this.nodesNumber = nodesNumber;
    }

    public ParallelEnvironment(int nodesNumber, TopologyDescriptor topologyDescriptor) {
        this(nodesNumber);
        this.topologyDescriptor = topologyDescriptor;
    }

    public ParallelEnvironment(ParallelEnvironment original) {
        this.nodesNumber = original.getNodesNumber();
        this.topologyDescriptor = original.topologyDescriptor;
    }

    public int getNodesNumber() {
        return this.nodesNumber;
    }

    public TopologyDescriptor getTopologyDescriptor() {
        return this.topologyDescriptor;
    }

    public void setTopologyDescriptor(TopologyDescriptor topologyDescriptor) {
        this.topologyDescriptor = topologyDescriptor;
    }

    public String toString() {
        return "ParallelEnvironment {  nodesNumber = " + this.nodesNumber + ", topologyDescriptor = " + this.topologyDescriptor + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelEnvironment that = (ParallelEnvironment)o;
        if (this.nodesNumber != that.nodesNumber) {
            return false;
        }
        return this.topologyDescriptor != null ? this.topologyDescriptor.equals(that.topologyDescriptor) : that.topologyDescriptor == null;
    }

    public int hashCode() {
        int result = this.nodesNumber;
        result = 31 * result + (this.topologyDescriptor != null ? this.topologyDescriptor.hashCode() : 0);
        return result;
    }
}

