/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;

public class TaskFilterCriteria
implements Serializable {
    private String tag = null;
    private long from = 0L;
    private long to = 0L;
    private int offset = 0;
    private int limit = 0;
    private String user = null;
    private String tenant = null;
    private boolean running = true;
    private boolean pending = true;
    private boolean finished = true;
    private ArrayList<SortSpecifierContainer> sortParameters = null;
    private static final long serialVersionUID = 121L;

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public List<SortSpecifierContainer> getSortParameters() {
        if (this.sortParameters != null) {
            return Collections.unmodifiableList(this.sortParameters);
        }
        return null;
    }

    public void setSortParameters(List<SortSpecifierContainer> sortParameters) {
        if (sortParameters != null) {
            this.sortParameters = new ArrayList<SortSpecifierContainer>(sortParameters);
        }
    }

    public static class TFCBuilder {
        private TaskFilterCriteria criterias = new TaskFilterCriteria();

        private TFCBuilder() {
        }

        public static TFCBuilder newInstance() {
            return new TFCBuilder();
        }

        public TFCBuilder tag(String tag) {
            this.criterias.setTag(tag);
            return this;
        }

        public TFCBuilder from(long from) {
            this.criterias.setFrom(from);
            return this;
        }

        public TFCBuilder to(long to) {
            this.criterias.setTo(to);
            return this;
        }

        public TFCBuilder offset(int offset) {
            this.criterias.setOffset(offset);
            return this;
        }

        public TFCBuilder limit(int limit) {
            this.criterias.setLimit(limit);
            return this;
        }

        public TFCBuilder running(boolean running) {
            this.criterias.setRunning(running);
            return this;
        }

        public TFCBuilder pending(boolean pending) {
            this.criterias.setPending(pending);
            return this;
        }

        public TFCBuilder finished(boolean finished) {
            this.criterias.setFinished(finished);
            return this;
        }

        public TFCBuilder user(String user) {
            this.criterias.setUser(user);
            return this;
        }

        public TFCBuilder tenant(String tenant) {
            this.criterias.setTenant(tenant);
            return this;
        }

        public TFCBuilder sortParameters(List<SortSpecifierContainer> sortParameters) {
            this.criterias.setSortParameters(sortParameters);
            return this;
        }

        public TaskFilterCriteria criterias() {
            return this.criterias;
        }
    }
}

