# Copyright (C) 2015 Schweitzer Engineering Laboratories, Inc.
# This software may be modified and distributed under the terms
# of the MIT license.  See the LICENSE file for details.

from __future__ import absolute_import
from __future__ import print_function
from __future__ import unicode_literals

import abc


class ICommand(object):
    """ Interface for Commands for this application.

    Implementors: Parsed arguments from argparse should be taken and checked
    for validity in the constructor.
    """
    @abc.abstractmethod
    def run(self):
        """ Run the command. Returns exit code.
        :rtype: int
        """
