/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.job.Job;

@PublicAPI
public abstract class JobFactory {
    public static final Logger logger = Logger.getLogger(JobFactory.class);
    public static final String JOBFACTORY_TMPDIR_PROPERTY = "pas.jobfactory.tmpdir";
    private static final String[] CURRENT_IMPL = new String[]{"org.ow2.proactive.scheduler.common.job.factories.StaxJobFactory"};
    public static final String ARCHIVE_DEFAULT_XMLFILE = "job.xml";
    public static final String ARCHIVE_MANIFEST_DIRECTORY = "JOB-INF";
    public static final String ARCHIVE_MANIFEST_FILE = "manifest.mf";
    public static final String ARCHIVE_MANIFEST_PROPERTY_XMLFILE = "job-xml";

    public static JobFactory getFactory() {
        JobFactory factory = null;
        for (String factoryInstance : CURRENT_IMPL) {
            try {
                ClassLoader cl = JobFactory.class.getClassLoader();
                Class<?> c = cl.loadClass(factoryInstance);
                factory = (JobFactory)c.newInstance();
                break;
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("Cannot instanciate this factory : " + factoryInstance), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn((Object)("Error while instanciating this factory : " + factoryInstance), (Throwable)e);
            }
        }
        if (factory == null) {
            throw new RuntimeException("Cannot instanciate any factory ! (see WARN logs to know why)");
        }
        return factory;
    }

    public static JobFactory getFactory(String impl) {
        JobFactory factory;
        if (impl == null) {
            return JobFactory.getFactory();
        }
        try {
            factory = (JobFactory)Class.forName(impl).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instanciate this factory : " + impl, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while instanciating this factory : " + impl, e);
        }
        return factory;
    }

    public abstract Job createJob(String var1) throws JobCreationException;

    public abstract Job createJob(String var1, Map<String, String> var2, Map<String, String> var3) throws JobCreationException;

    public abstract Job createJob(String var1, Map<String, String> var2, Map<String, String> var3, Scheduler var4, SchedulerSpaceInterface var5) throws JobCreationException;

    public abstract Job createJob(URI var1) throws JobCreationException;

    public abstract Job createJob(URI var1, Map<String, String> var2, Map<String, String> var3) throws JobCreationException;

    public abstract Job createJob(InputStream var1) throws JobCreationException;

    public abstract Job createJob(InputStream var1, Map<String, String> var2, Map<String, String> var3) throws JobCreationException;

    public abstract Job createJob(InputStream var1, Map<String, String> var2, Map<String, String> var3, Scheduler var4, SchedulerSpaceInterface var5) throws JobCreationException;
}

