# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TokenCertificate(Model):
    """The properties of a certificate used for authenticating a token.

    :param name: Possible values include: 'certificate1', 'certificate2'
    :type name: str or
     ~azure.mgmt.containerregistry.v2019_05_01_preview.models.TokenCertificateName
    :param expiry: The expiry datetime of the certificate.
    :type expiry: datetime
    :param thumbprint: The thumbprint of the certificate.
    :type thumbprint: str
    :param encoded_pem_certificate: Base 64 encoded string of the public
     certificate1 in PEM format that will be used for authenticating the token.
    :type encoded_pem_certificate: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'encoded_pem_certificate': {'key': 'encodedPemCertificate', 'type': 'str'},
    }

    def __init__(self, *, name=None, expiry=None, thumbprint: str=None, encoded_pem_certificate: str=None, **kwargs) -> None:
        super(TokenCertificate, self).__init__(**kwargs)
        self.name = name
        self.expiry = expiry
        self.thumbprint = thumbprint
        self.encoded_pem_certificate = encoded_pem_certificate
