

class NGL_Colors(object):
    """docstring for NGL_Colors"""

    colors_565 = [
        0xf801,  0xf800,  0xf860,  0xf880,  0xf8c0,  0xf8e0,  0xf920,  0xf940,  0xf980,  0xf9a0,
        0xf9e0,  0xfa00,  0xfa40,  0xfa60,  0xfaa0,  0xfac0,  0xfb00,  0xfb20,  0xfb60,  0xfb80,
        0xfbc0,  0xfbe0,  0xfc20,  0xfc40,  0xfc80,  0xfca0,  0xfce0,  0xfd00,  0xfd40,  0xfd60,
        0xfda0,  0xfdc0,  0xfe00,  0xfe20,  0xfe60,  0xfe80,  0xfec0,  0xfee0,  0xff20,  0xff40,
        0xff80,  0xffa0,  0xffe0,  0xffe0,  0xffe0,  0xf7e0,  0xefe0,  0xe7e0,  0xe7e0,  0xdfe0,
        0xd7e0,  0xcfe0,  0xcfe0,  0xc7e0,  0xbfe0,  0xb7e0,  0xb7e0,  0xafe0,  0xa7e0,  0x9fe0,
        0x9fe0,  0x97e0,  0x8fe0,  0x87e0,  0x87e0,  0x7fe0,  0x77e0,  0x6fe0,  0x6fe0,  0x67e0,
        0x5fe0,  0x57e0,  0x57e0,  0x4fe0,  0x47e0,  0x3fe0,  0x3fe0,  0x37e0,  0x2fe0,  0x27e0,
        0x27e0,  0x1fe0,  0x17e0,  0xfe0,  0xfe0,  0x7e0,  0x7e0,  0x7e0,  0x7e1,  0x7e2,
        0x7e3,  0x7e3,  0x7e4,  0x7e5,  0x7e6,  0x7e6,  0x7e7,  0x7e8,  0x7e9,  0x7e9,
        0x7ea,  0x7eb,  0x7ec,  0x7ec,  0x7ed,  0x7ee,  0x7ef,  0x7ef,  0x7f0,  0x7f1,
        0x7f2,  0x7f2,  0x7f3,  0x7f4,  0x7f5,  0x7f5,  0x7f6,  0x7f7,  0x7f8,  0x7f8,
        0x7f9,  0x7fa,  0x7fb,  0x7fb,  0x7fc,  0x7fd,  0x7fe,  0x7fe,  0x7ff,  0x7ff,
        0x7df,  0x79f,  0x77f,  0x73f,  0x71f,  0x6df,  0x6bf,  0x67f,  0x65f,  0x61f,
        0x5ff,  0x5bf,  0x59f,  0x55f,  0x53f,  0x4ff,  0x4df,  0x49f,  0x47f,  0x43f,
        0x41f,  0x3df,  0x3bf,  0x37f,  0x35f,  0x31f,  0x2ff,  0x2bf,  0x29f,  0x25f,
        0x23f,  0x1ff,  0x1df,  0x19f,  0x17f,  0x13f,  0x11f,  0xdf,  0xbf,  0x7f,
        0x5f,  0x1f,  0x1f,  0x1f,  0x81f,  0x101f,  0x181f,  0x181f,  0x201f,  0x281f,
        0x301f,  0x301f,  0x381f,  0x401f,  0x481f,  0x481f,  0x501f,  0x581f,  0x601f,  0x601f,
        0x681f,  0x701f,  0x781f,  0x781f,  0x801f,  0x881f,  0x901f,  0x901f,  0x981f,  0xa01f,
        0xa81f,  0xa81f,  0xb01f,  0xb81f,  0xc01f,  0xc01f,  0xc81f,  0xd01f,  0xd81f,  0xd81f,
        0xe01f,  0xe81f,  0xf01f,  0xf01f,  0xf81f,  0xf81f,  0xf81f,  0xf81e,  0xf81d,  0xf81c,
        0xf81c,  0xf81b,  0xf81a,  0xf819,  0xf819,  0xf818,  0xf817,  0xf816,  0xf816,  0xf815,
        0xf814,  0xf813,  0xf813,  0xf812,  0xf811,  0xf810,  0xf810,  0xf80f,  0xf80e,  0xf80d,
        0xf80d,  0xf80c,  0xf80b,  0xf80a,  0xf80a,  0xf809,  0xf808,  0xf807,  0xffff,
        0xffff,  0xce59,  0xce59,  0xb5b6,  0xb5b6,  0x2945,  0x2945 ]

    @staticmethod
    def getRGB(ngl_color):
        r = (ngl_color & 0xF800) << 8
        g = (ngl_color & 0x07E0) << 5
        b = (ngl_color & 0x001F) << 3

        return (r, g, b)

    @staticmethod
    def getColor(index):
        if index > 255:
            index = 255
        elif index < 0:
            index = 0

        color = NGL_Colors.colors_565[index]
        r = (color >> 11) << 19
        g = ((color >> 5) & 0x3F) << 10
        b = (color & 0x1F) << 3

        return r | g | b

    @staticmethod
    def fromARGB(argb_data):
        """ convert 8888_ARGB to 565_RGB """

        R = ((argb_data & 0xF80000) >> 8)
        G = ((argb_data & 0xFC00) >> 5)
        B = (argb_data & 0xF8) >> 3

        return (R | G | B)

    @staticmethod
    def fromRGB(rgb):
        """ convert 888_RGB to 565_RGB """
        R = (rgb[0] & 0x1F) << 11
        G = (rgb[1] & 0x3F) << 6
        B = rgb[2] & 0x1F
        return (R | G | B)

    @staticmethod
    def fromQColor(qcolor):
        rgb = qcolor.rgb() & 0xFFFFFF
        cdata = NGL_Colors.fromARGB(rgb)
        return cdata


