from unittest.mock import Mock

PORT_SNMP_DATA = {
    "526650240": {
        "ifIndex": Mock(safe_value="526650240"),
        "ifDescr": Mock(safe_value="Ethernet101/1/47"),
        "ifName": Mock(safe_value="Ethernet101/1/47"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:b0"),
    },
    "436211712": {
        "ifIndex": Mock(safe_value="436211712"),
        "ifDescr": Mock(safe_value="Ethernet1/2"),
        "ifName": Mock(safe_value="Ethernet1/2"),
        "ifAlias": Mock(safe_value="Test Device xe-1/1/2"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:69"),
    },
    "526649152": {
        "ifIndex": Mock(safe_value="526649152"),
        "ifDescr": Mock(safe_value="Ethernet101/1/30"),
        "ifName": Mock(safe_value="Ethernet101/1/30"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:9f"),
    },
    "151060483": {
        "ifIndex": Mock(safe_value="151060483"),
        "ifDescr": Mock(safe_value="Vlan3"),
        "ifName": Mock(safe_value="Vlan3"),
        "ifAlias": Mock(safe_value="Test Device Tools"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "527434752": {
        "ifIndex": Mock(safe_value="527434752"),
        "ifDescr": Mock(safe_value="Ethernet113/1/17"),
        "ifName": Mock(safe_value="Ethernet113/1/17"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d2"),
    },
    "437194752": {
        "ifIndex": Mock(safe_value="437194752"),
        "ifDescr": Mock(safe_value="Ethernet2/2"),
        "ifName": Mock(safe_value="Ethernet2/2"),
        "ifAlias": Mock(safe_value="Eth2/2"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:99"),
    },
    "151060485": {
        "ifIndex": Mock(safe_value="151060485"),
        "ifDescr": Mock(safe_value="Vlan5"),
        "ifName": Mock(safe_value="Vlan5"),
        "ifAlias": Mock(safe_value="Some data"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "526648960": {
        "ifIndex": Mock(safe_value="526648960"),
        "ifDescr": Mock(safe_value="Ethernet101/1/27"),
        "ifName": Mock(safe_value="Ethernet101/1/27"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:9c"),
    },
    "437190656": {
        "ifIndex": Mock(safe_value="437190656"),
        "ifDescr": Mock(safe_value="Ethernet2/1"),
        "ifName": Mock(safe_value="Ethernet2/1"),
        "ifAlias": Mock(safe_value="Eth2/1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:98"),
    },
    "526648768": {
        "ifIndex": Mock(safe_value="526648768"),
        "ifDescr": Mock(safe_value="Ethernet101/1/24"),
        "ifName": Mock(safe_value="Ethernet101/1/24"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:99"),
    },
    "151060504": {
        "ifIndex": Mock(safe_value="151060504"),
        "ifDescr": Mock(safe_value="Vlan24"),
        "ifName": Mock(safe_value="Vlan24"),
        "ifAlias": Mock(safe_value="Mgmt"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "526650304": {
        "ifIndex": Mock(safe_value="526650304"),
        "ifDescr": Mock(safe_value="Ethernet101/1/48"),
        "ifName": Mock(safe_value="Ethernet101/1/48"),
        "ifAlias": Mock(safe_value="test"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:b1"),
    },
    "527434496": {
        "ifIndex": Mock(safe_value="527434496"),
        "ifDescr": Mock(safe_value="Ethernet113/1/13"),
        "ifName": Mock(safe_value="Ethernet113/1/13"),
        "ifAlias": Mock(safe_value="MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ce"),
    },
    "437207040": {
        "ifIndex": Mock(safe_value="437207040"),
        "ifDescr": Mock(safe_value="Ethernet2/5"),
        "ifName": Mock(safe_value="Ethernet2/5"),
        "ifAlias": Mock(safe_value="Test Device  Eth2/5"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:9c"),
    },
    "526648512": {
        "ifIndex": Mock(safe_value="526648512"),
        "ifDescr": Mock(safe_value="Ethernet101/1/20"),
        "ifName": Mock(safe_value="Ethernet101/1/20"),
        "ifAlias": Mock(safe_value="Test Device  Gi0/2"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:95"),
    },
    "151060489": {
        "ifIndex": Mock(safe_value="151060489"),
        "ifDescr": Mock(safe_value="Vlan9"),
        "ifName": Mock(safe_value="Vlan9"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "151060484": {
        "ifIndex": Mock(safe_value="151060484"),
        "ifDescr": Mock(safe_value="Vlan4"),
        "ifName": Mock(safe_value="Vlan4"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "527434112": {
        "ifIndex": Mock(safe_value="527434112"),
        "ifDescr": Mock(safe_value="Ethernet113/1/7"),
        "ifName": Mock(safe_value="Ethernet113/1/7"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c8"),
    },
    "151060503": {
        "ifIndex": Mock(safe_value="151060503"),
        "ifDescr": Mock(safe_value="Vlan23"),
        "ifName": Mock(safe_value="Vlan23"),
        "ifAlias": Mock(safe_value="AnotherMgmt"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "151060486": {
        "ifIndex": Mock(safe_value="151060486"),
        "ifDescr": Mock(safe_value="Vlan6"),
        "ifName": Mock(safe_value="Vlan6"),
        "ifAlias": Mock(safe_value="Vlan Mgmt"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "526648576": {
        "ifIndex": Mock(safe_value="526648576"),
        "ifDescr": Mock(safe_value="Ethernet101/1/21"),
        "ifName": Mock(safe_value="Ethernet101/1/21"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:96"),
    },
    "436400128": {
        "ifIndex": Mock(safe_value="436400128"),
        "ifDescr": Mock(safe_value="Ethernet1/48"),
        "ifName": Mock(safe_value="Ethernet1/48"),
        "ifAlias": Mock(safe_value='"NEP6N2KC05"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:97"),
    },
    "526649088": {
        "ifIndex": Mock(safe_value="526649088"),
        "ifDescr": Mock(safe_value="Ethernet101/1/29"),
        "ifName": Mock(safe_value="Ethernet101/1/29"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:9e"),
    },
    "527434624": {
        "ifIndex": Mock(safe_value="527434624"),
        "ifDescr": Mock(safe_value="Ethernet113/1/15"),
        "ifName": Mock(safe_value="Ethernet113/1/15"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d0"),
    },
    "151060530": {
        "ifIndex": Mock(safe_value="151060530"),
        "ifDescr": Mock(safe_value="Vlan50"),
        "ifName": Mock(safe_value="Vlan50"),
        "ifAlias": Mock(safe_value="L3VPN"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "527434368": {
        "ifIndex": Mock(safe_value="527434368"),
        "ifDescr": Mock(safe_value="Ethernet113/1/11"),
        "ifName": Mock(safe_value="Ethernet113/1/11"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:cc"),
    },
    "527434176": {
        "ifIndex": Mock(safe_value="527434176"),
        "ifDescr": Mock(safe_value="Ethernet113/1/8"),
        "ifName": Mock(safe_value="Ethernet113/1/8"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c9"),
    },
    "527434048": {
        "ifIndex": Mock(safe_value="527434048"),
        "ifDescr": Mock(safe_value="Ethernet113/1/6"),
        "ifName": Mock(safe_value="Ethernet113/1/6"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c7"),
    },
    "526648640": {
        "ifIndex": Mock(safe_value="526648640"),
        "ifDescr": Mock(safe_value="Ethernet101/1/22"),
        "ifName": Mock(safe_value="Ethernet101/1/22"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:97"),
    },
    "527434688": {
        "ifIndex": Mock(safe_value="527434688"),
        "ifDescr": Mock(safe_value="Ethernet113/1/16"),
        "ifName": Mock(safe_value="Ethernet113/1/16"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d1"),
    },
    "527434304": {
        "ifIndex": Mock(safe_value="527434304"),
        "ifDescr": Mock(safe_value="Ethernet113/1/10"),
        "ifName": Mock(safe_value="Ethernet113/1/10"),
        "ifAlias": Mock(safe_value="Test Device  BIN"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:cb"),
    },
    "526648832": {
        "ifIndex": Mock(safe_value="526648832"),
        "ifDescr": Mock(safe_value="Ethernet101/1/25"),
        "ifName": Mock(safe_value="Ethernet101/1/25"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:9a"),
    },
    "527434560": {
        "ifIndex": Mock(safe_value="527434560"),
        "ifDescr": Mock(safe_value="Ethernet113/1/14"),
        "ifName": Mock(safe_value="Ethernet113/1/14"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:cf"),
    },
    "436207616": {
        "ifIndex": Mock(safe_value="436207616"),
        "ifDescr": Mock(safe_value="Ethernet1/1"),
        "ifName": Mock(safe_value="Ethernet1/1"),
        "ifAlias": Mock(safe_value="QFX xe-7/2/1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:68"),
    },
    "526649024": {
        "ifIndex": Mock(safe_value="526649024"),
        "ifDescr": Mock(safe_value="Ethernet101/1/28"),
        "ifName": Mock(safe_value="Ethernet101/1/28"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:9d"),
    },
    "527435456": {
        "ifIndex": Mock(safe_value="527435456"),
        "ifDescr": Mock(safe_value="Ethernet113/1/28"),
        "ifName": Mock(safe_value="Ethernet113/1/28"),
        "ifAlias": Mock(safe_value="Test Device  ETH2"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:dd"),
    },
    "527433984": {
        "ifIndex": Mock(safe_value="527433984"),
        "ifDescr": Mock(safe_value="Ethernet113/1/5"),
        "ifName": Mock(safe_value="Ethernet113/1/5"),
        "ifAlias": Mock(safe_value="Very Cool Data Here"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c6"),
    },
    "527434432": {
        "ifIndex": Mock(safe_value="527434432"),
        "ifDescr": Mock(safe_value="Ethernet113/1/12"),
        "ifName": Mock(safe_value="Ethernet113/1/12"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:cd"),
    },
    "527434240": {
        "ifIndex": Mock(safe_value="527434240"),
        "ifDescr": Mock(safe_value="Ethernet113/1/9"),
        "ifName": Mock(safe_value="Ethernet113/1/9"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ca"),
    },
    "526648704": {
        "ifIndex": Mock(safe_value="526648704"),
        "ifDescr": Mock(safe_value="Ethernet101/1/23"),
        "ifName": Mock(safe_value="Ethernet101/1/23"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:98"),
    },
    "151060488": {
        "ifIndex": Mock(safe_value="151060488"),
        "ifDescr": Mock(safe_value="Vlan8"),
        "ifName": Mock(safe_value="Vlan8"),
        "ifAlias": Mock(safe_value="to Firewall"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "527434816": {
        "ifIndex": Mock(safe_value="527434816"),
        "ifDescr": Mock(safe_value="Ethernet113/1/18"),
        "ifName": Mock(safe_value="Ethernet113/1/18"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d3"),
    },
    "437211136": {
        "ifIndex": Mock(safe_value="437211136"),
        "ifDescr": Mock(safe_value="Ethernet2/6"),
        "ifName": Mock(safe_value="Ethernet2/6"),
        "ifAlias": Mock(safe_value="Test Device  Eth2/6"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:9d"),
    },
    "526648896": {
        "ifIndex": Mock(safe_value="526648896"),
        "ifDescr": Mock(safe_value="Ethernet101/1/26"),
        "ifName": Mock(safe_value="Ethernet101/1/26"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:9b"),
    },
    "151060501": {
        "ifIndex": Mock(safe_value="151060501"),
        "ifDescr": Mock(safe_value="Vlan21"),
        "ifName": Mock(safe_value="Vlan21"),
        "ifAlias": Mock(safe_value="Vlan 21"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "526649920": {
        "ifIndex": Mock(safe_value="526649920"),
        "ifDescr": Mock(safe_value="Ethernet101/1/42"),
        "ifName": Mock(safe_value="Ethernet101/1/42"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:ab"),
    },
    "526780224": {
        "ifIndex": Mock(safe_value="526780224"),
        "ifDescr": Mock(safe_value="Ethernet103/1/30"),
        "ifName": Mock(safe_value="Ethernet103/1/30"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:ff"),
    },
    "527565184": {
        "ifIndex": Mock(safe_value="527565184"),
        "ifDescr": Mock(safe_value="Ethernet115/1/7"),
        "ifName": Mock(safe_value="Ethernet115/1/7"),
        "ifAlias": Mock(safe_value="Yet Another MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e8"),
    },
    "526780096": {
        "ifIndex": Mock(safe_value="526780096"),
        "ifDescr": Mock(safe_value="Ethernet103/1/28"),
        "ifName": Mock(safe_value="Ethernet103/1/28"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:fd"),
    },
    "527959296": {
        "ifIndex": Mock(safe_value="527959296"),
        "ifDescr": Mock(safe_value="Ethernet121/1/21"),
        "ifName": Mock(safe_value="Ethernet121/1/21"),
        "ifAlias": Mock(safe_value="NetApp"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:96"),
    },
    "527302656": {
        "ifIndex": Mock(safe_value="527302656"),
        "ifDescr": Mock(safe_value="Ethernet111/1/1"),
        "ifName": Mock(safe_value="Ethernet111/1/1"),
        "ifAlias": Mock(safe_value="Great Eth0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:02"),
    },
    "527303616": {
        "ifIndex": Mock(safe_value="527303616"),
        "ifDescr": Mock(safe_value="Ethernet111/1/16"),
        "ifName": Mock(safe_value="Ethernet111/1/16"),
        "ifAlias": Mock(safe_value="to Router"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:11"),
    },
    "526780288": {
        "ifIndex": Mock(safe_value="526780288"),
        "ifDescr": Mock(safe_value="Ethernet103/1/31"),
        "ifName": Mock(safe_value="Ethernet103/1/31"),
        "ifAlias": Mock(safe_value="to Router MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:00"),
    },
    "527565760": {
        "ifIndex": Mock(safe_value="527565760"),
        "ifDescr": Mock(safe_value="Ethernet115/1/16"),
        "ifName": Mock(safe_value="Ethernet115/1/16"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f1"),
    },
    "527435648": {
        "ifIndex": Mock(safe_value="527435648"),
        "ifDescr": Mock(safe_value="Ethernet113/1/31"),
        "ifName": Mock(safe_value="Ethernet113/1/31"),
        "ifAlias": Mock(safe_value="to Router NET1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e0"),
    },
    "527565632": {
        "ifIndex": Mock(safe_value="527565632"),
        "ifDescr": Mock(safe_value="Ethernet115/1/14"),
        "ifName": Mock(safe_value="Ethernet115/1/14"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:ef"),
    },
    "526780544": {
        "ifIndex": Mock(safe_value="526780544"),
        "ifDescr": Mock(safe_value="Ethernet103/1/35"),
        "ifName": Mock(safe_value="Ethernet103/1/35"),
        "ifAlias": Mock(safe_value="to Router MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:04"),
    },
    "527435328": {
        "ifIndex": Mock(safe_value="527435328"),
        "ifDescr": Mock(safe_value="Ethernet113/1/26"),
        "ifName": Mock(safe_value="Ethernet113/1/26"),
        "ifAlias": Mock(safe_value="to Router ETH1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:db"),
    },
    "527959232": {
        "ifIndex": Mock(safe_value="527959232"),
        "ifDescr": Mock(safe_value="Ethernet121/1/20"),
        "ifName": Mock(safe_value="Ethernet121/1/20"),
        "ifAlias": Mock(safe_value="to Router."),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:95"),
    },
    "527959104": {
        "ifIndex": Mock(safe_value="527959104"),
        "ifDescr": Mock(safe_value="Ethernet121/1/18"),
        "ifName": Mock(safe_value="Ethernet121/1/18"),
        "ifAlias": Mock(safe_value="to Router."),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:93"),
    },
    "527435264": {
        "ifIndex": Mock(safe_value="527435264"),
        "ifDescr": Mock(safe_value="Ethernet113/1/25"),
        "ifName": Mock(safe_value="Ethernet113/1/25"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:da"),
    },
    "527435776": {
        "ifIndex": Mock(safe_value="527435776"),
        "ifDescr": Mock(safe_value="Ethernet113/1/33"),
        "ifName": Mock(safe_value="Ethernet113/1/33"),
        "ifAlias": Mock(safe_value="Test Device  LAN1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e2"),
    },
    "527434944": {
        "ifIndex": Mock(safe_value="527434944"),
        "ifDescr": Mock(safe_value="Ethernet113/1/20"),
        "ifName": Mock(safe_value="Ethernet113/1/20"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d5"),
    },
    "527565376": {
        "ifIndex": Mock(safe_value="527565376"),
        "ifDescr": Mock(safe_value="Ethernet115/1/10"),
        "ifName": Mock(safe_value="Ethernet115/1/10"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:eb"),
    },
    "526650048": {
        "ifIndex": Mock(safe_value="526650048"),
        "ifDescr": Mock(safe_value="Ethernet101/1/44"),
        "ifName": Mock(safe_value="Ethernet101/1/44"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:ad"),
    },
    "527960640": {
        "ifIndex": Mock(safe_value="527960640"),
        "ifDescr": Mock(safe_value="Ethernet121/1/42"),
        "ifName": Mock(safe_value="Ethernet121/1/42"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:ab"),
    },
    "526649280": {
        "ifIndex": Mock(safe_value="526649280"),
        "ifDescr": Mock(safe_value="Ethernet101/1/32"),
        "ifName": Mock(safe_value="Ethernet101/1/32"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a1"),
    },
    "527435392": {
        "ifIndex": Mock(safe_value="527435392"),
        "ifDescr": Mock(safe_value="Ethernet113/1/27"),
        "ifName": Mock(safe_value="Ethernet113/1/27"),
        "ifAlias": Mock(safe_value="Test Device  ETH1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:dc"),
    },
    "527959936": {
        "ifIndex": Mock(safe_value="527959936"),
        "ifDescr": Mock(safe_value="Ethernet121/1/31"),
        "ifName": Mock(safe_value="Ethernet121/1/31"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a0"),
    },
    "527436032": {
        "ifIndex": Mock(safe_value="527436032"),
        "ifDescr": Mock(safe_value="Ethernet113/1/37"),
        "ifName": Mock(safe_value="Ethernet113/1/37"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e6"),
    },
    "527434880": {
        "ifIndex": Mock(safe_value="527434880"),
        "ifDescr": Mock(safe_value="Ethernet113/1/19"),
        "ifName": Mock(safe_value="Ethernet113/1/19"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d4"),
    },
    "527960704": {
        "ifIndex": Mock(safe_value="527960704"),
        "ifDescr": Mock(safe_value="Ethernet121/1/43"),
        "ifName": Mock(safe_value="Ethernet121/1/43"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:ac"),
    },
    "527435840": {
        "ifIndex": Mock(safe_value="527435840"),
        "ifDescr": Mock(safe_value="Ethernet113/1/34"),
        "ifName": Mock(safe_value="Ethernet113/1/34"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e3"),
    },
    "526780160": {
        "ifIndex": Mock(safe_value="526780160"),
        "ifDescr": Mock(safe_value="Ethernet103/1/29"),
        "ifName": Mock(safe_value="Ethernet103/1/29"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:fe"),
    },
    "527960576": {
        "ifIndex": Mock(safe_value="527960576"),
        "ifDescr": Mock(safe_value="Ethernet121/1/41"),
        "ifName": Mock(safe_value="Ethernet121/1/41"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:aa"),
    },
    "526649536": {
        "ifIndex": Mock(safe_value="526649536"),
        "ifDescr": Mock(safe_value="Ethernet101/1/36"),
        "ifName": Mock(safe_value="Ethernet101/1/36"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a5"),
    },
    "527435584": {
        "ifIndex": Mock(safe_value="527435584"),
        "ifDescr": Mock(safe_value="Ethernet113/1/30"),
        "ifName": Mock(safe_value="Ethernet113/1/30"),
        "ifAlias": Mock(safe_value="Test Device  NET1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:df"),
    },
    "527435200": {
        "ifIndex": Mock(safe_value="527435200"),
        "ifDescr": Mock(safe_value="Ethernet113/1/24"),
        "ifName": Mock(safe_value="Ethernet113/1/24"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d9"),
    },
    "527959360": {
        "ifIndex": Mock(safe_value="527959360"),
        "ifDescr": Mock(safe_value="Ethernet121/1/22"),
        "ifName": Mock(safe_value="Ethernet121/1/22"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:97"),
    },
    "527960256": {
        "ifIndex": Mock(safe_value="527960256"),
        "ifDescr": Mock(safe_value="Ethernet121/1/36"),
        "ifName": Mock(safe_value="Ethernet121/1/36"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a5"),
    },
    "526780672": {
        "ifIndex": Mock(safe_value="526780672"),
        "ifDescr": Mock(safe_value="Ethernet103/1/37"),
        "ifName": Mock(safe_value="Ethernet103/1/37"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:06"),
    },
    "527959680": {
        "ifIndex": Mock(safe_value="527959680"),
        "ifDescr": Mock(safe_value="Ethernet121/1/27"),
        "ifName": Mock(safe_value="Ethernet121/1/27"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:9c"),
    },
    "526649728": {
        "ifIndex": Mock(safe_value="526649728"),
        "ifDescr": Mock(safe_value="Ethernet101/1/39"),
        "ifName": Mock(safe_value="Ethernet101/1/39"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a8"),
    },
    "526780736": {
        "ifIndex": Mock(safe_value="526780736"),
        "ifDescr": Mock(safe_value="Ethernet103/1/38"),
        "ifName": Mock(safe_value="Ethernet103/1/38"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:07"),
    },
    "527565248": {
        "ifIndex": Mock(safe_value="527565248"),
        "ifDescr": Mock(safe_value="Ethernet115/1/8"),
        "ifName": Mock(safe_value="Ethernet115/1/8"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e9"),
    },
    "527565696": {
        "ifIndex": Mock(safe_value="527565696"),
        "ifDescr": Mock(safe_value="Ethernet115/1/15"),
        "ifName": Mock(safe_value="Ethernet115/1/15"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f0"),
    },
    "527959744": {
        "ifIndex": Mock(safe_value="527959744"),
        "ifDescr": Mock(safe_value="Ethernet121/1/28"),
        "ifName": Mock(safe_value="Ethernet121/1/28"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:9d"),
    },
    "527303488": {
        "ifIndex": Mock(safe_value="527303488"),
        "ifDescr": Mock(safe_value="Ethernet111/1/14"),
        "ifName": Mock(safe_value="Ethernet111/1/14"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:0f"),
    },
    "527303872": {
        "ifIndex": Mock(safe_value="527303872"),
        "ifDescr": Mock(safe_value="Ethernet111/1/20"),
        "ifName": Mock(safe_value="Ethernet111/1/20"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:15"),
    },
    "526649856": {
        "ifIndex": Mock(safe_value="526649856"),
        "ifDescr": Mock(safe_value="Ethernet101/1/41"),
        "ifName": Mock(safe_value="Ethernet101/1/41"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:aa"),
    },
    "527565056": {
        "ifIndex": Mock(safe_value="527565056"),
        "ifDescr": Mock(safe_value="Ethernet115/1/5"),
        "ifName": Mock(safe_value="Ethernet115/1/5"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e6"),
    },
    "527960448": {
        "ifIndex": Mock(safe_value="527960448"),
        "ifDescr": Mock(safe_value="Ethernet121/1/39"),
        "ifName": Mock(safe_value="Ethernet121/1/39"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a8"),
    },
    "526780416": {
        "ifIndex": Mock(safe_value="526780416"),
        "ifDescr": Mock(safe_value="Ethernet103/1/33"),
        "ifName": Mock(safe_value="Ethernet103/1/33"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:02"),
    },
    "526780032": {
        "ifIndex": Mock(safe_value="526780032"),
        "ifDescr": Mock(safe_value="Ethernet103/1/27"),
        "ifName": Mock(safe_value="Ethernet103/1/27"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:fc"),
    },
    "526650112": {
        "ifIndex": Mock(safe_value="526650112"),
        "ifDescr": Mock(safe_value="Ethernet101/1/45"),
        "ifName": Mock(safe_value="Ethernet101/1/45"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:ae"),
    },
    "527304000": {
        "ifIndex": Mock(safe_value="527304000"),
        "ifDescr": Mock(safe_value="Ethernet111/1/22"),
        "ifName": Mock(safe_value="Ethernet111/1/22"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:17"),
    },
    "527304064": {
        "ifIndex": Mock(safe_value="527304064"),
        "ifDescr": Mock(safe_value="Ethernet111/1/23"),
        "ifName": Mock(safe_value="Ethernet111/1/23"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:18"),
    },
    "527565312": {
        "ifIndex": Mock(safe_value="527565312"),
        "ifDescr": Mock(safe_value="Ethernet115/1/9"),
        "ifName": Mock(safe_value="Ethernet115/1/9"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:ea"),
    },
    "527565504": {
        "ifIndex": Mock(safe_value="527565504"),
        "ifDescr": Mock(safe_value="Ethernet115/1/12"),
        "ifName": Mock(safe_value="Ethernet115/1/12"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:ed"),
    },
    "527303936": {
        "ifIndex": Mock(safe_value="527303936"),
        "ifDescr": Mock(safe_value="Ethernet111/1/21"),
        "ifName": Mock(safe_value="Ethernet111/1/21"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:16"),
    },
    "526649408": {
        "ifIndex": Mock(safe_value="526649408"),
        "ifDescr": Mock(safe_value="Ethernet101/1/34"),
        "ifName": Mock(safe_value="Ethernet101/1/34"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a3"),
    },
    "526649472": {
        "ifIndex": Mock(safe_value="526649472"),
        "ifDescr": Mock(safe_value="Ethernet101/1/35"),
        "ifName": Mock(safe_value="Ethernet101/1/35"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a4"),
    },
    "527303680": {
        "ifIndex": Mock(safe_value="527303680"),
        "ifDescr": Mock(safe_value="Ethernet111/1/17"),
        "ifName": Mock(safe_value="Ethernet111/1/17"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:12"),
    },
    "526780864": {
        "ifIndex": Mock(safe_value="526780864"),
        "ifDescr": Mock(safe_value="Ethernet103/1/40"),
        "ifName": Mock(safe_value="Ethernet103/1/40"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:09"),
    },
    "527304128": {
        "ifIndex": Mock(safe_value="527304128"),
        "ifDescr": Mock(safe_value="Ethernet111/1/24"),
        "ifName": Mock(safe_value="Ethernet111/1/24"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:19"),
    },
    "527435968": {
        "ifIndex": Mock(safe_value="527435968"),
        "ifDescr": Mock(safe_value="Ethernet113/1/36"),
        "ifName": Mock(safe_value="Ethernet113/1/36"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e5"),
    },
    "527304192": {
        "ifIndex": Mock(safe_value="527304192"),
        "ifDescr": Mock(safe_value="Ethernet111/1/25"),
        "ifName": Mock(safe_value="Ethernet111/1/25"),
        "ifAlias": Mock(safe_value="Test Device  GE-0/0/7"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:1a"),
    },
    "527960320": {
        "ifIndex": Mock(safe_value="527960320"),
        "ifDescr": Mock(safe_value="Ethernet121/1/37"),
        "ifName": Mock(safe_value="Ethernet121/1/37"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a6"),
    },
    "526649792": {
        "ifIndex": Mock(safe_value="526649792"),
        "ifDescr": Mock(safe_value="Ethernet101/1/40"),
        "ifName": Mock(safe_value="Ethernet101/1/40"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a9"),
    },
    "528089600": {
        "ifIndex": Mock(safe_value="528089600"),
        "ifDescr": Mock(safe_value="Ethernet123/1/9"),
        "ifName": Mock(safe_value="Ethernet123/1/9"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:8a"),
    },
    "527959040": {
        "ifIndex": Mock(safe_value="527959040"),
        "ifDescr": Mock(safe_value="Ethernet121/1/17"),
        "ifName": Mock(safe_value="Ethernet121/1/17"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:92"),
    },
    "527960128": {
        "ifIndex": Mock(safe_value="527960128"),
        "ifDescr": Mock(safe_value="Ethernet121/1/34"),
        "ifName": Mock(safe_value="Ethernet121/1/34"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a3"),
    },
    "526649664": {
        "ifIndex": Mock(safe_value="526649664"),
        "ifDescr": Mock(safe_value="Ethernet101/1/38"),
        "ifName": Mock(safe_value="Ethernet101/1/38"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a7"),
    },
    "527960384": {
        "ifIndex": Mock(safe_value="527960384"),
        "ifDescr": Mock(safe_value="Ethernet121/1/38"),
        "ifName": Mock(safe_value="Ethernet121/1/38"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a7"),
    },
    "528089664": {
        "ifIndex": Mock(safe_value="528089664"),
        "ifDescr": Mock(safe_value="Ethernet123/1/10"),
        "ifName": Mock(safe_value="Ethernet123/1/10"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:8b"),
    },
    "527565120": {
        "ifIndex": Mock(safe_value="527565120"),
        "ifDescr": Mock(safe_value="Ethernet115/1/6"),
        "ifName": Mock(safe_value="Ethernet115/1/6"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e7"),
    },
    "527959808": {
        "ifIndex": Mock(safe_value="527959808"),
        "ifDescr": Mock(safe_value="Ethernet121/1/29"),
        "ifName": Mock(safe_value="Ethernet121/1/29"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:9e"),
    },
    "527303808": {
        "ifIndex": Mock(safe_value="527303808"),
        "ifDescr": Mock(safe_value="Ethernet111/1/19"),
        "ifName": Mock(safe_value="Ethernet111/1/19"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:14"),
    },
    "526649600": {
        "ifIndex": Mock(safe_value="526649600"),
        "ifDescr": Mock(safe_value="Ethernet101/1/37"),
        "ifName": Mock(safe_value="Ethernet101/1/37"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a6"),
    },
    "527959616": {
        "ifIndex": Mock(safe_value="527959616"),
        "ifDescr": Mock(safe_value="Ethernet121/1/26"),
        "ifName": Mock(safe_value="Ethernet121/1/26"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:9b"),
    },
    "527960192": {
        "ifIndex": Mock(safe_value="527960192"),
        "ifDescr": Mock(safe_value="Ethernet121/1/35"),
        "ifName": Mock(safe_value="Ethernet121/1/35"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a4"),
    },
    "527435072": {
        "ifIndex": Mock(safe_value="527435072"),
        "ifDescr": Mock(safe_value="Ethernet113/1/22"),
        "ifName": Mock(safe_value="Ethernet113/1/22"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d7"),
    },
    "527303744": {
        "ifIndex": Mock(safe_value="527303744"),
        "ifDescr": Mock(safe_value="Ethernet111/1/18"),
        "ifName": Mock(safe_value="Ethernet111/1/18"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:13"),
    },
    "527959872": {
        "ifIndex": Mock(safe_value="527959872"),
        "ifDescr": Mock(safe_value="Ethernet121/1/30"),
        "ifName": Mock(safe_value="Ethernet121/1/30"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:9f"),
    },
    "527959552": {
        "ifIndex": Mock(safe_value="527959552"),
        "ifDescr": Mock(safe_value="Ethernet121/1/25"),
        "ifName": Mock(safe_value="Ethernet121/1/25"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:9a"),
    },
    "526650176": {
        "ifIndex": Mock(safe_value="526650176"),
        "ifDescr": Mock(safe_value="Ethernet101/1/46"),
        "ifName": Mock(safe_value="Ethernet101/1/46"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:af"),
    },
    "527960512": {
        "ifIndex": Mock(safe_value="527960512"),
        "ifDescr": Mock(safe_value="Ethernet121/1/40"),
        "ifName": Mock(safe_value="Ethernet121/1/40"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a9"),
    },
    "526649344": {
        "ifIndex": Mock(safe_value="526649344"),
        "ifDescr": Mock(safe_value="Ethernet101/1/33"),
        "ifName": Mock(safe_value="Ethernet101/1/33"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a2"),
    },
    "526780800": {
        "ifIndex": Mock(safe_value="526780800"),
        "ifDescr": Mock(safe_value="Ethernet103/1/39"),
        "ifName": Mock(safe_value="Ethernet103/1/39"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:08"),
    },
    "527303552": {
        "ifIndex": Mock(safe_value="527303552"),
        "ifDescr": Mock(safe_value="Ethernet111/1/15"),
        "ifName": Mock(safe_value="Ethernet111/1/15"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:10"),
    },
    "527959424": {
        "ifIndex": Mock(safe_value="527959424"),
        "ifDescr": Mock(safe_value="Ethernet121/1/23"),
        "ifName": Mock(safe_value="Ethernet121/1/23"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:98"),
    },
    "526780480": {
        "ifIndex": Mock(safe_value="526780480"),
        "ifDescr": Mock(safe_value="Ethernet103/1/34"),
        "ifName": Mock(safe_value="Ethernet103/1/34"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:03"),
    },
    "527435136": {
        "ifIndex": Mock(safe_value="527435136"),
        "ifDescr": Mock(safe_value="Ethernet113/1/23"),
        "ifName": Mock(safe_value="Ethernet113/1/23"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d8"),
    },
    "527565568": {
        "ifIndex": Mock(safe_value="527565568"),
        "ifDescr": Mock(safe_value="Ethernet115/1/13"),
        "ifName": Mock(safe_value="Ethernet115/1/13"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:ee"),
    },
    "527435008": {
        "ifIndex": Mock(safe_value="527435008"),
        "ifDescr": Mock(safe_value="Ethernet113/1/21"),
        "ifName": Mock(safe_value="Ethernet113/1/21"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:d6"),
    },
    "526780352": {
        "ifIndex": Mock(safe_value="526780352"),
        "ifDescr": Mock(safe_value="Ethernet103/1/32"),
        "ifName": Mock(safe_value="Ethernet103/1/32"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:01"),
    },
    "526649984": {
        "ifIndex": Mock(safe_value="526649984"),
        "ifDescr": Mock(safe_value="Ethernet101/1/43"),
        "ifName": Mock(safe_value="Ethernet101/1/43"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:ac"),
    },
    "527959488": {
        "ifIndex": Mock(safe_value="527959488"),
        "ifDescr": Mock(safe_value="Ethernet121/1/24"),
        "ifName": Mock(safe_value="Ethernet121/1/24"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:99"),
    },
    "527960768": {
        "ifIndex": Mock(safe_value="527960768"),
        "ifDescr": Mock(safe_value="Ethernet121/1/44"),
        "ifName": Mock(safe_value="Ethernet121/1/44"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:ad"),
    },
    "526780608": {
        "ifIndex": Mock(safe_value="526780608"),
        "ifDescr": Mock(safe_value="Ethernet103/1/36"),
        "ifName": Mock(safe_value="Ethernet103/1/36"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:05"),
    },
    "527435904": {
        "ifIndex": Mock(safe_value="527435904"),
        "ifDescr": Mock(safe_value="Ethernet113/1/35"),
        "ifName": Mock(safe_value="Ethernet113/1/35"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e4"),
    },
    "527565440": {
        "ifIndex": Mock(safe_value="527565440"),
        "ifDescr": Mock(safe_value="Ethernet115/1/11"),
        "ifName": Mock(safe_value="Ethernet115/1/11"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:ec"),
    },
    "527435712": {
        "ifIndex": Mock(safe_value="527435712"),
        "ifDescr": Mock(safe_value="Ethernet113/1/32"),
        "ifName": Mock(safe_value="Ethernet113/1/32"),
        "ifAlias": Mock(safe_value="Test Device  NET1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e1"),
    },
    "527566656": {
        "ifIndex": Mock(safe_value="527566656"),
        "ifDescr": Mock(safe_value="Ethernet115/1/30"),
        "ifName": Mock(safe_value="Ethernet115/1/30"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:ff"),
    },
    "527959168": {
        "ifIndex": Mock(safe_value="527959168"),
        "ifDescr": Mock(safe_value="Ethernet121/1/19"),
        "ifName": Mock(safe_value="Ethernet121/1/19"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:94"),
    },
    "526779968": {
        "ifIndex": Mock(safe_value="526779968"),
        "ifDescr": Mock(safe_value="Ethernet103/1/26"),
        "ifName": Mock(safe_value="Ethernet103/1/26"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:fb"),
    },
    "527961024": {
        "ifIndex": Mock(safe_value="527961024"),
        "ifDescr": Mock(safe_value="Ethernet121/1/48"),
        "ifName": Mock(safe_value="Ethernet121/1/48"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:b1"),
    },
    "527960896": {
        "ifIndex": Mock(safe_value="527960896"),
        "ifDescr": Mock(safe_value="Ethernet121/1/46"),
        "ifName": Mock(safe_value="Ethernet121/1/46"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:af"),
    },
    "527960832": {
        "ifIndex": Mock(safe_value="527960832"),
        "ifDescr": Mock(safe_value="Ethernet121/1/45"),
        "ifName": Mock(safe_value="Ethernet121/1/45"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:ae"),
    },
    "528091520": {
        "ifIndex": Mock(safe_value="528091520"),
        "ifDescr": Mock(safe_value="Ethernet123/1/39"),
        "ifName": Mock(safe_value="Ethernet123/1/39"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a8"),
    },
    "527960960": {
        "ifIndex": Mock(safe_value="527960960"),
        "ifDescr": Mock(safe_value="Ethernet121/1/47"),
        "ifName": Mock(safe_value="Ethernet121/1/47"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:b0"),
    },
    "528091968": {
        "ifIndex": Mock(safe_value="528091968"),
        "ifDescr": Mock(safe_value="Ethernet123/1/46"),
        "ifName": Mock(safe_value="Ethernet123/1/46"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:af"),
    },
    "528091904": {
        "ifIndex": Mock(safe_value="528091904"),
        "ifDescr": Mock(safe_value="Ethernet123/1/45"),
        "ifName": Mock(safe_value="Ethernet123/1/45"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:ae"),
    },
    "528089088": {
        "ifIndex": Mock(safe_value="528089088"),
        "ifDescr": Mock(safe_value="Ethernet123/1/1"),
        "ifName": Mock(safe_value="Ethernet123/1/1"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:82"),
    },
    "528091840": {
        "ifIndex": Mock(safe_value="528091840"),
        "ifDescr": Mock(safe_value="Ethernet123/1/44"),
        "ifName": Mock(safe_value="Ethernet123/1/44"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:ad"),
    },
    "528091392": {
        "ifIndex": Mock(safe_value="528091392"),
        "ifDescr": Mock(safe_value="Ethernet123/1/37"),
        "ifName": Mock(safe_value="Ethernet123/1/37"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a6"),
    },
    "528091456": {
        "ifIndex": Mock(safe_value="528091456"),
        "ifDescr": Mock(safe_value="Ethernet123/1/38"),
        "ifName": Mock(safe_value="Ethernet123/1/38"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a7"),
    },
    "528091712": {
        "ifIndex": Mock(safe_value="528091712"),
        "ifDescr": Mock(safe_value="Ethernet123/1/42"),
        "ifName": Mock(safe_value="Ethernet123/1/42"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:ab"),
    },
    "528092096": {
        "ifIndex": Mock(safe_value="528092096"),
        "ifDescr": Mock(safe_value="Ethernet123/1/48"),
        "ifName": Mock(safe_value="Ethernet123/1/48"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:b1"),
    },
    "528091776": {
        "ifIndex": Mock(safe_value="528091776"),
        "ifDescr": Mock(safe_value="Ethernet123/1/43"),
        "ifName": Mock(safe_value="Ethernet123/1/43"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:ac"),
    },
    "528092032": {
        "ifIndex": Mock(safe_value="528092032"),
        "ifDescr": Mock(safe_value="Ethernet123/1/47"),
        "ifName": Mock(safe_value="Ethernet123/1/47"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:b0"),
    },
    "528091648": {
        "ifIndex": Mock(safe_value="528091648"),
        "ifDescr": Mock(safe_value="Ethernet123/1/41"),
        "ifName": Mock(safe_value="Ethernet123/1/41"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:aa"),
    },
    "528091584": {
        "ifIndex": Mock(safe_value="528091584"),
        "ifDescr": Mock(safe_value="Ethernet123/1/40"),
        "ifName": Mock(safe_value="Ethernet123/1/40"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a9"),
    },
    "526647488": {
        "ifIndex": Mock(safe_value="526647488"),
        "ifDescr": Mock(safe_value="Ethernet101/1/4"),
        "ifName": Mock(safe_value="Ethernet101/1/4"),
        "ifAlias": Mock(safe_value="Test Device  Ext"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:85"),
    },
    "526647616": {
        "ifIndex": Mock(safe_value="526647616"),
        "ifDescr": Mock(safe_value="Ethernet101/1/6"),
        "ifName": Mock(safe_value="Ethernet101/1/6"),
        "ifAlias": Mock(safe_value="Test Device  p0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:87"),
    },
    "526781184": {
        "ifIndex": Mock(safe_value="526781184"),
        "ifDescr": Mock(safe_value="Ethernet103/1/45"),
        "ifName": Mock(safe_value="Ethernet103/1/45"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:0e"),
    },
    "526647552": {
        "ifIndex": Mock(safe_value="526647552"),
        "ifDescr": Mock(safe_value="Ethernet101/1/5"),
        "ifName": Mock(safe_value="Ethernet101/1/5"),
        "ifAlias": Mock(safe_value="Test Device  Int"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:86"),
    },
    "526648192": {
        "ifIndex": Mock(safe_value="526648192"),
        "ifDescr": Mock(safe_value="Ethernet101/1/15"),
        "ifName": Mock(safe_value="Ethernet101/1/15"),
        "ifAlias": Mock(safe_value="Test Device  Gi0/2/0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:90"),
    },
    "527303424": {
        "ifIndex": Mock(safe_value="527303424"),
        "ifDescr": Mock(safe_value="Ethernet111/1/13"),
        "ifName": Mock(safe_value="Ethernet111/1/13"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:0e"),
    },
    "526648320": {
        "ifIndex": Mock(safe_value="526648320"),
        "ifDescr": Mock(safe_value="Ethernet101/1/17"),
        "ifName": Mock(safe_value="Ethernet101/1/17"),
        "ifAlias": Mock(safe_value="Test Device  mgt"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:92"),
    },
    "526648448": {
        "ifIndex": Mock(safe_value="526648448"),
        "ifDescr": Mock(safe_value="Ethernet101/1/19"),
        "ifName": Mock(safe_value="Ethernet101/1/19"),
        "ifAlias": Mock(safe_value="Test Device  Eth0/0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:94"),
    },
    "526647808": {
        "ifIndex": Mock(safe_value="526647808"),
        "ifDescr": Mock(safe_value="Ethernet101/1/9"),
        "ifName": Mock(safe_value="Ethernet101/1/9"),
        "ifAlias": Mock(safe_value="Test Device  gi1/47 (Leave Shut Down! L2Loop)"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:8a"),
    },
    "526647936": {
        "ifIndex": Mock(safe_value="526647936"),
        "ifDescr": Mock(safe_value="Ethernet101/1/11"),
        "ifName": Mock(safe_value="Ethernet101/1/11"),
        "ifAlias": Mock(safe_value="Test Device  mgt"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:8c"),
    },
    "151060481": {
        "ifIndex": Mock(safe_value="151060481"),
        "ifDescr": Mock(safe_value="Vlan1"),
        "ifName": Mock(safe_value="Vlan1"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "83886080": {
        "ifIndex": Mock(safe_value="83886080"),
        "ifDescr": Mock(safe_value="mgmt0"),
        "ifName": Mock(safe_value="mgmt0"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:61"),
    },
    "526647744": {
        "ifIndex": Mock(safe_value="526647744"),
        "ifDescr": Mock(safe_value="Ethernet101/1/8"),
        "ifName": Mock(safe_value="Ethernet101/1/8"),
        "ifAlias": Mock(safe_value="Test Device -L2-2 p33"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:89"),
    },
    "526647360": {
        "ifIndex": Mock(safe_value="526647360"),
        "ifDescr": Mock(safe_value="Ethernet101/1/2"),
        "ifName": Mock(safe_value="Ethernet101/1/2"),
        "ifAlias": Mock(safe_value="Test Device  gi2/1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:83"),
    },
    "526781248": {
        "ifIndex": Mock(safe_value="526781248"),
        "ifDescr": Mock(safe_value="Ethernet103/1/46"),
        "ifName": Mock(safe_value="Ethernet103/1/46"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:0f"),
    },
    "526648384": {
        "ifIndex": Mock(safe_value="526648384"),
        "ifDescr": Mock(safe_value="Ethernet101/1/18"),
        "ifName": Mock(safe_value="Ethernet101/1/18"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:93"),
    },
    "527302848": {
        "ifIndex": Mock(safe_value="527302848"),
        "ifDescr": Mock(safe_value="Ethernet111/1/4"),
        "ifName": Mock(safe_value="Ethernet111/1/4"),
        "ifAlias": Mock(safe_value="Test Device  Eth0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:05"),
    },
    "526649216": {
        "ifIndex": Mock(safe_value="526649216"),
        "ifDescr": Mock(safe_value="Ethernet101/1/31"),
        "ifName": Mock(safe_value="Ethernet101/1/31"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:a0"),
    },
    "526647296": {
        "ifIndex": Mock(safe_value="526647296"),
        "ifDescr": Mock(safe_value="Ethernet101/1/1"),
        "ifName": Mock(safe_value="Ethernet101/1/1"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:82"),
    },
    "527303104": {
        "ifIndex": Mock(safe_value="527303104"),
        "ifDescr": Mock(safe_value="Ethernet111/1/8"),
        "ifName": Mock(safe_value="Ethernet111/1/8"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:09"),
    },
    "527302784": {
        "ifIndex": Mock(safe_value="527302784"),
        "ifDescr": Mock(safe_value="Ethernet111/1/3"),
        "ifName": Mock(safe_value="Ethernet111/1/3"),
        "ifAlias": Mock(safe_value="Test Device  Eth0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:04"),
    },
    "526648128": {
        "ifIndex": Mock(safe_value="526648128"),
        "ifDescr": Mock(safe_value="Ethernet101/1/14"),
        "ifName": Mock(safe_value="Ethernet101/1/14"),
        "ifAlias": Mock(safe_value="Test Device  Gi0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:8f"),
    },
    "527304256": {
        "ifIndex": Mock(safe_value="527304256"),
        "ifDescr": Mock(safe_value="Ethernet111/1/26"),
        "ifName": Mock(safe_value="Ethernet111/1/26"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:1b"),
    },
    "526648000": {
        "ifIndex": Mock(safe_value="526648000"),
        "ifDescr": Mock(safe_value="Ethernet101/1/12"),
        "ifName": Mock(safe_value="Ethernet101/1/12"),
        "ifAlias": Mock(safe_value="Test Device  Gi0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:8d"),
    },
    "527303360": {
        "ifIndex": Mock(safe_value="527303360"),
        "ifDescr": Mock(safe_value="Ethernet111/1/12"),
        "ifName": Mock(safe_value="Ethernet111/1/12"),
        "ifAlias": Mock(safe_value="Test Device  RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:0d"),
    },
    "527304320": {
        "ifIndex": Mock(safe_value="527304320"),
        "ifDescr": Mock(safe_value="Ethernet111/1/27"),
        "ifName": Mock(safe_value="Ethernet111/1/27"),
        "ifAlias": Mock(safe_value="Test Device  RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:1c"),
    },
    "527302912": {
        "ifIndex": Mock(safe_value="527302912"),
        "ifDescr": Mock(safe_value="Ethernet111/1/5"),
        "ifName": Mock(safe_value="Ethernet111/1/5"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:06"),
    },
    "526781312": {
        "ifIndex": Mock(safe_value="526781312"),
        "ifDescr": Mock(safe_value="Ethernet103/1/47"),
        "ifName": Mock(safe_value="Ethernet103/1/47"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:10"),
    },
    "526648064": {
        "ifIndex": Mock(safe_value="526648064"),
        "ifDescr": Mock(safe_value="Ethernet101/1/13"),
        "ifName": Mock(safe_value="Ethernet101/1/13"),
        "ifAlias": Mock(safe_value="Test Device  Gi0/2/0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:8e"),
    },
    "526781376": {
        "ifIndex": Mock(safe_value="526781376"),
        "ifDescr": Mock(safe_value="Ethernet103/1/48"),
        "ifName": Mock(safe_value="Ethernet103/1/48"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:11"),
    },
    "527303040": {
        "ifIndex": Mock(safe_value="527303040"),
        "ifDescr": Mock(safe_value="Ethernet111/1/7"),
        "ifName": Mock(safe_value="Ethernet111/1/7"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:08"),
    },
    "526647872": {
        "ifIndex": Mock(safe_value="526647872"),
        "ifDescr": Mock(safe_value="Ethernet101/1/10"),
        "ifName": Mock(safe_value="Ethernet101/1/10"),
        "ifAlias": Mock(safe_value="Test Device  p1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:8b"),
    },
    "526648256": {
        "ifIndex": Mock(safe_value="526648256"),
        "ifDescr": Mock(safe_value="Ethernet101/1/16"),
        "ifName": Mock(safe_value="Ethernet101/1/16"),
        "ifAlias": Mock(safe_value="Test Device  p5"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:91"),
    },
    "526647424": {
        "ifIndex": Mock(safe_value="526647424"),
        "ifDescr": Mock(safe_value="Ethernet101/1/3"),
        "ifName": Mock(safe_value="Ethernet101/1/3"),
        "ifAlias": Mock(safe_value="Test Device  gi1/1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:84"),
    },
    "527302976": {
        "ifIndex": Mock(safe_value="527302976"),
        "ifDescr": Mock(safe_value="Ethernet111/1/6"),
        "ifName": Mock(safe_value="Ethernet111/1/6"),
        "ifAlias": Mock(safe_value="Test Device  RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:07"),
    },
    "526647680": {
        "ifIndex": Mock(safe_value="526647680"),
        "ifDescr": Mock(safe_value="Ethernet101/1/7"),
        "ifName": Mock(safe_value="Ethernet101/1/7"),
        "ifAlias": Mock(safe_value="Test Device  p1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:23:88"),
    },
    "369098854": {
        "ifIndex": Mock(safe_value="369098854"),
        "ifDescr": Mock(safe_value="port-channel103"),
        "ifName": Mock(safe_value="port-channel103"),
        "ifAlias": Mock(safe_value='"PSP6N2KC03"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8c"),
    },
    "527566272": {
        "ifIndex": Mock(safe_value="527566272"),
        "ifDescr": Mock(safe_value="Ethernet115/1/24"),
        "ifName": Mock(safe_value="Ethernet115/1/24"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f9"),
    },
    "528091328": {
        "ifIndex": Mock(safe_value="528091328"),
        "ifDescr": Mock(safe_value="Ethernet123/1/36"),
        "ifName": Mock(safe_value="Ethernet123/1/36"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a5"),
    },
    "527566016": {
        "ifIndex": Mock(safe_value="527566016"),
        "ifDescr": Mock(safe_value="Ethernet115/1/20"),
        "ifName": Mock(safe_value="Ethernet115/1/20"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f5"),
    },
    "528090752": {
        "ifIndex": Mock(safe_value="528090752"),
        "ifDescr": Mock(safe_value="Ethernet123/1/27"),
        "ifName": Mock(safe_value="Ethernet123/1/27"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:9c"),
    },
    "527958464": {
        "ifIndex": Mock(safe_value="527958464"),
        "ifDescr": Mock(safe_value="Ethernet121/1/8"),
        "ifName": Mock(safe_value="Ethernet121/1/8"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:89"),
    },
    "528090688": {
        "ifIndex": Mock(safe_value="528090688"),
        "ifDescr": Mock(safe_value="Ethernet123/1/26"),
        "ifName": Mock(safe_value="Ethernet123/1/26"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:9b"),
    },
    "369098852": {
        "ifIndex": Mock(safe_value="369098852"),
        "ifDescr": Mock(safe_value="port-channel101"),
        "ifName": Mock(safe_value="port-channel101"),
        "ifAlias": Mock(safe_value='"PSP6N2KC01"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8a"),
    },
    "527565952": {
        "ifIndex": Mock(safe_value="527565952"),
        "ifDescr": Mock(safe_value="Ethernet115/1/19"),
        "ifName": Mock(safe_value="Ethernet115/1/19"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f4"),
    },
    "527960064": {
        "ifIndex": Mock(safe_value="527960064"),
        "ifDescr": Mock(safe_value="Ethernet121/1/33"),
        "ifName": Mock(safe_value="Ethernet121/1/33"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a2"),
    },
    "436314112": {
        "ifIndex": Mock(safe_value="436314112"),
        "ifDescr": Mock(safe_value="Ethernet1/27"),
        "ifName": Mock(safe_value="Ethernet1/27"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:82"),
    },
    "527565888": {
        "ifIndex": Mock(safe_value="527565888"),
        "ifDescr": Mock(safe_value="Ethernet115/1/18"),
        "ifName": Mock(safe_value="Ethernet115/1/18"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f3"),
    },
    "526779328": {
        "ifIndex": Mock(safe_value="526779328"),
        "ifDescr": Mock(safe_value="Ethernet103/1/16"),
        "ifName": Mock(safe_value="Ethernet103/1/16"),
        "ifAlias": Mock(safe_value="Test Device  RE1 MGT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f1"),
    },
    "527567232": {
        "ifIndex": Mock(safe_value="527567232"),
        "ifDescr": Mock(safe_value="Ethernet115/1/39"),
        "ifName": Mock(safe_value="Ethernet115/1/39"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:08"),
    },
    "527567616": {
        "ifIndex": Mock(safe_value="527567616"),
        "ifDescr": Mock(safe_value="Ethernet115/1/45"),
        "ifName": Mock(safe_value="Ethernet115/1/45"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:0e"),
    },
    "527958144": {
        "ifIndex": Mock(safe_value="527958144"),
        "ifDescr": Mock(safe_value="Ethernet121/1/3"),
        "ifName": Mock(safe_value="Ethernet121/1/3"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:84"),
    },
    "527958272": {
        "ifIndex": Mock(safe_value="527958272"),
        "ifDescr": Mock(safe_value="Ethernet121/1/5"),
        "ifName": Mock(safe_value="Ethernet121/1/5"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:86"),
    },
    "528090880": {
        "ifIndex": Mock(safe_value="528090880"),
        "ifDescr": Mock(safe_value="Ethernet123/1/29"),
        "ifName": Mock(safe_value="Ethernet123/1/29"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:9e"),
    },
    "527566144": {
        "ifIndex": Mock(safe_value="527566144"),
        "ifDescr": Mock(safe_value="Ethernet115/1/22"),
        "ifName": Mock(safe_value="Ethernet115/1/22"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f7"),
    },
    "527958400": {
        "ifIndex": Mock(safe_value="527958400"),
        "ifDescr": Mock(safe_value="Ethernet121/1/7"),
        "ifName": Mock(safe_value="Ethernet121/1/7"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:88"),
    },
    "151061520": {
        "ifIndex": Mock(safe_value="151061520"),
        "ifDescr": Mock(safe_value="Vlan1040"),
        "ifName": Mock(safe_value="Vlan1040"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "527567488": {
        "ifIndex": Mock(safe_value="527567488"),
        "ifDescr": Mock(safe_value="Ethernet115/1/43"),
        "ifName": Mock(safe_value="Ethernet115/1/43"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:0c"),
    },
    "527566080": {
        "ifIndex": Mock(safe_value="527566080"),
        "ifDescr": Mock(safe_value="Ethernet115/1/21"),
        "ifName": Mock(safe_value="Ethernet115/1/21"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f6"),
    },
    "527567360": {
        "ifIndex": Mock(safe_value="527567360"),
        "ifDescr": Mock(safe_value="Ethernet115/1/41"),
        "ifName": Mock(safe_value="Ethernet115/1/41"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:0a"),
    },
    "151060561": {
        "ifIndex": Mock(safe_value="151060561"),
        "ifDescr": Mock(safe_value="Vlan81"),
        "ifName": Mock(safe_value="Vlan81"),
        "ifAlias": Mock(safe_value="Test Device.Trusted"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:bc"),
    },
    "527566336": {
        "ifIndex": Mock(safe_value="527566336"),
        "ifDescr": Mock(safe_value="Ethernet115/1/25"),
        "ifName": Mock(safe_value="Ethernet115/1/25"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:fa"),
    },
    "527958080": {
        "ifIndex": Mock(safe_value="527958080"),
        "ifDescr": Mock(safe_value="Ethernet121/1/2"),
        "ifName": Mock(safe_value="Ethernet121/1/2"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:83"),
    },
    "527566400": {
        "ifIndex": Mock(safe_value="527566400"),
        "ifDescr": Mock(safe_value="Ethernet115/1/26"),
        "ifName": Mock(safe_value="Ethernet115/1/26"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:fb"),
    },
    "369098866": {
        "ifIndex": Mock(safe_value="369098866"),
        "ifDescr": Mock(safe_value="port-channel115"),
        "ifName": Mock(safe_value="port-channel115"),
        "ifAlias": Mock(safe_value='"NEP6N2KC05"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="20000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:96"),
    },
    "526779456": {
        "ifIndex": Mock(safe_value="526779456"),
        "ifDescr": Mock(safe_value="Ethernet103/1/18"),
        "ifName": Mock(safe_value="Ethernet103/1/18"),
        "ifAlias": Mock(safe_value="Test Device  BI NIC 3"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f3"),
    },
    "369098762": {
        "ifIndex": Mock(safe_value="369098762"),
        "ifDescr": Mock(safe_value="port-channel11"),
        "ifName": Mock(safe_value="port-channel11"),
        "ifAlias": Mock(safe_value="Test Device  ae11"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:69"),
    },
    "528090112": {
        "ifIndex": Mock(safe_value="528090112"),
        "ifDescr": Mock(safe_value="Ethernet123/1/17"),
        "ifName": Mock(safe_value="Ethernet123/1/17"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:92"),
    },
    "527958208": {
        "ifIndex": Mock(safe_value="527958208"),
        "ifDescr": Mock(safe_value="Ethernet121/1/4"),
        "ifName": Mock(safe_value="Ethernet121/1/4"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:85"),
    },
    "528090240": {
        "ifIndex": Mock(safe_value="528090240"),
        "ifDescr": Mock(safe_value="Ethernet123/1/19"),
        "ifName": Mock(safe_value="Ethernet123/1/19"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:94"),
    },
    "526779200": {
        "ifIndex": Mock(safe_value="526779200"),
        "ifDescr": Mock(safe_value="Ethernet103/1/14"),
        "ifName": Mock(safe_value="Ethernet103/1/14"),
        "ifAlias": Mock(safe_value="Test Device  Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:ef"),
    },
    "369098862": {
        "ifIndex": Mock(safe_value="369098862"),
        "ifDescr": Mock(safe_value="port-channel111"),
        "ifName": Mock(safe_value="port-channel111"),
        "ifAlias": Mock(safe_value='"NEP6N2KC01"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:92"),
    },
    "528090432": {
        "ifIndex": Mock(safe_value="528090432"),
        "ifDescr": Mock(safe_value="Ethernet123/1/22"),
        "ifName": Mock(safe_value="Ethernet123/1/22"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:97"),
    },
    "335544320": {
        "ifIndex": Mock(safe_value="335544320"),
        "ifDescr": Mock(safe_value="loopback0"),
        "ifName": Mock(safe_value="loopback0"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="softwareLoopback"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="8000"),
        "ifPhysAddress": Mock(safe_value=""),
    },
    "527567808": {
        "ifIndex": Mock(safe_value="527567808"),
        "ifDescr": Mock(safe_value="Ethernet115/1/48"),
        "ifName": Mock(safe_value="Ethernet115/1/48"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:11"),
    },
    "527958336": {
        "ifIndex": Mock(safe_value="527958336"),
        "ifDescr": Mock(safe_value="Ethernet121/1/6"),
        "ifName": Mock(safe_value="Ethernet121/1/6"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:87"),
    },
    "527566208": {
        "ifIndex": Mock(safe_value="527566208"),
        "ifDescr": Mock(safe_value="Ethernet115/1/23"),
        "ifName": Mock(safe_value="Ethernet115/1/23"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f8"),
    },
    "526780928": {
        "ifIndex": Mock(safe_value="526780928"),
        "ifDescr": Mock(safe_value="Ethernet103/1/41"),
        "ifName": Mock(safe_value="Ethernet103/1/41"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:0a"),
    },
    "528091136": {
        "ifIndex": Mock(safe_value="528091136"),
        "ifDescr": Mock(safe_value="Ethernet123/1/33"),
        "ifName": Mock(safe_value="Ethernet123/1/33"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a2"),
    },
    "526779392": {
        "ifIndex": Mock(safe_value="526779392"),
        "ifDescr": Mock(safe_value="Ethernet103/1/17"),
        "ifName": Mock(safe_value="Ethernet103/1/17"),
        "ifAlias": Mock(safe_value="Test Device  BI NIC 3"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f2"),
    },
    "528090176": {
        "ifIndex": Mock(safe_value="528090176"),
        "ifDescr": Mock(safe_value="Ethernet123/1/18"),
        "ifName": Mock(safe_value="Ethernet123/1/18"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:93"),
    },
    "527567424": {
        "ifIndex": Mock(safe_value="527567424"),
        "ifDescr": Mock(safe_value="Ethernet115/1/42"),
        "ifName": Mock(safe_value="Ethernet115/1/42"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:0b"),
    },
    "528090304": {
        "ifIndex": Mock(safe_value="528090304"),
        "ifDescr": Mock(safe_value="Ethernet123/1/20"),
        "ifName": Mock(safe_value="Ethernet123/1/20"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:95"),
    },
    "527567680": {
        "ifIndex": Mock(safe_value="527567680"),
        "ifDescr": Mock(safe_value="Ethernet115/1/46"),
        "ifName": Mock(safe_value="Ethernet115/1/46"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:0f"),
    },
    "527565824": {
        "ifIndex": Mock(safe_value="527565824"),
        "ifDescr": Mock(safe_value="Ethernet115/1/17"),
        "ifName": Mock(safe_value="Ethernet115/1/17"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:f2"),
    },
    "527566592": {
        "ifIndex": Mock(safe_value="527566592"),
        "ifDescr": Mock(safe_value="Ethernet115/1/29"),
        "ifName": Mock(safe_value="Ethernet115/1/29"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:fe"),
    },
    "527958016": {
        "ifIndex": Mock(safe_value="527958016"),
        "ifDescr": Mock(safe_value="Ethernet121/1/1"),
        "ifName": Mock(safe_value="Ethernet121/1/1"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:82"),
    },
    "369098763": {
        "ifIndex": Mock(safe_value="369098763"),
        "ifDescr": Mock(safe_value="port-channel12"),
        "ifName": Mock(safe_value="port-channel12"),
        "ifAlias": Mock(safe_value="Test Device  Interlink"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="240000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:9d"),
    },
    "528091072": {
        "ifIndex": Mock(safe_value="528091072"),
        "ifDescr": Mock(safe_value="Ethernet123/1/32"),
        "ifName": Mock(safe_value="Ethernet123/1/32"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a1"),
    },
    "528091008": {
        "ifIndex": Mock(safe_value="528091008"),
        "ifDescr": Mock(safe_value="Ethernet123/1/31"),
        "ifName": Mock(safe_value="Ethernet123/1/31"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a0"),
    },
    "369098758": {
        "ifIndex": Mock(safe_value="369098758"),
        "ifDescr": Mock(safe_value="port-channel7"),
        "ifName": Mock(safe_value="port-channel7"),
        "ifAlias": Mock(safe_value="Test Device  ae7"),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:68"),
    },
    "528090944": {
        "ifIndex": Mock(safe_value="528090944"),
        "ifDescr": Mock(safe_value="Ethernet123/1/30"),
        "ifName": Mock(safe_value="Ethernet123/1/30"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:9f"),
    },
    "527567296": {
        "ifIndex": Mock(safe_value="527567296"),
        "ifDescr": Mock(safe_value="Ethernet115/1/40"),
        "ifName": Mock(safe_value="Ethernet115/1/40"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:09"),
    },
    "528090560": {
        "ifIndex": Mock(safe_value="528090560"),
        "ifDescr": Mock(safe_value="Ethernet123/1/24"),
        "ifName": Mock(safe_value="Ethernet123/1/24"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:99"),
    },
    "528090624": {
        "ifIndex": Mock(safe_value="528090624"),
        "ifDescr": Mock(safe_value="Ethernet123/1/25"),
        "ifName": Mock(safe_value="Ethernet123/1/25"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:9a"),
    },
    "527566528": {
        "ifIndex": Mock(safe_value="527566528"),
        "ifDescr": Mock(safe_value="Ethernet115/1/28"),
        "ifName": Mock(safe_value="Ethernet115/1/28"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:fd"),
    },
    "526779264": {
        "ifIndex": Mock(safe_value="526779264"),
        "ifDescr": Mock(safe_value="Ethernet103/1/15"),
        "ifName": Mock(safe_value="Ethernet103/1/15"),
        "ifAlias": Mock(safe_value="Test Device  RE1 MGT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f0"),
    },
    "369098874": {
        "ifIndex": Mock(safe_value="369098874"),
        "ifDescr": Mock(safe_value="port-channel123"),
        "ifName": Mock(safe_value="port-channel123"),
        "ifAlias": Mock(safe_value='"TEP6N2KC01"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:80"),
    },
    "527567552": {
        "ifIndex": Mock(safe_value="527567552"),
        "ifDescr": Mock(safe_value="Ethernet115/1/44"),
        "ifName": Mock(safe_value="Ethernet115/1/44"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:0d"),
    },
    "528090368": {
        "ifIndex": Mock(safe_value="528090368"),
        "ifDescr": Mock(safe_value="Ethernet123/1/21"),
        "ifName": Mock(safe_value="Ethernet123/1/21"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:96"),
    },
    "528090816": {
        "ifIndex": Mock(safe_value="528090816"),
        "ifDescr": Mock(safe_value="Ethernet123/1/28"),
        "ifName": Mock(safe_value="Ethernet123/1/28"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:9d"),
    },
    "369098872": {
        "ifIndex": Mock(safe_value="369098872"),
        "ifDescr": Mock(safe_value="port-channel121"),
        "ifName": Mock(safe_value="port-channel121"),
        "ifAlias": Mock(safe_value='"NENGN2KC01"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:87"),
    },
    "527566464": {
        "ifIndex": Mock(safe_value="527566464"),
        "ifDescr": Mock(safe_value="Ethernet115/1/27"),
        "ifName": Mock(safe_value="Ethernet115/1/27"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:fc"),
    },
    "528090496": {
        "ifIndex": Mock(safe_value="528090496"),
        "ifDescr": Mock(safe_value="Ethernet123/1/23"),
        "ifName": Mock(safe_value="Ethernet123/1/23"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:98"),
    },
    "369098864": {
        "ifIndex": Mock(safe_value="369098864"),
        "ifDescr": Mock(safe_value="port-channel113"),
        "ifName": Mock(safe_value="port-channel113"),
        "ifAlias": Mock(safe_value='"NEP6N2KC03"'),
        "ifType": Mock(safe_value="propVirtual"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="20000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:94"),
    },
    "527567744": {
        "ifIndex": Mock(safe_value="527567744"),
        "ifDescr": Mock(safe_value="Ethernet115/1/47"),
        "ifName": Mock(safe_value="Ethernet115/1/47"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:10"),
    },
    "526780992": {
        "ifIndex": Mock(safe_value="526780992"),
        "ifDescr": Mock(safe_value="Ethernet103/1/42"),
        "ifName": Mock(safe_value="Ethernet103/1/42"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:0b"),
    },
    "527564928": {
        "ifIndex": Mock(safe_value="527564928"),
        "ifDescr": Mock(safe_value="Ethernet115/1/3"),
        "ifName": Mock(safe_value="Ethernet115/1/3"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e4"),
    },
    "526781120": {
        "ifIndex": Mock(safe_value="526781120"),
        "ifDescr": Mock(safe_value="Ethernet103/1/44"),
        "ifName": Mock(safe_value="Ethernet103/1/44"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:0d"),
    },
    "527958592": {
        "ifIndex": Mock(safe_value="527958592"),
        "ifDescr": Mock(safe_value="Ethernet121/1/10"),
        "ifName": Mock(safe_value="Ethernet121/1/10"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:8b"),
    },
    "526781056": {
        "ifIndex": Mock(safe_value="526781056"),
        "ifDescr": Mock(safe_value="Ethernet103/1/43"),
        "ifName": Mock(safe_value="Ethernet103/1/43"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:27:0c"),
    },
    "527436288": {
        "ifIndex": Mock(safe_value="527436288"),
        "ifDescr": Mock(safe_value="Ethernet113/1/41"),
        "ifName": Mock(safe_value="Ethernet113/1/41"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ea"),
    },
    "527958656": {
        "ifIndex": Mock(safe_value="527958656"),
        "ifDescr": Mock(safe_value="Ethernet121/1/11"),
        "ifName": Mock(safe_value="Ethernet121/1/11"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:8c"),
    },
    "527436160": {
        "ifIndex": Mock(safe_value="527436160"),
        "ifDescr": Mock(safe_value="Ethernet113/1/39"),
        "ifName": Mock(safe_value="Ethernet113/1/39"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e8"),
    },
    "527958528": {
        "ifIndex": Mock(safe_value="527958528"),
        "ifDescr": Mock(safe_value="Ethernet121/1/9"),
        "ifName": Mock(safe_value="Ethernet121/1/9"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:8a"),
    },
    "527436736": {
        "ifIndex": Mock(safe_value="527436736"),
        "ifDescr": Mock(safe_value="Ethernet113/1/48"),
        "ifName": Mock(safe_value="Ethernet113/1/48"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:f1"),
    },
    "527436096": {
        "ifIndex": Mock(safe_value="527436096"),
        "ifDescr": Mock(safe_value="Ethernet113/1/38"),
        "ifName": Mock(safe_value="Ethernet113/1/38"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e7"),
    },
    "527564800": {
        "ifIndex": Mock(safe_value="527564800"),
        "ifDescr": Mock(safe_value="Ethernet115/1/1"),
        "ifName": Mock(safe_value="Ethernet115/1/1"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e2"),
    },
    "527436672": {
        "ifIndex": Mock(safe_value="527436672"),
        "ifDescr": Mock(safe_value="Ethernet113/1/47"),
        "ifName": Mock(safe_value="Ethernet113/1/47"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:f0"),
    },
    "527303168": {
        "ifIndex": Mock(safe_value="527303168"),
        "ifDescr": Mock(safe_value="Ethernet111/1/9"),
        "ifName": Mock(safe_value="Ethernet111/1/9"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:0a"),
    },
    "527958848": {
        "ifIndex": Mock(safe_value="527958848"),
        "ifDescr": Mock(safe_value="Ethernet121/1/14"),
        "ifName": Mock(safe_value="Ethernet121/1/14"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:8f"),
    },
    "527436224": {
        "ifIndex": Mock(safe_value="527436224"),
        "ifDescr": Mock(safe_value="Ethernet113/1/40"),
        "ifName": Mock(safe_value="Ethernet113/1/40"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:e9"),
    },
    "527960000": {
        "ifIndex": Mock(safe_value="527960000"),
        "ifDescr": Mock(safe_value="Ethernet121/1/32"),
        "ifName": Mock(safe_value="Ethernet121/1/32"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:a1"),
    },
    "527436608": {
        "ifIndex": Mock(safe_value="527436608"),
        "ifDescr": Mock(safe_value="Ethernet113/1/46"),
        "ifName": Mock(safe_value="Ethernet113/1/46"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ef"),
    },
    "527564992": {
        "ifIndex": Mock(safe_value="527564992"),
        "ifDescr": Mock(safe_value="Ethernet115/1/4"),
        "ifName": Mock(safe_value="Ethernet115/1/4"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e5"),
    },
    "527436544": {
        "ifIndex": Mock(safe_value="527436544"),
        "ifDescr": Mock(safe_value="Ethernet113/1/45"),
        "ifName": Mock(safe_value="Ethernet113/1/45"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ee"),
    },
    "527303296": {
        "ifIndex": Mock(safe_value="527303296"),
        "ifDescr": Mock(safe_value="Ethernet111/1/11"),
        "ifName": Mock(safe_value="Ethernet111/1/11"),
        "ifAlias": Mock(safe_value="Test Device  MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:0c"),
    },
    "527958784": {
        "ifIndex": Mock(safe_value="527958784"),
        "ifDescr": Mock(safe_value="Ethernet121/1/13"),
        "ifName": Mock(safe_value="Ethernet121/1/13"),
        "ifAlias": Mock(safe_value="Test Device "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:8e"),
    },
    "527303232": {
        "ifIndex": Mock(safe_value="527303232"),
        "ifDescr": Mock(safe_value="Ethernet111/1/10"),
        "ifName": Mock(safe_value="Ethernet111/1/10"),
        "ifAlias": Mock(safe_value="Test Device  MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:0b"),
    },
    "527566720": {
        "ifIndex": Mock(safe_value="527566720"),
        "ifDescr": Mock(safe_value="Ethernet115/1/31"),
        "ifName": Mock(safe_value="Ethernet115/1/31"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:00"),
    },
    "527436352": {
        "ifIndex": Mock(safe_value="527436352"),
        "ifDescr": Mock(safe_value="Ethernet113/1/42"),
        "ifName": Mock(safe_value="Ethernet113/1/42"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:eb"),
    },
    "527436480": {
        "ifIndex": Mock(safe_value="527436480"),
        "ifDescr": Mock(safe_value="Ethernet113/1/44"),
        "ifName": Mock(safe_value="Ethernet113/1/44"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ed"),
    },
    "527564864": {
        "ifIndex": Mock(safe_value="527564864"),
        "ifDescr": Mock(safe_value="Ethernet115/1/2"),
        "ifName": Mock(safe_value="Ethernet115/1/2"),
        "ifAlias": Mock(safe_value="Test Device  MGMT1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:45:e3"),
    },
    "527436416": {
        "ifIndex": Mock(safe_value="527436416"),
        "ifDescr": Mock(safe_value="Ethernet113/1/43"),
        "ifName": Mock(safe_value="Ethernet113/1/43"),
        "ifAlias": Mock(safe_value="Test Device  RE0 fxp0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:ec"),
    },
    "527958976": {
        "ifIndex": Mock(safe_value="527958976"),
        "ifDescr": Mock(safe_value="Ethernet121/1/16"),
        "ifName": Mock(safe_value="Ethernet121/1/16"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:91"),
    },
    "527958720": {
        "ifIndex": Mock(safe_value="527958720"),
        "ifDescr": Mock(safe_value="Ethernet121/1/12"),
        "ifName": Mock(safe_value="Ethernet121/1/12"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:8d"),
    },
    "527958912": {
        "ifIndex": Mock(safe_value="527958912"),
        "ifDescr": Mock(safe_value="Ethernet121/1/15"),
        "ifName": Mock(safe_value="Ethernet121/1/15"),
        "ifAlias": Mock(safe_value="RESTCONF"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:12:1d:90"),
    },
    "436310016": {
        "ifIndex": Mock(safe_value="436310016"),
        "ifDescr": Mock(safe_value="Ethernet1/26"),
        "ifName": Mock(safe_value="Ethernet1/26"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:81"),
    },
    "526778944": {
        "ifIndex": Mock(safe_value="526778944"),
        "ifDescr": Mock(safe_value="Ethernet103/1/10"),
        "ifName": Mock(safe_value="Ethernet103/1/10"),
        "ifAlias": Mock(safe_value="Test Device  Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:eb"),
    },
    "526779904": {
        "ifIndex": Mock(safe_value="526779904"),
        "ifDescr": Mock(safe_value="Ethernet103/1/25"),
        "ifName": Mock(safe_value="Ethernet103/1/25"),
        "ifAlias": Mock(safe_value="Test Device  MGT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:fa"),
    },
    "526779008": {
        "ifIndex": Mock(safe_value="526779008"),
        "ifDescr": Mock(safe_value="Ethernet103/1/11"),
        "ifName": Mock(safe_value="Ethernet103/1/11"),
        "ifAlias": Mock(safe_value="Test Device  Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:ec"),
    },
    "436260864": {
        "ifIndex": Mock(safe_value="436260864"),
        "ifDescr": Mock(safe_value="Ethernet1/14"),
        "ifName": Mock(safe_value="Ethernet1/14"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:75"),
    },
    "436305920": {
        "ifIndex": Mock(safe_value="436305920"),
        "ifDescr": Mock(safe_value="Ethernet1/25"),
        "ifName": Mock(safe_value="Ethernet1/25"),
        "ifAlias": Mock(safe_value='"TEP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:80"),
    },
    "528090048": {
        "ifIndex": Mock(safe_value="528090048"),
        "ifDescr": Mock(safe_value="Ethernet123/1/16"),
        "ifName": Mock(safe_value="Ethernet123/1/16"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:91"),
    },
    "436277248": {
        "ifIndex": Mock(safe_value="436277248"),
        "ifDescr": Mock(safe_value="Ethernet1/18"),
        "ifName": Mock(safe_value="Ethernet1/18"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:79"),
    },
    "528089728": {
        "ifIndex": Mock(safe_value="528089728"),
        "ifDescr": Mock(safe_value="Ethernet123/1/11"),
        "ifName": Mock(safe_value="Ethernet123/1/11"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:8c"),
    },
    "528089152": {
        "ifIndex": Mock(safe_value="528089152"),
        "ifDescr": Mock(safe_value="Ethernet123/1/2"),
        "ifName": Mock(safe_value="Ethernet123/1/2"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:83"),
    },
    "527566912": {
        "ifIndex": Mock(safe_value="527566912"),
        "ifDescr": Mock(safe_value="Ethernet115/1/34"),
        "ifName": Mock(safe_value="Ethernet115/1/34"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:03"),
    },
    "436256768": {
        "ifIndex": Mock(safe_value="436256768"),
        "ifDescr": Mock(safe_value="Ethernet1/13"),
        "ifName": Mock(safe_value="Ethernet1/13"),
        "ifAlias": Mock(safe_value='"PSP6DSRJ03 xe-0/3/0"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:74"),
    },
    "526778752": {
        "ifIndex": Mock(safe_value="526778752"),
        "ifDescr": Mock(safe_value="Ethernet103/1/7"),
        "ifName": Mock(safe_value="Ethernet103/1/7"),
        "ifAlias": Mock(safe_value="Test Device  Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e8"),
    },
    "527566976": {
        "ifIndex": Mock(safe_value="527566976"),
        "ifDescr": Mock(safe_value="Ethernet115/1/35"),
        "ifName": Mock(safe_value="Ethernet115/1/35"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:04"),
    },
    "526779072": {
        "ifIndex": Mock(safe_value="526779072"),
        "ifDescr": Mock(safe_value="Ethernet103/1/12"),
        "ifName": Mock(safe_value="Ethernet103/1/12"),
        "ifAlias": Mock(safe_value="Test Device  Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:ed"),
    },
    "436244480": {
        "ifIndex": Mock(safe_value="436244480"),
        "ifDescr": Mock(safe_value="Ethernet1/10"),
        "ifName": Mock(safe_value="Ethernet1/10"),
        "ifAlias": Mock(safe_value='"PSP6REGFW02 xe-1/0/0"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:71"),
    },
    "436318208": {
        "ifIndex": Mock(safe_value="436318208"),
        "ifDescr": Mock(safe_value="Ethernet1/28"),
        "ifName": Mock(safe_value="Ethernet1/28"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:83"),
    },
    "528089408": {
        "ifIndex": Mock(safe_value="528089408"),
        "ifDescr": Mock(safe_value="Ethernet123/1/6"),
        "ifName": Mock(safe_value="Ethernet123/1/6"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:87"),
    },
    "436236288": {
        "ifIndex": Mock(safe_value="436236288"),
        "ifDescr": Mock(safe_value="Ethernet1/8"),
        "ifName": Mock(safe_value="Ethernet1/8"),
        "ifAlias": Mock(safe_value="Test Device.UNTRUSTED.WIFI"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:6f"),
    },
    "528089472": {
        "ifIndex": Mock(safe_value="528089472"),
        "ifDescr": Mock(safe_value="Ethernet123/1/7"),
        "ifName": Mock(safe_value="Ethernet123/1/7"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:88"),
    },
    "527567040": {
        "ifIndex": Mock(safe_value="527567040"),
        "ifDescr": Mock(safe_value="Ethernet115/1/36"),
        "ifName": Mock(safe_value="Ethernet115/1/36"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:05"),
    },
    "528091200": {
        "ifIndex": Mock(safe_value="528091200"),
        "ifDescr": Mock(safe_value="Ethernet123/1/34"),
        "ifName": Mock(safe_value="Ethernet123/1/34"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a3"),
    },
    "528089984": {
        "ifIndex": Mock(safe_value="528089984"),
        "ifDescr": Mock(safe_value="Ethernet123/1/15"),
        "ifName": Mock(safe_value="Ethernet123/1/15"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:90"),
    },
    "436215808": {
        "ifIndex": Mock(safe_value="436215808"),
        "ifDescr": Mock(safe_value="Ethernet1/3"),
        "ifName": Mock(safe_value="Ethernet1/3"),
        "ifAlias": Mock(safe_value="Test Device  xe-1/1/3"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:6a"),
    },
    "526778816": {
        "ifIndex": Mock(safe_value="526778816"),
        "ifDescr": Mock(safe_value="Ethernet103/1/8"),
        "ifName": Mock(safe_value="Ethernet103/1/8"),
        "ifAlias": Mock(safe_value="Test Device  Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e9"),
    },
    "436289536": {
        "ifIndex": Mock(safe_value="436289536"),
        "ifDescr": Mock(safe_value="Ethernet1/21"),
        "ifName": Mock(safe_value="Ethernet1/21"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:7c"),
    },
    "436232192": {
        "ifIndex": Mock(safe_value="436232192"),
        "ifDescr": Mock(safe_value="Ethernet1/7"),
        "ifName": Mock(safe_value="Ethernet1/7"),
        "ifAlias": Mock(safe_value="Test Device.NEP6DXCSC9372PX01"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:6e"),
    },
    "436273152": {
        "ifIndex": Mock(safe_value="436273152"),
        "ifDescr": Mock(safe_value="Ethernet1/17"),
        "ifName": Mock(safe_value="Ethernet1/17"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:78"),
    },
    "528089856": {
        "ifIndex": Mock(safe_value="528089856"),
        "ifDescr": Mock(safe_value="Ethernet123/1/13"),
        "ifName": Mock(safe_value="Ethernet123/1/13"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:8e"),
    },
    "526778688": {
        "ifIndex": Mock(safe_value="526778688"),
        "ifDescr": Mock(safe_value="Ethernet103/1/6"),
        "ifName": Mock(safe_value="Ethernet103/1/6"),
        "ifAlias": Mock(safe_value="Test Device Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e7"),
    },
    "528089792": {
        "ifIndex": Mock(safe_value="528089792"),
        "ifDescr": Mock(safe_value="Ethernet123/1/12"),
        "ifName": Mock(safe_value="Ethernet123/1/12"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:8d"),
    },
    "527566848": {
        "ifIndex": Mock(safe_value="527566848"),
        "ifDescr": Mock(safe_value="Ethernet115/1/33"),
        "ifName": Mock(safe_value="Ethernet115/1/33"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:02"),
    },
    "528089920": {
        "ifIndex": Mock(safe_value="528089920"),
        "ifDescr": Mock(safe_value="Ethernet123/1/14"),
        "ifName": Mock(safe_value="Ethernet123/1/14"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:8f"),
    },
    "528089344": {
        "ifIndex": Mock(safe_value="528089344"),
        "ifDescr": Mock(safe_value="Ethernet123/1/5"),
        "ifName": Mock(safe_value="Ethernet123/1/5"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:86"),
    },
    "526779840": {
        "ifIndex": Mock(safe_value="526779840"),
        "ifDescr": Mock(safe_value="Ethernet103/1/24"),
        "ifName": Mock(safe_value="Ethernet103/1/24"),
        "ifAlias": Mock(safe_value="Test Device RSP1-MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f9"),
    },
    "526778880": {
        "ifIndex": Mock(safe_value="526778880"),
        "ifDescr": Mock(safe_value="Ethernet103/1/9"),
        "ifName": Mock(safe_value="Ethernet103/1/9"),
        "ifAlias": Mock(safe_value="Test Device Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:ea"),
    },
    "526778368": {
        "ifIndex": Mock(safe_value="526778368"),
        "ifDescr": Mock(safe_value="Ethernet103/1/1"),
        "ifName": Mock(safe_value="Ethernet103/1/1"),
        "ifAlias": Mock(safe_value="Test Device RE0 MGT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e2"),
    },
    "436297728": {
        "ifIndex": Mock(safe_value="436297728"),
        "ifDescr": Mock(safe_value="Ethernet1/23"),
        "ifName": Mock(safe_value="Ethernet1/23"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:7e"),
    },
    "436228096": {
        "ifIndex": Mock(safe_value="436228096"),
        "ifDescr": Mock(safe_value="Ethernet1/6"),
        "ifName": Mock(safe_value="Ethernet1/6"),
        "ifAlias": Mock(safe_value="Test Device.TRUSTED.1/22"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:6d"),
    },
    "436219904": {
        "ifIndex": Mock(safe_value="436219904"),
        "ifDescr": Mock(safe_value="Ethernet1/4"),
        "ifName": Mock(safe_value="Ethernet1/4"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:6b"),
    },
    "527567104": {
        "ifIndex": Mock(safe_value="527567104"),
        "ifDescr": Mock(safe_value="Ethernet115/1/37"),
        "ifName": Mock(safe_value="Ethernet115/1/37"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:06"),
    },
    "437198848": {
        "ifIndex": Mock(safe_value="437198848"),
        "ifDescr": Mock(safe_value="Ethernet2/3"),
        "ifName": Mock(safe_value="Ethernet2/3"),
        "ifAlias": Mock(safe_value="Test Device Eth2/3"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:9a"),
    },
    "437202944": {
        "ifIndex": Mock(safe_value="437202944"),
        "ifDescr": Mock(safe_value="Ethernet2/4"),
        "ifName": Mock(safe_value="Ethernet2/4"),
        "ifAlias": Mock(safe_value="Test Device Eth2/4"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="40000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:9b"),
    },
    "436264960": {
        "ifIndex": Mock(safe_value="436264960"),
        "ifDescr": Mock(safe_value="Ethernet1/15"),
        "ifName": Mock(safe_value="Ethernet1/15"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:76"),
    },
    "436281344": {
        "ifIndex": Mock(safe_value="436281344"),
        "ifDescr": Mock(safe_value="Ethernet1/19"),
        "ifName": Mock(safe_value="Ethernet1/19"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:7a"),
    },
    "527566784": {
        "ifIndex": Mock(safe_value="527566784"),
        "ifDescr": Mock(safe_value="Ethernet115/1/32"),
        "ifName": Mock(safe_value="Ethernet115/1/32"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:01"),
    },
    "526778624": {
        "ifIndex": Mock(safe_value="526778624"),
        "ifDescr": Mock(safe_value="Ethernet103/1/5"),
        "ifName": Mock(safe_value="Ethernet103/1/5"),
        "ifAlias": Mock(safe_value="Test Device Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e6"),
    },
    "436293632": {
        "ifIndex": Mock(safe_value="436293632"),
        "ifDescr": Mock(safe_value="Ethernet1/22"),
        "ifName": Mock(safe_value="Ethernet1/22"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:7d"),
    },
    "436252672": {
        "ifIndex": Mock(safe_value="436252672"),
        "ifDescr": Mock(safe_value="Ethernet1/12"),
        "ifName": Mock(safe_value="Ethernet1/12"),
        "ifAlias": Mock(safe_value='"PSP6DSRJ01 xe-0/3/0"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:73"),
    },
    "526779136": {
        "ifIndex": Mock(safe_value="526779136"),
        "ifDescr": Mock(safe_value="Ethernet103/1/13"),
        "ifName": Mock(safe_value="Ethernet103/1/13"),
        "ifAlias": Mock(safe_value="Test Device Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:ee"),
    },
    "528089216": {
        "ifIndex": Mock(safe_value="528089216"),
        "ifDescr": Mock(safe_value="Ethernet123/1/3"),
        "ifName": Mock(safe_value="Ethernet123/1/3"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:84"),
    },
    "436240384": {
        "ifIndex": Mock(safe_value="436240384"),
        "ifDescr": Mock(safe_value="Ethernet1/9"),
        "ifName": Mock(safe_value="Ethernet1/9"),
        "ifAlias": Mock(safe_value="Test Device.TRUSTED.WIFI"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:70"),
    },
    "436285440": {
        "ifIndex": Mock(safe_value="436285440"),
        "ifDescr": Mock(safe_value="Ethernet1/20"),
        "ifName": Mock(safe_value="Ethernet1/20"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:7b"),
    },
    "528089536": {
        "ifIndex": Mock(safe_value="528089536"),
        "ifDescr": Mock(safe_value="Ethernet123/1/8"),
        "ifName": Mock(safe_value="Ethernet123/1/8"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:89"),
    },
    "436224000": {
        "ifIndex": Mock(safe_value="436224000"),
        "ifDescr": Mock(safe_value="Ethernet1/5"),
        "ifName": Mock(safe_value="Ethernet1/5"),
        "ifAlias": Mock(safe_value="Test Device.UNTRUSTED.1/21"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:6c"),
    },
    "526778432": {
        "ifIndex": Mock(safe_value="526778432"),
        "ifDescr": Mock(safe_value="Ethernet103/1/2"),
        "ifName": Mock(safe_value="Ethernet103/1/2"),
        "ifAlias": Mock(safe_value="Test Device RE0 MGT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e3"),
    },
    "526778560": {
        "ifIndex": Mock(safe_value="526778560"),
        "ifDescr": Mock(safe_value="Ethernet103/1/4"),
        "ifName": Mock(safe_value="Ethernet103/1/4"),
        "ifAlias": Mock(safe_value="Test Device Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e5"),
    },
    "528091264": {
        "ifIndex": Mock(safe_value="528091264"),
        "ifDescr": Mock(safe_value="Ethernet123/1/35"),
        "ifName": Mock(safe_value="Ethernet123/1/35"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:a4"),
    },
    "436248576": {
        "ifIndex": Mock(safe_value="436248576"),
        "ifDescr": Mock(safe_value="Ethernet1/11"),
        "ifName": Mock(safe_value="Ethernet1/11"),
        "ifAlias": Mock(safe_value='"PSP6REGFW01 xe-1/0/0"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:72"),
    },
    "527567168": {
        "ifIndex": Mock(safe_value="527567168"),
        "ifDescr": Mock(safe_value="Ethernet115/1/38"),
        "ifName": Mock(safe_value="Ethernet115/1/38"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="00:da:55:ec:46:07"),
    },
    "526778496": {
        "ifIndex": Mock(safe_value="526778496"),
        "ifDescr": Mock(safe_value="Ethernet103/1/3"),
        "ifName": Mock(safe_value="Ethernet103/1/3"),
        "ifAlias": Mock(safe_value="Test Device Mgmt0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:e4"),
    },
    "528089280": {
        "ifIndex": Mock(safe_value="528089280"),
        "ifDescr": Mock(safe_value="Ethernet123/1/4"),
        "ifName": Mock(safe_value="Ethernet123/1/4"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="58:0a:20:97:af:85"),
    },
    "436301824": {
        "ifIndex": Mock(safe_value="436301824"),
        "ifDescr": Mock(safe_value="Ethernet1/24"),
        "ifName": Mock(safe_value="Ethernet1/24"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:7f"),
    },
    "436269056": {
        "ifIndex": Mock(safe_value="436269056"),
        "ifDescr": Mock(safe_value="Ethernet1/16"),
        "ifName": Mock(safe_value="Ethernet1/16"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:77"),
    },
    "527304768": {
        "ifIndex": Mock(safe_value="527304768"),
        "ifDescr": Mock(safe_value="Ethernet111/1/34"),
        "ifName": Mock(safe_value="Ethernet111/1/34"),
        "ifAlias": Mock(safe_value="Test Device-1 RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:23"),
    },
    "436326400": {
        "ifIndex": Mock(safe_value="436326400"),
        "ifDescr": Mock(safe_value="Ethernet1/30"),
        "ifName": Mock(safe_value="Ethernet1/30"),
        "ifAlias": Mock(safe_value='"NENGN2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:85"),
    },
    "436359168": {
        "ifIndex": Mock(safe_value="436359168"),
        "ifDescr": Mock(safe_value="Ethernet1/38"),
        "ifName": Mock(safe_value="Ethernet1/38"),
        "ifAlias": Mock(safe_value='"PSP6N2KC03"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8d"),
    },
    "527305024": {
        "ifIndex": Mock(safe_value="527305024"),
        "ifDescr": Mock(safe_value="Ethernet111/1/38"),
        "ifName": Mock(safe_value="Ethernet111/1/38"),
        "ifAlias": Mock(safe_value="Test Device RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:27"),
    },
    "527305280": {
        "ifIndex": Mock(safe_value="527305280"),
        "ifDescr": Mock(safe_value="Ethernet111/1/42"),
        "ifName": Mock(safe_value="Ethernet111/1/42"),
        "ifAlias": Mock(safe_value="Test Device mgmt"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:2b"),
    },
    "527304576": {
        "ifIndex": Mock(safe_value="527304576"),
        "ifDescr": Mock(safe_value="Ethernet111/1/31"),
        "ifName": Mock(safe_value="Ethernet111/1/31"),
        "ifAlias": Mock(safe_value="Test Device RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:20"),
    },
    "436383744": {
        "ifIndex": Mock(safe_value="436383744"),
        "ifDescr": Mock(safe_value="Ethernet1/44"),
        "ifName": Mock(safe_value="Ethernet1/44"),
        "ifAlias": Mock(safe_value='"NEP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:93"),
    },
    "527304704": {
        "ifIndex": Mock(safe_value="527304704"),
        "ifDescr": Mock(safe_value="Ethernet111/1/33"),
        "ifName": Mock(safe_value="Ethernet111/1/33"),
        "ifAlias": Mock(safe_value="Test Device Mgmt"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:22"),
    },
    "436396032": {
        "ifIndex": Mock(safe_value="436396032"),
        "ifDescr": Mock(safe_value="Ethernet1/47"),
        "ifName": Mock(safe_value="Ethernet1/47"),
        "ifAlias": Mock(safe_value='"NEP6N2KC05"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:96"),
    },
    "527305472": {
        "ifIndex": Mock(safe_value="527305472"),
        "ifDescr": Mock(safe_value="Ethernet111/1/45"),
        "ifName": Mock(safe_value="Ethernet111/1/45"),
        "ifAlias": Mock(safe_value="Test Device-112.14.2 RE1"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:2e"),
    },
    "527304896": {
        "ifIndex": Mock(safe_value="527304896"),
        "ifDescr": Mock(safe_value="Ethernet111/1/36"),
        "ifName": Mock(safe_value="Ethernet111/1/36"),
        "ifAlias": Mock(safe_value="Test Device MGMT"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:25"),
    },
    "527433728": {
        "ifIndex": Mock(safe_value="527433728"),
        "ifDescr": Mock(safe_value="Ethernet113/1/1"),
        "ifName": Mock(safe_value="Ethernet113/1/1"),
        "ifAlias": Mock(safe_value="Test Device ETH"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c2"),
    },
    "436334592": {
        "ifIndex": Mock(safe_value="436334592"),
        "ifDescr": Mock(safe_value="Ethernet1/32"),
        "ifName": Mock(safe_value="Ethernet1/32"),
        "ifAlias": Mock(safe_value='"NENGN2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:87"),
    },
    "526779712": {
        "ifIndex": Mock(safe_value="526779712"),
        "ifDescr": Mock(safe_value="Ethernet103/1/22"),
        "ifName": Mock(safe_value="Ethernet103/1/22"),
        "ifAlias": Mock(safe_value="Test Device RSP1-MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f7"),
    },
    "526779520": {
        "ifIndex": Mock(safe_value="526779520"),
        "ifDescr": Mock(safe_value="Ethernet103/1/19"),
        "ifName": Mock(safe_value="Ethernet103/1/19"),
        "ifAlias": Mock(safe_value="Test Device BI NIC 3"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f4"),
    },
    "436387840": {
        "ifIndex": Mock(safe_value="436387840"),
        "ifDescr": Mock(safe_value="Ethernet1/45"),
        "ifName": Mock(safe_value="Ethernet1/45"),
        "ifAlias": Mock(safe_value='"NEP6N2KC03"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:94"),
    },
    "527305408": {
        "ifIndex": Mock(safe_value="527305408"),
        "ifDescr": Mock(safe_value="Ethernet111/1/44"),
        "ifName": Mock(safe_value="Ethernet111/1/44"),
        "ifAlias": Mock(safe_value="Test Device-112.14.2 RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:2d"),
    },
    "436342784": {
        "ifIndex": Mock(safe_value="436342784"),
        "ifDescr": Mock(safe_value="Ethernet1/34"),
        "ifName": Mock(safe_value="Ethernet1/34"),
        "ifAlias": Mock(safe_value='"PSP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:89"),
    },
    "436355072": {
        "ifIndex": Mock(safe_value="436355072"),
        "ifDescr": Mock(safe_value="Ethernet1/37"),
        "ifName": Mock(safe_value="Ethernet1/37"),
        "ifAlias": Mock(safe_value='"PSP6N2KC03"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8c"),
    },
    "527305216": {
        "ifIndex": Mock(safe_value="527305216"),
        "ifDescr": Mock(safe_value="Ethernet111/1/41"),
        "ifName": Mock(safe_value="Ethernet111/1/41"),
        "ifAlias": Mock(safe_value="Test Device RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:2a"),
    },
    "527433856": {
        "ifIndex": Mock(safe_value="527433856"),
        "ifDescr": Mock(safe_value="Ethernet113/1/3"),
        "ifName": Mock(safe_value="Ethernet113/1/3"),
        "ifAlias": Mock(safe_value="Test Device"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c4"),
    },
    "527305344": {
        "ifIndex": Mock(safe_value="527305344"),
        "ifDescr": Mock(safe_value="Ethernet111/1/43"),
        "ifName": Mock(safe_value="Ethernet111/1/43"),
        "ifAlias": Mock(safe_value="Test Device mgmt"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:2c"),
    },
    "527305152": {
        "ifIndex": Mock(safe_value="527305152"),
        "ifDescr": Mock(safe_value="Ethernet111/1/40"),
        "ifName": Mock(safe_value="Ethernet111/1/40"),
        "ifAlias": Mock(safe_value="Test Device RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:29"),
    },
    "526779584": {
        "ifIndex": Mock(safe_value="526779584"),
        "ifDescr": Mock(safe_value="Ethernet103/1/20"),
        "ifName": Mock(safe_value="Ethernet103/1/20"),
        "ifAlias": Mock(safe_value="Test Device MGT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="100"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f5"),
    },
    "527433920": {
        "ifIndex": Mock(safe_value="527433920"),
        "ifDescr": Mock(safe_value="Ethernet113/1/4"),
        "ifName": Mock(safe_value="Ethernet113/1/4"),
        "ifAlias": Mock(safe_value="Test Device"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c5"),
    },
    "527305088": {
        "ifIndex": Mock(safe_value="527305088"),
        "ifDescr": Mock(safe_value="Ethernet111/1/39"),
        "ifName": Mock(safe_value="Ethernet111/1/39"),
        "ifAlias": Mock(safe_value="Test Device RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:28"),
    },
    "527304832": {
        "ifIndex": Mock(safe_value="527304832"),
        "ifDescr": Mock(safe_value="Ethernet111/1/35"),
        "ifName": Mock(safe_value="Ethernet111/1/35"),
        "ifAlias": Mock(safe_value="Test Device-2 RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:24"),
    },
    "527305536": {
        "ifIndex": Mock(safe_value="527305536"),
        "ifDescr": Mock(safe_value="Ethernet111/1/46"),
        "ifName": Mock(safe_value="Ethernet111/1/46"),
        "ifAlias": Mock(safe_value="Test Device MGMT0 "),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:2f"),
    },
    "527433792": {
        "ifIndex": Mock(safe_value="527433792"),
        "ifDescr": Mock(safe_value="Ethernet113/1/2"),
        "ifName": Mock(safe_value="Ethernet113/1/2"),
        "ifAlias": Mock(safe_value="Test Device ETH"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:c3"),
    },
    "436338688": {
        "ifIndex": Mock(safe_value="436338688"),
        "ifDescr": Mock(safe_value="Ethernet1/33"),
        "ifName": Mock(safe_value="Ethernet1/33"),
        "ifAlias": Mock(safe_value='"PSP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:88"),
    },
    "436363264": {
        "ifIndex": Mock(safe_value="436363264"),
        "ifDescr": Mock(safe_value="Ethernet1/39"),
        "ifName": Mock(safe_value="Ethernet1/39"),
        "ifAlias": Mock(safe_value='"PSP6N2KC03"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8e"),
    },
    "527435520": {
        "ifIndex": Mock(safe_value="527435520"),
        "ifDescr": Mock(safe_value="Ethernet113/1/29"),
        "ifName": Mock(safe_value="Ethernet113/1/29"),
        "ifAlias": Mock(safe_value=""),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="cc:d8:c1:59:01:de"),
    },
    "527304448": {
        "ifIndex": Mock(safe_value="527304448"),
        "ifDescr": Mock(safe_value="Ethernet111/1/29"),
        "ifName": Mock(safe_value="Ethernet111/1/29"),
        "ifAlias": Mock(safe_value="Test Device RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:1e"),
    },
    "527304384": {
        "ifIndex": Mock(safe_value="527304384"),
        "ifDescr": Mock(safe_value="Ethernet111/1/28"),
        "ifName": Mock(safe_value="Ethernet111/1/28"),
        "ifAlias": Mock(safe_value="Test Device RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:1d"),
    },
    "436379648": {
        "ifIndex": Mock(safe_value="436379648"),
        "ifDescr": Mock(safe_value="Ethernet1/43"),
        "ifName": Mock(safe_value="Ethernet1/43"),
        "ifAlias": Mock(safe_value='"NEP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:92"),
    },
    "436391936": {
        "ifIndex": Mock(safe_value="436391936"),
        "ifDescr": Mock(safe_value="Ethernet1/46"),
        "ifName": Mock(safe_value="Ethernet1/46"),
        "ifAlias": Mock(safe_value='"NEP6N2KC03"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:95"),
    },
    "436371456": {
        "ifIndex": Mock(safe_value="436371456"),
        "ifDescr": Mock(safe_value="Ethernet1/41"),
        "ifName": Mock(safe_value="Ethernet1/41"),
        "ifAlias": Mock(safe_value='"NEP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:90"),
    },
    "527305600": {
        "ifIndex": Mock(safe_value="527305600"),
        "ifDescr": Mock(safe_value="Ethernet111/1/47"),
        "ifName": Mock(safe_value="Ethernet111/1/47"),
        "ifAlias": Mock(safe_value="Test Device RE0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:30"),
    },
    "527304640": {
        "ifIndex": Mock(safe_value="527304640"),
        "ifDescr": Mock(safe_value="Ethernet111/1/32"),
        "ifName": Mock(safe_value="Ethernet111/1/32"),
        "ifAlias": Mock(safe_value="Test Device Mgmt"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:21"),
    },
    "436330496": {
        "ifIndex": Mock(safe_value="436330496"),
        "ifDescr": Mock(safe_value="Ethernet1/31"),
        "ifName": Mock(safe_value="Ethernet1/31"),
        "ifAlias": Mock(safe_value='"NENGN2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:86"),
    },
    "526779648": {
        "ifIndex": Mock(safe_value="526779648"),
        "ifDescr": Mock(safe_value="Ethernet103/1/21"),
        "ifName": Mock(safe_value="Ethernet103/1/21"),
        "ifAlias": Mock(safe_value="Test Device RSP0-MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f6"),
    },
    "436322304": {
        "ifIndex": Mock(safe_value="436322304"),
        "ifDescr": Mock(safe_value="Ethernet1/29"),
        "ifName": Mock(safe_value="Ethernet1/29"),
        "ifAlias": Mock(safe_value='"NENGN2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:84"),
    },
    "436367360": {
        "ifIndex": Mock(safe_value="436367360"),
        "ifDescr": Mock(safe_value="Ethernet1/40"),
        "ifName": Mock(safe_value="Ethernet1/40"),
        "ifAlias": Mock(safe_value='"PSP6N2KC03"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8f"),
    },
    "527305664": {
        "ifIndex": Mock(safe_value="527305664"),
        "ifDescr": Mock(safe_value="Ethernet111/1/48"),
        "ifName": Mock(safe_value="Ethernet111/1/48"),
        "ifAlias": Mock(safe_value="Test Device"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:31"),
    },
    "436346880": {
        "ifIndex": Mock(safe_value="436346880"),
        "ifDescr": Mock(safe_value="Ethernet1/35"),
        "ifName": Mock(safe_value="Ethernet1/35"),
        "ifAlias": Mock(safe_value='"PSP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8a"),
    },
    "436375552": {
        "ifIndex": Mock(safe_value="436375552"),
        "ifDescr": Mock(safe_value="Ethernet1/42"),
        "ifName": Mock(safe_value="Ethernet1/42"),
        "ifAlias": Mock(safe_value='"NEP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:91"),
    },
    "526779776": {
        "ifIndex": Mock(safe_value="526779776"),
        "ifDescr": Mock(safe_value="Ethernet103/1/23"),
        "ifName": Mock(safe_value="Ethernet103/1/23"),
        "ifAlias": Mock(safe_value="Test Device RSP0-MGMT0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="a0:55:4f:a1:26:f8"),
    },
    "436350976": {
        "ifIndex": Mock(safe_value="436350976"),
        "ifDescr": Mock(safe_value="Ethernet1/36"),
        "ifName": Mock(safe_value="Ethernet1/36"),
        "ifAlias": Mock(safe_value='"PSP6N2KC01"'),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="10000"),
        "ifPhysAddress": Mock(safe_value="8c:60:4f:91:9a:8b"),
    },
    "527302720": {
        "ifIndex": Mock(safe_value="527302720"),
        "ifDescr": Mock(safe_value="Ethernet111/1/2"),
        "ifName": Mock(safe_value="Ethernet111/1/2"),
        "ifAlias": Mock(safe_value="Test Device Eth0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:03"),
    },
    "527304512": {
        "ifIndex": Mock(safe_value="527304512"),
        "ifDescr": Mock(safe_value="Ethernet111/1/30"),
        "ifName": Mock(safe_value="Ethernet111/1/30"),
        "ifAlias": Mock(safe_value="Test Device RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="1000"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:1f"),
    },
    "527304960": {
        "ifIndex": Mock(safe_value="527304960"),
        "ifDescr": Mock(safe_value="Ethernet111/1/37"),
        "ifName": Mock(safe_value="Ethernet111/1/37"),
        "ifAlias": Mock(safe_value="Test Device RSP0"),
        "ifType": Mock(safe_value="ethernetCsmacd"),
        "ifMtu": Mock(safe_value="1500"),
        "ifHighSpeed": Mock(safe_value="0"),
        "ifPhysAddress": Mock(safe_value="bc:c4:93:11:a3:26"),
    },
}
