# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class AccountResource(Resource):
    """
    The Batch account information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param account_endpoint: The endpoint used by this account to obtain
     Batch services.
    :type account_endpoint: str
    :param provisioning_state: The provisioned state of the resource.
     Possible values include: 'Invalid', 'Creating', 'Deleting', 'Succeeded',
     'Failed', 'Cancelled'
    :type provisioning_state: str
    :param auto_storage: The properties and status of any auto storage
     associated with the account.
    :type auto_storage: :class:`AutoStorageProperties
     <azure.mgmt.batch.models.AutoStorageProperties>`
    :param core_quota: The core quota for this Batch account.
    :type core_quota: int
    :param pool_quota: The pool quota for this Batch account.
    :type pool_quota: int
    :param active_job_and_job_schedule_quota: The active job and job schedule
     quota for this Batch account.
    :type active_job_and_job_schedule_quota: int
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'account_endpoint': {'key': 'properties.accountEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'AccountProvisioningState'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageProperties'},
        'core_quota': {'key': 'properties.coreQuota', 'type': 'int'},
        'pool_quota': {'key': 'properties.poolQuota', 'type': 'int'},
        'active_job_and_job_schedule_quota': {'key': 'properties.activeJobAndJobScheduleQuota', 'type': 'int'},
    }

    def __init__(self, location=None, tags=None, account_endpoint=None, provisioning_state=None, auto_storage=None, core_quota=None, pool_quota=None, active_job_and_job_schedule_quota=None):
        super(AccountResource, self).__init__(location=location, tags=tags)
        self.account_endpoint = account_endpoint
        self.provisioning_state = provisioning_state
        self.auto_storage = auto_storage
        self.core_quota = core_quota
        self.pool_quota = pool_quota
        self.active_job_and_job_schedule_quota = active_job_and_job_schedule_quota
