VERSION = "$Id: grOutput.py,v 1.2 2008/09/20 00:53:23 pletzer Exp $"

"""
Write response matric data

"""

import time

class Output:

    def __init__(self, filename, args):
        """
        Constructor
        """
        self.f = file(filename, 'w')
        print >>self.f, "# generated by '%s'" % args
        print >>self.f, "# version %s" % VERSION
        import time
        print >>self.f, '# on %s' % time.asctime()

    def write(self, nTor, A, strIndices):
        """
        Write matrix to file
        """
        nCols = 8
        print >>self.f,'name=%s nTor=%d sizes=[%d,%d] ' % \
          ('A'+strIndices, nTor, A.shape[0], A.shape[1]),
        descr = 'response matrix lambda(nod%s)/d lambda(seg%s)/dn' \
                % (strIndices[0], strIndices[1])
        print >>self.f,'descr="%s"' % descr
        nElems = len(A.flat)
        nRows = nElems // nCols
        for ir in range(nRows):
            print >>self.f, ('%12e ')*nCols % \
              tuple(A.flat[ir*nCols:(ir+1)*nCols].flat)
        nRemd = nElems - nRows*nCols
        # last line
        print >>self.f, ('%12e ')*nRemd  % \
              tuple(A.flat[nRows*nCols:].flat)
    
