#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Part of the PsychoPy library
# Copyright (C) 2018 Jonathan Peirce
# Distributed under the terms of the GNU General Public License (GPL).

"""Data useful for calibrations (Smith-Pokorny cone fundamentals etc...)
"""
from __future__ import absolute_import, print_function

import numpy

# 380 to 780 inclusive with 5nm steps
wavelength_5nm = numpy.arange(380, 785, 5)
juddVosXYZ1976_5nm = numpy.asarray([
    [0.003, 0.005, 0.011, 0.021, 0.038, 0.063, 0.100, 0.158, 0.229, 0.281,
     0.311, 0.331, 0.333, 0.317, 0.289, 0.260, 0.233, 0.210, 0.175, 0.133,
     0.092, 0.057, 0.032, 0.015, 0.005, 0.002, 0.009, 0.029, 0.064, 0.111,
     0.167, 0.228, 0.293, 0.362, 0.436, 0.515, 0.597, 0.681, 0.764, 0.844,
     0.916, 0.977, 1.023, 1.051, 1.055, 1.036, 0.992, 0.929, 0.843, 0.740,
     0.633, 0.534, 0.441, 0.355, 0.279, 0.215, 0.162, 0.118, 0.086, 0.063,
     0.046, 0.032, 0.022, 0.016, 0.011, 0.008, 0.006, 0.004, 0.003, 0.002,
     0.001, 0.001, 0.001, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     0.000],
    [0.000, 0.000, 0.001, 0.002, 0.003, 0.005, 0.007, 0.012, 0.018, 0.023,
     0.027, 0.033, 0.038, 0.042, 0.047, 0.052, 0.060, 0.073, 0.091, 0.113,
     0.139, 0.170, 0.208, 0.258, 0.323, 0.405, 0.503, 0.608, 0.710, 0.795,
     0.862, 0.915, 0.954, 0.980, 0.995, 1.000, 0.995, 0.979, 0.952, 0.916,
     0.870, 0.816, 0.757, 0.695, 0.631, 0.567, 0.503, 0.442, 0.381, 0.321,
     0.265, 0.217, 0.175, 0.138, 0.107, 0.082, 0.061, 0.044, 0.032, 0.023,
     0.017, 0.012, 0.008, 0.006, 0.004, 0.003, 0.002, 0.001, 0.001, 0.001,
     0.001, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     0.000],
    [0.012, 0.024, 0.049, 0.095, 0.174, 0.290, 0.461, 0.732, 1.066, 1.315,
     1.467, 1.580, 1.617, 1.568, 1.472, 1.374, 1.292, 1.236, 1.114, 0.942,
     0.756, 0.586, 0.447, 0.341, 0.264, 0.206, 0.154, 0.109, 0.077, 0.056,
     0.041, 0.029, 0.020, 0.013, 0.009, 0.006, 0.004, 0.003, 0.002, 0.002,
     0.002, 0.002, 0.001, 0.001, 0.001, 0.001, 0.000, 0.000, 0.000, 0.000,
     0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000,
     0.000], ])
cones_SmithPokorny = numpy.asarray([
    [0.000000, 0.000000, 0.000000, 0.000000, 0.002660, 0.004380, 0.006890,
     0.010800, 0.015800, 0.020000, 0.023300, 0.026800, 0.030100, 0.032400,
     0.034300, 0.036800, 0.041200, 0.050200, 0.062700, 0.079800, 0.102000,
     0.128000, 0.162000, 0.206000, 0.263000, 0.337000, 0.423000, 0.520000,
     0.617000, 0.700000, 0.773000, 0.834000, 0.883000, 0.923000, 0.954000,
     0.977000, 0.993000, 1.000000, 0.997000, 0.986000, 0.965000, 0.934000,
     0.894000, 0.848000, 0.795000, 0.735000, 0.670000, 0.602000, 0.530000,
     0.454000, 0.380000, 0.315000, 0.256000, 0.204000, 0.159000, 0.122000,
     0.091400, 0.067000, 0.048200, 0.035000, 0.025700, 0.018000, 0.012400,
     0.008660, 0.006210, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
     0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
     0.000000, 0.000000, 0.000000, 0.000000],
    [0.000000, 0.000000, 0.000000, 0.000000, 0.002820, 0.004750, 0.007670,
     0.012400, 0.018900, 0.025400, 0.031700, 0.039500, 0.047700, 0.055500,
     0.063500, 0.073100, 0.086000, 0.107000, 0.130000, 0.157000, 0.189000,
     0.224000, 0.267000, 0.324000, 0.396000, 0.491000, 0.595000, 0.706000,
     0.808000, 0.884000, 0.941000, 0.978000, 0.997000, 0.999000, 0.987000,
     0.961000, 0.922000, 0.870000, 0.806000, 0.732000, 0.651000, 0.564000,
     0.477000, 0.393000, 0.318000, 0.250000, 0.193000, 0.147000, 0.110000,
     0.080800, 0.058300, 0.041800, 0.029600, 0.020700, 0.014400, 0.010100,
     0.006990, 0.004850, 0.003330, 0.002330, 0.001640, 0.001110, 0.000750,
     0.000517, 0.000368, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
     0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
     0.000000, 0.000000, 0.000000, 0.000000],
    [0.000000, 0.000000, 0.000000, 0.000000, 0.108000, 0.179000, 0.285000,
     0.453000, 0.659000, 0.813000, 0.908000, 0.977000, 1.000000, 0.970000,
     0.910000, 0.850000, 0.799000, 0.775000, 0.689000, 0.582000, 0.468000,
     0.362000, 0.276000, 0.212000, 0.164000, 0.128000, 0.095600, 0.067600,
     0.047400, 0.034700, 0.025600, 0.018200, 0.012400, 0.008260, 0.005450,
     0.003650, 0.002530, 0.001840, 0.001440, 0.001260, 0.001160, 0.001000,
     0.000812, 0.000741, 0.000610, 0.000479, 0.000312, 0.000240, 0.000198,
     0.000132, 0.000090, 0.000068, 0.000053, 0.000038, 0.000025, 0.000019,
     0.000014, 0.000010, 0.000008, 0.000005, 0.000004, 0.000003, 0.000002,
     0.000001, 0.000001, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
     0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,
     0.000000, 0.000000, 0.000000, 0.000000], ])
