/******************************************************************************
 * Copyright (c) 2009-2018, Barthelemy Dagenais and individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * - The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *****************************************************************************/
package py4j.examples;

import py4j.ClientServer;
import py4j.GatewayServer;

public class SingleThreadApplication {

	public static void main(String[] args) {
		GatewayServer.turnLoggingOff();
		ExampleEntryPoint point = new ExampleEntryPoint();
		ClientServer clientServer = new ClientServer(point);
		// Wait for Python side to shut down Java side
		clientServer.startServer(true);

		// Shut down after 5 seconds
		//		clientServer.startServer(true);
		//		try {
		//			Thread.currentThread().sleep(5000);
		//		} catch (Exception e) {
		//			e.printStackTrace();
		//		}
		//		clientServer.shutdown();
		//
		//		System.out.println("Stopping");
	}

	public static class SingleThreadShortTimeoutApplication {
		public static void main(String[] args) {
			GatewayServer.turnLoggingOff();
			ClientServer clientServer = new ClientServer.ClientServerBuilder().readTimeout(250)
					.entryPoint(new ExampleEntryPoint()).build();
			clientServer.startServer(true);
		}
	}
}
