﻿# coding=utf-8
# This file was originally generated by PyScripter's unitest wizard

import unittest
import ddt
import sys
from pyinference.fuzzy.subset import *

sys.path.append("..\\")


@ddt.ddt
class TestSubset(unittest.TestCase):
    def setUp(self):
        self.subset = Subset()
        self.subset[0.75] = 0.75
        self.subsetA = Subset()
        self.subsetA[0.75] = 1
        self.subsetB = Subset()
        self.subsetB[0.25] = 1

    def test_boundaries(self):
        self.assertAlmostEqual(0, self.subset.domain.begin)
        self.assertAlmostEqual(1, self.subset.domain.end)

    def test_value(self):
        self.subset[0.75] = 1.0
        self.assertAlmostEqual(1, self.subset[0.75])

    def test_inner_value(self):
        self.subset[0.75] = 1.0
        self.assertAlmostEqual(0.6, self.subset[0.85])

    def test_outer_value(self):
        self.assertEqual(0.0, self.subset[1.5])

    def testnormalize(self):
        self.subset = Subset()
        self.subset[0.75] = 0.75
        s2 = self.subset.normalize()
        self.assertAlmostEqual(0.75, self.subset[0.75])
        self.assertAlmostEqual(1.0, s2[0.75])

    def testsup(self):
        self.subset = Subset()
        self.subset[0.75] = 0.75
        self.assertAlmostEqual(0.75, self.subset.sup())

    def testlevel(self):
        res = self.subset.level(0.5)
        self.assertAlmostEqual(0.5, res.begin_tol)
        self.assertAlmostEqual(0.834, res.end_tol)
        self.assertAlmostEqual(0.667, res.centr(), places=3)

    @ddt.data(
        (0.5, 0.5, 1.0),
        (0.5, 0.5, 0.75),
        (0.67, 1.0, 0.75),
        (0.33, 0.0, 1.0),
    )
    @ddt.unpack
    def testcentr(self, centroid, value, membership):
        self.subset = Subset()
        self.subset[value] = membership
        self.assertAlmostEquals(centroid, self.subset.centr(), places=2)

    @ddt.data(
        (0.25, 0.5, 0.75, 1.0, 100),
        (0.1875, 0.5, 0.75, 0.75, 100),
        (0.5, 0.0, 0.75, 1.0, 100),
        (0.25, 0.0, 0.75, 0.5, 100),
        (0.25, 0.0, 0.75, 0.5, 10000),
        (0.25, 0.0, 0.75, 0.5, 20),
    )
    @ddt.unpack
    def testcard(self, card, begin, mode, member, acc):
        self.subset = Subset()
        self.subset.domain.acc = acc
        self.subset[mode] = member
        self.subset[begin] = 0.0
        self.assertAlmostEqual(card, self.subset.card())

    def testmode(self):
        self.subset = Subset()
        self.subset[0.75] = 0.75
        self.assertAlmostEqual(0.75, self.subset.mode())

    def testeuclid_distance(self):
        self.assertAlmostEqual(0.385,
                               self.subsetA.euclid_distance(self.subsetB), places=3)

    def testhamming_distance(self):
        self.assertAlmostEqual(0.333,
                               self.subsetA.hamming_distance(self.subsetB), places=3)

    def test__add__(self):
        res = self.subsetA + self.subsetB
        self.assertAlmostEqual(0.5, res.centr(), places=3)
        self.assertAlmostEqual(0.188, res.mode(), places=3)
        self.assertAlmostEqual(1.0, res.sup(), places=3)
        self.assertAlmostEqual(1.0, res[0.25], places=3)
        self.assertAlmostEqual(1.0, res[0.75], places=3)
        self.assertAlmostEqual(0.533, res[0.1], places=3)

    def test__sub__(self):
        res = self.subsetA - self.subsetB
        self.assertAlmostEqual(0.75, res.centr(), places=3)
        self.assertAlmostEqual(0.75, res.mode(), places=3)
        self.assertAlmostEqual(0.667, res.sup(), places=3)
        self.assertAlmostEqual(0.0, res[0.25], places=3)
        self.assertAlmostEqual(0.667, res[0.75], places=3)
        self.assertAlmostEqual(0.0, res[0.1], places=3)

    def test__mul__(self):
        res = self.subsetA * self.subsetB
        self.assertAlmostEqual(0.5, res.centr(), places=3)
        self.assertAlmostEqual(0.5, res.mode(), places=3)
        self.assertAlmostEqual(0.444, res.sup(), places=3)
        self.assertAlmostEqual(0.333, res[0.25], places=3)
        self.assertAlmostEqual(0.333, res[0.75], places=3)
        self.assertAlmostEqual(0.053, res[0.1], places=3)

    def test__pow__(self):
        res = self.subsetA ** 2
        self.assertAlmostEqual(0.625, res.centr(), places=3)
        self.assertAlmostEqual(0.75, res.mode(), places=3)
        self.assertAlmostEqual(1.0, res.sup(), places=3)
        self.assertAlmostEqual(0.111, res[0.25], places=3)
        self.assertAlmostEqual(1.0, res[0.75], places=3)
        self.assertAlmostEqual(0.018, res[0.1], places=3)

    ##    def test__not__(self):
    ##        res = not self.subsetA
    ##        self.assertAlmostEqual(0.5, res.centr(), places=3)
    ##        self.assertAlmostEqual(0.5, res.mode(), places=3)
    ##        self.assertAlmostEqual(0.444, res.sup(), places=3)
    ##        self.assertAlmostEqual(0.333, res[0.25], places=3)
    ##        self.assertAlmostEqual(0.333, res[0.75], places=3)
    ##        self.assertAlmostEqual(0.053, res[0.1], places=3)

    def test__neg__(self):
        res = -self.subsetA
        self.assertAlmostEqual(0.416, res.centr(), places=3)
        self.assertAlmostEqual(0.0, res.mode(), places=3)
        self.assertAlmostEqual(1.0, res.sup(), places=3)
        self.assertAlmostEqual(0.667, res[0.25], places=3)
        self.assertAlmostEqual(0.0, res[0.75], places=3)
        self.assertAlmostEqual(0.867, res[0.1], places=3)

    def test__and__(self):
        res = self.subsetA and self.subsetB
        self.assertAlmostEqual(0.417, res.centr(), places=3)
        self.assertAlmostEqual(0.25, res.mode(), places=3)
        self.assertAlmostEqual(1.0, res.sup(), places=3)
        self.assertAlmostEqual(1.0, res[0.25], places=3)
        self.assertAlmostEqual(0.333, res[0.75], places=3)
        self.assertAlmostEqual(0.4, res[0.1], places=3)

    def test__or__(self):
        res = self.subsetA or self.subsetB
        self.assertAlmostEqual(0.583, res.centr(), places=3)
        self.assertAlmostEqual(0.75, res.mode(), places=3)
        self.assertAlmostEqual(1.0, res.sup(), places=3)
        self.assertAlmostEqual(0.333, res[0.25], places=3)
        self.assertAlmostEqual(1.0, res[0.75], places=3)
        self.assertAlmostEqual(0.133, res[0.1], places=3)


##    def test__cmp__(self):
##        res = (self.subsetA > self.subsetB)
##        self.assertAlmostEqual(0.5, res, places=3)
##        res = (self.subsetA < self.subsetB)
##        self.assertAlmostEqual(0.5, res, places=3)
##
##    def test__eq__(self):
##        res = (self.subsetA == self.subsetB)
##        self.assertAlmostEqual(0.5, res, places=3)
##
##    def test__ne__(self):
##        res = (self.subsetA != self.subsetB)
##        self.assertAlmostEqual(0.5, res, places=3)

@ddt.ddt
class TestTrapezoidal(unittest.TestCase):
    def setUp(self):
        self.subset = Trapezoidal((0, 1, 2, 4))

    @ddt.data(
        (0, 0),
        (0, 4),
        (1, 1),
        (1, 2),
        (1, 1.5),
        (0.3, 0.3),
        (0.6, 2.8),
        (0.0, -2.8),
    )
    @ddt.unpack
    def testvalue(self, member, value):
        self.assertAlmostEqual(member, self.subset[value])

    def testcard(self):
        self.assertAlmostEqual(2.5, self.subset.card(), places=3)

    def testmom(self):
        self.assertAlmostEqual(1.5, self.subset.mom())

    def testmode(self):
        self.assertAlmostEqual(1.0, self.subset.mode())

    def testmedian(self):
        self.assertAlmostEqual(1.75, self.subset.median(), places=3)


@ddt.ddt
class TestTriangle(unittest.TestCase):
    def setUp(self):
        self.subset = Triangle(0, 1, 4)

    @ddt.data(
        (0, 0),
        (1, 1),
        (0, 4),
        (0.5, 0.5),
        (0.5, 2.5),
        (0, 4.6),
    )
    @ddt.unpack
    def testvalue(self, member, value):
        self.assertAlmostEqual(member, self.subset[value])

    def testmode(self):
        self.assertAlmostEqual(1.0, self.subset.mode())

    def testcard(self):
        self.assertAlmostEqual(2.0, self.subset.card(), places=3)


@ddt.ddt
class TestInterval(unittest.TestCase):
    def setUp(self):
        self.subset = Interval(1.5, 3.3)

    @ddt.data(
        (0, 0),
        (1, 1.5),
        (1, 3.3),
        (1, 2.5),
        (0, 4.6),
    )
    @ddt.unpack
    def testvalue(self, member, value):
        self.assertAlmostEqual(member, self.subset[value])

    def testcard(self):
        self.assertAlmostEqual(1.8, self.subset.card())


@ddt.ddt
class TestPoint(unittest.TestCase):
    def setUp(self):
        self.subset = Point(8.3)

    @ddt.data(
        (0, 0),
        (1, 8.3),
        (0, 8.4),
    )
    @ddt.unpack
    def testvalue(self, member, value):
        self.assertAlmostEqual(member, self.subset[value])

    def testcard(self):
        self.assertAlmostEqual(0.0, self.subset.card())


@ddt.ddt
class TestGaussian(unittest.TestCase):
    def setUp(self):
        self.subset = Gaussian(2.3, 1.2)

    @ddt.data(
        (0.159, 0),
        (1, 2.3),
        (0, 8.4),
    )
    @ddt.unpack
    def testvalue(self, member, value):
        self.assertAlmostEqual(member, self.subset[value], places=3)

    def testcentr(self):
        self.assertAlmostEqual(2.3, self.subset.centr(), places=3)

    def testmode(self):
        self.assertAlmostEqual(2.3, self.subset.mode(), places=3)

    def testcard(self):
        self.assertAlmostEqual(3.008, self.subset.card(), places=3)


if __name__ == '__main__':
    unittest.main()
