if(__add_lief_git)
  return()
endif()
set(__add_lief_git ON)


execute_process(
  COMMAND ${GIT_EXECUTABLE} log -1 --format=%h
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE LIEF_COMMIT_HASH
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

execute_process(
  COMMAND ${GIT_EXECUTABLE} rev-list --count ${LIEF_COMMIT_HASH}
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE LIEF_COMMIT_COUNT
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

execute_process(
  COMMAND ${GIT_EXECUTABLE} describe --abbrev=0 --tags HEAD --always
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE LIEF_GIT_TAG
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

execute_process(
  COMMAND ${GIT_EXECUTABLE} tag --list --points-at=HEAD
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE LIEF_GIT_COMMIT_TAGGED
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

execute_process(
  COMMAND ${GIT_EXECUTABLE} rev-parse --abbrev-ref HEAD
  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
  OUTPUT_VARIABLE LIEF_GIT_BRANCH
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

string(COMPARE NOTEQUAL "${LIEF_GIT_COMMIT_TAGGED}" "" LIEF_IS_TAGGED)

string(REGEX MATCHALL "([0-9]+)" VERSION_STRING "${LIEF_GIT_TAG}")

message(STATUS "Tagged: ${LIEF_IS_TAGGED}")
if (${LIEF_IS_TAGGED})
  message(STATUS "Tag: ${LIEF_GIT_TAG}")
else()
  if(LIEF_GIT_BRANCH MATCHES "^release-")
    string(REGEX MATCHALL "([0-9]+)" VERSION_STRING "${LIEF_GIT_BRANCH}")
    message(STATUS "${VERSION_STRING}")
  endif()
endif()
message(STATUS "Current branch: ${LIEF_GIT_BRANCH}")


if (VERSION_STRING)
  list(GET VERSION_STRING 0 LIEF_VERSION_MAJOR)
  list(GET VERSION_STRING 1 LIEF_VERSION_MINOR)
  list(GET VERSION_STRING 2 LIEF_VERSION_PATCH)

  if (NOT ${LIEF_IS_TAGGED})
    if(LIEF_GIT_BRANCH MATCHES "^release-")
      message(STATUS "Release branch")
    else()
      MATH(EXPR LIEF_VERSION_MINOR "${LIEF_VERSION_MINOR}+1")
      set(LIEF_VERSION_PATCH 0)
    endif()
  endif()
else()
  set(LIEF_VERSION_MAJOR 0)
  set(LIEF_VERSION_MINOR 0)
  set(LIEF_VERSION_PATCH 0)
endif()

