# Stubs for os.path
# Ron Murawski <ron@horizonchess.com>

# based on http://docs.python.org/3.2/library/os.path.html

from typing import overload, List, Any, AnyStr, Tuple, BinaryIO, TextIO

# ----- os.path variables -----
supports_unicode_filenames = False
# aliases (also in os)
curdir = ...  # type: str
pardir = ...  # type: str
sep = ...  # type: str
altsep = ...  # type: str
extsep = ...  # type: str
pathsep = ...  # type: str
defpath = ...  # type: str
devnull = ...  # type: str

# ----- os.path function stubs -----
def abspath(path: AnyStr) -> AnyStr: ...
def basename(path: AnyStr) -> AnyStr: ...

# NOTE: Empty List[bytes] results in '' (str) => fall back to Any return type.
def commonprefix(list: List[AnyStr]) -> Any: ...
def dirname(path: AnyStr) -> AnyStr: ...
def exists(path: AnyStr) -> bool: ...
def lexists(path: AnyStr) -> bool: ...
def expanduser(path: AnyStr) -> AnyStr: ...
def expandvars(path: AnyStr) -> AnyStr: ...


# These return float if os.stat_float_times() == True
def getatime(path: AnyStr) -> Any: ...
def getmtime(path: AnyStr) -> Any: ...
def getctime(path: AnyStr) -> Any: ...

def getsize(path: AnyStr) -> int: ...
def isabs(path: AnyStr) -> bool: ...
def isfile(path: AnyStr) -> bool: ...
def isdir(path: AnyStr) -> bool: ...
def islink(path: AnyStr) -> bool: ...
def ismount(path: AnyStr) -> bool: ...

def join(path: AnyStr, *paths: AnyStr) -> AnyStr: ...

def normcase(path: AnyStr) -> AnyStr: ...
def normpath(path: AnyStr) -> AnyStr: ...
def realpath(path: AnyStr) -> AnyStr: ...
def relpath(path: AnyStr, start: AnyStr = ...) -> AnyStr: ...

def samefile(path1: AnyStr, path2: AnyStr) -> bool: ...
def sameopenfile(fp1: int, fp2: int) -> bool: ...
#def samestat(stat1: stat_result,
#             stat2: stat_result) -> bool: ...  # Unix only

def split(path: AnyStr) -> Tuple[AnyStr, AnyStr]: ...
def splitdrive(path: AnyStr) -> Tuple[AnyStr, AnyStr]: ...
def splitext(path: AnyStr) -> Tuple[AnyStr, AnyStr]: ...

#def splitunc(path: str) -> Tuple[str, str]: ...  # Windows only, deprecated
