# -*- coding: utf-8 -*-
#
# This file is part of SENAITE.PATIENT.
#
# SENAITE.PATIENT is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 51
# Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright 2020-2022 by it's authors.
# Some rights reserved, see README and LICENSE.

from zope.i18nmessageid import MessageFactory
from senaite.patient.catalog import PATIENT_CATALOG  # noqa

_ = MessageFactory("senaite.patient")

PRODUCT_NAME = "senaite.patient"

DEFAULT_ROLES = ("Manager", )

DEFAULT_TYPES = ("PatientFolder", "Patient", )

AUTO_ID_MARKER = "-- autogenerated --"

SEXES = (
    ("m", _("Male")),
    ("f", _("Female")),
    ("", _("Not specified")),
)

GENDERS = (
    ("m", _("Man")),
    ("f", _("Woman")),
    ("t", _("Transgender")),
    ("d", _("Diverse")),
    ("", _("Not Specified")),
)

NAME_ENTRY_MODES = (
    ("parts", _("First name + last name")),
    ("full", _("Fullname")),
)


IDENTIFIERS = (
    (u"passport_id", _(u"Passport ID")),
    (u"national_id", _(u"National ID")),
    (u"driver_id", _(u"Driver ID")),
    (u"voter_id", _(u"Voter ID")),
)

# https://hl7.org/fhir/us/core/ValueSet-omb-race-category.html#expansion
RACES = (
    (u"1002-5", _(u"American Indian or Alaska Native")),
    (u"2028-9", _(u"Asian")),
    (u"2054-5", _(u"Black or African American")),
    (u"2076-8", _(u"Native Hawaiian or Other Pacific Islander")),
    (u"2106-3", _(u"White")),
    (u"2131-1", _(u"Other Race")),
    (u"ASKU", _(u"asked but unknown")),
    (u"UNK", _(u"unknown")),
)

# https://hl7.org/fhir/us/core/ValueSet-detailed-ethnicity.html#expansion
ETHNICITIES = (
    (u"2137-8", _(u"Spaniard")),
    (u"2138-6", _(u"Andalusian")),
    (u"2139-4", _(u"Asturian")),
    (u"2140-2", _(u"Castillian")),
    (u"2141-0", _(u"Catalonian")),
    (u"2142-8", _(u"Belearic Islander")),
    (u"2143-6", _(u"Gallego")),
    (u"2144-4", _(u"Valencian")),
    (u"2145-1", _(u"Canarian")),
    (u"2146-9", _(u"Spanish Basque")),
    (u"2148-5", _(u"Mexican")),
    (u"2149-3", _(u"Mexican American")),
    (u"2150-1", _(u"Mexicano")),
    (u"2151-9", _(u"Chicano")),
    (u"2152-7", _(u"La Raza")),
    (u"2153-5", _(u"Mexican American Indian")),
    (u"2155-0", _(u"Central American")),
    (u"2156-8", _(u"Costa Rican")),
    (u"2157-6", _(u"Guatemalan")),
    (u"2158-4", _(u"Honduran")),
    (u"2159-2", _(u"Nicaraguan")),
    (u"2160-0", _(u"Panamanian")),
    (u"2161-8", _(u"Salvadoran")),
    (u"2162-6", _(u"Central American Indian")),
    (u"2163-4", _(u"Canal Zone")),
    (u"2165-9", _(u"South American")),
    (u"2166-7", _(u"Argentinean")),
    (u"2167-5", _(u"Bolivian")),
    (u"2168-3", _(u"Chilean")),
    (u"2169-1", _(u"Colombian")),
    (u"2170-9", _(u"Ecuadorian")),
    (u"2171-7", _(u"Paraguayan")),
    (u"2172-5", _(u"Peruvian")),
    (u"2173-3", _(u"Uruguayan")),
    (u"2174-1", _(u"Venezuelan")),
    (u"2175-8", _(u"South American Indian")),
    (u"2176-6", _(u"Criollo")),
    (u"2178-2", _(u"Latin American")),
    (u"2180-8", _(u"Puerto Rican")),
    (u"2182-4", _(u"Cuban")),
    (u"2184-0", _(u"Dominican")),
    (u"ASKU", _(u"asked but unknown")),
    (u"OTH", _(u"other")),
    (u"UNK", _(u"unknown")),
)
