# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """
    Describes a virtual machine scale set network profile's IP configuration.

    :param id: Resource Id
    :type id: str
    :param name: Gets or sets the IP configuration name.
    :type name: str
    :param subnet: Gets or sets the subnet.
    :type subnet: :class:`ApiEntityReference
     <azure.mgmt.compute.models.ApiEntityReference>`
    :param application_gateway_backend_address_pools: Gets or sets the
     application gateway backend address pools.
    :type application_gateway_backend_address_pools: list of
     :class:`SubResource <azure.mgmt.compute.models.SubResource>`
    :param load_balancer_backend_address_pools: Gets or sets the load
     balancer backend address pools.
    :type load_balancer_backend_address_pools: list of :class:`SubResource
     <azure.mgmt.compute.models.SubResource>`
    :param load_balancer_inbound_nat_pools: Gets or sets the load balancer
     inbound nat pools.
    :type load_balancer_inbound_nat_pools: list of :class:`SubResource
     <azure.mgmt.compute.models.SubResource>`
    """ 

    _validation = {
        'name': {'required': True},
        'subnet': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(self, name, subnet, id=None, application_gateway_backend_address_pools=None, load_balancer_backend_address_pools=None, load_balancer_inbound_nat_pools=None):
        super(VirtualMachineScaleSetIPConfiguration, self).__init__(id=id)
        self.name = name
        self.subnet = subnet
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools
