/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public enum TaskStatus implements Serializable
{
    SUBMITTED("Submitted", true),
    PENDING("Pending", true),
    PAUSED("Paused", true),
    RUNNING("Running", true),
    WAITING_ON_ERROR("Faulty...", true),
    WAITING_ON_FAILURE("Failed...", true),
    FAILED("Resource down", false),
    NOT_STARTED("Could not start", false),
    NOT_RESTARTED("Could not restart", false),
    ABORTED("Aborted", false),
    FAULTY("Faulty", false),
    FINISHED("Finished", false),
    SKIPPED("Skipped", false),
    IN_ERROR("In-Error", true);

    private String name;
    private final boolean taskAlive;

    private TaskStatus(String name, boolean taskAlive) {
        this.name = name;
        this.taskAlive = taskAlive;
    }

    public boolean isTaskAlive() {
        return this.taskAlive;
    }

    public String toString() {
        return this.name;
    }

    public static List<TaskStatus> allExceptThese(TaskStatus ... taskStatuses) {
        HashSet<TaskStatus> statusesToAvoid = new HashSet<TaskStatus>(Arrays.asList(taskStatuses));
        return Arrays.stream(TaskStatus.values()).filter(taskStatus -> !statusesToAvoid.contains(taskStatus)).collect(Collectors.toList());
    }
}

