# Synthetic Data Tools

makefakedata.R is a tool to create synthetic clinical lab data from simple
template files.
These files can be used to create sample input data to be processed by RED-I
and loaded into a REDCap system.

Using a file that defines the components of a test panel, normal ranges for
their values and typical units, makefakedata can create a file of lab results
for that panel with multiple instances of that panel for multiple study
subjects, over a range of dates.  The number of panels, research subjects, date
ranges, input and output file names can all be controlled with parameters of
makefakedata.

makefakedata is designed to create sample datasets that are free of identifiers
and any clinical history.  With no claim to ownership, no research value, and
no history of private data, these files can be published as test datasets with
any software project.

Test data sets can be tailored to the needs of the individual software project
via panel templates and input parameters.

# Example

In this example, 3 subjects are created in both the CBC and Chemistry output
files.  For each subject, 7-20 panels of each test will be created.

    chem <- makefakedata("chemistry_input.csv", "output-chem.csv", min_panel=7, max_panel=20, subject_count=3)
    cbc <-  makefakedata("cbc_input.csv", "output-cbc.csv", min_panel=7, max_panel=20, subject_count=3)

# Panel Templates

A template file is a CSV file containing a header row of column labels and one
lab component per row.  Typical columns for the panel template are

* loinc_component - a name that describe a lab component
* loinc_code - the code for that lab component
* low - a normal low value for that component (required)
* high - a normal high value for that component (required)
* units - typical units for the component, compatible with low and high
* panel - a lab panel on which these tests are likely to appear
* loinc_long_common_name - a more descriptive name from LOINC

The columns _low_ and _high_ define a range from which the result value will
random chosen.  All other columns are strictly optional, but recommended.
The input values _loinc_component, loinc_code, low, high, and units_ in the
input will appear in the output file without alteration.

A typical panel template looks like this:

    loinc_component,loinc_code,low,high,units,panel,loinc_long_common_name
    Leukocytes,26464-8,3.8,10.8,10*3/uL,cbc,Leukocytes [#/volume] in Blood
    Neutrophils,26499-4,1.5,7.8,10*3/uL,cbc,Neutrophils [#/volume] in Blood
    Lymphocytes,26474-7,0.85,3.9,10*3/uL,cbc,Lymphocytes [#/volume] in Blood
    Platelets,26515-7,0.172,0.45,10*3/uL,cbc,Platelets [#/volume] in Blood
    Hemoglobin,718-7,12,16,g/dl,cbc,Hemoglobin [Mass/volume] in Blood

Here two CBC panels for one subject generated by makefakedata using the above
panel template as an input.

    "result","loinc_component","loinc_code","low","high","units","date_time_stamp","study_id"
    3.813,"Leukocytes","26464-8",3.8,10.8,"10*3/uL",2112-10-27,1
    3.433,"Neutrophils","26499-4",1.5,7.8,"10*3/uL",2112-10-27,1
    1.978,"Lymphocytes","26474-7",0.85,3.9,"10*3/uL",2112-10-27,1
    0.378,"Platelets","26515-7",0.172,0.45,"10*3/uL",2112-10-27,1
    13.617,"Hemoglobin","718-7",12,16,"g/dl",2112-10-27,1
    5.599,"Leukocytes","26464-8",3.8,10.8,"10*3/uL",2112-01-12,1
    3.246,"Neutrophils","26499-4",1.5,7.8,"10*3/uL",2112-01-12,1
    2.916,"Lymphocytes","26474-7",0.85,3.9,"10*3/uL",2112-01-12,1
    0.181,"Platelets","26515-7",0.172,0.45,"10*3/uL",2112-01-12,1
    12.78,"Hemoglobin","718-7",12,16,"g/dl",2112-01-12,1

# Usage

Accepted function arguments

<pre>
    data <- makefakedata(
        input,
        output,
        min_panel=<minimum required number of panels/subject>,
        max_panel=<maximum allowed number of panels/subject>,
        incomplete_panels=<TRUE|FALSE>,
        start_date=<"Earliest date for a lab panel in YYYY-MM-DD format">,
        end_date=<"Latest date for a lab panel in YYYY-MM-DD format">,
        subject_count=<number of research subjects for which panels will be created>)
</pre>

Command line example:

<pre>
$ r
$ source('makefakedata.R')
$ makefakedata('example_input.csv', 'out.csv', subject_count=10)
</pre>

Notes:
 - If min_panel = max_panel then 5 sets of data are generated
 - Currently the code does not support integer numbers generation
