#!/usr/bin/env python
"""Constants for the data servers."""


# Range for consistent hashing.
MAX_RANGE = 2 ** 64

# Important file names for rebalancing.
REBALANCE_DIRECTORY = ".GRR_REBALANCE"
TRANSACTION_FILENAME = ".TRANSACTION"
REMOVE_FILENAME = ".TRANSACTION_REMOVE"

# HTTP status codes.
RESPONSE_OK = 200

RESPONSE_SERVER_NOT_AUTHORIZED = 401
RESPONSE_SERVER_NOT_ALLOWED = 403
RESPONSE_SERVER_NOT_REGISTERED = 401
RESPONSE_NOT_MASTER_SERVER = 404
RESPONSE_NOT_A_CLIENT = 400
RESPONSE_MAPPING_NOT_FOUND = 404
RESPONSE_NOT_FOUND = 404
RESPONSE_MASTER_IS_REBALANCING = 401
RESPONSE_DATA_SERVERS_UNREACHABLE = 400
RESPONSE_FILE_NOT_SAVED = 500
RESPONSE_WRONG_TRANSACTION = 401
RESPONSE_FILES_NOT_COPIED = 500
RESPONSE_NOT_COMMITED = 500
RESPONSE_FILES_NOT_MOVED = 500
RESPONSE_TRANSACTION_NOT_FOUND = 400
RESPONSE_EQUAL_DATA_SERVER = 401
RESPONSE_IS_MASTER_SERVER = 404
RESPONSE_INCOMPLETE_SYNC = 503
RESPONSE_DATA_SERVER_NOT_FOUND = 409
RESPONSE_RANGE_NOT_EMPTY = 402
