# -*- coding: utf-8 -*-
"""
著作權所有 (C) 民國103年 意傳文化科技
開發者：薛丞宏
網址：http://意傳.台灣
語料來源：請看各資料庫內說明

本程式乃自由軟體，您必須遵照SocialCalc設計的通用公共授權（Common Public Attribution License, CPAL)來修改和重新發佈這一程式，詳情請參閱條文。授權大略如下，若有歧異，以授權原文為主：
	１．得使用、修改、複製並發佈此程式碼，且必須以通用公共授權發行；
	２．任何以程式碼衍生的執行檔或網路服務，必須公開該程式碼；
	３．將此程式的原始碼當函式庫引用入商業軟體，且不需公開非關此函式庫的任何程式碼

此開放原始碼、共享軟體或說明文件之使用或散佈不負擔保責任，並拒絕負擔因使用上述軟體或說明文件所致任何及一切賠償責任或損害。

臺灣言語工具緣起於本土文化推廣與傳承，非常歡迎各界用於商業軟體，但希望在使用之餘，能夠提供建議、錯誤回報或修補，回饋給這塊土地。

感謝您的使用與推廣～～勞力！承蒙！
"""
import os
from 臺灣言語工具.語音合成.句物件轉合成標仔 import 句物件轉合成標仔
from 臺灣言語工具.語音辨識.腳本程式 import 腳本程式
from 臺灣言語工具.語音辨識.語料處理 import 語料處理

class 辨識模型(腳本程式, 語料處理):
	_轉合成標仔 = 句物件轉合成標仔()
	恬音 = _轉合成標仔.產生主要音值標仔(_轉合成標仔.恬音)
	短恬 = _轉合成標仔.產生主要音值標仔(_轉合成標仔.短恬)
	def 對齊(self, 參數檔, 聲韻類檔, 對照檔, 模型檔,
			標仔檔, 特徵檔, 結果夾, 執行檔路徑=''):
		執行檔路徑 = self.執行檔路徑加尾(執行檔路徑)
		os.makedirs(結果夾, exist_ok=True)
		對齊指令 = '{0}HVite -A -C {1} -p -20 -H {2} -I {3} -S {4} -o S -y lab -l "{5}" {6} {7}'\
			.format(執行檔路徑, 參數檔, 模型檔, 標仔檔, 特徵檔,
				結果夾, 對照檔, 聲韻類檔)
		self.走指令(對齊指令)
		return
	def 對齊聲韻(self, 聲韻類檔, 模型檔, 聲韻檔, 特徵檔, 資料目錄, 執行檔路徑=''):
		參數檔 = os.path.join(資料目錄, '參數檔.cfg')
		self.設定參數(聲韻類檔, 參數檔)
		聲韻對照檔 = os.path.join(資料目錄, '聲韻對照檔.dict')
		self.家己對照檔(聲韻類檔, 聲韻對照檔)
		對齊結果檔 = os.path.join(資料目錄, '對齊聲韻結果')
		self.對齊(參數檔, 聲韻類檔, 聲韻對照檔, 模型檔, 聲韻檔, 特徵檔, 對齊結果檔, 執行檔路徑)
		return 對齊結果檔
	def 對齊音節(self, 音節聲韻對照檔, 聲韻類檔, 模型檔, 音節檔, 特徵檔, 資料目錄, 執行檔路徑=''):
		參數檔 = os.path.join(資料目錄, '參數檔.cfg')
		self.設定參數(聲韻類檔, 參數檔)
		對齊結果檔 = os.path.join(資料目錄, '對齊音節結果')
		self.對齊(參數檔, 聲韻類檔, 音節聲韻對照檔, 模型檔, 音節檔, 特徵檔, 對齊結果檔, 執行檔路徑)
		return 對齊結果檔
	def 辨識(self, 設定檔, 聲韻類檔, 對照檔, 模型檔, 網路檔, 幾條網路, 特徵檔, 結果檔, 結果網路資料夾, 執行檔路徑=''):
		執行檔路徑 = self.執行檔路徑加尾(執行檔路徑)
		if 幾條網路 > 0:
			os.makedirs(結果網路資料夾, exist_ok=True)
			幾條網路設定 = '-n {0}'.format(幾條網路)
		else:
			結果網路資料夾 = '*'
			幾條網路設定 = ''
		辨識指令 = '{0}HVite -A -C {1} -p -20 -H {2} -w {3} -S {4} -o N -y rec -z lattices -i {5} -l "{6}" {7} {8} {9}'\
			.format(執行檔路徑, 設定檔, 模型檔, 網路檔, 特徵檔,
				結果檔, 結果網路資料夾, 幾條網路設定, 對照檔, 聲韻類檔)
		self.走指令(辨識指令)
		return
	def 辨識聲韻(self, 聲韻類檔, 模型檔, 特徵檔, 資料目錄, 幾條網路, 執行檔路徑=''):
		參數檔 = os.path.join(資料目錄, '參數檔.cfg')
		self.設定參數(聲韻類檔, 參數檔)
		網路檔 = os.path.join(資料目錄, '聲韻網路檔.lat')
		self.生辨識網路(執行檔路徑, 資料目錄, 聲韻類檔, 網路檔)
		結果檔 = os.path.join(資料目錄, '辨識聲韻結果檔.mlf')
		聲韻對照檔 = os.path.join(資料目錄, '聲韻對照檔.dict')
		self.家己對照檔(聲韻類檔, 聲韻對照檔)
		結果網路資料夾 = os.path.join(資料目錄, '辨識聲韻網路')
		self.辨識(參數檔, 聲韻類檔, 聲韻對照檔, 模型檔, 網路檔, 幾條網路,
			特徵檔, 結果檔, 結果網路資料夾, 執行檔路徑)
		return 結果檔, 結果網路資料夾
	def 辨識音節(self, 音節聲韻對照檔, 聲韻類檔, 模型檔,
			特徵檔, 資料目錄, 幾條網路, 執行檔路徑=''):
		參數檔 = os.path.join(資料目錄, '參數檔.cfg')
		self.設定參數(聲韻類檔, 參數檔)
		音節類檔 = os.path.join(資料目錄, '音節類檔.list')
		self.家己類檔(音節聲韻對照檔, 聲韻類檔, 音節類檔)
		網路檔 = os.path.join(資料目錄, '音節網路檔.lat')
		self.生辨識網路(執行檔路徑, 資料目錄, 音節類檔, 網路檔)
		結果檔 = os.path.join(資料目錄, '辨識音節結果檔.mlf')
		結果網路資料夾 = os.path.join(資料目錄, '辨識音節網路')
		self.辨識(參數檔, 聲韻類檔, 音節聲韻對照檔, 模型檔, 網路檔, 幾條網路,
			特徵檔, 結果檔, 結果網路資料夾, 執行檔路徑)
		return 結果檔, 結果網路資料夾
	def 處理試驗語料(self, 音檔目錄, 資料目錄,
			標仔目錄=None, 音節聲韻對照檔=None, 執行檔路徑=''):
		全部語料 = self.揣全部語料(音檔目錄, 標仔目錄)
		全部特徵檔 = os.path.join(資料目錄, '資料特徵檔.scp')
		os.makedirs(資料目錄, exist_ok=True)
		self.揣特徵而且算(執行檔路徑, 資料目錄, 全部語料, 全部特徵檔)
		if 標仔目錄 == None:
			return 全部特徵檔
		全部標仔檔 = os.path.join(資料目錄, '試驗語料標仔檔.scp')
		音節檔 = os.path.join(資料目錄, '試驗語料音節檔.mlf')
		聲韻類檔 = os.path.join(資料目錄, '試驗語料聲韻類檔.list')
		聲韻檔 = os.path.join(資料目錄, '試驗語料聲韻檔.mlf')
		全部標仔 = []
		for 語料 in 全部語料:
			標仔所在 = 語料[2]
			全部標仔.append(標仔所在)
		self.陣列寫入檔案(全部標仔檔, 全部標仔)
		用袂著的檔案 = os.path.join(資料目錄, '用袂著的檔案.garbage')
		self.標仔收集起來(執行檔路徑, 全部標仔檔, 資料目錄, 用袂著的檔案, 音節檔)
		self.標仔切做聲韻(執行檔路徑, 音節檔, 音節聲韻對照檔, 資料目錄, 聲韻類檔, 聲韻檔)
# 		self.標仔加恬佮切開(執行檔路徑, 全部標仔檔, 音節聲韻對照檔,
# 			資料目錄, 音節檔, 聲韻類檔, 聲韻檔)
		return 全部特徵檔, 音節檔, 聲韻檔
	def 生辨識網路(self, 執行檔路徑, 資料目錄, 聲韻類檔, 網路檔):
		執行檔路徑 = self.執行檔路徑加尾(執行檔路徑)
		辨識的可能 = set()
		短恬語法 = ''
		for 聲韻 in self.讀檔案(聲韻類檔):
			主要音值 = self._轉合成標仔.產生主要音值標仔(聲韻)
			if 主要音值 != self.短恬:
				辨識的可能.add(主要音值)
			else:
				短恬語法 = '[{0}]'.format(self.短恬)
		語法 = '{2}={3};\n({0} < {2} {1} > {0})'.format(
			self.恬音, 短恬語法,
			'$SYL', '|'.join(辨識的可能))
		語法檔 = os.path.join(資料目錄, '語法檔.syntax')
		self.字串寫入檔案(語法檔, 語法)
		產生網路指令 = '{0}HParse -A {1} {2}'\
			.format(執行檔路徑, 語法檔, 網路檔)
		self.走指令(產生網路指令)
	def 家己類檔(self, 對照檔, 聲韻類檔, 類檔):
		聲韻類 = set(self.讀檔案(聲韻類檔))
		類表 = []
		for 類 in self.讀檔案(對照檔):
			音節, *拆聲韻 = 類.split()
			for 聲韻 in 拆聲韻:
				if 聲韻 not in 聲韻類:
					break
			else:
				類表.append('{0}'.format(音節))
		self.陣列寫入檔案(類檔, 類表)
	def 家己對照檔(self, 類檔, 對照檔):
		對照表 = []
		for 類 in self.讀檔案(類檔):
			對照表.append('{0}\t{0}'.format(
				self._轉合成標仔.產生主要音值標仔(類)))
		self.陣列寫入檔案(對照檔, set(對照表))
	def 設定參數(self, 聲韻類檔, 上尾參數檔):
		參數 = ['noNumEscapes = TRUE']
		if '-' in ''.join(self.讀檔案(聲韻類檔)):
			參數.append('ALLOWXWRDEXP = TRUE')
			參數.append('FORCECXTEXP = TRUE')
		self.陣列寫入檔案(上尾參數檔, 參數)
