# -*- coding: utf-8 -*-
"""
著作權所有 (C) 民國103年 意傳文化科技
開發者：薛丞宏
網址：http://意傳.台灣
語料來源：請看各資料庫內說明

本程式乃自由軟體，您必須遵照SocialCalc設計的通用公共授權（Common Public Attribution License, CPAL)來修改和重新發佈這一程式，詳情請參閱條文。授權大略如下，若有歧異，以授權原文為主：
	１．得使用、修改、複製並發佈此程式碼，且必須以通用公共授權發行；
	２．任何以程式碼衍生的執行檔或網路服務，必須公開該程式碼；
	３．將此程式的原始碼當函式庫引用入商業軟體，且不需公開非關此函式庫的任何程式碼

此開放原始碼、共享軟體或說明文件之使用或散佈不負擔保責任，並拒絕負擔因使用上述軟體或說明文件所致任何及一切賠償責任或損害。

臺灣言語工具緣起於本土文化推廣與傳承，非常歡迎各界用於商業軟體，但希望在使用之餘，能夠提供建議、錯誤回報或修補，回饋給這塊土地。

感謝您的使用與推廣～～勞力！承蒙！
"""
import itertools
from 臺灣言語工具.語音合成.句物件轉合成標仔 import 句物件轉合成標仔

class 生文本音值對照表:
	_轉合成標仔 = 句物件轉合成標仔()
	def 生聲韻對照(self, 拼音, 拼音聲母表, 拼音韻母表):
		資料 = []
		格式 = '{0}\t{1}'
		資料.append(格式.format(self._轉合成標仔.恬音,
			self._轉合成標仔.產生主要音值標仔(self._轉合成標仔.恬音)))
		資料.append(格式.format(self._轉合成標仔.短恬,
			self._轉合成標仔.產生主要音值標仔(self._轉合成標仔.短恬)))
		for 聲母 in 拼音聲母表:
			for 韻母 in 拼音韻母表:
				音 = 聲母 + 韻母
				資料.append(格式.format(音,
						' '.join(拼音(音).音值()[:-1])))
		資料.sort()
		return 資料
	def 生聲韻表(self, 對照音值聲母表, 對照音值韻母表):
		資料 = []
		格式 = '{0}\t{1}'
		for 音 in itertools.chain.from_iterable([
				[self._轉合成標仔.恬音, self._轉合成標仔.短恬],
				對照音值聲母表.values(),
				對照音值韻母表.values(),
				]):
			標仔 = self._轉合成標仔.產生主要音值標仔(音)
			資料.append(格式.format(標仔, 標仔))
		資料.sort()
		return 資料
