# Author: echel0n <echel0n@sickrage.ca>
# URL: https://sickrage.ca
#
# This file is part of SickRage.
#
# SickRage is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SickRage is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SickRage.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import unicode_literals
from __future__ import unicode_literals

import re

__all__ = ['resolve']


def resolve(code):
    """
    Transform the given (2- or 3-letter) language code to a human readable
    language name.  The return value is a 2-tuple containing the given
    language code and the language name.  If the language code cannot be
    resolved, name will be 'Unknown (<code>)'.
    """
    if not code:
        return None, None
    if not isinstance(code, basestring):
        raise ValueError('Invalid language code specified by parser')

    # Take up to 3 letters from the code.
    code = re.split(r'[^a-z]', code.lower())[0][:3]

    for spec in codes:
        if code in spec[:-1]:
            return code, spec[-1]

    return code, 'Unknown (%r)' % code


# Parsed from http://www.loc.gov/standards/iso639-2/ISO-639-2_utf-8.txt
codes = (
    ('aar', 'aa', 'Afar'),
    ('abk', 'ab', 'Abkhazian'),
    ('ace', 'Achinese'),
    ('ach', 'Acoli'),
    ('ada', 'Adangme'),
    ('ady', 'Adyghe'),
    ('afa', 'Afro-Asiatic '),
    ('afh', 'Afrihili'),
    ('afr', 'af', 'Afrikaans'),
    ('ain', 'Ainu'),
    ('aka', 'ak', 'Akan'),
    ('akk', 'Akkadian'),
    ('alb', 'sq', 'Albanian'),
    ('ale', 'Aleut'),
    ('alg', 'Algonquian languages'),
    ('alt', 'Southern Altai'),
    ('amh', 'am', 'Amharic'),
    ('ang', 'English, Old '),
    ('anp', 'Angika'),
    ('apa', 'Apache languages'),
    ('ara', 'ar', 'Arabic'),
    ('arc', 'Official Aramaic '),
    ('arg', 'an', 'Aragonese'),
    ('arm', 'hy', 'Armenian'),
    ('arn', 'Mapudungun'),
    ('arp', 'Arapaho'),
    ('art', 'Artificial '),
    ('arw', 'Arawak'),
    ('asm', 'as', 'Assamese'),
    ('ast', 'Asturian'),
    ('ath', 'Athapascan languages'),
    ('aus', 'Australian languages'),
    ('ava', 'av', 'Avaric'),
    ('ave', 'ae', 'Avestan'),
    ('awa', 'Awadhi'),
    ('aym', 'ay', 'Aymara'),
    ('aze', 'az', 'Azerbaijani'),
    ('bad', 'Banda languages'),
    ('bai', 'Bamileke languages'),
    ('bak', 'ba', 'Bashkir'),
    ('bal', 'Baluchi'),
    ('bam', 'bm', 'Bambara'),
    ('ban', 'Balinese'),
    ('baq', 'eu', 'Basque'),
    ('bas', 'Basa'),
    ('bat', 'Baltic '),
    ('bej', 'Beja'),
    ('bel', 'be', 'Belarusian'),
    ('bem', 'Bemba'),
    ('ben', 'bn', 'Bengali'),
    ('ber', 'Berber '),
    ('bho', 'Bhojpuri'),
    ('bih', 'bh', 'Bihari'),
    ('bik', 'Bikol'),
    ('bin', 'Bini'),
    ('bis', 'bi', 'Bislama'),
    ('bla', 'Siksika'),
    ('bnt', 'Bantu '),
    ('bos', 'bs', 'Bosnian'),
    ('bra', 'Braj'),
    ('bre', 'br', 'Breton'),
    ('btk', 'Batak languages'),
    ('bua', 'Buriat'),
    ('bug', 'Buginese'),
    ('bul', 'bg', 'Bulgarian'),
    ('bur', 'my', 'Burmese'),
    ('byn', 'Blin'),
    ('cad', 'Caddo'),
    ('cai', 'Central American Indian '),
    ('car', 'Galibi Carib'),
    ('cat', 'ca', 'Catalan'),
    ('cau', 'Caucasian '),
    ('ceb', 'Cebuano'),
    ('cel', 'Celtic '),
    ('cha', 'ch', 'Chamorro'),
    ('chb', 'Chibcha'),
    ('che', 'ce', 'Chechen'),
    ('chg', 'Chagatai'),
    ('chi', 'zh', 'Chinese'),
    ('chk', 'Chuukese'),
    ('chm', 'Mari'),
    ('chn', 'Chinook jargon'),
    ('cho', 'Choctaw'),
    ('chp', 'Chipewyan'),
    ('chr', 'Cherokee'),
    ('chu', 'cu', 'Church Slavic'),
    ('chv', 'cv', 'Chuvash'),
    ('chy', 'Cheyenne'),
    ('cmc', 'Chamic languages'),
    ('cop', 'Coptic'),
    ('cor', 'kw', 'Cornish'),
    ('cos', 'co', 'Corsican'),
    ('cpe', 'Creoles and pidgins, English based '),
    ('cpf', 'Creoles and pidgins, French-based '),
    ('cpp', 'Creoles and pidgins, Portuguese-based '),
    ('cre', 'cr', 'Cree'),
    ('crh', 'Crimean Tatar'),
    ('crp', 'Creoles and pidgins '),
    ('csb', 'Kashubian'),
    ('cus', 'Cushitic '),
    ('cze', 'cs', 'Czech'),
    ('dak', 'Dakota'),
    ('dan', 'da', 'Danish'),
    ('dar', 'Dargwa'),
    ('day', 'Land Dayak languages'),
    ('del', 'Delaware'),
    ('den', 'Slave '),
    ('dgr', 'Dogrib'),
    ('din', 'Dinka'),
    ('div', 'dv', 'Divehi'),
    ('doi', 'Dogri'),
    ('dra', 'Dravidian '),
    ('dsb', 'Lower Sorbian'),
    ('dua', 'Duala'),
    ('dum', 'Dutch, Middle '),
    ('dut', 'nl', 'Dutch'),
    ('dyu', 'Dyula'),
    ('dzo', 'dz', 'Dzongkha'),
    ('efi', 'Efik'),
    ('egy', 'Egyptian '),
    ('eka', 'Ekajuk'),
    ('elx', 'Elamite'),
    ('eng', 'en', 'English'),
    ('enm', 'English, Middle '),
    ('epo', 'eo', 'Esperanto'),
    ('est', 'et', 'Estonian'),
    ('ewe', 'ee', 'Ewe'),
    ('ewo', 'Ewondo'),
    ('fan', 'Fang'),
    ('fao', 'fo', 'Faroese'),
    ('fat', 'Fanti'),
    ('fij', 'fj', 'Fijian'),
    ('fil', 'Filipino'),
    ('fin', 'fi', 'Finnish'),
    ('fiu', 'Finno-Ugrian '),
    ('fon', 'Fon'),
    ('fre', 'fr', 'French'),
    ('frm', 'French, Middle '),
    ('fro', 'French, Old '),
    ('frr', 'Northern Frisian'),
    ('frs', 'Eastern Frisian'),
    ('fry', 'fy', 'Western Frisian'),
    ('ful', 'ff', 'Fulah'),
    ('fur', 'Friulian'),
    ('gaa', 'Ga'),
    ('gay', 'Gayo'),
    ('gba', 'Gbaya'),
    ('gem', 'Germanic '),
    ('geo', 'ka', 'Georgian'),
    ('ger', 'de', 'German'),
    ('gez', 'Geez'),
    ('gil', 'Gilbertese'),
    ('gla', 'gd', 'Gaelic'),
    ('gle', 'ga', 'Irish'),
    ('glg', 'gl', 'Galician'),
    ('glv', 'gv', 'Manx'),
    ('gmh', 'German, Middle High '),
    ('goh', 'German, Old High '),
    ('gon', 'Gondi'),
    ('gor', 'Gorontalo'),
    ('got', 'Gothic'),
    ('grb', 'Grebo'),
    ('grc', 'Greek, Ancient '),
    ('gre', 'el', 'Greek, Modern '),
    ('grn', 'gn', 'Guarani'),
    ('gsw', 'Swiss German'),
    ('guj', 'gu', 'Gujarati'),
    ('gwi', u"Gwich'in"),
    ('hai', 'Haida'),
    ('hat', 'ht', 'Haitian'),
    ('hau', 'ha', 'Hausa'),
    ('haw', 'Hawaiian'),
    ('heb', 'he', 'Hebrew'),
    ('her', 'hz', 'Herero'),
    ('hil', 'Hiligaynon'),
    ('him', 'Himachali'),
    ('hin', 'hi', 'Hindi'),
    ('hit', 'Hittite'),
    ('hmn', 'Hmong'),
    ('hmo', 'ho', 'Hiri Motu'),
    ('hsb', 'Upper Sorbian'),
    ('hun', 'hu', 'Hungarian'),
    ('hup', 'Hupa'),
    ('iba', 'Iban'),
    ('ibo', 'ig', 'Igbo'),
    ('ice', 'is', 'Icelandic'),
    ('ido', 'io', 'Ido'),
    ('iii', 'ii', 'Sichuan Yi'),
    ('ijo', 'Ijo languages'),
    ('iku', 'iu', 'Inuktitut'),
    ('ile', 'ie', 'Interlingue'),
    ('ilo', 'Iloko'),
    ('ina', 'ia', 'Interlingua '),
    ('inc', 'Indic '),
    ('ind', 'id', 'Indonesian'),
    ('ine', 'Indo-European '),
    ('inh', 'Ingush'),
    ('ipk', 'ik', 'Inupiaq'),
    ('ira', 'Iranian '),
    ('iro', 'Iroquoian languages'),
    ('ita', 'it', 'Italian'),
    ('jav', 'jv', 'Javanese'),
    ('jbo', 'Lojban'),
    ('jpn', 'ja', 'Japanese'),
    ('jpr', 'Judeo-Persian'),
    ('jrb', 'Judeo-Arabic'),
    ('kaa', 'Kara-Kalpak'),
    ('kab', 'Kabyle'),
    ('kac', 'Kachin'),
    ('kal', 'kl', 'Kalaallisut'),
    ('kam', 'Kamba'),
    ('kan', 'kn', 'Kannada'),
    ('kar', 'Karen languages'),
    ('kas', 'ks', 'Kashmiri'),
    ('kau', 'kr', 'Kanuri'),
    ('kaw', 'Kawi'),
    ('kaz', 'kk', 'Kazakh'),
    ('kbd', 'Kabardian'),
    ('kha', 'Khasi'),
    ('khi', 'Khoisan '),
    ('khm', 'km', 'Central Khmer'),
    ('kho', 'Khotanese'),
    ('kik', 'ki', 'Kikuyu'),
    ('kin', 'rw', 'Kinyarwanda'),
    ('kir', 'ky', 'Kirghiz'),
    ('kmb', 'Kimbundu'),
    ('kok', 'Konkani'),
    ('kom', 'kv', 'Komi'),
    ('kon', 'kg', 'Kongo'),
    ('kor', 'ko', 'Korean'),
    ('kos', 'Kosraean'),
    ('kpe', 'Kpelle'),
    ('krc', 'Karachay-Balkar'),
    ('krl', 'Karelian'),
    ('kro', 'Kru languages'),
    ('kru', 'Kurukh'),
    ('kua', 'kj', 'Kuanyama'),
    ('kum', 'Kumyk'),
    ('kur', 'ku', 'Kurdish'),
    ('kut', 'Kutenai'),
    ('lad', 'Ladino'),
    ('lah', 'Lahnda'),
    ('lam', 'Lamba'),
    ('lao', 'lo', 'Lao'),
    ('lat', 'la', 'Latin'),
    ('lav', 'lv', 'Latvian'),
    ('lez', 'Lezghian'),
    ('lim', 'li', 'Limburgan'),
    ('lin', 'ln', 'Lingala'),
    ('lit', 'lt', 'Lithuanian'),
    ('lol', 'Mongo'),
    ('loz', 'Lozi'),
    ('ltz', 'lb', 'Luxembourgish'),
    ('lua', 'Luba-Lulua'),
    ('lub', 'lu', 'Luba-Katanga'),
    ('lug', 'lg', 'Ganda'),
    ('lui', 'Luiseno'),
    ('lun', 'Lunda'),
    ('luo', 'Luo '),
    ('lus', 'Lushai'),
    ('mac', 'mk', 'Macedonian'),
    ('mad', 'Madurese'),
    ('mag', 'Magahi'),
    ('mah', 'mh', 'Marshallese'),
    ('mai', 'Maithili'),
    ('mak', 'Makasar'),
    ('mal', 'ml', 'Malayalam'),
    ('man', 'Mandingo'),
    ('mao', 'mi', 'Maori'),
    ('map', 'Austronesian '),
    ('mar', 'mr', 'Marathi'),
    ('mas', 'Masai'),
    ('may', 'ms', 'Malay'),
    ('mdf', 'Moksha'),
    ('mdr', 'Mandar'),
    ('men', 'Mende'),
    ('mga', 'Irish, Middle '),
    ('mic', u"Mi'kmaq"),
    ('min', 'Minangkabau'),
    ('mis', 'Uncoded languages'),
    ('mkh', 'Mon-Khmer '),
    ('mlg', 'mg', 'Malagasy'),
    ('mlt', 'mt', 'Maltese'),
    ('mnc', 'Manchu'),
    ('mni', 'Manipuri'),
    ('mno', 'Manobo languages'),
    ('moh', 'Mohawk'),
    ('mol', 'mo', 'Moldavian'),
    ('mon', 'mn', 'Mongolian'),
    ('mos', 'Mossi'),
    ('mul', 'Multiple languages'),
    ('mun', 'Munda languages'),
    ('mus', 'Creek'),
    ('mwl', 'Mirandese'),
    ('mwr', 'Marwari'),
    ('myn', 'Mayan languages'),
    ('myv', 'Erzya'),
    ('nah', 'Nahuatl languages'),
    ('nai', 'North American Indian'),
    ('nap', 'Neapolitan'),
    ('nau', 'na', 'Nauru'),
    ('nav', 'nv', 'Navajo'),
    ('nbl', 'nr', 'Ndebele, South'),
    ('nde', 'nd', 'Ndebele, North'),
    ('ndo', 'ng', 'Ndonga'),
    ('nds', 'Low German'),
    ('nep', 'ne', 'Nepali'),
    ('new', 'Nepal Bhasa'),
    ('nia', 'Nias'),
    ('nic', 'Niger-Kordofanian '),
    ('niu', 'Niuean'),
    ('nno', 'nn', 'Norwegian Nynorsk'),
    ('nob', 'nb', 'Bokm\xe5l, Norwegian'),
    ('nog', 'Nogai'),
    ('non', 'Norse, Old'),
    ('nor', 'no', 'Norwegian'),
    ('nqo', u"N'Ko"),
    ('nso', 'Pedi'),
    ('nub', 'Nubian languages'),
    ('nwc', 'Classical Newari'),
    ('nya', 'ny', 'Chichewa'),
    ('nym', 'Nyamwezi'),
    ('nyn', 'Nyankole'),
    ('nyo', 'Nyoro'),
    ('nzi', 'Nzima'),
    ('oci', 'oc', 'Occitan '),
    ('oji', 'oj', 'Ojibwa'),
    ('ori', 'or', 'Oriya'),
    ('orm', 'om', 'Oromo'),
    ('osa', 'Osage'),
    ('oss', 'os', 'Ossetian'),
    ('ota', 'Turkish, Ottoman '),
    ('oto', 'Otomian languages'),
    ('paa', 'Papuan '),
    ('pag', 'Pangasinan'),
    ('pal', 'Pahlavi'),
    ('pam', 'Pampanga'),
    ('pan', 'pa', 'Panjabi'),
    ('pap', 'Papiamento'),
    ('pau', 'Palauan'),
    ('peo', 'Persian, Old '),
    ('per', 'fa', 'Persian'),
    ('phi', 'Philippine '),
    ('phn', 'Phoenician'),
    ('pli', 'pi', 'Pali'),
    ('pol', 'pl', 'Polish'),
    ('pon', 'Pohnpeian'),
    ('por', 'pt', 'Portuguese'),
    ('pra', 'Prakrit languages'),
    ('pro', 'Proven\xe7al, Old '),
    ('pus', 'ps', 'Pushto'),
    ('qaa-qtz', 'Reserved for local use'),
    ('que', 'qu', 'Quechua'),
    ('raj', 'Rajasthani'),
    ('rap', 'Rapanui'),
    ('rar', 'Rarotongan'),
    ('roa', 'Romance '),
    ('roh', 'rm', 'Romansh'),
    ('rom', 'Romany'),
    ('rum', 'ro', 'Romanian'),
    ('run', 'rn', 'Rundi'),
    ('rup', 'Aromanian'),
    ('rus', 'ru', 'Russian'),
    ('sad', 'Sandawe'),
    ('sag', 'sg', 'Sango'),
    ('sah', 'Yakut'),
    ('sai', 'South American Indian '),
    ('sal', 'Salishan languages'),
    ('sam', 'Samaritan Aramaic'),
    ('san', 'sa', 'Sanskrit'),
    ('sas', 'Sasak'),
    ('sat', 'Santali'),
    ('scc', 'sr', 'Serbian'),
    ('scn', 'Sicilian'),
    ('sco', 'Scots'),
    ('scr', 'hr', 'Croatian'),
    ('sel', 'Selkup'),
    ('sem', 'Semitic '),
    ('sga', 'Irish, Old '),
    ('sgn', 'Sign Languages'),
    ('shn', 'Shan'),
    ('sid', 'Sidamo'),
    ('sin', 'si', 'Sinhala'),
    ('sio', 'Siouan languages'),
    ('sit', 'Sino-Tibetan '),
    ('sla', 'Slavic '),
    ('slo', 'sk', 'Slovak'),
    ('slv', 'sl', 'Slovenian'),
    ('sma', 'Southern Sami'),
    ('sme', 'se', 'Northern Sami'),
    ('smi', 'Sami languages '),
    ('smj', 'Lule Sami'),
    ('smn', 'Inari Sami'),
    ('smo', 'sm', 'Samoan'),
    ('sms', 'Skolt Sami'),
    ('sna', 'sn', 'Shona'),
    ('snd', 'sd', 'Sindhi'),
    ('snk', 'Soninke'),
    ('sog', 'Sogdian'),
    ('som', 'so', 'Somali'),
    ('son', 'Songhai languages'),
    ('sot', 'st', 'Sotho, Southern'),
    ('spa', 'es', 'Spanish'),
    ('srd', 'sc', 'Sardinian'),
    ('srn', 'Sranan Tongo'),
    ('srr', 'Serer'),
    ('ssa', 'Nilo-Saharan '),
    ('ssw', 'ss', 'Swati'),
    ('suk', 'Sukuma'),
    ('sun', 'su', 'Sundanese'),
    ('sus', 'Susu'),
    ('sux', 'Sumerian'),
    ('swa', 'sw', 'Swahili'),
    ('swe', 'sv', 'Swedish'),
    ('syc', 'Classical Syriac'),
    ('syr', 'Syriac'),
    ('tah', 'ty', 'Tahitian'),
    ('tai', 'Tai '),
    ('tam', 'ta', 'Tamil'),
    ('tat', 'tt', 'Tatar'),
    ('tel', 'te', 'Telugu'),
    ('tem', 'Timne'),
    ('ter', 'Tereno'),
    ('tet', 'Tetum'),
    ('tgk', 'tg', 'Tajik'),
    ('tgl', 'tl', 'Tagalog'),
    ('tha', 'th', 'Thai'),
    ('tib', 'bo', 'Tibetan'),
    ('tig', 'Tigre'),
    ('tir', 'ti', 'Tigrinya'),
    ('tiv', 'Tiv'),
    ('tkl', 'Tokelau'),
    ('tlh', 'Klingon'),
    ('tli', 'Tlingit'),
    ('tmh', 'Tamashek'),
    ('tog', 'Tonga '),
    ('ton', 'to', 'Tonga '),
    ('tpi', 'Tok Pisin'),
    ('tsi', 'Tsimshian'),
    ('tsn', 'tn', 'Tswana'),
    ('tso', 'ts', 'Tsonga'),
    ('tuk', 'tk', 'Turkmen'),
    ('tum', 'Tumbuka'),
    ('tup', 'Tupi languages'),
    ('tur', 'tr', 'Turkish'),
    ('tut', 'Altaic '),
    ('tvl', 'Tuvalu'),
    ('twi', 'tw', 'Twi'),
    ('tyv', 'Tuvinian'),
    ('udm', 'Udmurt'),
    ('uga', 'Ugaritic'),
    ('uig', 'ug', 'Uighur'),
    ('ukr', 'uk', 'Ukrainian'),
    ('umb', 'Umbundu'),
    ('und', 'Undetermined'),
    ('urd', 'ur', 'Urdu'),
    ('uzb', 'uz', 'Uzbek'),
    ('vai', 'Vai'),
    ('ven', 've', 'Venda'),
    ('vie', 'vi', 'Vietnamese'),
    ('vol', 'vo', 'Volap\xfck'),
    ('vot', 'Votic'),
    ('wak', 'Wakashan languages'),
    ('wal', 'Walamo'),
    ('war', 'Waray'),
    ('was', 'Washo'),
    ('wel', 'cy', 'Welsh'),
    ('wen', 'Sorbian languages'),
    ('wln', 'wa', 'Walloon'),
    ('wol', 'wo', 'Wolof'),
    ('xal', 'Kalmyk'),
    ('xho', 'xh', 'Xhosa'),
    ('yao', 'Yao'),
    ('yap', 'Yapese'),
    ('yid', 'yi', 'Yiddish'),
    ('yor', 'yo', 'Yoruba'),
    ('ypk', 'Yupik languages'),
    ('zap', 'Zapotec'),
    ('zbl', 'Blissymbols'),
    ('zen', 'Zenaga'),
    ('zha', 'za', 'Zhuang'),
    ('znd', 'Zande languages'),
    ('zul', 'zu', 'Zulu'),
    ('zun', 'Zuni'),
    ('zxx', 'No linguistic content'),
    ('zza', 'Zaza'),
)
