# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass


class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CompoundOperationKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """(Optional) Set to 'OR' for joining metadata using 'OR' operation."""

    AND_ENUM = "AND"
    OR_ENUM = "OR"


class ErrorCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    INVALID_ARGUMENT = "InvalidArgument"
    UNAUTHORIZED = "Unauthorized"
    FORBIDDEN = "Forbidden"
    NOT_FOUND = "NotFound"
    TOO_MANY_REQUESTS = "TooManyRequests"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"


class InnerErrorCode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    EXTRACTION_FAILURE = "ExtractionFailure"


class RankerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """(Optional) Set to 'QuestionOnly' for using a question only Ranker."""

    DEFAULT = "Default"
    QUESTION_ONLY = "QuestionOnly"


class StringIndexType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes)
    according to Unicode v8.0.0. For additional information see
    https://aka.ms/text-analytics-offsets.
    """

    #: Returned offset and length values will correspond to TextElements (Graphemes and Grapheme
    #: clusters) confirming to the Unicode 8.0.0 standard. Use this option if your application is
    #: written in .Net Framework or .Net Core and you will be using StringInfo.
    TEXT_ELEMENTS_V8 = "TextElements_v8"
    #: Returned offset and length values will correspond to Unicode code points. Use this option if
    #: your application is written in a language that support Unicode, for example Python.
    UNICODE_CODE_POINT = "UnicodeCodePoint"
    #: Returned offset and length values will correspond to UTF-16 code units. Use this option if your
    #: application is written in a language that support Unicode, for example Java, JavaScript.
    UTF16_CODE_UNIT = "Utf16CodeUnit"
