# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._question_answering_client_enums import *


class AnswerSpan(msrest.serialization.Model):
    """Answer span object of QnA.

    :param text: Predicted text of answer span.
    :type text: str
    :param confidence_score: Predicted score of answer span, value ranges from 0 to 1.
    :type confidence_score: float
    :param offset: The answer span offset from the start of answer.
    :type offset: int
    :param length: The length of the answer span.
    :type length: int
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        confidence_score: Optional[float] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
        **kwargs
    ):
        super(AnswerSpan, self).__init__(**kwargs)
        self.text = text
        self.confidence_score = confidence_score
        self.offset = offset
        self.length = length


class AnswerSpanRequest(msrest.serialization.Model):
    """To configure Answer span prediction feature.

    :param enable: Enable or disable Answer Span prediction.
    :type enable: bool
    :param confidence_score_threshold: Minimum threshold score required to include an answer span,
     value ranges from 0 to 1.
    :type confidence_score_threshold: float
    :param top_answers_with_span: Number of Top answers to be considered for span prediction from 1
     to 10.
    :type top_answers_with_span: int
    """

    _validation = {
        "confidence_score_threshold": {"maximum": 1, "minimum": 0},
        "top_answers_with_span": {"maximum": 10, "minimum": 1},
    }

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "confidence_score_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "top_answers_with_span": {"key": "topAnswersWithSpan", "type": "int"},
    }

    def __init__(
        self,
        *,
        enable: Optional[bool] = None,
        confidence_score_threshold: Optional[float] = None,
        top_answers_with_span: Optional[int] = None,
        **kwargs
    ):
        super(AnswerSpanRequest, self).__init__(**kwargs)
        self.enable = enable
        self.confidence_score_threshold = confidence_score_threshold
        self.top_answers_with_span = top_answers_with_span


class Error(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "TooManyRequests", "InternalServerError", "ServiceUnavailable".
    :type code: str or ~azure.ai.language.questionanswering.models.ErrorCode
    :param message: Required. A human-readable representation of the error.
    :type message: str
    :param target: The target of the error.
    :type target: str
    :param details: An array of details about specific errors that led to this reported error.
    :type details: list[~azure.ai.language.questionanswering.models.Error]
    :param innererror: An object containing more specific information than the current object about
     the error.
    :type innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "ErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[List["Error"]] = None,
        innererror: Optional["InnerErrorModel"] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :param error: The error object.
    :type error: ~azure.ai.language.questionanswering.models.Error
    """

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: Optional["Error"] = None, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class InnerErrorModel(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
    :type code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
    :param message: Required. Error message.
    :type message: str
    :param details: Error details.
    :type details: dict[str, str]
    :param target: Error target.
    :type target: str
    :param innererror: An object containing more specific information than the current object about
     the error.
    :type innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "{str}"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "InnerErrorCode"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["InnerErrorModel"] = None,
        **kwargs
    ):
        super(InnerErrorModel, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class KnowledgeBaseAnswer(msrest.serialization.Model):
    """Represents knowledge base answer.

    :param questions: List of questions.
    :type questions: list[str]
    :param answer: The Answer.
    :type answer: str
    :param confidence_score: Answer confidence score, value ranges from 0 to 1.
    :type confidence_score: float
    :param id: ID of the QnA result.
    :type id: int
    :param source: Source of QnA result.
    :type source: str
    :param metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :type metadata: dict[str, str]
    :param dialog: Dialog associated with Answer.
    :type dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
    :param answer_span: Answer span object of QnA with respect to user's question.
    :type answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "questions": {"key": "questions", "type": "[str]"},
        "answer": {"key": "answer", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "int"},
        "source": {"key": "source", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "dialog": {"key": "dialog", "type": "KnowledgeBaseAnswerDialog"},
        "answer_span": {"key": "answerSpan", "type": "AnswerSpan"},
    }

    def __init__(
        self,
        *,
        questions: Optional[List[str]] = None,
        answer: Optional[str] = None,
        confidence_score: Optional[float] = None,
        id: Optional[int] = None,
        source: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        dialog: Optional["KnowledgeBaseAnswerDialog"] = None,
        answer_span: Optional["AnswerSpan"] = None,
        **kwargs
    ):
        super(KnowledgeBaseAnswer, self).__init__(**kwargs)
        self.questions = questions
        self.answer = answer
        self.confidence_score = confidence_score
        self.id = id
        self.source = source
        self.metadata = metadata
        self.dialog = dialog
        self.answer_span = answer_span


class KnowledgeBaseAnswerDialog(msrest.serialization.Model):
    """Dialog associated with Answer.

    :param is_context_only: To mark if a prompt is relevant only with a previous question or not.
     If true, do not include this QnA as search result for queries without context; otherwise, if
     false, ignores context and includes this QnA in search result.
    :type is_context_only: bool
    :param prompts: List of 0 to 20 prompts associated with the answer.
    :type prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
    """

    _validation = {
        "prompts": {"max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "is_context_only": {"key": "isContextOnly", "type": "bool"},
        "prompts": {"key": "prompts", "type": "[KnowledgeBaseAnswerPrompt]"},
    }

    def __init__(
        self,
        *,
        is_context_only: Optional[bool] = None,
        prompts: Optional[List["KnowledgeBaseAnswerPrompt"]] = None,
        **kwargs
    ):
        super(KnowledgeBaseAnswerDialog, self).__init__(**kwargs)
        self.is_context_only = is_context_only
        self.prompts = prompts


class KnowledgeBaseAnswerPrompt(msrest.serialization.Model):
    """Prompt for an answer.

    :param display_order: Index of the prompt - used in ordering of the prompts.
    :type display_order: int
    :param qna_id: QnA ID corresponding to the prompt.
    :type qna_id: int
    :param display_text: Text displayed to represent a follow up question prompt.
    :type display_text: str
    """

    _validation = {
        "display_text": {"max_length": 200, "min_length": 0},
    }

    _attribute_map = {
        "display_order": {"key": "displayOrder", "type": "int"},
        "qna_id": {"key": "qnaId", "type": "int"},
        "display_text": {"key": "displayText", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_order: Optional[int] = None,
        qna_id: Optional[int] = None,
        display_text: Optional[str] = None,
        **kwargs
    ):
        super(KnowledgeBaseAnswerPrompt, self).__init__(**kwargs)
        self.display_order = display_order
        self.qna_id = qna_id
        self.display_text = display_text


class KnowledgeBaseAnswerRequestContext(msrest.serialization.Model):
    """Context object with previous QnA's information.

    All required parameters must be populated in order to send to Azure.

    :param previous_qna_id: Required. Previous turn top answer result QnA ID.
    :type previous_qna_id: int
    :param previous_user_query: Previous user query.
    :type previous_user_query: str
    """

    _validation = {
        "previous_qna_id": {"required": True},
    }

    _attribute_map = {
        "previous_qna_id": {"key": "previousQnaId", "type": "int"},
        "previous_user_query": {"key": "previousUserQuery", "type": "str"},
    }

    def __init__(self, *, previous_qna_id: int, previous_user_query: Optional[str] = None, **kwargs):
        super(KnowledgeBaseAnswerRequestContext, self).__init__(**kwargs)
        self.previous_qna_id = previous_qna_id
        self.previous_user_query = previous_user_query


class KnowledgeBaseAnswers(msrest.serialization.Model):
    """Represents List of Question Answers.

    :param answers: Represents Answer Result list.
    :type answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[KnowledgeBaseAnswer]"},
    }

    def __init__(self, *, answers: Optional[List["KnowledgeBaseAnswer"]] = None, **kwargs):
        super(KnowledgeBaseAnswers, self).__init__(**kwargs)
        self.answers = answers


class KnowledgeBaseQueryOptions(msrest.serialization.Model):
    """The question parameters to answer using a knowledge base.

    :param qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question.
    :type qna_id: int
    :param question: User question to query against the knowledge base.
    :type question: str
    :param top: Max number of answers to be returned for the question.
    :type top: int
    :param user_id: Unique identifier for the user.
    :type user_id: str
    :param confidence_score_threshold: Minimum threshold score for answers, value ranges from 0 to
     1.
    :type confidence_score_threshold: float
    :param context: Context object with previous QnA's information.
    :type context: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerRequestContext
    :param ranker_type: (Optional) Set to 'QuestionOnly' for using a question only Ranker. Possible
     values include: "Default", "QuestionOnly".
    :type ranker_type: str or ~azure.ai.language.questionanswering.models.RankerType
    :param strict_filters: Filter QnAs based on give metadata list and knowledge base source names.
    :type strict_filters: ~azure.ai.language.questionanswering.models.StrictFilters
    :param answer_span_request: To configure Answer span prediction feature.
    :type answer_span_request: ~azure.ai.language.questionanswering.models.AnswerSpanRequest
    :param include_unstructured_sources: (Optional) Flag to enable Query over Unstructured Sources.
    :type include_unstructured_sources: bool
    """

    _validation = {
        "confidence_score_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "qna_id": {"key": "qnaId", "type": "int"},
        "question": {"key": "question", "type": "str"},
        "top": {"key": "top", "type": "int"},
        "user_id": {"key": "userId", "type": "str"},
        "confidence_score_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "context": {"key": "context", "type": "KnowledgeBaseAnswerRequestContext"},
        "ranker_type": {"key": "rankerType", "type": "str"},
        "strict_filters": {"key": "strictFilters", "type": "StrictFilters"},
        "answer_span_request": {"key": "answerSpanRequest", "type": "AnswerSpanRequest"},
        "include_unstructured_sources": {"key": "includeUnstructuredSources", "type": "bool"},
    }

    def __init__(
        self,
        *,
        qna_id: Optional[int] = None,
        question: Optional[str] = None,
        top: Optional[int] = None,
        user_id: Optional[str] = None,
        confidence_score_threshold: Optional[float] = None,
        context: Optional["KnowledgeBaseAnswerRequestContext"] = None,
        ranker_type: Optional[Union[str, "RankerType"]] = None,
        strict_filters: Optional["StrictFilters"] = None,
        answer_span_request: Optional["AnswerSpanRequest"] = None,
        include_unstructured_sources: Optional[bool] = None,
        **kwargs
    ):
        super(KnowledgeBaseQueryOptions, self).__init__(**kwargs)
        self.qna_id = qna_id
        self.question = question
        self.top = top
        self.user_id = user_id
        self.confidence_score_threshold = confidence_score_threshold
        self.context = context
        self.ranker_type = ranker_type
        self.strict_filters = strict_filters
        self.answer_span_request = answer_span_request
        self.include_unstructured_sources = include_unstructured_sources


class MetadataFilter(msrest.serialization.Model):
    """Find QnAs that are associated with the given list of metadata.

    :param metadata: Dictionary of :code:`<string>`.
    :type metadata: dict[str, str]
    :param compound_operation: (Optional) Set to 'OR' for joining metadata using 'OR' operation.
     Possible values include: "AND", "OR".
    :type compound_operation: str or
     ~azure.ai.language.questionanswering.models.CompoundOperationKind
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "compound_operation": {"key": "compoundOperation", "type": "str"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        compound_operation: Optional[Union[str, "CompoundOperationKind"]] = None,
        **kwargs
    ):
        super(MetadataFilter, self).__init__(**kwargs)
        self.metadata = metadata
        self.compound_operation = compound_operation


class StrictFilters(msrest.serialization.Model):
    """filters over knowledge base.

    :param metadata_filter: Find QnAs that are associated with the given list of metadata.
    :type metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
    :param source_filter: Find QnAs that are associated with the given list of sources in knowledge
     base.
    :type source_filter: list[str]
    :param compound_operation: (Optional) Set to 'OR' for joining metadata using 'OR' operation.
     Possible values include: "AND", "OR".
    :type compound_operation: str or
     ~azure.ai.language.questionanswering.models.CompoundOperationKind
    """

    _attribute_map = {
        "metadata_filter": {"key": "metadataFilter", "type": "MetadataFilter"},
        "source_filter": {"key": "sourceFilter", "type": "[str]"},
        "compound_operation": {"key": "compoundOperation", "type": "str"},
    }

    def __init__(
        self,
        *,
        metadata_filter: Optional["MetadataFilter"] = None,
        source_filter: Optional[List[str]] = None,
        compound_operation: Optional[Union[str, "CompoundOperationKind"]] = None,
        **kwargs
    ):
        super(StrictFilters, self).__init__(**kwargs)
        self.metadata_filter = metadata_filter
        self.source_filter = source_filter
        self.compound_operation = compound_operation


class TextAnswer(msrest.serialization.Model):
    """Represents answer result.

    :param answer: Answer.
    :type answer: str
    :param confidence_score: answer confidence score, value ranges from 0 to 1.
    :type confidence_score: float
    :param id: record ID.
    :type id: str
    :param answer_span: Answer span object with respect to user's question.
    :type answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
    :param offset: The sentence offset from the start of the document.
    :type offset: int
    :param length: The length of the sentence.
    :type length: int
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "answer": {"key": "answer", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "answer_span": {"key": "answerSpan", "type": "AnswerSpan"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        answer: Optional[str] = None,
        confidence_score: Optional[float] = None,
        id: Optional[str] = None,
        answer_span: Optional["AnswerSpan"] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
        **kwargs
    ):
        super(TextAnswer, self).__init__(**kwargs)
        self.answer = answer
        self.confidence_score = confidence_score
        self.id = id
        self.answer_span = answer_span
        self.offset = offset
        self.length = length


class TextAnswers(msrest.serialization.Model):
    """Represents the answer results.

    :param answers: Represents the answer results.
    :type answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[TextAnswer]"},
    }

    def __init__(self, *, answers: Optional[List["TextAnswer"]] = None, **kwargs):
        super(TextAnswers, self).__init__(**kwargs)
        self.answers = answers


class TextQueryOptions(msrest.serialization.Model):
    """The question and text record parameters to answer.

    All required parameters must be populated in order to send to Azure.

    :param question: Required. User question to query against the given text records.
    :type question: str
    :param records: Required. Text records to be searched for given question.
    :type records: list[~azure.ai.language.questionanswering.models.TextRecord]
    :param language: Language of the text records. This is BCP-47 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :type language: str
    :param string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Possible values include: "TextElements_v8",
     "UnicodeCodePoint", "Utf16CodeUnit". Default value: "TextElements_v8".
    :type string_index_type: str or ~azure.ai.language.questionanswering.models.StringIndexType
    """

    _validation = {
        "question": {"required": True},
        "records": {"required": True},
    }

    _attribute_map = {
        "question": {"key": "question", "type": "str"},
        "records": {"key": "records", "type": "[TextRecord]"},
        "language": {"key": "language", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        question: str,
        records: List["TextRecord"],
        language: Optional[str] = None,
        string_index_type: Optional[Union[str, "StringIndexType"]] = "TextElements_v8",
        **kwargs
    ):
        super(TextQueryOptions, self).__init__(**kwargs)
        self.question = question
        self.records = records
        self.language = language
        self.string_index_type = string_index_type


class TextRecord(msrest.serialization.Model):
    """Represent input text record to be queried.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Unique identifier for the text record.
    :type id: str
    :param text: Required. Text contents of the record.
    :type text: str
    """

    _validation = {
        "id": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, *, id: str, text: str, **kwargs):
        super(TextRecord, self).__init__(**kwargs)
        self.id = id
        self.text = text
