import ezdxf

fit_points = [
    (1942.411852044661, 1371.147300260481, 0.0),
    (2154.13373000597, 2873.856241556621, 0.0),
    (2736.36885466561, 3593.463340849929, 0.0),
    (3784.392091278795, 4048.509007829161, 0.0),
    (5626.372330512928, 3688.705454914216, 0.0),
    (7140.183679079659, 4873.940676126147, 0.0),
    (10146.63419208474, 5487.723199879192, 0.0),
    (11385.20711030502, 6567.133852087446, 0.0),
    (12157.99191657175, 7720.621701944615, 0.0),
    (13323.3574514168, 7328.258737846129, 0.0),
    (13905.59258830227, 5518.658537941759, 0.0),
    (14085.55617784517, 4460.412802148874, 0.0),
    (12603.50310547102, 4026.532051585013, 0.0),
    (11767.20173459331, 4894.293552712738, 0.0),
    (10041.6685202911, 3730.223247916174, 0.0),
    (9533.536040080799, 2365.086246978477, 0.0),
    (7670.383616718281, 2058.194988370248, 0.0),
    (5891.919942095126, 2555.570481643635, 0.0),
    (3552.393314714877, 2068.77744330964, 0.0),
    (3393.601909300354, 820.0474793881822, 0.0),
    (5500.234486816747, -111.2087709856523, 0.0),
    (7405.731278436022, -153.5385972798067, 0.0),
    (9353.572450537895, 238.0123269899014, 0.0),
    (10422.76788350529, 904.7071385130768, 0.0),
    (12063.61234906814, 947.0369648072319, 0.0),
    (13513.90713302389, 1201.015942181913, 0.0),
    (14508.99990931613, 1730.138806810064, 0.0),
    (15239.4403473261, 2873.044201727842, 0.0),
    (15101.82113826579, 4756.721605817713, 0.0),
    (14980.95212659797, 6411.128920668436, 0.0),
    (14773.65223537255, 7233.016623781842, 0.0),
    (13577.42369763487, 7931.458806659779, 0.0),
    (10052.2546123553, 8301.844814514117, 0.0),
    (6643.532564233479, 7497.578056095915, 0.0),
    (5828.40337748415, 6703.89375915369, 0.0),
    (3880.562205382279, 6248.848092174459, 0.0),
    (3128.949583243926, 7349.423654261499, 0.0),
    (1784.515732155909, 6926.125358637027, 0.0),
    (1107.005754466889, 6079.52877392467, 0.0),
    (683.5620229959386, 4820.216348527235, 0.0),
    (545.9428017097962, 3243.430209582181, 0.0)
]

dwg = ezdxf.new('R2000')
msp = dwg.modelspace()

msp.add_open_spline(control_points=fit_points, degree=3, dxfattribs={'color': 4})
dxf_spline = msp.add_spline_approx(fit_points, count=len(fit_points), degree=3, dxfattribs={'color': 3})
dwg.saveas("spline_approximation.dxf")
